# 画面設計書 16-コンソール出力（フル）

## 概要

本ドキュメントは、Jenkinsにおけるコンソール出力（フル）画面の設計仕様を記述したものです。ビルドログをページ区切りなしで全表示する画面です。

### 本画面の処理概要

**業務上の目的・背景**：コンソール出力（フル）画面は、ビルドログ全体を一度に確認する必要がある場合に使用します。通常のコンソール出力画面では大きなログはページネーションされますが、この画面ではすべてのログを連続して表示します。ログ全体を検索したり、完全なログをコピーしたりする際に便利です。

**画面へのアクセス方法**：コンソール出力画面から「Full Log」リンクをクリック、またはURLに直接`/job/{ジョブ名}/{ビルド番号}/consoleFull`を指定してアクセスできます。

**主要な操作・処理内容**：
1. ビルドログ全体の表示（ページ区切りなし）
2. ログのダウンロード
3. ログのクリップボードへのコピー
4. プレーンテキスト表示への切り替え

**画面遷移**：
- 遷移元：コンソール出力
- 遷移先：プレーンテキストビュー

**権限による表示制御**：
- `Run.READ`権限があれば閲覧可能
- 大きなログファイルの場合、メモリ使用量に注意が必要

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 6 | ビルド（Build） | 主機能 | ビルドログの全件表示 |

## 画面種別

詳細/ログ表示

## URL/ルーティング

```
/job/{ジョブ名}/{ビルド番号}/consoleFull
/job/{フォルダ名}/job/{ジョブ名}/{ビルド番号}/consoleFull
```

Staplerによりリクエストは`hudson.model.Run`クラスの`consoleFull.jelly`にルーティングされます。

## 入出力項目

| 項目名 | 入出力 | 型 | 説明 |
|--------|--------|-----|------|
| consoleText | 出力 | AnnotatedLargeText | コンソールログ全体（アノテーション付き） |
| consoleFull | 内部 | Boolean | フル表示フラグ（true固定） |

## 表示項目

| 項目 | 説明 | データソース |
|------|------|------------|
| コンソールログ全体 | ビルド実行のログ出力（全件） | `console-log.jelly` |
| ダウンロードボタン | ログファイルのダウンロード | `consoleText`エンドポイント |
| コピーボタン | ログのクリップボードコピー | `l:copyButton` |
| プレーンテキストリンク | テキスト形式での表示 | `consoleText`エンドポイント |

## イベント仕様

コンソール出力画面と同様のイベント仕様です。詳細は「15-コンソール出力」を参照してください。

### 1-ダウンロードボタン押下

ログファイルをテキストファイルとしてダウンロードします。

### 2-コピーボタン押下

ログ内容をクリップボードにコピーします。

### 3-プレーンテキスト表示リンククリック

ログをプレーンテキスト形式で表示します。

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| （なし） | - | - | 本画面は参照専用で更新処理なし |

## メッセージ仕様

| メッセージID | メッセージ内容 | 表示条件 | メッセージ種別 |
|-------------|---------------|---------|--------------|
| Console | コンソール | アプリバータイトル | 情報 |
| Download | ダウンロード | ダウンロードボタン | 情報 |
| Copy | コピー | コピーボタン | 情報 |
| View as plain text | プレーンテキストで表示 | リンクテキスト | 情報 |

## 例外処理

| 例外条件 | 処理内容 | 画面表示 |
|---------|---------|---------|
| ビルドが存在しない | 404エラー | 404エラー画面 |
| 権限不足 | アクセス拒否 | 403エラー画面 |
| メモリ不足（大きなログ） | OutOfMemoryError | エラーメッセージ表示 |

## 備考

- この画面は`consoleFull.jelly`で`consoleFull`変数を`true`に設定し、`console.jelly`をインクルードする薄いラッパーです。
- 大きなログファイル（数百MB以上）の場合、ブラウザとサーバーの両方でメモリ使用量が増加するため、注意が必要です。
- ビルド実行中の場合もリアルタイム更新は行われますが、全体を一度に表示するため負荷が高くなる可能性があります。

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: エントリーポイントを理解する

処理の起点となるJellyテンプレートを確認します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | consoleFull.jelly | `core/src/main/resources/hudson/model/Run/consoleFull.jelly` | フル表示のエントリーポイント |

**主要処理フロー**:
1. **26行目**: `consoleFull`変数を`true`に設定
2. **27行目**: `console.jelly`をインクルード

この画面は非常にシンプルで、単に`consoleFull`フラグを設定してから通常のコンソール画面をインクルードするだけです。

#### Step 2: コンソール出力の実装を理解する

コンソール出力画面の実装詳細については、「15-コンソール出力」のコードリーディングガイドを参照してください。

### プログラム呼び出し階層図

```
consoleFull.jelly (コンソール出力（フル）画面)
    │
    ├─ consoleFull = true (変数設定)
    │
    └─ console.jelly (インクルード)
           │
           └─ (15-コンソール出力と同じ構造)
```

### データフロー図

```
[入力]               [処理]                    [出力]

URLリクエスト ───▶ consoleFull.jelly ───▶ console.jelly
  /consoleFull            │                    │
                          ▼                    ▼
              consoleFull = true       全ログ表示
                                      (ページネーションなし)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| consoleFull.jelly | `core/src/main/resources/hudson/model/Run/consoleFull.jelly` | テンプレート | フル表示ラッパー |
| console.jelly | `core/src/main/resources/hudson/model/Run/console.jelly` | テンプレート | メイン画面テンプレート |
| console-log.jelly | `core/src/main/resources/hudson/model/Run/console-log.jelly` | テンプレート | ログ表示コンポーネント |
| Run.java | `core/src/main/java/hudson/model/Run.java` | ソース | ビルド実行クラス |
