# 画面設計書 17-ビルド設定

## 概要

本ドキュメントは、Jenkinsにおけるビルド設定画面の設計仕様を記述したものです。特定のビルドの設定（表示名、説明）を変更するための画面です。

### 本画面の処理概要

**業務上の目的・背景**：ビルド設定画面は、個別のビルドに対してメタデータを追加・編集するための画面です。開発者はこの画面を通じて、ビルドに分かりやすい表示名（例：「リリース候補v1.2.0」）を付けたり、ビルドの内容や変更点に関する説明を記録したりできます。これにより、ビルド履歴の可読性が向上し、重要なビルドを特定しやすくなります。

**画面へのアクセス方法**：ビルド詳細画面のサイドパネルにある「Edit Build Information」リンクをクリック、またはURLに直接`/job/{ジョブ名}/{ビルド番号}/configure`を指定してアクセスできます。

**主要な操作・処理内容**：
1. ビルド表示名の設定・変更
2. ビルド説明の設定・変更
3. 設定の保存

**画面遷移**：
- 遷移元：ビルド詳細
- 遷移先：ビルド詳細（保存後）

**権限による表示制御**：
- `Run.UPDATE`権限がないとアクセス不可（編集権限が必要）
- 読み取り専用モードはサポートしていません

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 6 | ビルド（Build） | 主機能 | ビルド設定（説明等）の編集 |

## 画面種別

編集

## URL/ルーティング

```
/job/{ジョブ名}/{ビルド番号}/configure
/job/{フォルダ名}/job/{ジョブ名}/{ビルド番号}/configure
```

Staplerによりリクエストは`hudson.model.Run`クラスの`configure.jelly`にルーティングされます。

## 入出力項目

| 項目名 | 入出力 | 型 | 必須 | 説明 |
|--------|--------|-----|------|------|
| displayName | 入力 | String | - | カスタム表示名（空の場合はデフォルトの#番号を使用） |
| description | 入力 | String | - | ビルドの説明（マークアップ対応） |

## 表示項目

| 項目 | 説明 | データソース |
|------|------|------------|
| 表示名フィールド | カスタム表示名の入力欄 | `Run.displayName` |
| 説明フィールド | ビルド説明の入力エリア | `Run.description` |
| 保存/適用ボタン | 設定保存のボタン | `f:saveApplyBar` |

## イベント仕様

### 1-保存ボタン押下

設定内容を保存してビルド詳細画面へリダイレクトします。

- 処理フロー：
  1. POSTリクエストで`configSubmit`アクションへ送信
  2. サーバーサイドで`Run.doConfigSubmit()`が呼び出される
  3. displayNameとdescriptionを更新
  4. build.xmlファイルに永続化
  5. 成功時、ビルド詳細画面へリダイレクト

### 2-適用ボタン押下

設定内容を保存しますが、画面遷移は行わず同じ画面にとどまります。

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 保存ボタン押下 | build.xml（ファイル） | UPDATE | ビルド設定XMLの更新 |
| 適用ボタン押下 | build.xml（ファイル） | UPDATE | ビルド設定XMLの更新 |

### テーブル別更新項目詳細

#### build.xml

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| UPDATE | displayName | ユーザー入力値 | 空の場合はnull（デフォルト表示名を使用） |
| UPDATE | description | ユーザー入力値 | マークアップ形式でサニタイズ |

## メッセージ仕様

| メッセージID | メッセージ内容 | 表示条件 | メッセージ種別 |
|-------------|---------------|---------|--------------|
| Edit Build Information | ビルド情報を編集 | ページタイトル/パンくずリスト | 情報 |
| DisplayName | 表示名 | フィールドラベル | 情報 |
| Description | 説明 | フィールドラベル | 情報 |

## 例外処理

| 例外条件 | 処理内容 | 画面表示 |
|---------|---------|---------|
| ビルドが存在しない | 404エラー | 404エラー画面 |
| 権限不足（UPDATE権限なし） | アクセス拒否 | 403エラー画面 |
| 保存時のI/Oエラー | エラーログ出力 | エラーメッセージ表示 |

## 備考

- displayNameが空または未設定の場合、ビルドは`#{番号}`形式のデフォルト表示名で表示されます。
- `hasCustomDisplayName()`メソッドで、カスタム表示名が設定されているかどうかを判定できます。
- 説明フィールドはマークアップ対応で、設定されたMarkupFormatterに応じてHTML/Markdown等が使用可能です。

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、ビルドの表示名と説明のデータ構造を理解します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | Run.java | `core/src/main/java/hudson/model/Run.java` | displayName、descriptionフィールドの定義 |

**読解のコツ**: displayNameはnull可で、nullの場合は`#{number}`形式のデフォルト名が使用されます。

#### Step 2: エントリーポイントを理解する

処理の起点となるJellyテンプレートを確認します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | configure.jelly | `core/src/main/resources/hudson/model/Run/configure.jelly` | ビルド設定画面のメインテンプレート |

**主要処理フロー**:
1. **27行目**: レイアウト設定（タイトルに`displayName Config`を使用）
2. **28行目**: サイドパネルのインクルード
3. **29行目**: パンくずリストの設定
4. **30-31行目**: アプリバーとスケルトンの表示
5. **32-33行目**: フォーム開始（`action="configSubmit"`）
6. **34行目**: `readOnlyMode`の判定（UPDATE権限の有無）
7. **35-36行目**: 表示名フィールド（ヘルプ付き）
8. **38-39行目**: 説明フィールド（マークアップ対応、プレビュー機能付き）
9. **41行目**: 保存/適用ボタンバー

#### Step 3: フォーム処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | Run.java | `core/src/main/java/hudson/model/Run.java` | `doConfigSubmit()`メソッドの実装 |

### プログラム呼び出し階層図

```
configure.jelly (ビルド設定画面)
    │
    ├─ sidepanel.jelly (サイドパネル)
    │
    └─ f:form (フォーム)
           │
           ├─ f:entry (表示名)
           │      └─ f:textbox
           │
           ├─ f:entry (説明)
           │      └─ f:textarea
           │
           └─ f:saveApplyBar
                  └─ configSubmit (POSTアクション)
                         └─ Run.doConfigSubmit()
                                └─ Run.save()
```

### データフロー図

```
[入力]               [処理]                    [出力]

フォーム入力 ───▶ configSubmit ───▶ Run.doConfigSubmit()
                      │                    │
                      ▼                    ▼
              displayName          build.xml
              description           更新
                      │                    │
                      ▼                    ▼
              Run.save()          リダイレクト
                                  ビルド詳細へ
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| configure.jelly | `core/src/main/resources/hudson/model/Run/configure.jelly` | テンプレート | メイン設定画面 |
| sidepanel.jelly | `core/src/main/resources/hudson/model/Run/sidepanel.jelly` | テンプレート | サイドパネル |
| Run.java | `core/src/main/java/hudson/model/Run.java` | ソース | ビルド実行クラス |
| displayName.html | `core/src/main/resources/help/run-config/displayName.html` | ヘルプ | 表示名のヘルプ |
| description.html | `core/src/main/resources/help/run-config/description.html` | ヘルプ | 説明のヘルプ |
