# 画面設計書 18-ビルド削除確認

## 概要

本ドキュメントは、Jenkinsにおけるビルド削除確認画面の設計仕様を記述したものです。ビルドを削除する前に確認を求める画面です。

### 本画面の処理概要

**業務上の目的・背景**：ビルド削除確認画面は、誤ってビルド履歴を削除することを防ぐための確認画面です。ビルド履歴にはログ、成果物、テスト結果などの重要な情報が含まれており、一度削除すると復元できません。この画面を通じて、ユーザーは削除対象のビルドを確認し、意図的な削除のみを実行できます。

**画面へのアクセス方法**：ビルド詳細画面のサイドパネルにある「削除」リンクをクリックしてアクセスします。URLに直接`/job/{ジョブ名}/{ビルド番号}/confirmDelete`を指定することも可能です。

**主要な操作・処理内容**：
1. 削除対象ビルドの確認メッセージ表示
2. 削除の実行（削除ボタン押下）
3. ビルド保持警告の表示（保持設定されている場合）

**画面遷移**：
- 遷移元：ビルド詳細
- 遷移先：ジョブ詳細（削除完了後）

**権限による表示制御**：
- `Run.DELETE`権限がないとアクセス不可
- ビルド保持（keepLog）が設定されている場合、警告メッセージを表示し削除ボタンを非表示

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 6 | ビルド（Build） | 主機能 | ビルド削除の確認処理 |
| 22 | ログローテーション | 補助機能 | ビルド履歴管理 |

## 画面種別

確認

## URL/ルーティング

```
/job/{ジョブ名}/{ビルド番号}/confirmDelete
/job/{フォルダ名}/job/{ジョブ名}/{ビルド番号}/confirmDelete
```

Staplerによりリクエストは`hudson.model.Run`クラスの`confirmDelete.jelly`にルーティングされます。

## 入出力項目

| 項目名 | 入出力 | 型 | 説明 |
|--------|--------|-----|------|
| displayName | 出力 | String | 削除対象ビルドの表示名 |
| whyKeepLog | 出力 | String | ビルド保持理由（設定されている場合） |

## 表示項目

| 項目 | 説明 | データソース |
|------|------|------------|
| 警告メッセージ | ビルド保持時の警告 | `Run.whyKeepLog` |
| 確認メッセージ | 削除確認のテキスト | `delete.build`メッセージ |
| 削除ボタン | 削除実行ボタン | 固定 |

## イベント仕様

### 1-削除ボタン押下

ビルドを削除してジョブ詳細画面へリダイレクトします。

- 処理フロー：
  1. POSTリクエストで`doDelete`アクションへ送信
  2. サーバーサイドで`Run.doDoDelete()`が呼び出される
  3. ビルドディレクトリとファイルを削除
  4. ビルドリストから該当ビルドを除去
  5. 成功時、ジョブ詳細画面へリダイレクト

### 2-キャンセル（ブラウザバック）

ブラウザの戻るボタンまたはサイドパネルのリンクで、ビルド詳細画面に戻ります。

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 削除ボタン押下 | ビルドディレクトリ | DELETE | ビルド関連ファイル全体の削除 |

### テーブル別更新項目詳細

#### ビルドディレクトリ（builds/{番号}/）

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| DELETE | 全ファイル | - | build.xml、log、artifacts等を含むディレクトリ全体 |

## メッセージ仕様

| メッセージID | メッセージ内容 | 表示条件 | メッセージ種別 |
|-------------|---------------|---------|--------------|
| Confirm deletion | 削除の確認 | パンくずリスト | 情報 |
| Warning | 警告 | ビルド保持時 | 警告 |
| delete.build | ビルド {displayName} を削除しますか？ | 削除可能時 | 確認 |
| Delete | 削除 | 削除ボタン | 情報 |

## 例外処理

| 例外条件 | 処理内容 | 画面表示 |
|---------|---------|---------|
| ビルドが存在しない | 404エラー | 404エラー画面 |
| 権限不足（DELETE権限なし） | アクセス拒否 | 403エラー画面 |
| ビルド保持設定あり | 削除ボタン非表示 | 警告メッセージのみ表示 |
| 削除時のI/Oエラー | エラーログ出力 | エラーメッセージ表示 |

## 備考

- ビルドに`keepLog`フラグが設定されている場合、`whyKeepLog`メソッドが保持理由を返し、削除ボタンは表示されません。
- 削除は物理削除であり、ビルドディレクトリ全体が削除されます。
- 削除ボタンには破壊的アクションを示す`jenkins-!-destructive-color`クラスが適用されています。

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、ビルド保持に関するデータ構造を理解します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | Run.java | `core/src/main/java/hudson/model/Run.java` | keepLog、whyKeepLogの定義と動作 |

**読解のコツ**: `keepLog`はブール値、`whyKeepLog()`は保持理由を返すメソッドです。保持理由がnullでない場合、ビルドは保護されています。

#### Step 2: エントリーポイントを理解する

処理の起点となるJellyテンプレートを確認します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | confirmDelete.jelly | `core/src/main/resources/hudson/model/Run/confirmDelete.jelly` | 削除確認画面のメインテンプレート |

**主要処理フロー**:
1. **29行目**: レイアウト設定（タイトルにfullDisplayNameを使用）
2. **30行目**: サイドパネルのインクルード
3. **31行目**: パンくずリストの設定（「Confirm deletion」）
4. **33行目**: `whyKeepLog`変数の取得
5. **34-36行目**: 保持理由がある場合の警告表示
6. **38-42行目**: 保持理由がない場合の削除フォーム表示
7. **39行目**: フォーム（`action="doDelete"`、POST）
8. **40行目**: 確認メッセージの表示
9. **41行目**: 削除ボタン（破壊的カラー）

#### Step 3: 削除処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | Run.java | `core/src/main/java/hudson/model/Run.java` | `doDoDelete()`メソッドの実装 |

### プログラム呼び出し階層図

```
confirmDelete.jelly (削除確認画面)
    │
    ├─ sidepanel.jelly (サイドパネル)
    │
    ├─ whyKeepLog チェック
    │      │
    │      ├─ [保持理由あり] ───▶ 警告メッセージ表示
    │      │
    │      └─ [保持理由なし] ───▶ 削除フォーム表示
    │                                   │
    │                                   └─ doDelete (POSTアクション)
    │                                          └─ Run.doDoDelete()
    │                                                 └─ Run.delete()
    │
    └─ ジョブ詳細へリダイレクト
```

### データフロー図

```
[入力]               [処理]                    [出力]

URLリクエスト ───▶ confirmDelete.jelly ───▶ 確認画面表示
  /confirmDelete          │
                          ▼
              whyKeepLog チェック
                          │
          ┌───────────────┴───────────────┐
          ▼                               ▼
    [保持理由あり]                  [保持理由なし]
    警告表示のみ                    削除フォーム表示
                                          │
                                          ▼
                                    doDelete POST
                                          │
                                          ▼
                                    Run.delete()
                                          │
                                          ▼
                                    ビルドディレクトリ削除
                                          │
                                          ▼
                                    ジョブ詳細へリダイレクト
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| confirmDelete.jelly | `core/src/main/resources/hudson/model/Run/confirmDelete.jelly` | テンプレート | 削除確認画面 |
| sidepanel.jelly | `core/src/main/resources/hudson/model/Run/sidepanel.jelly` | テンプレート | サイドパネル |
| Run.java | `core/src/main/java/hudson/model/Run.java` | ソース | ビルド実行・削除処理 |
| confirmDelete.properties | `core/src/main/resources/hudson/model/Run/confirmDelete.properties` | リソース | メッセージ定義 |
