# 画面設計書 19-成果物一覧

## 概要

本ドキュメントは、Jenkinsにおける成果物一覧画面の設計仕様を記述したものです。ビルドで生成された成果物（アーティファクト）の一覧を表示する画面です。

### 本画面の処理概要

**業務上の目的・背景**：成果物一覧画面は、ビルドプロセスで生成されたファイル（バイナリ、ドキュメント、テストレポート等）を確認・取得するための画面です。CI/CDパイプラインでは、ビルド成果物は次のステージへの入力や、最終的なデプロイ対象となる重要な出力です。この画面を通じて、開発者やリリースエンジニアは必要な成果物を確認し、ダウンロードできます。

**画面へのアクセス方法**：ビルド詳細画面の「Build Artifacts」セクションから「all files」リンクをクリック、またはURLに直接`/job/{ジョブ名}/{ビルド番号}/artifact/`を指定してアクセスできます。

**主要な操作・処理内容**：
1. 成果物ファイルの一覧表示
2. ファイルの閲覧・ダウンロード
3. ファイルサイズの確認

**画面遷移**：
- 遷移元：ビルド詳細
- 遷移先：個別ファイルのダウンロード/表示

**権限による表示制御**：
- `Run.ARTIFACTS`権限が有効な場合、その権限がないとアクセス不可
- 権限が無効の場合（デフォルト）は`Run.READ`権限で閲覧可能

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 18 | 成果物アーカイブ | 主機能 | ビルド成果物の一覧表示とダウンロード |
| 6 | ビルド（Build） | 補助機能 | ビルド情報の参照 |

## 画面種別

一覧

## URL/ルーティング

```
/job/{ジョブ名}/{ビルド番号}/artifact/
/job/{フォルダ名}/job/{ジョブ名}/{ビルド番号}/artifact/
```

Staplerによりリクエストは`hudson.model.Run`クラスの`artifacts-index.jelly`にルーティングされます。

## 入出力項目

| 項目名 | 入出力 | 型 | 説明 |
|--------|--------|-----|------|
| artifacts | 出力 | List<Artifact> | 成果物のリスト |
| fullDisplayName | 出力 | String | ビルドの完全表示名 |

## 表示項目

| 項目 | 説明 | データソース |
|------|------|------------|
| ビルドキャプション | 「Build Artifacts」タイトル | 固定 |
| ファイルアイコン | ドキュメントアイコン | `icon-document` |
| ファイル名 | 成果物のパス/名前（リンク） | `Artifact.displayPath` |
| ファイルサイズ | ファイルのバイト数 | `Artifact.length` |

## イベント仕様

### 1-ファイル名リンククリック

成果物ファイルをダウンロードまたはブラウザで表示します。

- 処理フロー：
  1. `artifact/{相対パス}`エンドポイントにアクセス
  2. ArtifactManagerがファイルを取得
  3. Content-Typeに基づいてダウンロードまたは表示

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| （なし） | - | - | 本画面は参照専用で更新処理なし |

## メッセージ仕様

| メッセージID | メッセージ内容 | 表示条件 | メッセージ種別 |
|-------------|---------------|---------|--------------|
| Artifacts | 成果物 | パンくずリスト | 情報 |
| Build Artifacts | ビルド成果物 | ページヘッダー | 情報 |

## 例外処理

| 例外条件 | 処理内容 | 画面表示 |
|---------|---------|---------|
| ビルドが存在しない | 404エラー | 404エラー画面 |
| 権限不足（ARTIFACTS権限なし） | 空の応答 | 何も表示されない |
| 成果物なし | 空のテーブル | テーブルボディが空 |
| ファイル取得エラー | エラーログ出力 | エラーメッセージ表示 |

## 備考

- 成果物の保存・取得は`ArtifactManager`インターフェースを通じて行われ、プラグインでカスタマイズ可能です。
- デフォルトの`StandardArtifactManager`は、ビルドディレクトリ内の`archive`フォルダにファイルを保存します。
- `artifacts-index.jelly`は、`ARTIFACTS`権限が有効な場合のみ権限チェックを行います。
- ファイル一覧はテーブル形式で表示され、`fileList`クラスが適用されています。

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、成果物のデータ構造を理解します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | Run.java | `core/src/main/java/hudson/model/Run.java` | Artifact内部クラスの定義 |
| 1-2 | ArtifactManager.java | `core/src/main/java/jenkins/model/ArtifactManager.java` | 成果物管理のインターフェース |

**読解のコツ**: `Artifact`はRun内部クラスで、`displayPath`（表示用パス）、`href`（リンク用パス）、`length`（サイズ）を持ちます。

#### Step 2: エントリーポイントを理解する

処理の起点となるJellyテンプレートを確認します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | artifacts-index.jelly | `core/src/main/resources/hudson/model/Run/artifacts-index.jelly` | 成果物一覧画面のメインテンプレート |

**主要処理フロー**:
1. **27行目**: 権限チェック（ARTIFACTSが有効な場合のみ）
2. **28行目**: レイアウト設定（タイトルに`fullDisplayName Artifacts`を使用）
3. **29行目**: サイドパネルのインクルード
4. **30行目**: パンくずリストの設定
5. **31-32行目**: ビルドキャプションの表示
6. **33行目**: テーブル開始（`fileList`クラス）
7. **34-45行目**: 成果物のループ処理
8. **35-37行目**: ファイルアイコン表示
9. **38-40行目**: ファイル名リンク表示
10. **41-43行目**: ファイルサイズ表示

#### Step 3: 成果物管理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | ArtifactManager.java | `core/src/main/java/jenkins/model/ArtifactManager.java` | 成果物管理インターフェース |
| 3-2 | StandardArtifactManager.java | `core/src/main/java/jenkins/model/StandardArtifactManager.java` | デフォルト実装 |

### プログラム呼び出し階層図

```
artifacts-index.jelly (成果物一覧画面)
    │
    ├─ 権限チェック
    │      └─ isArtifactsPermissionEnabled()
    │             └─ hasPermission(ARTIFACTS)
    │
    ├─ sidepanel.jelly (サイドパネル)
    │
    ├─ t:buildCaption (ビルドキャプション)
    │
    └─ テーブル (成果物一覧)
           │
           └─ Run.getArtifacts()
                  │
                  └─ ArtifactManager.root()
                         └─ VirtualFile (ファイルシステム抽象化)
```

### データフロー図

```
[入力]               [処理]                    [出力]

URLリクエスト ───▶ artifacts-index.jelly ───▶ 成果物一覧表示
  /artifact/              │
                          ▼
              権限チェック
                          │
                          ▼
              Run.getArtifacts()
                          │
                          ▼
              ArtifactManager
              (StandardArtifactManager)
                          │
                          ▼
              archive/ディレクトリ
              ファイル一覧取得
                          │
                          ▼
              テーブル形式で表示
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| artifacts-index.jelly | `core/src/main/resources/hudson/model/Run/artifacts-index.jelly` | テンプレート | 成果物一覧画面 |
| sidepanel.jelly | `core/src/main/resources/hudson/model/Run/sidepanel.jelly` | テンプレート | サイドパネル |
| Run.java | `core/src/main/java/hudson/model/Run.java` | ソース | ビルド実行・成果物管理 |
| ArtifactManager.java | `core/src/main/java/jenkins/model/ArtifactManager.java` | ソース | 成果物管理インターフェース |
| StandardArtifactManager.java | `core/src/main/java/jenkins/model/StandardArtifactManager.java` | ソース | デフォルト成果物管理 |
| buildCaption.jelly | `core/src/main/resources/lib/hudson/buildCaption.jelly` | テンプレート | ビルドキャプション |
