# 画面設計書 2-新規ジョブ作成

## 概要

本ドキュメントは、Jenkinsの新規ジョブ（プロジェクト）作成画面の設計仕様を定義するものです。

### 本画面の処理概要

新規ジョブ作成画面は、Jenkins上に新しいビルドジョブを作成するための入力フォームを提供します。ユーザーはジョブ名を入力し、ジョブタイプを選択して新しいジョブを作成します。

**業務上の目的・背景**：CI/CDパイプラインの構築において、新しいプロジェクトやリポジトリに対応するビルドジョブを作成する必要があります。この画面は、Freestyle Project、Pipeline、マルチブランチPipelineなど様々なジョブタイプの中から適切なものを選択し、新規ジョブを効率的に作成するためのインターフェースを提供します。

**画面へのアクセス方法**：ダッシュボードのサイドパネルにある「新規ジョブ作成」リンクをクリックするか、URLで直接 `/view/{viewName}/newJob` または `/newJob` にアクセスします。Item.CREATE権限が必要です。

**主要な操作・処理内容**：
1. ジョブ名（Item name）の入力 - 必須項目で、既存ジョブとの重複チェックあり
2. ジョブタイプの選択 - フリースタイルプロジェクト、Pipeline等から選択
3. 既存ジョブからのコピー - オプションで既存ジョブの設定をコピー可能
4. 作成ボタン押下によるジョブの作成と設定画面への遷移

**画面遷移**：ダッシュボード（View一覧）からこの画面に遷移します。ジョブ作成後はジョブ設定画面に遷移します。

**権限による表示制御**：Item.CREATE権限がないユーザーはこの画面にアクセスできません。権限がない場合は403 Forbiddenエラーが返されます。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 4 | ジョブ（Job） | 主機能 | 新規ジョブの作成処理 |
| 5 | フリースタイルプロジェクト | 補助機能 | フリースタイルプロジェクトタイプの選択 |
| 64 | フォームバリデーション | API連携 | ジョブ名の入力検証 |

## 画面種別

登録

## URL/ルーティング

- `/newJob` - Jenkins直下での新規ジョブ作成
- `/view/{viewName}/newJob` - 特定View配下での新規ジョブ作成

## 入出力項目

| 項目名 | 入力/出力 | データ型 | 必須 | 説明 |
|--------|----------|----------|------|------|
| name | 入力 | String | ○ | ジョブ名 |
| mode | 入力 | String | ○ | ジョブタイプまたは"copy"（コピーモード） |
| from | 入力 | String | - | コピー元ジョブ名（コピーモード時のみ） |

## 表示項目

| 項目名 | データ型 | 説明 |
|--------|----------|------|
| ジョブ名入力フィールド | TextInput | ジョブ名を入力するテキストフィールド |
| ジョブタイプ一覧 | RadioButtonGroup | 選択可能なジョブタイプの一覧（ラジオボタン形式） |
| コピー元入力フィールド | TextInput | 既存ジョブからコピーする場合のジョブ名入力 |
| バリデーションメッセージ | Message | 入力検証エラーメッセージ |

## イベント仕様

### 1-ジョブ名入力

ジョブ名入力フィールドに入力すると、リアルタイムでバリデーションが実行されます。以下のチェックが行われます：
- 空文字チェック
- 使用禁止文字チェック（`/`、`\`、`<`、`>`、`|`、`:`、`?`、`*`等）
- 既存ジョブ名との重複チェック

### 2-ジョブタイプ選択

ラジオボタンでジョブタイプを選択します。選択可能なタイプはプラグインにより拡張されます。

### 3-コピー元選択

「Copy from」ラジオボタンを選択し、テキストボックスにコピー元のジョブ名を入力します。オートコンプリートが提供されます。

### 4-OKボタン押下

入力内容のバリデーションを行い、問題がなければ`createItem`アクションにPOSTリクエストを送信してジョブを作成します。作成成功後、ジョブ設定画面にリダイレクトされます。

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| OKボタン押下 | $JENKINS_HOME/jobs/{jobName}/ | INSERT | ジョブディレクトリとconfig.xmlの作成 |

### テーブル別更新項目詳細

#### Jenkinsファイルシステム（$JENKINS_HOME/jobs/{jobName}/）

| 操作 | 項目 | 更新値・取得条件 | 備考 |
|-----|------|-----------------|------|
| INSERT | config.xml | ジョブタイプに応じた初期設定XML | フォームから収集した設定値 |
| INSERT | nextBuildNumber | 1 | 初期ビルド番号 |

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|-------------|------|---------------|---------|
| ItemName.validation.required | エラー | "Enter an item name" | ジョブ名が空の場合 |
| ItemType.validation.required | エラー | "Please select an item type" | ジョブタイプが未選択の場合 |
| itemname-invalid | エラー | 動的メッセージ | ジョブ名のバリデーションエラー時 |

## 例外処理

| 例外状態 | 処理内容 |
|---------|---------|
| Item.CREATE権限なし | 403 Forbiddenエラー |
| ジョブ名重複 | エラーメッセージ表示、登録不可 |
| 不正な文字使用 | エラーメッセージ表示、登録不可 |
| コピー元ジョブ不存在 | エラーメッセージ表示、登録不可 |

## 備考

- ジョブタイプはTopLevelItemDescriptorを実装するプラグインにより拡張可能です
- 画面のスタイルシートは`add-item.css`、JavaScriptは`add-item.js`で管理されています
- ジョブ名のバリデーションはAjaxで非同期に行われます

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

ジョブ（TopLevelItem）の作成に関わるデータ構造を理解します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | TopLevelItemDescriptor.java | `core/src/main/java/hudson/model/TopLevelItemDescriptor.java` | ジョブタイプの定義 |
| 1-2 | Item.java | `core/src/main/java/hudson/model/Item.java` | CREATE権限の定義 |

**読解のコツ**: TopLevelItemDescriptorはジョブタイプを定義する拡張ポイントです。各ジョブタイプ（FreeStyleProject等）はこれを継承します。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | newJob.jelly | `core/src/main/resources/hudson/model/View/newJob.jelly` | 画面のメインテンプレート |

**主要処理フロー**:
1. **27行目**: Item.CREATE権限のチェック
2. **29行目**: レイアウト定義、権限チェック付き
3. **40行目**: フォーム定義、createItemアクションへPOST
4. **44行目**: ジョブ名入力フィールド
5. **53行目**: ジョブタイプ選択エリア（#items）
6. **56-66行目**: コピーオプション（既存ジョブがある場合のみ表示）

#### Step 3: バリデーションロジックを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | add-item.js | `war/src/main/js/pages/add-item.js` | クライアントサイドバリデーション |
| 3-2 | View.java | `core/src/main/java/hudson/model/View.java` | サーバーサイドバリデーション（checkJobName） |

**主要処理フロー**:
- クライアントサイドでジョブ名の入力をリアルタイム検証
- サーバーサイドでcheckJobNameエンドポイントを呼び出し

#### Step 4: ジョブ作成処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | ItemGroupMixIn.java | `core/src/main/java/hudson/model/ItemGroupMixIn.java` | createTopLevelItemメソッド |

**主要処理フロー**:
- フォームデータからジョブタイプを特定
- 対応するDescriptorのnewInstanceメソッドを呼び出し
- ジョブディレクトリの作成とconfig.xmlの保存

### プログラム呼び出し階層図

```
newJob.jelly (エントリーポイント)
    │
    ├─ add-item.js (クライアントサイド)
    │      ├─ ジョブ名バリデーション
    │      └─ ジョブタイプ選択UI
    │
    └─ createItem (フォーム送信先)
           │
           ├─ View.doCreateItem()
           │      └─ checkJobName() (バリデーション)
           │
           └─ ItemGroupMixIn.createTopLevelItem()
                  └─ TopLevelItemDescriptor.newInstance()
                         └─ config.xml保存
```

### データフロー図

```
[入力]               [処理]                    [出力]

ジョブ名 ───────▶ checkJobName ───▶ バリデーション結果
                        │
ジョブタイプ ────▶ createItem ───▶ config.xml作成
                        │
(コピー元) ──────▶ copyJob ───────▶ ジョブ設定画面へリダイレクト
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| newJob.jelly | `core/src/main/resources/hudson/model/View/newJob.jelly` | テンプレート | メイン画面テンプレート |
| add-item.js | `war/src/main/js/pages/add-item.js` | JavaScript | クライアントサイドロジック |
| add-item.css | `war/src/main/css/pages/add-item.css` | CSS | スタイルシート |
| View.java | `core/src/main/java/hudson/model/View.java` | ソース | バリデーション、ジョブ作成処理 |
| ItemGroupMixIn.java | `core/src/main/java/hudson/model/ItemGroupMixIn.java` | ソース | ジョブ作成のミックスイン |
| TopLevelItemDescriptor.java | `core/src/main/java/hudson/model/TopLevelItemDescriptor.java` | ソース | ジョブタイプ定義 |
| newJobButtonBar.jelly | `core/src/main/resources/hudson/model/View/newJobButtonBar.jelly` | テンプレート | ボタンバーテンプレート |
