# 画面設計書 20-パラメータ入力

## 概要

本ドキュメントは、Jenkinsにおけるパラメータ入力画面の設計仕様を記述したものです。パラメータ付きビルドを実行する際のパラメータ入力フォームを表示する画面です。

### 本画面の処理概要

**業務上の目的・背景**：パラメータ入力画面は、ビルドの動作を実行時にカスタマイズするための画面です。開発チームはこの画面を通じて、ビルド対象のブランチ、デプロイ先の環境、テストのスコープなど、ビルドごとに異なる値を指定できます。これにより、1つのジョブ定義で複数のユースケースに対応でき、CI/CDパイプラインの柔軟性が大幅に向上します。

**画面へのアクセス方法**：パラメータ付きジョブの詳細画面で「Build with Parameters」リンクをクリック、またはURLに直接`/job/{ジョブ名}/build`を指定してアクセスできます。パラメータが定義されていないジョブでは、この画面はスキップされ直接ビルドがキューに追加されます。

**主要な操作・処理内容**：
1. 定義されたパラメータの入力フォーム表示
2. 各パラメータのデフォルト値の表示
3. パラメータ値の入力・選択
4. ビルドの実行（パラメータ付き）

**画面遷移**：
- 遷移元：ジョブ詳細
- 遷移先：ビルド詳細（ビルド開始後）、ビルドキュー

**権限による表示制御**：
- `Job.BUILD`権限がないとアクセス不可
- 個々のパラメータの表示/非表示はパラメータ定義の設定による

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 54 | パラメータ定義 | 主機能 | ビルドパラメータの入力フォーム表示 |
| 55 | 文字列パラメータ | 補助機能 | 文字列入力フィールドの表示 |
| 56 | 選択パラメータ | 補助機能 | プルダウン選択肢の表示 |
| 57 | ブールパラメータ | 補助機能 | チェックボックスの表示 |
| 7 | キュー管理 | 遷移先機能 | ビルドキューへの追加 |

## 画面種別

登録

## URL/ルーティング

```
/job/{ジョブ名}/build
/job/{フォルダ名}/job/{ジョブ名}/build
```

Staplerによりリクエストは`hudson.model.ParametersDefinitionProperty`クラスの`index.jelly`にルーティングされます。

## 入出力項目

| 項目名 | 入出力 | 型 | 必須 | 説明 |
|--------|--------|-----|------|------|
| parameter | 入力 | JSONArray | - | パラメータ名と値のペア |
| delay | 入力 | int | - | ビルド開始までの遅延秒数 |

## 表示項目

| 項目 | 説明 | データソース |
|------|------|------------|
| ジョブ名 | ジョブの表示名とpronoun | `Job.pronoun`, `Job.displayName` |
| 説明 | パラメータ入力の説明テキスト | `description`メッセージ |
| パラメータフォーム | 各パラメータの入力フィールド | `contents.jelly` |
| ビルド実行ボタン | ビルドを開始するボタン | `buildButtonText` |

## イベント仕様

### 1-ビルド実行ボタン押下

入力されたパラメータでビルドを開始します。

- 処理フロー：
  1. POSTリクエストで`build`アクションへ送信
  2. サーバーサイドで`ParametersDefinitionProperty._doBuild()`が呼び出される
  3. JSONからパラメータ値を抽出
  4. 各ParameterDefinitionから`ParameterValue`を生成
  5. ビルドをキューに追加（`Queue.schedule()`）
  6. 成功時、ビルドキューまたはビルド詳細へリダイレクト

### 2-パラメータ値の変更

各パラメータタイプに応じた入力フィールドで値を変更します。

- 文字列パラメータ: テキストボックスで入力
- 選択パラメータ: ドロップダウンで選択
- ブールパラメータ: チェックボックスで切り替え
- ファイルパラメータ: ファイルアップロード

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| ビルド実行ボタン押下 | Queue | INSERT | ビルドキューへの追加 |
| ビルド開始後 | build.xml | INSERT | 新規ビルドの作成 |

### テーブル別更新項目詳細

#### ビルドキュー

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT | actions | ParametersAction | パラメータ値を含むアクション |
| INSERT | causes | CauseAction | UserIdCause（実行ユーザー） |

## メッセージ仕様

| メッセージID | メッセージ内容 | 表示条件 | メッセージ種別 |
|-------------|---------------|---------|--------------|
| description | このビルドはパラメータ化されています | 常時 | 情報 |
| buildButtonText | ビルド | ビルドボタンラベル | 情報 |

## 例外処理

| 例外条件 | 処理内容 | 画面表示 |
|---------|---------|---------|
| ジョブが存在しない | 404エラー | 404エラー画面 |
| 権限不足（BUILD権限なし） | アクセス拒否 | 403エラー画面 |
| パラメータ定義なし | 直接ビルド開始 | パラメータ入力画面は表示されない |
| パラメータ値エラー | IllegalArgumentException | エラーメッセージ表示 |
| ステータスコード | 405 Method Not Allowed | POSTでないアクセスに対して |

## 備考

- HTTPステータスコードは405（Method Not Allowed）を返します。これはGETリクエストでフォームを表示するが、実際のビルドはPOSTで行う必要があるためです。
- `buildButtonText`は`AlternativeUiTextProvider`によりカスタマイズ可能です。
- `contents.jelly`は各`ParameterDefinition`の入力フィールドをレンダリングします。
- `delay`パラメータを指定すると、ビルド開始までの待機時間を設定できます。

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、パラメータ定義のデータ構造を理解します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | ParametersDefinitionProperty.java | `core/src/main/java/hudson/model/ParametersDefinitionProperty.java` | パラメータ定義のコンテナ |
| 1-2 | ParameterDefinition.java | `core/src/main/java/hudson/model/ParameterDefinition.java` | 個別パラメータの基底クラス |
| 1-3 | ParameterValue.java | `core/src/main/java/hudson/model/ParameterValue.java` | パラメータ値の基底クラス |

**読解のコツ**: `ParametersDefinitionProperty`はジョブプロパティとして設定され、複数の`ParameterDefinition`を保持します。各`ParameterDefinition`は対応する`ParameterValue`を生成します。

#### Step 2: エントリーポイントを理解する

処理の起点となるJellyテンプレートを確認します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | index.jelly | `core/src/main/resources/hudson/model/ParametersDefinitionProperty/index.jelly` | パラメータ入力画面のメインテンプレート |

**主要処理フロー**:
1. **37行目**: HTTPステータスコード405を設定
2. **38行目**: レイアウト設定（タイトルにジョブ表示名を使用）
3. **39行目**: ジョブのサイドパネルをインクルード
4. **41行目**: ジョブ名（pronounと表示名）の表示
5. **42行目**: 説明文の表示
6. **43行目**: `contents.jelly`のインクルード（パラメータフォーム）

#### Step 3: パラメータフォームを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | contents.jelly | `core/src/main/resources/hudson/model/ParametersDefinitionProperty/contents.jelly` | パラメータ入力フォーム |

#### Step 4: ビルド処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | ParametersDefinitionProperty.java | `core/src/main/java/hudson/model/ParametersDefinitionProperty.java` | `_doBuild()`メソッドの実装 |

**主要処理フロー**（_doBuild、155-193行目）:
1. **156-157行目**: delayパラメータの処理
2. **160-180行目**: JSONからパラメータ値を抽出
3. **171-174行目**: 各パラメータ定義から値を生成
4. **183-184行目**: キューにビルドを追加
5. **186-192行目**: リダイレクト処理

### プログラム呼び出し階層図

```
index.jelly (パラメータ入力画面)
    │
    ├─ job/sidepanel.jelly (サイドパネル)
    │
    ├─ contents.jelly (パラメータフォーム)
    │      │
    │      └─ 各ParameterDefinition.config.jelly
    │             ├─ StringParameterDefinition
    │             ├─ ChoiceParameterDefinition
    │             ├─ BooleanParameterDefinition
    │             └─ その他...
    │
    └─ build (POSTアクション)
           │
           └─ ParametersDefinitionProperty._doBuild()
                  │
                  ├─ ParameterDefinition.createValue()
                  │
                  └─ Queue.schedule()
                         └─ ParametersAction
                                └─ ParameterValue[]
```

### データフロー図

```
[入力]               [処理]                    [出力]

URLリクエスト ───▶ index.jelly ───▶ パラメータフォーム表示
  /build                  │
                          ▼
              contents.jelly
              (各パラメータ入力)
                          │
                          ▼
フォーム送信 ───▶ _doBuild() ───▶ Queue.schedule()
(POST)                │                    │
                      ▼                    ▼
              JSONパース          ParametersAction
              ParameterValue生成       作成
                                          │
                                          ▼
                                   ビルドキューに追加
                                          │
                                          ▼
                                   リダイレクト
                                   (キューまたはビルド詳細)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| index.jelly | `core/src/main/resources/hudson/model/ParametersDefinitionProperty/index.jelly` | テンプレート | メイン画面 |
| contents.jelly | `core/src/main/resources/hudson/model/ParametersDefinitionProperty/contents.jelly` | テンプレート | パラメータフォーム |
| ParametersDefinitionProperty.java | `core/src/main/java/hudson/model/ParametersDefinitionProperty.java` | ソース | パラメータプロパティ |
| ParameterDefinition.java | `core/src/main/java/hudson/model/ParameterDefinition.java` | ソース | パラメータ定義基底クラス |
| ParameterValue.java | `core/src/main/java/hudson/model/ParameterValue.java` | ソース | パラメータ値基底クラス |
| ParametersAction.java | `core/src/main/java/hudson/model/ParametersAction.java` | ソース | パラメータアクション |
| StringParameterDefinition.java | `core/src/main/java/hudson/model/StringParameterDefinition.java` | ソース | 文字列パラメータ |
| ChoiceParameterDefinition.java | `core/src/main/java/hudson/model/ChoiceParameterDefinition.java` | ソース | 選択パラメータ |
| BooleanParameterDefinition.java | `core/src/main/java/hudson/model/BooleanParameterDefinition.java` | ソース | ブールパラメータ |
