# 画面設計書 21-ノード一覧

## 概要

本ドキュメントは、Jenkins CI/CDサーバーにおける「ノード一覧」画面の設計仕様を定義するものである。

### 本画面の処理概要

ノード一覧画面は、Jenkins環境に登録されているすべてのノード（エージェント）の一覧を表示し、各ノードの状態や監視情報を確認できる画面である。ビルトインノード（コントローラー）および接続されているリモートエージェントの健全性を一目で把握し、必要に応じてノードの追加・設定・状態更新などの操作を行うことができる。

**業務上の目的・背景**：分散ビルド環境においては、複数のノードでビルドを並列実行することでビルド時間を短縮する。この画面は、管理者がノードの稼働状況を監視し、リソースの最適化やトラブルシューティングを行うための中心的なインターフェースとして機能する。ノードがオフラインになった場合や、ディスク容量・メモリなどのリソースが不足している場合に迅速に対応するために必要不可欠な画面である。

**画面へのアクセス方法**：Jenkins管理画面（/manage）から「Nodes」リンクをクリック、またはサイドパネルのナビゲーションから「ノード管理」を選択してアクセスする。直接URLとしては `/computer/` または `/manage/computer/` でアクセス可能。

**主要な操作・処理内容**：
1. ノード一覧の表示 - すべてのノードの名前、状態アイコン、監視データ（ディスク容量、メモリ使用量等）を表形式で表示
2. 新規ノードの作成 - 「New Node」ボタンから新しいエージェントを追加
3. ノードモニター設定 - 「Configure Monitors」ボタンからノード監視の設定を変更
4. 状態の更新 - 「Refresh status」ボタンで監視データを即時更新
5. 個別ノードへのナビゲーション - ノード名クリックでノード詳細画面へ遷移
6. ノード設定へのアクセス - 設定アイコンクリックでノード設定画面へ遷移

**画面遷移**：
- 遷移元：Jenkins管理画面、ダッシュボード、サイドパネル
- 遷移先：ノード詳細画面、ノード設定画面、新規ノード作成画面、ノードモニター設定画面、クラウド一覧画面

**権限による表示制御**：
- Computer.CREATE権限：「New Node」ボタンの表示/非表示
- Jenkins.MANAGE権限またはJenkins.SYSTEM_READ権限：「Configure Monitors」ボタンの表示/非表示
- Jenkins.ADMINISTER権限またはJenkins.MANAGE権限：「Refresh status」ボタンの表示/非表示
- Computer.EXTENDED_READ権限：個別ノードの設定リンクの表示/非表示

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 12 | コンピューター管理 | 主機能 | ノード一覧の表示と状態確認 |
| 13 | ノードモニター | 補助機能 | ノード健全性情報の表示 |
| 10 | エージェントノード | 補助機能 | エージェントノード情報の表示 |

## 画面種別

一覧

## URL/ルーティング

- `/computer/` - ノード一覧画面
- `/manage/computer/` - Jenkins管理画面経由のノード一覧

## 入出力項目

| 項目名 | 項目ID | 入出力 | 型 | 必須 | 説明 |
|--------|--------|--------|-----|------|------|
| - | - | - | - | - | 本画面は入力項目なし（表示のみ） |

## 表示項目

| 項目名 | 項目ID | 型 | 説明 |
|--------|--------|-----|------|
| 状態アイコン | statusIcon | Icon | ノードの状態を示すアイコン（オンライン/オフライン/接続中等） |
| ノード名 | displayName | String | ノードの表示名（リンク） |
| 監視データ列 | monitorData | Dynamic | ノードモニターから取得した各種メトリクス（アーキテクチャ、応答時間、クロック差、空きディスク容量、空き一時領域、空きスワップ容量等） |
| 設定リンク | configureLink | Link | ノード設定画面へのリンクアイコン |
| データ取得時刻 | timestampString | String | 各監視データの最終取得時刻 |

## イベント仕様

### 1-New Nodeボタン押下

「New Node」ボタン押下により、新規ノード作成画面（/computer/new）へ遷移する。ノード名の入力とノードタイプの選択を行う画面が表示される。

### 2-Configure Monitorsボタン押下

「Configure Monitors」ボタン押下により、ノードモニター設定画面（/computer/configure）へ遷移する。各種モニターの有効/無効や閾値を設定できる。

### 3-Refresh statusボタン押下

「Refresh status」ボタン押下（POST /computer/updateNow）により、すべてのノードモニターのデータを即時更新する。更新完了後、現在の画面を再表示する。

### 4-ノード名リンククリック

ノード名のリンクをクリックすると、該当ノードの詳細画面（/computer/{nodeName}/）へ遷移する。

### 5-設定アイコンクリック

設定アイコンをクリックすると、該当ノードの設定画面（/computer/{nodeName}/configure）へ遷移する。

### 6-Legendボタン押下

「Legend」ボタン押下により、ノードアイコンの凡例をモーダルダイアログで表示する。

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| Refresh status | nodeMonitors.xml | UPDATE | ノードモニターデータの更新 |

### テーブル別更新項目詳細

#### nodeMonitors.xml

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| UPDATE | 各モニターデータ | 各NodeMonitorの triggerUpdate()結果 | 非同期で更新 |

## メッセージ仕様

| メッセージID | メッセージ内容 | 表示条件 | 種別 |
|-------------|---------------|----------|------|
| - | ノード一覧画面には定義されたメッセージなし | - | - |

## 例外処理

| 例外条件 | 対応処理 |
|---------|---------|
| 権限不足 | 対応するボタン・リンクが非表示になる |
| ノードが存在しない | 一覧にBuilt-In Nodeのみ表示 |
| モニターデータ取得失敗 | 該当列にN/Aまたは空白を表示 |

## 備考

- ノード一覧はソート可能なテーブルで表示される（sortableクラス）
- アイコンサイズは16x16/24x24/32x32から選択可能
- クラウドプラグインがインストールされている場合、各クラウドからのノード情報も表示される

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、ノード管理に関連するデータ構造を理解することが重要である。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | ComputerSet.java | `core/src/main/java/hudson/model/ComputerSet.java` | ノード一覧を管理するコンテナクラス。getComputers()でノード一覧を取得 |
| 1-2 | Computer.java | `core/src/main/java/hudson/model/Computer.java` | 個々のノードを表すクラス。状態管理、エグゼキュータ管理を担当 |
| 1-3 | IComputer.java | `core/src/main/java/jenkins/model/IComputer.java` | Computerのインターフェース定義 |
| 1-4 | NodeMonitor.java | `core/src/main/java/hudson/node_monitors/NodeMonitor.java` | ノード監視の基底クラス |

**読解のコツ**: ComputerSetはURLの`/computer/`にマッピングされるトップレベルオブジェクト。getComputers()メソッドがノード一覧取得の起点となる。

#### Step 2: エントリーポイントを理解する

処理の起点となるファイル・関数を特定する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | index.jelly | `core/src/main/resources/hudson/model/ComputerSet/index.jelly` | 画面のビューテンプレート。テーブル構造とデータバインディングを確認 |
| 2-2 | ComputerSet.java | `core/src/main/java/hudson/model/ComputerSet.java` | doUpdateNow()メソッドが状態更新処理のエントリーポイント |

**主要処理フロー**:
1. **行30-34**: アプリバーのタイトル設定とNodesLinkの参照
2. **行36-41**: Computer.CREATE権限チェックとNew Nodeボタンの条件付き表示
3. **行42-47**: MANAGE_AND_SYSTEM_READ権限チェックとConfigure Monitorsボタンの条件付き表示
4. **行67-132**: ノード一覧テーブルの構築（ヘッダーと各行のレンダリング）
5. **行83-112**: 各ノードの情報（アイコン、名前、監視データ、設定リンク）の表示

#### Step 3: ノードデータ取得処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | ComputerSet.java | `core/src/main/java/hudson/model/ComputerSet.java` | getComputers()メソッド（行132-135）でノード一覧を取得 |
| 3-2 | ComputerSourceImpl | `core/src/main/java/hudson/model/ComputerSet.java` | 内部クラス（行575-582）がJenkinsからComputer一覧を取得 |

**主要処理フロー**:
- **行132-135**: ExtensionList.lookupFirst(ComputerSource.class).get()でノード一覧を取得し、名前でソート

#### Step 4: ノードモニター更新処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | ComputerSet.java | `core/src/main/java/hudson/model/ComputerSet.java` | doUpdateNow()メソッド（行262-273）で監視データを更新 |

**主要処理フロー**:
- **行262-273**: Jenkins.MANAGE権限チェック後、全NodeMonitorのtriggerUpdate()を呼び出し

### プログラム呼び出し階層図

```
HTTP Request: GET /computer/
    │
    ├─ ComputerSet (Model Object)
    │      ├─ getComputers() → IComputer[]
    │      │      └─ ComputerSourceImpl.get()
    │      │             └─ Jenkins.getComputersCollection()
    │      │
    │      └─ _monitors → DescribableList<NodeMonitor>
    │             └─ NodeMonitor.data(Computer) → モニタリングデータ
    │
    └─ index.jelly (View)
           ├─ l:app-bar → ヘッダー部分
           ├─ <table> → ノード一覧テーブル
           │      └─ j:forEach var="c" items="${it.computers}"
           │             └─ 各ノードの行をレンダリング
           └─ t:iconSize → アイコンサイズ選択UI

HTTP Request: POST /computer/updateNow
    │
    └─ ComputerSet.doUpdateNow()
           └─ NodeMonitor.getAll().forEach(nm -> nm.triggerUpdate())
```

### データフロー図

```
[入力]               [処理]                    [出力]

ブラウザリクエスト   ComputerSet              HTML画面
GET /computer/ ───▶ getComputers() ───▶ index.jelly ───▶ ノード一覧表示
                         │
                         ▼
                    Jenkins.getComputersCollection()
                         │
                         ▼
                    Computer[] (ノード配列)
                         │
                         ▼
                    NodeMonitor.data() ───▶ 監視データ
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| index.jelly | `core/src/main/resources/hudson/model/ComputerSet/index.jelly` | テンプレート | 画面表示用Jellyテンプレート |
| ComputerSet.java | `core/src/main/java/hudson/model/ComputerSet.java` | ソース | ノード一覧管理のモデルクラス |
| Computer.java | `core/src/main/java/hudson/model/Computer.java` | ソース | 個別ノードを表すクラス |
| NodeMonitor.java | `core/src/main/java/hudson/node_monitors/NodeMonitor.java` | ソース | ノード監視の基底クラス |
| _legend.jelly | `core/src/main/resources/hudson/model/ComputerSet/_legend.jelly` | テンプレート | アイコン凡例表示 |
| computer-set.js | `core/src/main/js/pages/computer-set.js` | JavaScript | クライアント側スクリプト |
| Messages.properties | `core/src/main/resources/hudson/model/ComputerSet/Messages.properties` | 設定 | メッセージリソース |
| nodeMonitors.xml | `$JENKINS_HOME/nodeMonitors.xml` | 設定 | ノードモニター設定の永続化ファイル |
