# 画面設計書 22-ノード詳細

## 概要

本ドキュメントは、Jenkins CI/CDサーバーにおける「ノード詳細」画面の設計仕様を定義するものである。

### 本画面の処理概要

ノード詳細画面は、特定のノード（エージェント）の詳細情報を表示する画面である。ノードの状態、モニタリングデータ、ラベル情報、このノードに紐づくジョブ一覧、およびノードの接続状態管理機能を提供する。管理者はこの画面からノードのオンライン/オフライン状態の切り替え、オフライン理由の設定・更新、およびエージェントの手動接続などの操作を行える。

**業務上の目的・背景**：分散ビルド環境において、個々のノードの詳細な状態を把握することは、トラブルシューティングやリソース最適化に不可欠である。この画面は、特定ノードに関する詳細情報を集約し、ノードの健全性確認、関連ジョブの把握、状態管理を一元的に行うためのインターフェースとして機能する。ビルドの失敗原因がノードの状態に起因する場合の調査や、特定ノードへのジョブ割り当て状況の確認に活用される。

**画面へのアクセス方法**：ノード一覧画面からノード名をクリック、またはビルド詳細画面のノードリンクをクリック、もしくは直接URL `/computer/{nodeName}/` でアクセスする。

**主要な操作・処理内容**：
1. ノード状態の表示 - オンライン/オフライン状態、接続情報、オフライン理由の表示
2. モニタリングデータの表示 - アーキテクチャ、応答時間、ディスク容量等の監視データ展開表示
3. ラベル一覧の表示 - ノードに割り当てられたラベルのクラウド表示（ラベル詳細へのリンク）
4. 紐づきジョブ一覧 - このノードに制限されたジョブのプロジェクトビュー表示
5. オフライン切り替え - 一時的にオフラインに設定/オンラインに戻す
6. オフライン理由の更新 - オフライン理由のメッセージを更新
7. 説明の編集 - ノードの説明文を編集
8. エージェントの手動起動 - ComputerLauncherによる手動接続（該当する場合）

**画面遷移**：
- 遷移元：ノード一覧画面、ビルド詳細画面、ジョブ詳細画面
- 遷移先：ノード設定画面、ノード負荷統計画面、ノードオフライン設定画面、ラベル詳細画面、ジョブ詳細画面

**権限による表示制御**：
- Computer.CONFIGURE権限：説明編集ボタンの表示
- Computer.CONNECT権限：オンライン復帰ボタン、オフライン理由更新ボタンの表示
- Computer.DISCONNECT権限：オフライン設定ボタンの表示
- 手動起動コントロールはComputerLauncherによる条件とRetentionStrategyによる許可判定

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 12 | コンピューター管理 | 主機能 | ノードの詳細情報表示 |
| 13 | ノードモニター | 補助機能 | モニタリングデータの表示 |
| 68 | ラベル管理 | 補助機能 | ノードラベルの表示 |
| 4 | ジョブ（Job） | 補助機能 | 関連ジョブの表示 |

## 画面種別

詳細

## URL/ルーティング

- `/computer/{nodeName}/` - ノード詳細画面
- `/computer/(built-in)/` - ビルトインノード（コントローラー）の詳細

## 入出力項目

| 項目名 | 項目ID | 入出力 | 型 | 必須 | 説明 |
|--------|--------|--------|-----|------|------|
| オフラインメッセージ | offlineMessage | 入力 | String | No | オフライン設定/更新時の理由メッセージ |

## 表示項目

| 項目名 | 項目ID | 型 | 説明 |
|--------|--------|-----|------|
| ノード名 | caption | String | ノードの表示名（タイトル） |
| 状態アイコン | iconClassName | Icon | ノードの状態アイコン |
| オフライン理由 | offlineCause | OfflineCause | オフライン時の理由オブジェクト（cause.jellyで表示） |
| モニタリングデータ | monitoringData | Map | NodeMonitorから取得した監視データのマップ |
| ラベル一覧 | labelCloud | List | ノードに割り当てられたラベルのリスト |
| 紐づきジョブ | tiedJobs | List | このノードに制限されたジョブ一覧 |
| 説明 | description | String | ノードの説明文 |

## イベント仕様

### 1-説明編集ボタン押下

説明編集ボタン押下により、ノードの説明文を編集するダイアログが表示される。Computer.CONFIGURE権限が必要。

### 2-オフライン設定ボタン押下

「Mark this node temporarily offline」ボタン押下（POST markOffline）により、オフライン設定画面（/computer/{nodeName}/markOffline）へ遷移する。Computer.DISCONNECT権限が必要。

### 3-オンライン復帰ボタン押下

「Bring this node back online」ボタン押下（POST toggleOffline）により、ノードをオンライン状態に復帰させる。処理完了後、現在の画面にリダイレクトする。Computer.CONNECT権限が必要。

### 4-オフライン理由更新ボタン押下

「Update offline cause」ボタン押下（POST setOfflineCause）により、オフライン理由更新画面へ遷移する。Computer.CONNECT権限が必要。

### 5-ラベルリンククリック

ラベル名のリンクをクリックすると、該当ラベルの詳細画面（/label/{labelName}）へ遷移する。

### 6-ジョブリンククリック

紐づきジョブ一覧のジョブ名リンクをクリックすると、該当ジョブの詳細画面へ遷移する。

### 7-手動起動コントロール操作

ComputerLauncherによる手動起動コントロール（app-bar-controls.jelly）の操作により、エージェントの接続処理を開始する。

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| オンライン復帰 | Node設定 | UPDATE | temporaryOfflineCauseをnullに設定 |
| オフライン設定 | Node設定 | UPDATE | temporaryOfflineCauseを設定 |
| 説明編集 | Node設定 | UPDATE | nodeDescriptionを更新 |

### テーブル別更新項目詳細

#### Node設定（config.xml内）

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| UPDATE | temporaryOfflineCause | OfflineCause.UserCause or null | ノードのオフライン状態管理 |
| UPDATE | nodeDescription | ユーザー入力値 | 説明文 |

## メッセージ仕様

| メッセージID | メッセージ内容 | 表示条件 | 種別 |
|-------------|---------------|----------|------|
| title.projects_tied_on | Projects tied to {0} | 常時表示 | 見出し |
| title.no_manual_launch | This node is managed by {0} which disallows manual launch | 手動起動不可時 | 説明 |
| None | None | 紐づきジョブがない場合 | 情報 |

## 例外処理

| 例外条件 | 対応処理 |
|---------|---------|
| ノードが存在しない | 404エラー |
| 権限不足 | 対応するボタン・リンクが非表示になる |
| オフライン理由がない | オフライン理由セクションを非表示 |

## 備考

- ノードがオフラインの場合、オフライン理由がcause.jellyでレンダリングされる
- ラベルはクラウド形式で表示され、セルフラベル（ノード名そのもの）は除外される
- モニタリングデータは「Monitoring Data」セクションに折りたたみ可能な形式で表示
- 新旧UIの切り替えは本画面では適用されない

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、ノードの詳細情報に関連するデータ構造を理解することが重要である。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | Computer.java | `core/src/main/java/hudson/model/Computer.java` | ノードの実行状態を管理するクラス。エグゼキュータ管理、状態管理を担当 |
| 1-2 | Node.java | `core/src/main/java/hudson/model/Node.java` | ノードの設定を表すクラス。ラベル、説明等を保持 |
| 1-3 | OfflineCause.java | `core/src/main/java/hudson/slaves/OfflineCause.java` | オフライン理由を表すクラス階層 |
| 1-4 | NodeMonitor.java | `core/src/main/java/hudson/node_monitors/NodeMonitor.java` | ノード監視データの基底クラス |

**読解のコツ**: ComputerはNodeの「実行時の状態」を表し、NodeはComputerの「設定・定義」を表す。getNode()でComputerからNodeを取得できる。

#### Step 2: エントリーポイントを理解する

処理の起点となるファイル・関数を特定する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | index.jelly | `core/src/main/resources/hudson/model/Computer/index.jelly` | 画面のビューテンプレート。レイアウト構造とデータバインディングを確認 |
| 2-2 | sidepanel.jelly | `core/src/main/resources/hudson/model/Computer/sidepanel.jelly` | サイドパネルのナビゲーション構造 |

**主要処理フロー**:
1. **行27-28**: レイアウト開始、ノードのdisplayNameをタイトルに設定
2. **行31-57**: アプリバーの構築（説明編集、手動起動、オフライン切り替えボタン）
3. **行61-63**: オフライン時のオフライン理由表示
4. **行65-67**: ComputerLauncherによる手動起動UI（該当する場合）
5. **行73-83**: モニタリングデータの展開表示
6. **行85-96**: ラベルクラウドの表示
7. **行100-111**: 紐づきジョブ一覧の表示

#### Step 3: 状態切り替え処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | Computer.java | `core/src/main/java/hudson/model/Computer.java` | doToggleOffline()メソッド（行1401-1414）で状態切り替え |
| 3-2 | Computer.java | `core/src/main/java/hudson/model/Computer.java` | setTemporaryOfflineCause()メソッド（行725-731）で理由設定 |

**主要処理フロー**:
- **行1401-1414**: doToggleOffline()がオフライン状態を切り替え
- **行1416-1421**: doChangeOfflineCause()がオフライン理由を更新
- **行725-731**: setTemporaryOfflineCause()がNode.setTemporaryOfflineCause()を呼び出し

#### Step 4: モニタリングデータ取得を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | Computer.java | `core/src/main/java/hudson/model/Computer.java` | getMonitoringData()メソッド（行1141-1150）で監視データを取得 |

**主要処理フロー**:
- **行1141-1150**: NodeMonitor.getAll()から各モニターのデータを収集してMapで返却

### プログラム呼び出し階層図

```
HTTP Request: GET /computer/{nodeName}/
    │
    ├─ Computer (Model Object)
    │      ├─ getCaption() → 表示名
    │      ├─ isTemporarilyOffline() → オフライン状態
    │      ├─ getOfflineCause() → オフライン理由
    │      ├─ getMonitoringData() → Map<NodeMonitor, Object>
    │      ├─ getNode()
    │      │      ├─ getAssignedLabels() → ラベル一覧
    │      │      └─ getLabelCloud() → クラウド形式ラベル
    │      └─ getTiedJobs() → List<AbstractProject>
    │
    └─ index.jelly (View)
           ├─ l:app-bar → ヘッダー・操作ボタン
           ├─ st:include cause.jelly → オフライン理由
           ├─ f:advanced (Monitoring Data) → 監視データ
           ├─ labelCloud forEach → ラベル表示
           └─ t:projectView → 紐づきジョブ

HTTP Request: POST /computer/{nodeName}/toggleOffline
    │
    └─ Computer.doToggleOffline()
           ├─ isTemporarilyOffline() → 現在の状態確認
           ├─ checkPermission(CONNECT) → 権限チェック
           └─ setTemporaryOfflineCause(null) → オンラインに復帰
```

### データフロー図

```
[入力]               [処理]                    [出力]

ブラウザリクエスト   Computer                 HTML画面
GET /computer/x/ ───▶ getNode() ───▶ index.jelly ───▶ ノード詳細表示
                         │
                         ▼
                    Node (設定情報)
                         │
                    ┌────┴────┐
                    ▼         ▼
             getLabels()  getDescription()
                    │         │
                    ▼         ▼
              ラベル一覧   説明文

                    getMonitoringData()
                         │
                         ▼
                    NodeMonitor.getAll()
                         │
                         ▼
                    監視データMap
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| index.jelly | `core/src/main/resources/hudson/model/Computer/index.jelly` | テンプレート | 画面表示用Jellyテンプレート |
| sidepanel.jelly | `core/src/main/resources/hudson/model/Computer/sidepanel.jelly` | テンプレート | サイドパネル用テンプレート |
| Computer.java | `core/src/main/java/hudson/model/Computer.java` | ソース | ノード実行状態管理クラス |
| Node.java | `core/src/main/java/hudson/model/Node.java` | ソース | ノード設定クラス |
| OfflineCause.java | `core/src/main/java/hudson/slaves/OfflineCause.java` | ソース | オフライン理由クラス |
| cause.jelly | `core/src/main/resources/hudson/slaves/OfflineCause/cause.jelly` | テンプレート | オフライン理由表示 |
| nodepropertysummaries.jelly | `core/src/main/resources/hudson/model/Computer/nodepropertysummaries.jelly` | テンプレート | ノードプロパティサマリー |
| Messages.properties | `core/src/main/resources/hudson/model/Computer/Messages.properties` | 設定 | メッセージリソース |
