# 画面設計書 24-ノード負荷統計

## 概要

本ドキュメントは、Jenkins CI/CDサーバーにおける「ノード負荷統計」画面の設計仕様を定義するものである。

### 本画面の処理概要

ノード負荷統計画面は、特定のノード（エージェント）の負荷統計情報をグラフ形式で表示する画面である。時間経過に伴うエグゼキュータ使用状況、キュー待ちビルド数、利用可能エグゼキュータ数などの推移をビジュアルに確認できる。LoadStatisticsクラスによって収集された統計データを、異なる時間スケール（短期/中期/長期）で可視化する。

**業務上の目的・背景**：分散ビルド環境において、各ノードの負荷状況を把握することは、リソース配置の最適化やキャパシティプランニングに不可欠である。この画面は、特定ノードの負荷傾向を分析し、エグゼキュータ数の調整判断、ピーク時間の特定、ボトルネックの発見などに活用される。クラウドプロビジョニングのチューニングや、追加ノードの必要性判断にも役立つ。

**画面へのアクセス方法**：ノード詳細画面のサイドパネルから「Load Statistics」リンクをクリック、または直接URL `/computer/{nodeName}/load-statistics/` でアクセスする。

**主要な操作・処理内容**：
1. 負荷統計グラフの表示 - 短期/中期/長期の時間スケールでグラフを表示
2. グラフの解釈 - ビジー/アイドル/利用可能/キュー待ちの各指標を色分け表示

**画面遷移**：
- 遷移元：ノード詳細画面
- 遷移先：なし（情報表示のみ）

**権限による表示制御**：
- 特別な権限制御なし（ノード詳細画面にアクセスできるユーザーは閲覧可能）

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 48 | ロード統計 | 主機能 | ノードの負荷統計グラフ表示 |
| 12 | コンピューター管理 | 補助機能 | ノード統計データの取得 |

## 画面種別

詳細（グラフ表示）

## URL/ルーティング

- `/computer/{nodeName}/load-statistics/` - ノード負荷統計画面

## 入出力項目

| 項目名 | 項目ID | 入出力 | 型 | 必須 | 説明 |
|--------|--------|--------|-----|------|------|
| - | - | - | - | - | 本画面は入力項目なし（表示のみ） |

## 表示項目

| 項目名 | 項目ID | 型 | 説明 |
|--------|--------|-----|------|
| ページタイトル | title | String | 「{nodeName} Load Statistics」形式のタイトル |
| 短期グラフ | shortGraph | Image | 直近の負荷統計グラフ |
| 中期グラフ | mediumGraph | Image | 中期の負荷統計グラフ |
| 長期グラフ | longGraph | Image | 長期の負荷統計グラフ |

## イベント仕様

### 1-グラフ表示

画面表示時に、LoadStatisticsオブジェクトからグラフデータを取得し、main.jellyテンプレートで描画する。グラフは自動的に更新されない（ページリロードが必要）。

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| - | - | - | 本画面はデータ更新なし（表示のみ） |

## メッセージ仕様

| メッセージID | メッセージ内容 | 表示条件 | 種別 |
|-------------|---------------|----------|------|
| - | - | - | 本画面にメッセージなし |

## 例外処理

| 例外条件 | 対応処理 |
|---------|---------|
| ノードが存在しない | 404エラー |
| 統計データがない | 空のグラフを表示 |

## 備考

- グラフはLoadStatistics.main.jellyで描画される
- 統計データはJenkins内部で定期的に収集され、メモリ上に保持される
- 時間スケールは短期（分単位）、中期（時間単位）、長期（日単位）の3種類
- グラフの凡例: Busy executors（赤）、Total executors（青）、Available executors（緑）、Queue length（紫）

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、負荷統計に関連するデータ構造を理解することが重要である。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | LoadStatistics.java | `core/src/main/java/hudson/model/LoadStatistics.java` | 負荷統計データを保持・計算するクラス |
| 1-2 | MultiStageTimeSeries.java | `core/src/main/java/hudson/model/MultiStageTimeSeries.java` | 複数時間スケールの時系列データ |

**読解のコツ**: LoadStatisticsは各ノード/ラベルに関連付けられ、定期的に統計を更新。getLoadStatistics()でComputerから取得可能。

#### Step 2: エントリーポイントを理解する

処理の起点となるファイル・関数を特定する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | load-statistics.jelly | `core/src/main/resources/hudson/model/Computer/load-statistics.jelly` | 画面のビューテンプレート |
| 2-2 | main.jelly | `core/src/main/resources/hudson/model/LoadStatistics/main.jelly` | グラフ描画テンプレート |

**主要処理フロー**:
1. **行27**: レイアウト開始、「{nodeName} Load Statistics」タイトル
2. **行29**: パンくずリストに「Load Statistics」追加
3. **行31**: LoadStatisticsのmain.jellyをインクルード

#### Step 3: 統計データ取得処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | Computer.java | `core/src/main/java/hudson/model/Computer.java` | getLoadStatistics()メソッド（行607-610）で統計取得 |

**主要処理フロー**:
- **行607-610**: getLoadStatistics()がLabelAtomからloadStatisticsフィールドを取得

### プログラム呼び出し階層図

```
HTTP Request: GET /computer/{nodeName}/load-statistics/
    │
    ├─ Computer (Model Object)
    │      └─ getLoadStatistics() → LoadStatistics
    │             └─ LabelAtom.loadStatistics
    │
    └─ load-statistics.jelly (View)
           └─ st:include main.jelly from LoadStatistics
                  ├─ 短期グラフ描画
                  ├─ 中期グラフ描画
                  └─ 長期グラフ描画
```

### データフロー図

```
[入力]               [処理]                    [出力]

ブラウザリクエスト   Computer                 HTML画面
GET .../load-statistics/ ───▶ getLoadStatistics() ───▶ グラフ表示
                                    │
                                    ▼
                              LoadStatistics
                                    │
                              ┌─────┼─────┐
                              ▼     ▼     ▼
                           短期   中期   長期
                          統計   統計   統計
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| load-statistics.jelly | `core/src/main/resources/hudson/model/Computer/load-statistics.jelly` | テンプレート | 画面表示用テンプレート |
| main.jelly | `core/src/main/resources/hudson/model/LoadStatistics/main.jelly` | テンプレート | グラフ描画テンプレート |
| Computer.java | `core/src/main/java/hudson/model/Computer.java` | ソース | getLoadStatistics()による統計取得 |
| LoadStatistics.java | `core/src/main/java/hudson/model/LoadStatistics.java` | ソース | 負荷統計データクラス |
| MultiStageTimeSeries.java | `core/src/main/java/hudson/model/MultiStageTimeSeries.java` | ソース | 時系列データクラス |
