# 画面設計書 26-クラウド一覧

## 概要

本ドキュメントは、Jenkins CI/CDサーバーにおける「クラウド一覧」画面の設計仕様を定義するものである。

### 本画面の処理概要

クラウド一覧画面は、Jenkinsに設定されているすべてのクラウドプロバイダーの一覧を表示する画面である。クラウドは、ビルド需要に応じて動的にエージェントノードをプロビジョニングするための設定であり、AWS EC2、Kubernetes、Docker Cloud等の各種クラウドプラグインによって提供される。この画面では、クラウドの追加、編集、削除、順序変更などの管理操作を行える。

**業務上の目的・背景**：動的なビルドインフラストラクチャを構築する際、クラウドベースのノードプロビジョニングは不可欠である。この画面は、設定されているクラウドプロバイダーの一覧を把握し、新規クラウドの追加や既存クラウドの設定変更を行うための中心的なインターフェースとして機能する。複数のクラウドプロバイダーを優先順位付きで管理し、柔軟なリソース調達を実現するために必要な画面である。

**画面へのアクセス方法**：Jenkins管理画面から「Clouds」リンクをクリック、またはノード一覧画面から「Manage clouds」リンクをクリック、もしくは直接URL `/cloud/` でアクセスする。

**主要な操作・処理内容**：
1. クラウド一覧の表示 - 設定されているすべてのクラウドをアイコン、名前、タイプ付きで表示
2. 新規クラウドの追加 - 「New cloud」ボタンから新しいクラウドを追加
3. クラウドの順序変更 - ドラッグ＆ドロップまたは上下矢印でクラウドの優先順位を変更
4. クラウドの編集 - クラウド名クリックでクラウド詳細・設定画面へ遷移
5. クラウドの削除 - 削除ボタンでクラウドを削除

**画面遷移**：
- 遷移元：Jenkins管理画面、ノード一覧画面
- 遷移先：クラウド詳細画面、クラウド設定画面、新規クラウド作成画面

**権限による表示制御**：
- Jenkins.SYSTEM_READ権限：クラウド一覧の閲覧
- Jenkins.ADMINISTER権限：クラウドの追加、削除、順序変更

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 11 | クラウド | 主機能 | クラウドプロバイダーの一覧管理 |
| 10 | エージェントノード | 補助機能 | 動的ノードプロビジョニング |

## 画面種別

一覧

## URL/ルーティング

- `/cloud/` - クラウド一覧画面
- `/manage/cloud/` - Jenkins管理画面経由のクラウド一覧

## 入出力項目

| 項目名 | 項目ID | 入出力 | 型 | 必須 | 説明 |
|--------|--------|--------|-----|------|------|
| - | - | - | - | - | 本画面は入力項目なし（表示のみ） |

## 表示項目

| 項目名 | 項目ID | 型 | 説明 |
|--------|--------|-----|------|
| クラウドアイコン | icon | Icon | クラウドタイプのアイコン |
| クラウド名 | name | String | クラウドの名前（リンク） |
| クラウドタイプ | descriptorDisplayName | String | クラウドプラグインの種類 |
| 削除ボタン | deleteButton | Button | クラウドを削除するボタン |

## イベント仕様

### 1-New cloudボタン押下

「New cloud」ボタン押下により、新規クラウド作成画面へ遷移する。クラウドタイプの選択とクラウド名の入力を行う。

### 2-クラウド名リンククリック

クラウド名のリンクをクリックすると、該当クラウドの詳細画面（/cloud/{cloudName}/）へ遷移する。

### 3-削除ボタン押下

削除ボタン押下（POST doDoDelete）により、該当クラウドを削除する。確認ダイアログが表示される場合がある。

### 4-順序変更操作

ドラッグ＆ドロップまたは上下矢印ボタンにより、クラウドの順序を変更する。変更はdoReorderで保存される。

### 5-Save orderボタン押下

順序変更後、「Save order」ボタン押下（POST doReorder）により、クラウドの順序を保存する。

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| クラウド削除 | config.xml | DELETE | cloudsリストから該当クラウドを削除 |
| 順序変更 | config.xml | UPDATE | cloudsリストの順序を更新 |

### テーブル別更新項目詳細

#### config.xml（Jenkins設定）

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| DELETE | clouds/{cloudName} | 削除対象のクラウド | クラウド設定を削除 |
| UPDATE | clouds | 並び替え後のリスト | クラウド順序を更新 |

## メッセージ仕様

| メッセージID | メッセージ内容 | 表示条件 | 種別 |
|-------------|---------------|----------|------|
| CloudSet_DisplayName | Clouds | 常時表示 | タイトル |
| CloudSet_CloudAlreadyExists | A cloud named {0} already exists | 名前重複時 | エラー |
| CloudSet_NoSuchCloud | No such cloud {0} | クラウドが存在しない時 | エラー |

## 例外処理

| 例外条件 | 対応処理 |
|---------|---------|
| 権限不足（SYSTEM_READ以下） | アクセス拒否（403） |
| クラウドプラグインがない | 「No cloud implementations available」メッセージ表示 |
| クラウド削除失敗 | エラーメッセージ表示 |

## 備考

- クラウドプラグインがインストールされていない場合、プラグインマネージャーへのリンクが表示される
- クラウドの順序は、ノードプロビジョニング時の優先順位に影響する
- クラウド名は一意である必要がある
- クラウド一覧は並び替え可能なテーブルで表示される（sortable）

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、クラウドに関連するデータ構造を理解することが重要である。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | CloudSet.java | `core/src/main/java/jenkins/agents/CloudSet.java` | クラウド一覧を管理するコンテナクラス |
| 1-2 | Cloud.java | `core/src/main/java/hudson/slaves/Cloud.java` | 個々のクラウドを表す基底クラス |
| 1-3 | Jenkins.CloudList | `core/src/main/java/jenkins/model/Jenkins.java` | Jenkinsのcloudsフィールドの型 |

**読解のコツ**: CloudSetはURLの`/cloud/`にマッピングされるトップレベルオブジェクト。getClouds()でクラウド一覧を取得できる。

#### Step 2: エントリーポイントを理解する

処理の起点となるファイル・関数を特定する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | index.jelly | `core/src/main/resources/jenkins/agents/CloudSet/index.jelly` | 画面のビューテンプレート |

**主要処理フロー**:
1. **行29-35**: アプリバーのタイトル設定とNew cloudボタン
2. **行36-42**: クラウドがない場合のメッセージ表示
3. **行44-78**: クラウド一覧テーブルの構築
4. **行80-88**: Save orderボタンとフォーム

#### Step 3: クラウド操作処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | CloudSet.java | `core/src/main/java/jenkins/agents/CloudSet.java` | doCreate()、doDoCreate()、doReorder()メソッド |
| 3-2 | Cloud.java | `core/src/main/java/hudson/slaves/Cloud.java` | doDoDelete()メソッド（行312-317）で削除 |

**主要処理フロー**:
- **CloudSet.doCreate() 行207-246**: 新規クラウド作成の第一段階（名前・タイプ選択）
- **CloudSet.doDoCreate() 行261-275**: 新規クラウド作成の実行
- **CloudSet.doReorder() 行277-289**: クラウド順序の変更
- **Cloud.doDoDelete() 行312-317**: クラウドの削除

### プログラム呼び出し階層図

```
HTTP Request: GET /cloud/
    │
    ├─ CloudSet (Model Object)
    │      ├─ getClouds() → Jenkins.CloudList
    │      ├─ hasClouds() → boolean
    │      └─ isCloudAvailable() → boolean (プラグイン有無)
    │
    └─ index.jelly (View)
           ├─ l:app-bar → ヘッダー・New cloudボタン
           ├─ <table> → クラウド一覧テーブル
           │      └─ j:forEach var="c" items="${it.clouds}"
           │             └─ 各クラウドの行をレンダリング
           └─ f:form → doReorderへPOST (順序変更)

HTTP Request: POST /cloud/doReorder
    │
    └─ CloudSet.doReorder()
           ├─ checkPermission(ADMINISTER)
           ├─ req.getParameterValues("name")
           └─ Jenkins.get().clouds.replaceBy(sortedList)

HTTP Request: POST /cloud/{name}/doDelete
    │
    └─ Cloud.doDoDelete()
           ├─ checkPermission(ADMINISTER)
           └─ Jenkins.get().clouds.remove(this)
```

### データフロー図

```
[入力]               [処理]                    [出力]

ブラウザリクエスト   CloudSet                 HTML画面
GET /cloud/ ───▶ getClouds() ───▶ index.jelly ───▶ クラウド一覧表示
                         │
                         ▼
                    Jenkins.clouds
                         │
                         ▼
                    Cloud[] (クラウド配列)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| index.jelly | `core/src/main/resources/jenkins/agents/CloudSet/index.jelly` | テンプレート | 画面表示用Jellyテンプレート |
| CloudSet.java | `core/src/main/java/jenkins/agents/CloudSet.java` | ソース | クラウド一覧管理のモデルクラス |
| Cloud.java | `core/src/main/java/hudson/slaves/Cloud.java` | ソース | クラウド基底クラス |
| _new.jelly | `core/src/main/resources/jenkins/agents/CloudSet/_new.jelly` | テンプレート | 新規クラウド作成フォーム |
| CloudsLink.java | `core/src/main/java/jenkins/agents/CloudsLink.java` | ソース | 管理画面へのリンク |
| Messages.properties | `core/src/main/resources/jenkins/agents/Messages.properties` | 設定 | メッセージリソース |
