# 画面設計書 27-クラウド詳細

## 概要

本ドキュメントは、Jenkins CI/CDサーバーにおける「クラウド詳細」画面の設計仕様を定義するものである。

### 本画面の処理概要

クラウド詳細画面は、特定のクラウドプロバイダーの詳細情報を表示する画面である。クラウドの設定概要、プロビジョニング状況、関連アクションなどを確認できる。この画面はCloud基底クラスの標準的なビューを提供し、各クラウドプラグインは独自のtop.jelly、main.jelly、sidepanel.jellyを提供することでカスタマイズ可能である。

**業務上の目的・背景**：動的ノードプロビジョニングを使用する際、クラウドプロバイダーの状態確認やトラブルシューティングが必要になる。この画面は、クラウドの設定情報を確認し、設定画面へのナビゲーション、関連アクション（プロビジョニングログの確認等）へのアクセスを提供するインターフェースとして機能する。

**画面へのアクセス方法**：クラウド一覧画面からクラウド名をクリック、または直接URL `/cloud/{cloudName}/` でアクセスする。

**主要な操作・処理内容**：
1. クラウド概要の表示 - クラウドの基本情報とステータス表示
2. 設定画面へのナビゲーション - サイドパネルの「Configure」リンク
3. アクションの実行 - クラウド固有のアクション（プラグインにより異なる）
4. クラウドの削除 - 「Delete Cloud」ボタンでクラウドを削除

**画面遷移**：
- 遷移元：クラウド一覧画面
- 遷移先：クラウド設定画面、クラウド一覧画面（削除後）

**権限による表示制御**：
- Jenkins.SYSTEM_READ権限：クラウド詳細の閲覧
- Jenkins.ADMINISTER権限：クラウドの削除、設定変更

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 11 | クラウド | 主機能 | クラウドプロバイダーの詳細表示 |

## 画面種別

詳細

## URL/ルーティング

- `/cloud/{cloudName}/` - クラウド詳細画面

## 入出力項目

| 項目名 | 項目ID | 入出力 | 型 | 必須 | 説明 |
|--------|--------|--------|-----|------|------|
| - | - | - | - | - | 本画面は入力項目なし（表示のみ） |

## 表示項目

| 項目名 | 項目ID | 型 | 説明 |
|--------|--------|-----|------|
| クラウドアイコン | icon | Icon | クラウドタイプのアイコン |
| クラウド名 | displayName | String | クラウドの表示名 |
| クラウドタイプ | descriptorDisplayName | String | クラウドプラグインの種類 |
| アクション一覧 | actions | List | クラウドに関連するアクションのリスト |

## イベント仕様

### 1-Configureリンククリック

サイドパネルの「Configure」リンクをクリックすると、クラウド設定画面（/cloud/{cloudName}/configure）へ遷移する。

### 2-Delete Cloudボタン押下

「Delete Cloud」ボタン押下（POST doDoDelete）により、クラウドを削除する。処理完了後、クラウド一覧画面へリダイレクトする。

### 3-アクションリンククリック

各アクションのリンクをクリックすると、該当アクションの画面へ遷移する。アクションはクラウドプラグインにより提供される。

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| クラウド削除 | config.xml | DELETE | cloudsリストから該当クラウドを削除 |

### テーブル別更新項目詳細

#### config.xml（Jenkins設定）

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| DELETE | clouds/{cloudName} | 削除対象のクラウド | クラウド設定を削除 |

## メッセージ仕様

| メッセージID | メッセージ内容 | 表示条件 | 種別 |
|-------------|---------------|----------|------|
| - | Delete Cloud | サイドパネル | リンクラベル |
| - | Configure | サイドパネル | リンクラベル |

## 例外処理

| 例外条件 | 対応処理 |
|---------|---------|
| クラウドが存在しない | 404エラー |
| 権限不足 | アクセス拒否（403） |

## 備考

- クラウドプラグインは独自のindex.jelly、top.jelly、main.jelly、sidepanel.jellyを提供可能
- アクションはTransientCloudActionFactoryにより動的に追加される場合がある
- 基底クラスのindex.jellyはプラグインのビューがない場合のフォールバック

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、クラウドに関連するデータ構造を理解することが重要である。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | Cloud.java | `core/src/main/java/hudson/slaves/Cloud.java` | クラウドの基底クラス、name、URL、権限管理 |
| 1-2 | Actionable.java | `core/src/main/java/hudson/model/Actionable.java` | アクション管理の基底クラス |

**読解のコツ**: Cloudはnameフィールドを持ち、getUrl()でURLパスを生成。ActionableからgetActions()でアクション一覧を取得可能。

#### Step 2: エントリーポイントを理解する

処理の起点となるファイル・関数を特定する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | index.jelly | `core/src/main/resources/hudson/slaves/Cloud/index.jelly` | 画面のビューテンプレート |

**主要処理フロー**:
1. **行27-28**: レイアウト開始、タイトル設定
2. **行30**: sidepanel.jellyのインクルード
3. **行32-37**: top.jellyがあればインクルード
4. **行39-45**: main.jellyがあればインクルード
5. **行47-49**: アクションサマリーの表示

#### Step 3: クラウド操作処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | Cloud.java | `core/src/main/java/hudson/slaves/Cloud.java` | doDoDelete()メソッド（行312-317）で削除 |
| 3-2 | Cloud.java | `core/src/main/java/hudson/slaves/Cloud.java` | doConfigSubmit()メソッド（行322-341）で設定更新 |

**主要処理フロー**:
- **行312-317**: doDoDelete()がADMINISTER権限をチェック後、cloudsリストから削除
- **行322-341**: doConfigSubmit()が設定フォームを受け取り、クラウドを再構成・置換

### プログラム呼び出し階層図

```
HTTP Request: GET /cloud/{cloudName}/
    │
    ├─ Cloud (Model Object)
    │      ├─ getDisplayName() → 表示名
    │      ├─ getUrl() → "cloud/{name}/"
    │      ├─ getIcon() → アイコン
    │      └─ getActions() → アクションリスト
    │
    └─ index.jelly (View)
           ├─ l:layout → レイアウト
           ├─ st:include sidepanel.jelly
           ├─ st:include top.jelly (optional)
           ├─ st:include main.jelly (optional)
           └─ t:summary → アクションサマリー

HTTP Request: POST /cloud/{cloudName}/doDelete
    │
    └─ Cloud.doDoDelete()
           ├─ checkPermission(ADMINISTER)
           └─ Jenkins.get().clouds.remove(this)
                  └─ HttpRedirect("..")
```

### データフロー図

```
[入力]               [処理]                    [出力]

ブラウザリクエスト   Cloud                    HTML画面
GET /cloud/x/ ───▶ getDisplayName() ───▶ index.jelly ───▶ クラウド詳細表示
                   getActions()               │
                                              ▼
                                      プラグイン固有ビュー
                                      (top.jelly, main.jelly)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| index.jelly | `core/src/main/resources/hudson/slaves/Cloud/index.jelly` | テンプレート | 画面表示用テンプレート |
| sidepanel.jelly | `core/src/main/resources/hudson/slaves/Cloud/sidepanel.jelly` | テンプレート | サイドパネル用テンプレート |
| Cloud.java | `core/src/main/java/hudson/slaves/Cloud.java` | ソース | クラウド基底クラス |
| configure.jelly | `core/src/main/resources/hudson/slaves/Cloud/configure.jelly` | テンプレート | 設定画面用テンプレート |
