# 画面設計書 28-Jenkins管理

## 概要

本ドキュメントは、Jenkins CI/CDサーバーにおける「Jenkins管理」画面の設計仕様を定義するものである。

### 本画面の処理概要

Jenkins管理画面は、Jenkinsシステムの管理機能への中央アクセスポイントとなる画面である。システム設定、セキュリティ設定、プラグイン管理、ノード管理、システム情報表示など、Jenkinsの管理に必要な各種機能へのリンクを一覧で提供する。また、管理通知（AdministrativeMonitor）がある場合はその警告も表示する。

**業務上の目的・背景**：Jenkins管理者がシステム全体の設定・監視・保守を行うための統合的なダッシュボードとして機能する。日常的な管理タスク（プラグインの更新、セキュリティ設定の確認、システムログの確認等）への迅速なアクセスを提供し、管理効率を向上させる。新しいUIフラグが有効な場合は、configureページへリダイレクトされる。

**画面へのアクセス方法**：Jenkinsトップページのサイドパネルから「Manage Jenkins」リンクをクリック、または直接URL `/manage/` でアクセスする。

**主要な操作・処理内容**：
1. 管理リンク一覧の表示 - カテゴリ別にManagementLinkを表示
2. 管理通知の確認 - セキュリティ警告やシステム警告の表示
3. 各管理画面へのナビゲーション - リンククリックで各管理画面へ遷移

**画面遷移**：
- 遷移元：Jenkinsトップページ（ダッシュボード）
- 遷移先：システム設定、セキュリティ設定、プラグイン管理、ノード管理、等の各管理画面

**権限による表示制御**：
- Jenkins.MANAGE権限またはJenkins.SYSTEM_READ権限：管理画面へのアクセス
- 各ManagementLinkはgetRequiredPermission()で個別に権限制御

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 53 | 管理リンク | 主機能 | 管理機能への一覧アクセス |
| 52 | 管理モニター | 補助機能 | 管理通知の表示 |

## 画面種別

一覧（ポータル）

## URL/ルーティング

- `/manage/` - Jenkins管理画面

## 入出力項目

| 項目名 | 項目ID | 入出力 | 型 | 必須 | 説明 |
|--------|--------|--------|-----|------|------|
| - | - | - | - | - | 本画面は入力項目なし（表示のみ） |

## 表示項目

| 項目名 | 項目ID | 型 | 説明 |
|--------|--------|-----|------|
| 管理リンクアイコン | iconFileName | Icon | 管理機能のアイコン |
| 管理リンク名 | displayName | String | 管理機能の表示名（リンク） |
| 管理リンク説明 | description | String | 管理機能の説明文 |
| 管理通知 | administrativeMonitors | List | 表示すべき管理通知のリスト |
| バッジ | badge | Badge | リンクに表示するバッジ（警告数等） |

## イベント仕様

### 1-管理リンククリック

管理リンクをクリックすると、該当する管理画面（/manage/{urlName}）へ遷移する。

### 2-管理通知のDismiss

管理通知の「Dismiss」ボタン押下（POST monitor/disable）により、該当通知を非表示にする。

### 3-管理通知のAcknowledge

一部の通知の「OK」ボタン押下により、通知を確認済みにする。

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 通知Dismiss | config.xml | UPDATE | disabledAdministrativeMonitorsリストに追加 |

### テーブル別更新項目詳細

#### config.xml（Jenkins設定）

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| UPDATE | disabledAdministrativeMonitors | モニターIDを追加 | 無効化された通知のリスト |

## メッセージ仕様

| メッセージID | メッセージ内容 | 表示条件 | 種別 |
|-------------|---------------|----------|------|
| ManageJenkinsAction_DisplayName | Manage Jenkins | 常時表示 | タイトル |
| ManageJenkinsAction_notifications | 1+ | 通知がある場合 | バッジ |

## 例外処理

| 例外条件 | 対応処理 |
|---------|---------|
| 権限不足 | アクセス拒否（403） |
| ManagementLinkがない | 該当カテゴリを非表示 |

## 備考

- ManagementLinkはプラグインにより追加可能（ExtensionPoint）
- 管理リンクはカテゴリ（SYSTEM、STATUS、SECURITY、MISC等）別にグループ化
- NewManageJenkinsUserExperimentalFlagが有効な場合、/manage/configureへリダイレクト
- 管理通知はセキュリティ関連（isSecurity()=true）とその他で表示優先度が異なる

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、管理リンクに関連するデータ構造を理解することが重要である。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | ManagementLink.java | `core/src/main/java/hudson/model/ManagementLink.java` | 管理リンクの基底クラス |
| 1-2 | AdministrativeMonitor.java | `core/src/main/java/hudson/model/AdministrativeMonitor.java` | 管理通知の基底クラス |
| 1-3 | ManageJenkinsAction.java | `core/src/main/java/hudson/model/ManageJenkinsAction.java` | 管理画面へのアクション |

**読解のコツ**: ManagementLinkはExtensionPointで、各プラグインが独自の管理リンクを追加可能。getCategoryを使用してカテゴリ分類。

#### Step 2: エントリーポイントを理解する

処理の起点となるファイル・関数を特定する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | index.jelly | `core/src/main/resources/hudson/model/ManageJenkinsAction/index.jelly` | 画面のビューテンプレート |

**主要処理フロー**:
1. **行27-30**: レイアウト開始、タイトル設定
2. **行32-50**: 管理通知の表示（セキュリティ優先）
3. **行52-100**: カテゴリ別の管理リンク表示

#### Step 3: リダイレクト処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | ManageJenkinsAction.java | `core/src/main/java/hudson/model/ManageJenkinsAction.java` | doIndex()メソッド（行82-95）でリダイレクト判定 |

**主要処理フロー**:
- **行82-95**: doIndex()がNewManageJenkinsUserExperimentalFlagをチェックし、有効ならconfigureへリダイレクト

### プログラム呼び出し階層図

```
HTTP Request: GET /manage/
    │
    ├─ ManageJenkinsAction (RootAction)
    │      ├─ doIndex() → リダイレクト判定
    │      ├─ getDisplayName() → "Manage Jenkins"
    │      └─ getBadge() → 通知バッジ
    │
    └─ index.jelly (View)
           ├─ l:layout → レイアウト
           ├─ 管理通知セクション
           │      └─ j:forEach administrativeMonitors
           └─ 管理リンクセクション
                  └─ j:forEach ManagementLink.all()
                         └─ カテゴリ別グループ化

StaplerFallback → Jenkins
    │
    └─ 各ManagementLinkへのルーティング
```

### データフロー図

```
[入力]               [処理]                    [出力]

ブラウザリクエスト   ManageJenkinsAction      HTML画面
GET /manage/ ───▶ doIndex() ───▶ index.jelly ───▶ 管理リンク一覧
                         │
                         ▼
                    リダイレクト判定
                    (NewManageJenkinsUserExperimentalFlag)
                         │
                    ┌────┴────┐
                    ▼         ▼
              index.jelly  /manage/configure
              レンダリング  リダイレクト
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| index.jelly | `core/src/main/resources/hudson/model/ManageJenkinsAction/index.jelly` | テンプレート | 画面表示用テンプレート |
| ManageJenkinsAction.java | `core/src/main/java/hudson/model/ManageJenkinsAction.java` | ソース | 管理画面アクション |
| ManagementLink.java | `core/src/main/java/hudson/model/ManagementLink.java` | ソース | 管理リンク基底クラス |
| AdministrativeMonitor.java | `core/src/main/java/hudson/model/AdministrativeMonitor.java` | ソース | 管理通知基底クラス |
| Badge.java | `core/src/main/java/jenkins/management/Badge.java` | ソース | バッジ表示クラス |
| Messages.properties | `core/src/main/resources/hudson/model/ManageJenkinsAction/Messages.properties` | 設定 | メッセージリソース |
