# 画面設計書 29-システム設定

## 概要

本ドキュメントは、Jenkins CI/CDサーバーにおける「システム設定」画面の設計仕様を定義するものである。

### 本画面の処理概要

システム設定画面は、Jenkinsシステム全体の設定を行う中心的な画面である。Jenkins URL、システムメッセージ、エグゼキュータ数、使用統計、グローバルセキュリティ設定、環境変数、ツール設定など、Jenkinsの動作に影響する基本設定を編集できる。また、インストールされたプラグインが提供するグローバル設定もこの画面に統合される。

**業務上の目的・背景**：Jenkinsを組織のCI/CD基盤として運用するためには、適切なシステム設定が不可欠である。この画面は、Jenkins全体の動作を制御する設定を一元管理し、セキュリティ要件への対応、パフォーマンス調整、外部サービスとの連携設定などを行うための主要インターフェースとして機能する。設定変更の影響範囲が広いため、変更には管理者権限が必要。

**画面へのアクセス方法**：Jenkins管理画面から「System」リンクをクリック、または直接URL `/manage/configure` でアクセスする。

**主要な操作・処理内容**：
1. システムメッセージの設定 - ダッシュボードに表示するメッセージを設定
2. エグゼキュータ数の設定 - ビルトインノードの並列実行数を設定
3. Jenkins URLの設定 - 外部からアクセス可能なURLを設定
4. 使用統計の設定 - 匿名の使用統計送信の有効/無効
5. グローバルプロパティの設定 - 環境変数やツールロケーション
6. プラグイン設定の編集 - 各プラグインのグローバル設定
7. 保存 - 設定をconfig.xmlに保存

**画面遷移**：
- 遷移元：Jenkins管理画面
- 遷移先：Jenkins管理画面（保存後）

**権限による表示制御**：
- Jenkins.SYSTEM_READ権限：設定画面の閲覧（読み取り専用）
- Jenkins.MANAGE権限：基本設定の編集・保存
- Jenkins.ADMINISTER権限：すべての設定の編集・保存

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 1 | Jenkinsシステム | 主機能 | システム全体の設定管理 |
| 64 | フォームバリデーション | API連携 | 設定値の入力検証 |

## 画面種別

編集

## URL/ルーティング

- `/manage/configure` - システム設定画面
- `/configure` - 旧URL（互換性のため残存）

## 入出力項目

| 項目名 | 項目ID | 入出力 | 型 | 必須 | 説明 |
|--------|--------|--------|-----|------|------|
| システムメッセージ | systemMessage | 入力 | String | No | ダッシュボードに表示するメッセージ |
| エグゼキュータ数 | numExecutors | 入力 | Integer | Yes | ビルトインノードの並列実行数 |
| Jenkins URL | jenkinsUrl | 入力 | String | No | 外部からアクセス可能なURL |
| 使用統計 | usageStatisticsCollected | 入力 | Boolean | No | 使用統計の送信許可 |
| ワークスペースルート | workspaceDir | 入力 | String | No | ワークスペースの基準ディレクトリ |
| ビルドレコードルート | buildsDir | 入力 | String | No | ビルドレコードの基準ディレクトリ |
| ラベル | labelString | 入力 | String | No | ビルトインノードのラベル |
| 使用方法 | mode | 入力 | Enum | Yes | ビルトインノードの使用制限 |
| グローバル環境変数 | globalNodeProperties | 入力 | List | No | 環境変数等のグローバルプロパティ |

## 表示項目

| 項目名 | 項目ID | 型 | 説明 |
|--------|--------|-----|------|
| ページタイトル | title | String | 「System」 |
| 設定フォーム | form | Form | 各設定項目を含むフォーム |

## イベント仕様

### 1-Saveボタン押下

「Save」ボタン押下（POST configSubmit）により、入力された設定値をバリデーションし、問題がなければシステム設定を保存する。保存完了後、Jenkins管理画面へリダイレクトする。

### 2-Applyボタン押下

「Apply」ボタン押下（POST configSubmit + apply=true）により、画面遷移なしで設定を保存する。AJAXによる非同期保存が行われ、結果がメッセージとして表示される。

### 3-フォームバリデーション

各入力項目の変更時に、対応するdoCheck{FieldName}メソッドがAJAX呼び出しされ、リアルタイムでバリデーション結果が表示される。

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| Save/Apply | config.xml | UPDATE | Jenkins設定ファイルの更新 |

### テーブル別更新項目詳細

#### config.xml（Jenkins設定）

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| UPDATE | systemMessage | フォーム入力値 | システムメッセージ |
| UPDATE | numExecutors | フォーム入力値 | エグゼキュータ数 |
| UPDATE | mode | フォーム選択値 | 使用方法 |
| UPDATE | jenkinsUrl | フォーム入力値 | Jenkins URL |
| UPDATE | workspaceDir | フォーム入力値 | ワークスペースルート |
| UPDATE | buildsDir | フォーム入力値 | ビルドレコードルート |
| UPDATE | labelString | フォーム入力値 | ラベル |
| UPDATE | usageStatisticsCollected | フォームチェック値 | 使用統計フラグ |
| UPDATE | globalNodeProperties | フォーム設定値 | グローバルプロパティ |

## メッセージ仕様

| メッセージID | メッセージ内容 | 表示条件 | 種別 |
|-------------|---------------|----------|------|
| Hudson_Computer_IncorrectNumberOfExecutors | Incorrect number of executors | エグゼキュータ数が不正時 | エラー |
| FormValidation.ok | (空または成功メッセージ) | バリデーション成功時 | 成功 |

## 例外処理

| 例外条件 | 対応処理 |
|---------|---------|
| 権限不足（SYSTEM_READ以下） | アクセス拒否（403） |
| バリデーションエラー | 該当項目にエラーメッセージを表示 |
| エグゼキュータ数が不正 | FormExceptionでエラーメッセージ表示 |

## 備考

- GlobalConfigurationクラスを継承したプラグイン設定がこの画面に統合される
- readOnlyModeが有効な場合（MANAGE権限なし）、フォームは無効化される
- 設定変更後、一部の変更は即時反映されるが、再起動が必要なものもある
- Jenkins URLは外部からのリンク生成（メール通知等）に使用される

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、システム設定に関連するデータ構造を理解することが重要である。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | Jenkins.java | `core/src/main/java/jenkins/model/Jenkins.java` | Jenkinsシステムの中核クラス、設定フィールドを保持 |
| 1-2 | GlobalConfiguration.java | `core/src/main/java/jenkins/model/GlobalConfiguration.java` | プラグインのグローバル設定基底クラス |

**読解のコツ**: Jenkins.javaは非常に大きなクラス。systemMessage、numExecutors、mode等のフィールドと、対応するgetter/setterに注目。

#### Step 2: エントリーポイントを理解する

処理の起点となるファイル・関数を特定する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | configure.jelly | `core/src/main/resources/jenkins/model/Jenkins/configure.jelly` | 画面のビューテンプレート |

**主要処理フロー**:
1. **レイアウト開始**: 権限チェック（SYSTEM_READ）とreadOnlyMode判定
2. **フォーム構築**: configSubmitアクションへPOST
3. **システムメッセージ**: Markupフォーマッターとの連携
4. **エグゼキュータ/ラベル/使用方法**: ビルトインノード設定
5. **グローバル設定**: GlobalConfiguration拡張の各設定項目
6. **Save/Applyボタン**: f:saveApplyBar

#### Step 3: 設定保存処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | Jenkins.java | `core/src/main/java/jenkins/model/Jenkins.java` | doConfigSubmit()メソッドでフォーム処理 |

**主要処理フロー**:
- doConfigSubmit()がフォームを受け取り、各設定フィールドを更新
- save()メソッドでconfig.xmlに永続化
- FormApply.success()でリダイレクト

### プログラム呼び出し階層図

```
HTTP Request: GET /manage/configure
    │
    ├─ Jenkins (Model Object)
    │      ├─ getSystemMessage()
    │      ├─ getNumExecutors()
    │      ├─ getMode()
    │      ├─ getLabels()
    │      └─ hasPermission(MANAGE) → readOnlyMode判定
    │
    └─ configure.jelly (View)
           ├─ f:form → configSubmitへPOST
           ├─ f:section "System Message"
           ├─ f:section "Built-In Node"
           │      ├─ f:entry numExecutors
           │      ├─ f:entry labelString
           │      └─ f:entry mode
           ├─ st:include GlobalConfiguration items
           └─ f:saveApplyBar

HTTP Request: POST /manage/configSubmit
    │
    └─ Jenkins.doConfigSubmit()
           ├─ checkPermission(MANAGE/ADMINISTER)
           ├─ getSubmittedForm()
           ├─ 各設定フィールドの更新
           ├─ GlobalConfiguration.all().configure()
           ├─ save() → config.xml更新
           └─ FormApply.success()
```

### データフロー図

```
[入力]               [処理]                    [出力]

フォーム入力値       Jenkins                  config.xml
systemMessage ───▶ doConfigSubmit() ───▶ $JENKINS_HOME/config.xml
numExecutors            │
mode, etc.              ▼
                   フィールド更新
                        │
                        ▼
                   GlobalConfiguration.configure()
                        │
                        ▼
                   save() → XStream シリアライズ
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| configure.jelly | `core/src/main/resources/jenkins/model/Jenkins/configure.jelly` | テンプレート | 画面表示用テンプレート |
| Jenkins.java | `core/src/main/java/jenkins/model/Jenkins.java` | ソース | Jenkinsシステムの中核クラス |
| GlobalConfiguration.java | `core/src/main/java/jenkins/model/GlobalConfiguration.java` | ソース | グローバル設定基底クラス |
| config.xml | `$JENKINS_HOME/config.xml` | 設定 | Jenkins設定の永続化ファイル |
| Messages.properties | `core/src/main/resources/jenkins/model/Jenkins/Messages.properties` | 設定 | メッセージリソース |
