# 画面設計書 3-新規View作成

## 概要

本ドキュメントは、Jenkinsの新規View作成画面の設計仕様を定義するものです。

### 本画面の処理概要

新規View作成画面は、ダッシュボードに新しいView（タブ）を追加するための入力フォームを提供します。Viewはジョブをグループ化して表示するための機能であり、大規模なJenkins環境でジョブを整理するために使用されます。

**業務上の目的・背景**：大規模なJenkins環境では多数のジョブが存在し、全てのジョブを一覧で表示すると視認性が低下します。Viewを使用することで、チーム別、プロジェクト別、環境別などの観点でジョブをグループ化し、必要なジョブのみを効率的に確認できるようになります。

**画面へのアクセス方法**：ダッシュボードのViewタブ右端にある「+」アイコンをクリックするか、URLで直接 `/newView` にアクセスします。View.CREATE権限が必要です。

**主要な操作・処理内容**：
1. View名の入力 - 必須項目で、既存Viewとの重複チェックあり
2. Viewタイプの選択 - リストビュー、マイビューなどから選択
3. 既存Viewからのコピー - オプションで既存Viewの設定をコピー可能
4. 作成ボタン押下によるViewの作成と設定画面への遷移

**画面遷移**：ダッシュボード（View一覧）からこの画面に遷移します。View作成後はView設定画面に遷移するか、ダッシュボードに戻ります。

**権限による表示制御**：View.CREATE権限がないユーザーはこの画面にアクセスできません。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 35 | ビュー管理 | 主機能 | 新規Viewの作成処理 |
| 36 | リストビュー | 補助機能 | リストビュータイプの選択 |
| 64 | フォームバリデーション | API連携 | View名の入力検証 |

## 画面種別

登録

## URL/ルーティング

- `/newView` - 新規View作成画面

## 入出力項目

| 項目名 | 入力/出力 | データ型 | 必須 | 説明 |
|--------|----------|----------|------|------|
| name | 入力 | String | ○ | View名 |
| mode | 入力 | String | ○ | Viewタイプ（リストビュー等）または"copy"（コピーモード） |
| from | 入力 | String | - | コピー元View名（コピーモード時のみ） |

## 表示項目

| 項目名 | データ型 | 説明 |
|--------|----------|------|
| View名入力フィールド | TextInput | View名を入力するテキストフィールド |
| Viewタイプ一覧 | RadioButtonGroup | 選択可能なViewタイプの一覧 |
| コピー元入力フィールド | TextInput | 既存Viewからコピーする場合のView名入力 |
| タイプ説明 | Text | 各Viewタイプの説明文 |

## イベント仕様

### 1-View名入力

View名入力フィールドに入力すると、リアルタイムでバリデーションが実行されます。`checkViewName`エンドポイントを呼び出し、以下のチェックが行われます：
- 空文字チェック
- 既存View名との重複チェック

### 2-Viewタイプ選択

ラジオボタンでViewタイプを選択します。標準で以下のタイプが利用可能です：
- リストビュー（ListView）
- マイビュー（MyView）

プラグインにより追加のViewタイプが提供される場合があります。

### 3-コピー元選択

「Copy Existing View」ラジオボタンを選択し、テキストボックスにコピー元のView名を入力します。

### 4-OKボタン押下

入力内容のバリデーションを行い、問題がなければ`createView`アクションにPOSTリクエストを送信してViewを作成します。

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| OKボタン押下 | $JENKINS_HOME/config.xml | UPDATE | Viewの追加をconfig.xmlに保存 |

### テーブル別更新項目詳細

#### Jenkinsファイルシステム（$JENKINS_HOME/config.xml）

| 操作 | 項目 | 更新値・取得条件 | 備考 |
|-----|------|-----------------|------|
| UPDATE | views要素 | 新しいViewの設定を追加 | ViewタイプによりXML構造が異なる |

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|-------------|------|---------------|---------|
| (View名必須) | エラー | "View name is required" | View名が空の場合 |
| (重複エラー) | エラー | "A view with this name already exists" | View名が既存と重複する場合 |

## 例外処理

| 例外状態 | 処理内容 |
|---------|---------|
| View.CREATE権限なし | 403 Forbiddenエラー |
| View名重複 | エラーメッセージ表示、登録不可 |
| 不正なViewタイプ | エラー表示 |

## 備考

- Viewタイプはプラグインにより拡張可能です（例：ダッシュボードビュー、ネステッドビュー）
- `View.allInstantiable()`メソッドで利用可能なViewタイプを取得します
- View作成はnewFromListタグライブラリ（`/lib/hudson/newFromList`）を使用しています

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

View（ビュー）の基本構造とタイプ定義を理解します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | View.java | `core/src/main/java/hudson/model/View.java` | Viewの基底クラス、CREATE権限の定義 |
| 1-2 | ViewDescriptor.java | `core/src/main/java/hudson/model/ViewDescriptor.java` | Viewタイプの定義 |
| 1-3 | ListView.java | `core/src/main/java/hudson/model/ListView.java` | 標準的なリストビューの実装 |

**読解のコツ**: View.allInstantiable()でインスタンス化可能な全てのViewタイプ（ViewDescriptor）を取得できます。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | newView.jelly | `core/src/main/resources/jenkins/model/Jenkins/newView.jelly` | 画面のメインテンプレート |

**主要処理フロー**:
1. **30行目**: View.CREATE権限のチェック（`permission="${app.primaryView.CREATE}"`）
2. **34行目**: `View.allInstantiable()`で利用可能なViewタイプを取得
3. **35-36行目**: `n:form`タグでフォームを生成（newFromListタグライブラリ使用）

#### Step 3: フォームテンプレートを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | form.jelly | `core/src/main/resources/lib/hudson/newFromList/form.jelly` | 汎用的な新規作成フォーム |

**主要処理フロー**:
- View名入力フィールドの生成
- Viewタイプ選択ラジオボタンの生成
- コピーオプションの生成

#### Step 4: View作成処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | Jenkins.java | `core/src/main/java/jenkins/model/Jenkins.java` | doCreateViewメソッド |

**主要処理フロー**:
- フォームデータの検証
- Viewインスタンスの作成
- config.xmlへの保存

### プログラム呼び出し階層図

```
newView.jelly (エントリーポイント)
    │
    ├─ sidepanel.jelly (Jenkinsサイドパネル)
    │
    └─ n:form (newFromListフォーム)
           │
           ├─ View.allInstantiable() ─▶ Viewタイプ一覧取得
           │
           └─ createView (フォーム送信先)
                  │
                  └─ Jenkins.doCreateView()
                         ├─ checkViewName() (バリデーション)
                         └─ View保存 (config.xml更新)
```

### データフロー図

```
[入力]               [処理]                    [出力]

View名 ──────▶ checkViewName ───▶ バリデーション結果
                     │
Viewタイプ ────▶ createView ─────▶ config.xml更新
                     │
(コピー元) ─────▶ copyView ───────▶ View設定画面へリダイレクト
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| newView.jelly | `core/src/main/resources/jenkins/model/Jenkins/newView.jelly` | テンプレート | メイン画面テンプレート |
| View.java | `core/src/main/java/hudson/model/View.java` | ソース | Viewの基底クラス |
| ViewDescriptor.java | `core/src/main/java/hudson/model/ViewDescriptor.java` | ソース | Viewタイプ定義 |
| ListView.java | `core/src/main/java/hudson/model/ListView.java` | ソース | リストビュー実装 |
| Jenkins.java | `core/src/main/java/jenkins/model/Jenkins.java` | ソース | View作成処理 |
| form.jelly | `core/src/main/resources/lib/hudson/newFromList/form.jelly` | テンプレート | 汎用フォームテンプレート |
