# 画面設計書 30-エグゼキュータ設定

## 概要

本ドキュメントは、Jenkins CI/CDサーバーにおける「エグゼキュータ設定」画面の設計仕様を定義するものである。

### 本画面の処理概要

エグゼキュータ設定画面は、ビルトインノード（コントローラー）のエグゼキュータ数とラベルを設定するための簡易画面である。システム設定画面の一部機能を切り出した専用画面であり、ビルトインノードの基本的な設定を素早く変更できる。

**業務上の目的・背景**：ビルトインノードのエグゼキュータ数やラベルの調整は、日常的な運用作業として頻繁に行われる。システム設定画面全体を開くのではなく、この専用画面を使用することで、目的の設定に素早くアクセスし、他の設定を誤って変更するリスクを低減できる。特にセキュリティ上の理由からビルトインノードでのビルド実行を無効化（エグゼキュータ数を0に）する際に使用される。

**画面へのアクセス方法**：Jenkins管理画面から「Number of Executors」等の関連リンクをクリック、または直接URL `/manage/configureExecutors` でアクセスする。ビルトインノードの設定画面からもアクセス可能。

**主要な操作・処理内容**：
1. エグゼキュータ数の設定 - ビルトインノードの並列実行数を設定
2. ラベルの設定 - ビルトインノードに割り当てるラベルを設定
3. 使用方法の設定 - ジョブ実行の制限（可能な限り使用/ラベル制限のみ）
4. 保存 - 設定をconfig.xmlに保存

**画面遷移**：
- 遷移元：Jenkins管理画面、ビルトインノード設定画面
- 遷移先：Jenkins管理画面（保存後）

**権限による表示制御**：
- Jenkins.SYSTEM_READ権限：設定画面の閲覧（読み取り専用）
- Jenkins.MANAGE権限：設定の編集・保存

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 1 | Jenkinsシステム | 主機能 | ビルトインノードの設定 |
| 12 | コンピューター管理 | 補助機能 | エグゼキュータ管理 |

## 画面種別

編集

## URL/ルーティング

- `/manage/configureExecutors` - エグゼキュータ設定画面

## 入出力項目

| 項目名 | 項目ID | 入出力 | 型 | 必須 | 説明 |
|--------|--------|--------|-----|------|------|
| エグゼキュータ数 | numExecutors | 入力 | Integer | Yes | ビルトインノードの並列実行数（0以上） |
| ラベル | labelString | 入力 | String | No | スペース区切りのラベル文字列 |
| 使用方法 | mode | 入力 | Enum | Yes | NORMAL（可能な限り使用）/ EXCLUSIVE（ラベル制限） |

## 表示項目

| 項目名 | 項目ID | 型 | 説明 |
|--------|--------|-----|------|
| ページタイトル | title | String | 「Configure Executors」 |
| 設定フォーム | form | Form | エグゼキュータ設定項目を含むフォーム |

## イベント仕様

### 1-Saveボタン押下

「Save」ボタン押下（POST configExecutorsSubmit）により、入力された設定値をバリデーションし、問題がなければ設定を保存する。保存完了後、Jenkins管理画面へリダイレクトする。

### 2-Applyボタン押下

「Apply」ボタン押下（POST configExecutorsSubmit + apply=true）により、画面遷移なしで設定を保存する。AJAXによる非同期保存が行われ、結果がメッセージとして表示される。

### 3-フォームバリデーション

エグゼキュータ数の変更時に、バリデーションが行われ、0未満の場合はエラーメッセージが表示される。

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| Save/Apply | config.xml | UPDATE | Jenkins設定ファイルのエグゼキュータ関連設定を更新 |

### テーブル別更新項目詳細

#### config.xml（Jenkins設定）

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| UPDATE | numExecutors | フォーム入力値 | エグゼキュータ数 |
| UPDATE | label | フォーム入力値 | ラベル |
| UPDATE | mode | フォーム選択値 | 使用方法 |

## メッセージ仕様

| メッセージID | メッセージ内容 | 表示条件 | 種別 |
|-------------|---------------|----------|------|
| Hudson_Computer_IncorrectNumberOfExecutors | Incorrect number of executors | エグゼキュータ数が不正時 | エラー |
| FormValidation.ok | (空または成功メッセージ) | バリデーション成功時 | 成功 |

## 例外処理

| 例外条件 | 対応処理 |
|---------|---------|
| 権限不足（SYSTEM_READ以下） | アクセス拒否（403） |
| エグゼキュータ数が不正 | FormExceptionでエラーメッセージ表示 |
| バリデーションエラー | 該当項目にエラーメッセージを表示 |

## 備考

- エグゼキュータ数を0に設定すると、ビルトインノードでビルドが実行されなくなる
- セキュリティベストプラクティスとして、ビルトインノードのエグゼキュータ数を0にすることが推奨される
- この画面はシステム設定画面の一部機能のサブセット
- mode設定により、ビルトインノードへのジョブ割り当てを制御できる

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、エグゼキュータ設定に関連するデータ構造を理解することが重要である。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | Jenkins.java | `core/src/main/java/jenkins/model/Jenkins.java` | numExecutors、mode、labelStringフィールド |

**読解のコツ**: エグゼキュータ設定はJenkins.javaの一部フィールドのみに関係。numExecutors、mode、labelString（実際はgetSelfLabel()経由）に注目。

#### Step 2: エントリーポイントを理解する

処理の起点となるファイル・関数を特定する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | configureExecutors.jelly | `core/src/main/resources/jenkins/model/Jenkins/configureExecutors.jelly` | 画面のビューテンプレート |

**主要処理フロー**:
1. **レイアウト開始**: 権限チェック（SYSTEM_READ）とreadOnlyMode判定
2. **フォーム構築**: configExecutorsSubmitアクションへPOST
3. **エグゼキュータ数入力**: f:entry numExecutors
4. **ラベル入力**: f:entry labelString
5. **使用方法選択**: f:entry mode
6. **Save/Applyボタン**: f:saveApplyBar

#### Step 3: 設定保存処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | Jenkins.java | `core/src/main/java/jenkins/model/Jenkins.java` | doConfigExecutorsSubmit()メソッドでフォーム処理 |

**主要処理フロー**:
- doConfigExecutorsSubmit()がフォームを受け取り、numExecutors、mode、labelを更新
- save()メソッドでconfig.xmlに永続化
- FormApply.success()でリダイレクト

### プログラム呼び出し階層図

```
HTTP Request: GET /manage/configureExecutors
    │
    ├─ Jenkins (Model Object)
    │      ├─ getNumExecutors()
    │      ├─ getMode()
    │      ├─ getLabelString()
    │      └─ hasPermission(MANAGE) → readOnlyMode判定
    │
    └─ configureExecutors.jelly (View)
           ├─ f:form → configExecutorsSubmitへPOST
           ├─ f:entry numExecutors
           ├─ f:entry labelString
           ├─ f:entry mode
           └─ f:saveApplyBar

HTTP Request: POST /manage/configExecutorsSubmit
    │
    └─ Jenkins.doConfigExecutorsSubmit()
           ├─ checkPermission(MANAGE)
           ├─ getSubmittedForm()
           ├─ setNumExecutors(form.getInt("numExecutors"))
           ├─ setLabelString(form.getString("labelString"))
           ├─ setMode(form.getString("mode"))
           ├─ save() → config.xml更新
           └─ FormApply.success()
```

### データフロー図

```
[入力]               [処理]                    [出力]

フォーム入力値       Jenkins                  config.xml
numExecutors ───▶ doConfigExecutorsSubmit() ───▶ $JENKINS_HOME/config.xml
labelString             │
mode                    ▼
                   フィールド更新
                        │
                        ▼
                   save() → XStream シリアライズ
                        │
                        ▼
                   リダイレクト ───▶ 管理画面
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| configureExecutors.jelly | `core/src/main/resources/jenkins/model/Jenkins/configureExecutors.jelly` | テンプレート | 画面表示用テンプレート |
| Jenkins.java | `core/src/main/java/jenkins/model/Jenkins.java` | ソース | Jenkinsシステムの中核クラス |
| config.xml | `$JENKINS_HOME/config.xml` | 設定 | Jenkins設定の永続化ファイル |
| Messages.properties | `core/src/main/resources/jenkins/model/Jenkins/Messages.properties` | 設定 | メッセージリソース |
