# 画面設計書 31-システム情報

## 概要

本ドキュメントは、Jenkinsの「システム情報」画面の設計について記述したものです。この画面はJenkinsの診断やトラブルシューティングに必要なシステム情報を一覧表示します。

### 本画面の処理概要

この画面では、Jenkins運用管理者がシステムの状態を把握するために必要な各種情報を確認できます。

**業務上の目的・背景**：Jenkins環境のトラブルシューティングや性能診断において、JVMの設定値、環境変数、インストール済みプラグインの状態、メモリ使用状況などのシステム情報は不可欠です。本画面により、管理者は一箇所でこれらの情報を確認し、問題の原因特定や設定の確認を効率的に行えます。また、サポートへの問い合わせ時に必要な情報収集にも活用されます。

**画面へのアクセス方法**：Jenkins管理画面（/manage）から「システム情報」リンクをクリック、または直接 `/manage/systemInfo` URLにアクセスします。管理権限（MANAGE権限またはSYSTEM_READ権限）を持つユーザーのみがアクセス可能です。

**主要な操作・処理内容**：
1. システムプロパティの一覧表示（Javaシステムプロパティの参照）
2. 環境変数の一覧表示（OSレベルの環境変数の参照）
3. インストール済みプラグイン一覧の表示（名前、バージョン、有効/無効状態）
4. メモリ使用状況のグラフ表示（時間範囲の切り替えが可能）
5. スレッドダンプへのリンク（管理者権限保持者のみ）

**画面遷移**：
- 遷移元：Jenkins管理画面（/manage）
- 遷移先：スレッドダンプ画面（/threadDump）、プラグイン詳細ページ（外部リンク）

**権限による表示制御**：
- SYSTEM_READ権限：システムプロパティと環境変数のタブが表示される
- ADMINISTER権限：スレッドダンプタブが追加表示される
- 機密情報は一部マスクされて表示される（sensitiveフラグ）

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 1 | Jenkins本体 | 主機能 | Jenkinsシステム情報の表示 |
| 62 | 環境変数 | 補助機能 | 環境変数情報の表示 |

## 画面種別

一覧 / 詳細（タブ切り替え型の情報表示画面）

## URL/ルーティング

| URL | HTTPメソッド | 説明 |
|-----|-------------|------|
| `/manage/systemInfo` | GET | システム情報画面の表示 |

## 入出力項目

この画面は参照専用のため、入力項目はタイムスパン選択のみです。

| 項目名 | 項目種別 | 必須 | 説明 |
|--------|---------|------|------|
| Timespan | セレクトボックス | - | メモリ使用状況グラフの時間範囲（Short/Medium/Long） |

## 表示項目

### システムプロパティタブ

| 項目名 | 説明 |
|--------|------|
| プロパティ名 | Javaシステムプロパティのキー |
| プロパティ値 | Javaシステムプロパティの値（機密情報はマスク） |

### 環境変数タブ

| 項目名 | 説明 |
|--------|------|
| 変数名 | 環境変数名 |
| 変数値 | 環境変数の値（機密情報はマスク） |

### プラグインタブ

| 項目名 | 説明 |
|--------|------|
| Name | プラグイン表示名（外部リンク付き） |
| Version | プラグインバージョン |
| Enabled | 有効/無効状態（true/false） |

### メモリ使用状況タブ

| 項目名 | 説明 |
|--------|------|
| グラフ | JVMメモリ使用状況の時系列グラフ |
| Timespan | 表示時間範囲の選択（Short: 10秒、Medium: 1分、Long: 1時間） |

### スレッドダンプタブ（管理者のみ）

| 項目名 | 説明 |
|--------|------|
| リンク | スレッドダンプ画面へのリンク |

## イベント仕様

### 1-タブ切り替え

タブ（System Properties / Environment Variables / Plugins / Memory Usage / Thread Dumps）をクリックすると、対応する情報パネルが表示されます。JavaScriptによるクライアントサイド切り替えで、ページリロードは発生しません。

### 2-Timespan変更

メモリ使用状況タブでTimespanを変更すると、グラフの表示期間が変更されます。

| Timespan | 表示期間 |
|----------|---------|
| Short | 過去10秒 |
| Medium | 過去1分 |
| Long | 過去1時間 |

### 3-プラグインリンククリック

プラグイン名をクリックすると、そのプラグインの外部URLが新しいタブで開きます。

## データベース更新仕様

本画面は参照専用のため、データベースの更新は発生しません。

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 画面表示 | - | SELECT | システムプロパティ、環境変数、プラグイン情報の取得（ファイルシステム/メモリから） |

## メッセージ仕様

| メッセージID | メッセージ種別 | メッセージ内容 | 表示条件 |
|-------------|---------------|---------------|---------|
| - | 情報 | No plugins installed | プラグインが一つもインストールされていない場合 |

## 例外処理

| 例外条件 | 表示内容 | 処理 |
|---------|---------|------|
| 権限不足 | アクセス拒否画面 | MANAGE_AND_SYSTEM_READ権限がない場合は画面にアクセスできない |
| プラグイン情報取得失敗 | エラーメッセージ | 失敗したプラグイン一覧にエラー原因が表示される |

## 備考

- システムプロパティと環境変数の表示では、パスワードやトークンなどの機密情報が含まれる可能性があるため、`sensitive="true"`フラグにより一部の値がマスクされます
- メモリ使用状況グラフはJavaScriptによる動的ロードで表示され、`section-to-tabs.js`と`system-information.js`により制御されます
- 本画面はレスポンシブ対応しており、サイドパネルを含むレイアウトで表示されます

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

システム情報画面で表示されるデータは、主にJenkinsインスタンスとPluginManagerから取得されます。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | SystemInfoLink.java | `core/src/main/java/jenkins/management/SystemInfoLink.java` | ManagementLinkの実装。URLName、必要権限、カテゴリの定義を確認 |
| 1-2 | Functions.java | `core/src/main/java/hudson/Functions.java` | `getSystemProperties()`と`getEnvVars()`メソッドでプロパティ/環境変数を取得 |

**読解のコツ**: `ManagementLink`は管理画面のリンクを定義する抽象クラスで、`getUrlName()`が返す値がURLパスになります。

#### Step 2: エントリーポイントを理解する

処理の起点となるJellyテンプレートを確認します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | systemInfo.jelly | `core/src/main/resources/jenkins/model/Jenkins/systemInfo.jelly` | メイン画面テンプレート。タブ構成と権限チェックの実装を確認 |

**主要処理フロー**:
1. **30行目**: `SystemInfoLink`をインスタンス化し`it`変数に設定
2. **32行目**: `l:settings-subpage`で権限チェック（MANAGE_AND_SYSTEM_READ）
3. **36-46行目**: SYSTEM_READ権限がある場合、システムプロパティと環境変数タブを表示
4. **48-83行目**: プラグインタブの表示（全ユーザー閲覧可能）
5. **85-97行目**: メモリ使用状況タブの表示
6. **99-103行目**: 管理者のみスレッドダンプタブを表示

#### Step 3: 補助コンポーネントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | propertyTable.jelly | `core/src/main/resources/lib/hudson/propertyTable.jelly` | プロパティテーブル表示用タグライブラリ |
| 3-2 | section-to-tabs.js | `war/src/main/js/section-to-tabs.js` | タブUIの動的生成を行うJavaScript |
| 3-3 | system-information.js | `war/src/main/js/pages/manage-jenkins/system-information.js` | システム情報画面固有のJavaScript |

**主要処理フロー**:
- **propertyTable.jelly**: `items`属性で渡されたMapをテーブル形式で表示
- **section-to-tabs.js**: `l:tabPane`要素をタブUIに変換

### プログラム呼び出し階層図

```
[HTTPリクエスト: /manage/systemInfo]
    │
    ├─ Jenkins.java
    │      └─ Stapler routing → systemInfo.jelly
    │
    └─ systemInfo.jelly
           │
           ├─ SystemInfoLink (itオブジェクト生成)
           │
           ├─ l:settings-subpage (権限チェック)
           │      └─ MANAGE_AND_SYSTEM_READ権限確認
           │
           ├─ t:propertyTable (システムプロパティ)
           │      └─ h.systemProperties → Functions.getSystemProperties()
           │
           ├─ t:propertyTable (環境変数)
           │      └─ h.envVars → Functions.getEnvVars()
           │
           ├─ app.pluginManager.plugins (プラグイン一覧)
           │      └─ PluginManager.getPlugins()
           │
           └─ Memory Usage Graph
                  └─ system-information.js (動的ロード)
```

### データフロー図

```
[入力]                     [処理]                           [出力]

System.getProperties() ──▶ Functions.getSystemProperties() ──▶ システムプロパティタブ
                                  │
                                  ▼
                           機密情報マスク処理

System.getenv() ──────────▶ Functions.getEnvVars() ─────────▶ 環境変数タブ
                                  │
                                  ▼
                           機密情報マスク処理

PluginManager ────────────▶ getPlugins() ───────────────────▶ プラグインタブ
                                  │
                                  ▼
                           pluginsSortedByTitle

MemoryUsageMonitor ───────▶ Graph API ─────────────────────▶ メモリ使用状況グラフ
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| systemInfo.jelly | `core/src/main/resources/jenkins/model/Jenkins/systemInfo.jelly` | テンプレート | メイン画面のJellyテンプレート |
| SystemInfoLink.java | `core/src/main/java/jenkins/management/SystemInfoLink.java` | ソース | ManagementLinkの実装クラス |
| Functions.java | `core/src/main/java/hudson/Functions.java` | ソース | ユーティリティ関数（システムプロパティ/環境変数取得） |
| PluginManager.java | `core/src/main/java/hudson/PluginManager.java` | ソース | プラグイン管理クラス |
| propertyTable.jelly | `core/src/main/resources/lib/hudson/propertyTable.jelly` | テンプレート | プロパティテーブル表示用タグ |
| section-to-tabs.js | `war/src/main/js/section-to-tabs.js` | JavaScript | タブUI生成スクリプト |
| system-information.js | `war/src/main/js/pages/manage-jenkins/system-information.js` | JavaScript | 画面固有スクリプト |
| systemInfo.properties | `core/src/main/resources/jenkins/model/Jenkins/systemInfo.properties` | 設定 | 国際化メッセージ定義 |
