# 画面設計書 32-負荷統計

## 概要

本ドキュメントは、Jenkinsの「負荷統計」画面の設計について記述したものです。この画面はJenkinsマスター全体のエグゼキュータ使用状況や負荷状態をグラフ形式で可視化します。

### 本画面の処理概要

この画面では、Jenkins運用管理者がシステム全体の負荷状況をリアルタイムで監視できます。

**業務上の目的・背景**：Jenkins環境の効率的な運用には、エグゼキュータの使用率、ビルドキューの長さ、利用可能なリソースの把握が不可欠です。本画面により、管理者はJenkins全体の負荷傾向を視覚的に把握し、リソースの増減判断、ビルド集中時間帯の特定、パフォーマンスボトルネックの検出に活用できます。継続的インテグレーション環境の安定運用に直結する重要な監視機能です。

**画面へのアクセス方法**：Jenkins管理画面（/manage）から「負荷統計」リンクをクリック、または直接 `/manage/load-statistics` URLにアクセスします。MANAGE権限を持つユーザーのみがアクセス可能です。

**主要な操作・処理内容**：
1. 負荷統計グラフの表示（ビジーエグゼキュータ、オンラインエグゼキュータ、キュー長、利用可能エグゼキュータ）
2. 表示時間範囲の切り替え（Short: 10秒、Medium: 1分、Long: 1時間）
3. グラフの自動更新による負荷状況のリアルタイム監視

**画面遷移**：
- 遷移元：Jenkins管理画面（/manage）
- 遷移先：なし（本画面は終端画面）

**権限による表示制御**：
- MANAGE権限を持つユーザーのみアクセス可能
- 全ての表示項目が権限保持者には同一内容で表示される

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 48 | ロード統計 | 主機能 | Jenkins全体の負荷統計表示 |
| 8 | エグゼキューター | 補助機能 | エグゼキュータ使用状況の表示 |

## 画面種別

グラフ表示画面（統計・監視画面）

## URL/ルーティング

| URL | HTTPメソッド | 説明 |
|-----|-------------|------|
| `/manage/load-statistics` | GET | 負荷統計画面の表示 |
| `/manage/load-statistics/graph` | GET | 負荷統計グラフ画像の取得（API） |

## 入出力項目

| 項目名 | 項目種別 | 必須 | 説明 |
|--------|---------|------|------|
| Timespan | セレクトボックス | - | グラフの表示時間範囲を選択 |

### Timespan選択肢

| 値 | 表示名 | 説明 |
|---|--------|------|
| sec10 | Short | 過去10秒の統計を表示 |
| min | Medium | 過去1分の統計を表示（デフォルト） |
| hour | Long | 過去1時間の統計を表示 |

## 表示項目

### 負荷統計グラフ

| 系列名 | 色 | 説明 |
|--------|---|------|
| Busy Executors | - | 現在ビルドを実行中のエグゼキュータ数 |
| Online Executors | - | オンライン状態のエグゼキュータ総数 |
| Queue Length | - | ビルドキューで待機中のアイテム数 |
| Available Executors | - | 利用可能（アイドル状態）のエグゼキュータ数 |

### 説明テキスト

グラフの下に、負荷統計の意味と活用方法についての説明文（blurb）が表示されます。

## イベント仕様

### 1-Timespan変更

Timespanセレクトボックスの値を変更すると、グラフの表示期間が動的に切り替わります。

**処理フロー**:
1. ユーザーがTimespanを選択
2. JavaScriptがグラフAPIを呼び出し
3. 新しい時間範囲のグラフ画像を取得
4. グラフ表示領域を更新

### 2-グラフ自動更新

グラフはJavaScriptにより定期的に自動更新され、リアルタイムの負荷状況を反映します。

## データベース更新仕様

本画面は参照専用のため、データベースの更新は発生しません。

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 画面表示 | - | SELECT | OverallLoadStatisticsからメモリ上のデータを取得 |

## メッセージ仕様

| メッセージID | メッセージ種別 | メッセージ内容 | 表示条件 |
|-------------|---------------|---------------|---------|
| blurb | 情報 | 負荷統計の説明文 | 常時表示 |
| title | ラベル | Load Statistics | 画面タイトル（it.displayNameがappでない場合） |

## 例外処理

| 例外条件 | 表示内容 | 処理 |
|---------|---------|------|
| 権限不足 | アクセス拒否画面 | MANAGE権限がない場合は画面にアクセスできない |
| グラフ生成エラー | 代替画像またはエラーメッセージ | noscriptタグ内の静的画像が表示される |

## 備考

- 負荷統計データは`OverallLoadStatistics`クラスによりメモリ上で管理され、定期的に更新されます
- グラフ描画は`MultiStageTimeSeries`クラスの`TrendChart`機能を使用しています
- JavaScript無効環境では、noscriptタグ内の静的画像が表示されます（サイズ調整不可）
- グラフはRetina対応で、2倍解像度の画像も提供されます（srcset属性）

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

負荷統計データの構造を理解することが、この画面を理解する鍵です。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | OverallLoadStatistics.java | `core/src/main/java/hudson/model/OverallLoadStatistics.java` | Jenkins全体の負荷統計クラス。busyExecutors、onlineExecutors、queueLength、availableExecutorsの定義 |
| 1-2 | LoadStatistics.java | `core/src/main/java/hudson/model/LoadStatistics.java` | 基底クラス。MultiStageTimeSeriesを使った時系列データ管理 |
| 1-3 | MultiStageTimeSeries.java | `core/src/main/java/hudson/model/MultiStageTimeSeries.java` | 複数タイムスケール（10秒、1分、1時間）でデータを保持する仕組み |

**読解のコツ**: `MultiStageTimeSeries`は`TimeScale`列挙型（SEC10, MIN, HOUR）ごとにデータを保持し、`TrendChart`を生成します。

#### Step 2: エントリーポイントを理解する

処理の起点となるファイルを確認します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | StatisticsLink.java | `core/src/main/java/jenkins/management/StatisticsLink.java` | ManagementLinkの実装。URLName（"load-statistics"）と必要権限（MANAGE）の定義 |
| 2-2 | load-statistics.jelly | `core/src/main/resources/jenkins/model/Jenkins/load-statistics.jelly` | メイン画面テンプレート。main.jellyをインクルード |

**主要処理フロー**:
1. **27行目**: `StatisticsLink`をインスタンス化し`it`変数に設定
2. **29行目**: `l:settings-subpage`でレイアウト設定
3. **30行目**: `it`を`app`（Jenkinsインスタンス）に再設定
4. **32-33行目**: `prefix`を設定し、`main.jelly`をインクルード

#### Step 3: グラフ表示コンポーネントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | main.jelly | `core/src/main/resources/hudson/model/LoadStatistics/main.jelly` | グラフ表示用テンプレート。Timespan選択とグラフ描画領域の定義 |
| 3-2 | resources.js | `core/src/main/resources/hudson/model/LoadStatistics/resources/resources.js` | グラフ動的ロードのJavaScript（adjunctで読み込み） |

**主要処理フロー（main.jelly）**:
- **28行目**: LoadStatistics用のadjunctリソースを読み込み
- **34-42行目**: Timespan選択UIの定義
- **44-48行目**: グラフ表示用div（JavaScriptで動的描画）
- **49-52行目**: noscript時の静的画像表示

### プログラム呼び出し階層図

```
[HTTPリクエスト: /manage/load-statistics]
    │
    ├─ Jenkins.java
    │      └─ Stapler routing → load-statistics.jelly
    │
    └─ load-statistics.jelly
           │
           ├─ StatisticsLink (itオブジェクト生成)
           │
           ├─ l:settings-subpage (レイアウト)
           │
           └─ st:include page="main.jelly"
                  │
                  ├─ LoadStatistics.main.jelly
                  │      │
                  │      ├─ Timespan選択UI
                  │      │
                  │      └─ js-load-graph (動的グラフ)
                  │             │
                  │             └─ /load-statistics/graph API呼び出し
                  │                    │
                  │                    └─ OverallLoadStatistics.createOverallTrendChart()
                  │                           │
                  │                           └─ MultiStageTimeSeries.createTrendChart()
                  │
                  └─ app.overallLoad (OverallLoadStatistics)
```

### データフロー図

```
[入力]                        [処理]                              [出力]

Jenkinsビルド実行状況 ─────▶ LoadStatistics.onOnline()      ┐
                             LoadStatistics.onBusy()        ├──▶ MultiStageTimeSeries
                             LoadStatistics.onQueueChange() ┘         │
                                                                      ▼
                                                              OverallLoadStatistics
                                                                      │
Timespan選択 ─────────────▶ graph APIリクエスト ───────────────▶ TrendChart生成
                                                                      │
                                                                      ▼
                                                              [グラフ画像（PNG）]
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| load-statistics.jelly | `core/src/main/resources/jenkins/model/Jenkins/load-statistics.jelly` | テンプレート | メイン画面のJellyテンプレート |
| StatisticsLink.java | `core/src/main/java/jenkins/management/StatisticsLink.java` | ソース | ManagementLinkの実装クラス |
| main.jelly | `core/src/main/resources/hudson/model/LoadStatistics/main.jelly` | テンプレート | グラフ表示用テンプレート |
| OverallLoadStatistics.java | `core/src/main/java/hudson/model/OverallLoadStatistics.java` | ソース | 全体負荷統計クラス |
| LoadStatistics.java | `core/src/main/java/hudson/model/LoadStatistics.java` | ソース | 負荷統計基底クラス |
| MultiStageTimeSeries.java | `core/src/main/java/hudson/model/MultiStageTimeSeries.java` | ソース | 時系列データ管理 |
| resources.js | `core/src/main/resources/hudson/model/LoadStatistics/resources/resources.js` | JavaScript | グラフ動的ロード |
| main.properties | `core/src/main/resources/hudson/model/LoadStatistics/main.properties` | 設定 | 国際化メッセージ |
