# 画面設計書 33-スレッドダンプ

## 概要

本ドキュメントは、Jenkinsの「スレッドダンプ」画面の設計について記述したものです。この画面はJenkinsマスターおよび全エージェントのJVMスレッドダンプを取得・表示します。

### 本画面の処理概要

この画面では、Jenkins管理者がシステムのスレッド状態を診断するためのスレッドダンプを取得できます。

**業務上の目的・背景**：Jenkinsの動作が遅くなった場合や、ハングアップが疑われる場合、スレッドダンプはその原因特定に不可欠なデバッグ情報です。本画面により、管理者はJenkinsマスターだけでなく、接続されている全てのエージェントのスレッドダンプを一度に取得でき、デッドロック、無限ループ、リソース競合などの問題を診断できます。サポートへの問い合わせ時にも頻繁に求められる情報です。

**画面へのアクセス方法**：Jenkins管理画面（/manage）から「システム情報」→「Thread Dumps」タブ→リンクをクリック、または直接 `/threadDump` URLにアクセスします。ADMINISTER権限（管理者権限）を持つユーザーのみがアクセス可能です。

**主要な操作・処理内容**：
1. Jenkinsマスターのスレッドダンプ表示
2. 接続中の全エージェントのスレッドダンプ表示
3. 各スレッドダンプのクリップボードコピー機能
4. エージェント詳細ページへのリンク

**画面遷移**：
- 遷移元：システム情報画面（/manage/systemInfo）、Jenkins管理画面（/manage）
- 遷移先：ノード詳細画面（/computer/{ノード名}/）

**権限による表示制御**：
- ADMINISTER権限を持つユーザーのみアクセス可能
- 非管理者ユーザーはこの画面にアクセスできない

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 1 | Jenkins本体 | 主機能 | JVMスレッドダンプの取得と表示 |

## 画面種別

詳細表示画面（診断・デバッグ画面）

## URL/ルーティング

| URL | HTTPメソッド | 説明 |
|-----|-------------|------|
| `/threadDump` | GET | スレッドダンプ画面の表示 |

## 入出力項目

この画面は参照専用のため、入力項目はありません。

## 表示項目

### ナビゲーション部

| 項目名 | 説明 |
|--------|------|
| ノードリンク | 各エージェントへのアンカーリンク（ページ内ジャンプ） |

### スレッドダンプ部（ノードごと）

| 項目名 | 説明 |
|--------|------|
| ノード名 | エージェント/ノードの名前（ノード詳細ページへのリンク付き） |
| スレッド名 | 各スレッドの識別名 |
| スレッドダンプ本文 | スレッドのスタックトレース（pre要素で表示） |
| コピーボタン | スレッドダンプをクリップボードにコピー |

## イベント仕様

### 1-ノードリンククリック

ページ上部のノードリンクをクリックすると、対応するノードのスレッドダンプ位置へページ内スクロールします。

**処理フロー**:
1. ユーザーがノードリンクをクリック
2. ブラウザがアンカー（`#id{hashCode}`）へスクロール
3. 対応するノードのスレッドダンプが表示領域に移動

### 2-コピーボタンクリック

各スレッドダンプの横にあるコピーボタンをクリックすると、そのスレッドダンプの内容がクリップボードにコピーされます。

**処理フロー**:
1. ユーザーがコピーボタンをクリック
2. `l:copyButton`コンポーネントがテキストをクリップボードにコピー
3. 成功メッセージ（successfullyCopied）がツールチップで表示

### 3-ノード名クリック

ノードセクションの見出しにあるノード名をクリックすると、そのノードの詳細画面に遷移します。

## データベース更新仕様

本画面は参照専用のため、データベースの更新は発生しません。

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 画面表示 | - | SELECT | JMXを通じてJVMからスレッドダンプを取得 |

## メッセージ仕様

| メッセージID | メッセージ種別 | メッセージ内容 | 表示条件 |
|-------------|---------------|---------------|---------|
| threadDump | ラベル | Thread Dump | 画面タイトル/パンくずリスト |
| threadDumpTitle | 見出し | Thread Dump | h1要素のタイトル |
| successfullyCopied | 成功 | コピー成功メッセージ | クリップボードコピー成功時 |
| clickToCopy | ツールチップ | クリックしてコピー | コピーボタンホバー時 |

## 例外処理

| 例外条件 | 表示内容 | 処理 |
|---------|---------|------|
| 権限不足 | アクセス拒否画面 | ADMINISTER権限がない場合は画面にアクセスできない |
| エージェント接続不可 | タイムアウトまたはエラー表示 | ハングしているエージェントはスキップされる可能性あり |

## 備考

- スレッドダンプの取得はJMX（Java Management Extensions）を使用しています
- `getAllThreadDumps()`メソッドは全エージェントに並列でリクエストを送信し、結果を収集します
- ハングしているエージェントに対しては、タイムアウト機構が働き、他のエージェントの結果を待たないようになっています
- 大規模環境では多くのスレッドダンプが表示されるため、ページが重くなる可能性があります
- 各ノードセクションは水平線（hr）で区切られ、視覚的に分離されています

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

スレッドダンプデータの構造を理解することが重要です。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | Jenkins.java | `core/src/main/java/jenkins/model/Jenkins.java` | `getAllThreadDumps()`メソッド（行4210付近）。戻り値は`Map<String, Map<String, String>>`（ノード名→スレッド名→ダンプ） |
| 1-2 | RemotingDiagnostics.java | `core/src/main/java/hudson/util/RemotingDiagnostics.java` | リモートノードからスレッドダンプを取得するユーティリティ |

**読解のコツ**: `getAllThreadDumps()`は全ノードに並列でリクエストを送信し、`Future`で結果を収集します。タイムアウト処理にも注目してください。

#### Step 2: エントリーポイントを理解する

処理の起点となるファイルを確認します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | threadDump.jelly | `core/src/main/resources/jenkins/model/Jenkins/threadDump.jelly` | メイン画面テンプレート。権限チェックとスレッドダンプ表示ロジック |

**主要処理フロー**:
1. **30行目**: `l:layout`で権限チェック（`permission="${app.ADMINISTER}"`）
2. **34行目**: `it.getAllThreadDumps()`を呼び出し、全スレッドダンプを取得
3. **36-42行目**: ノードリンク一覧を生成（ページ内ナビゲーション用）
4. **44-60行目**: 各ノードのスレッドダンプをループで表示

#### Step 3: コンポーネントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | copyButton.jelly | `core/src/main/resources/lib/layout/copyButton.jelly` | クリップボードコピー機能のUIコンポーネント |

**主要処理フロー**:
- **56-57行目**: `l:copyButton`でコピー機能を提供
- **58行目**: `pre`要素でスレッドダンプを等幅フォント表示

### プログラム呼び出し階層図

```
[HTTPリクエスト: /threadDump]
    │
    ├─ Jenkins.java
    │      └─ Stapler routing → threadDump.jelly
    │
    └─ threadDump.jelly
           │
           ├─ l:layout (権限チェック: ADMINISTER)
           │
           ├─ it.getAllThreadDumps()
           │      │
           │      ├─ Jenkins.getAllThreadDumps() (Jenkins.java 行4210)
           │      │      │
           │      │      ├─ マスターノードのスレッドダンプ取得
           │      │      │      └─ ThreadMXBean.dumpAllThreads()
           │      │      │
           │      │      └─ 各エージェントに並列リクエスト
           │      │             └─ RemotingDiagnostics.getThreadDump()
           │      │                    └─ VirtualChannel経由でJMX呼び出し
           │      │
           │      └─ Map<String, Map<String, String>> を返却
           │
           ├─ ノードリンク一覧生成（j:forEach）
           │
           └─ スレッドダンプ表示（j:forEach）
                  │
                  ├─ ノード見出し（h1 + リンク）
                  │
                  └─ スレッドごとの表示（h2 + pre）
                         └─ l:copyButton
```

### データフロー図

```
[入力]                      [処理]                              [出力]

JVMスレッド状態 ────────▶ ThreadMXBean.dumpAllThreads() ──▶ マスタースレッドダンプ
（マスター）                                                      │
                                                                  │
                                                                  ▼
JVMスレッド状態 ────────▶ RemotingDiagnostics ─────────────▶ エージェントスレッドダンプ
（各エージェント）          │                                      │
                          ▼                                      │
                    VirtualChannel                               │
                    （リモート通信）                               │
                                                                  │
                                                                  ▼
                                                        getAllThreadDumps()
                                                                  │
                                                                  ▼
                                                    Map<ノード名, Map<スレッド名, ダンプ>>
                                                                  │
                                                                  ▼
                                                        [HTML表示]
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| threadDump.jelly | `core/src/main/resources/jenkins/model/Jenkins/threadDump.jelly` | テンプレート | メイン画面のJellyテンプレート |
| Jenkins.java | `core/src/main/java/jenkins/model/Jenkins.java` | ソース | `getAllThreadDumps()`メソッドの実装 |
| RemotingDiagnostics.java | `core/src/main/java/hudson/util/RemotingDiagnostics.java` | ソース | リモートスレッドダンプ取得ユーティリティ |
| copyButton.jelly | `core/src/main/resources/lib/layout/copyButton.jelly` | テンプレート | クリップボードコピーUIコンポーネント |
| threadDump.properties | `core/src/main/resources/jenkins/model/Jenkins/threadDump.properties` | 設定 | 国際化メッセージ定義 |
