# 画面設計書 34-再起動

## 概要

本ドキュメントは、Jenkinsの「再起動」画面の設計について記述したものです。この画面はJenkinsを即座に再起動するための確認画面を提供します。

### 本画面の処理概要

この画面では、Jenkins管理者がJenkinsを即座に再起動するための確認と実行を行えます。

**業務上の目的・背景**：Jenkinsの設定変更やプラグイン更新後など、変更を反映するために再起動が必要な場合があります。本画面により、管理者は確認ダイアログを経て安全にJenkinsを再起動できます。ただし、この操作は実行中のビルドを強制的に中断するため、緊急性がない場合は「安全な再起動」の使用が推奨されます。

**画面へのアクセス方法**：Jenkins管理画面から「Jenkinsの再起動」を選択、または直接 `/restart` URLにアクセスします。MANAGE権限を持つユーザーのみがアクセス可能です。

**主要な操作・処理内容**：
1. 再起動確認メッセージの表示
2. 「Yes」ボタンによる再起動の実行
3. 再起動不可時のエラーメッセージ表示

**画面遷移**：
- 遷移元：Jenkins管理画面（/manage）、システム設定画面
- 遷移先：再起動中画面（HudsonIsRestarting）→ダッシュボード

**権限による表示制御**：
- MANAGE権限を持つユーザーのみアクセス可能
- 再起動機能がサポートされていない環境では、代替メッセージが表示される

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 1 | Jenkins本体 | 主機能 | Jenkinsの再起動処理 |

## 画面種別

確認画面（アクション実行確認）

## URL/ルーティング

| URL | HTTPメソッド | 説明 |
|-----|-------------|------|
| `/restart` | GET | 再起動確認画面の表示 |
| `/restart` | POST | 再起動処理の実行 |

## 入出力項目

### 入力項目

| 項目名 | 項目種別 | 必須 | 説明 |
|--------|---------|------|------|
| （なし） | - | - | 確認ボタンのみ |

### 出力項目

| 項目名 | 説明 |
|--------|------|
| 確認メッセージ | 再起動確認のテキスト |
| Yesボタン | 再起動実行ボタン |
| エラーメッセージ | 再起動不可時のメッセージ |

## 表示項目

### 再起動可能時

| 項目名 | 説明 |
|--------|------|
| 確認メッセージ | "Are you sure you want to restart Jenkins?" |
| Yesボタン | 再起動を実行するSubmitボタン |

### 再起動不可時

| 項目名 | 説明 |
|--------|------|
| エラーメッセージ | "Jenkins cannot restart itself as currently configured." |

## イベント仕様

### 1-Yesボタンクリック

「Yes」ボタンをクリックすると、Jenkinsの再起動処理が開始されます。

**処理フロー**:
1. ユーザーが「Yes」ボタンをクリック
2. POSTリクエストが`/restart`に送信される
3. `doRestart()`メソッドが呼び出される
4. `Lifecycle.restart()`が実行される
5. Jenkinsが停止し、再起動プロセスが開始
6. 再起動中画面（HudsonIsRestarting）が表示される
7. 再起動完了後、ダッシュボードにリダイレクト

### 2-ブラウザ戻るボタン

再起動をキャンセルする場合、ブラウザの戻るボタンで前の画面に戻れます。

## データベース更新仕様

本画面自体はデータベースを更新しませんが、再起動処理によりJenkinsの状態が変更されます。

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| Yes押下 | - | - | JVMプロセスの再起動（データベース操作なし） |

## メッセージ仕様

| メッセージID | メッセージ種別 | メッセージ内容 | 表示条件 |
|-------------|---------------|---------------|---------|
| Restart Jenkins | ラベル | 画面タイトル | 常時 |
| Are you sure... | 確認 | Are you sure you want to restart Jenkins? | 再起動可能時 |
| Yes | ボタン | Yesボタンラベル | 再起動可能時 |
| Jenkins cannot restart... | エラー | Jenkins cannot restart itself as currently configured. | 再起動不可時 |

## 例外処理

| 例外条件 | 表示内容 | 処理 |
|---------|---------|------|
| 権限不足 | アクセス拒否画面 | MANAGE権限がない場合は画面にアクセスできない |
| 再起動未サポート | エラーメッセージ | Lifecycleが再起動をサポートしていない場合 |
| RestartNotSupportedException | エラー画面 | 再起動処理中にエラーが発生した場合 |

## 備考

- 再起動は即座に実行されるため、実行中のビルドは強制的に中断されます
- 緊急性がない場合は「安全な再起動」（/safeRestart）の使用を推奨します
- `Lifecycle.canRestart()`で再起動機能のサポート状況を確認しています
- Windowsサービスとして動作している場合など、一部の環境では再起動がサポートされない場合があります
- サイドパネルを含むレイアウトで表示されます（sidepanel.jelly）

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

再起動処理に関わる主要なクラスを理解します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | Lifecycle.java | `core/src/main/java/hudson/lifecycle/Lifecycle.java` | 再起動機能の抽象化。`canRestart()`と`restart()`メソッドの定義 |
| 1-2 | RestartNotSupportedException.java | `core/src/main/java/hudson/lifecycle/RestartNotSupportedException.java` | 再起動未サポート時の例外 |

**読解のコツ**: `Lifecycle`は環境依存の起動/停止処理を抽象化するクラスです。実装クラス（UnixLifecycle、WindowsLifecycleなど）を確認すると、各環境での再起動方法がわかります。

#### Step 2: エントリーポイントを理解する

処理の起点となるファイルを確認します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | _restart.jelly | `core/src/main/resources/jenkins/model/Jenkins/_restart.jelly` | 確認画面テンプレート。Lifecycleの確認とフォーム表示 |
| 2-2 | Jenkins.java | `core/src/main/java/jenkins/model/Jenkins.java` | `doRestart()`メソッド（行4546付近）。再起動処理のエントリーポイント |

**主要処理フロー（_restart.jelly）**:
1. **28行目**: `l:layout`でレイアウト設定（タイトル: "Restart Jenkins"）
2. **29行目**: `st:include page="sidepanel.jelly"`でサイドパネル表示
3. **33行目**: `app.lifecycle.canRestart()`で再起動可否を確認
4. **34-37行目**: 再起動可能時はフォームとYesボタンを表示
5. **39-41行目**: 再起動不可時はエラーメッセージを表示

**主要処理フロー（Jenkins.doRestart()）**:
1. **4547行目**: `checkPermission(MANAGE)`で権限確認
2. **4548-4550行目**: GETリクエストの場合は確認画面にフォワード
3. **4551行目以降**: POSTリクエストの場合は再起動処理を実行

#### Step 3: 再起動処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | HudsonIsRestarting.java | `core/src/main/java/hudson/util/HudsonIsRestarting.java` | 再起動中に表示されるプレースホルダー |

### プログラム呼び出し階層図

```
[HTTPリクエスト: GET /restart]
    │
    ├─ Jenkins.doRestart() (行4546)
    │      │
    │      ├─ checkPermission(MANAGE)
    │      │
    │      └─ req.getView(this, "_restart.jelly").forward()
    │             │
    │             └─ _restart.jelly
    │                    │
    │                    ├─ app.lifecycle.canRestart()
    │                    │      └─ Lifecycle.canRestart()
    │                    │
    │                    └─ フォーム表示（再起動可能時）

[HTTPリクエスト: POST /restart]
    │
    ├─ Jenkins.doRestart() (行4546)
    │      │
    │      ├─ checkPermission(MANAGE)
    │      │
    │      ├─ restartableLifecycle()
    │      │      └─ Lifecycle.get()
    │      │
    │      ├─ HudsonIsRestartingに切り替え
    │      │
    │      └─ lifecycle.restart()
    │             │
    │             ├─ (Unix) exec()でプロセス再起動
    │             │
    │             └─ (Windows) サービス再起動
```

### データフロー図

```
[入力]                     [処理]                              [出力]

GETリクエスト ─────────▶ doRestart() ─────────────────────▶ _restart.jelly表示
                              │
                              ▼
                        canRestart()確認
                              │
                    ┌─────────┴─────────┐
                    ▼                   ▼
               再起動可能           再起動不可
                    │                   │
                    ▼                   ▼
              フォーム表示        エラーメッセージ

POSTリクエスト ────────▶ doRestart() ─────────────────────▶ HudsonIsRestarting
（Yesボタン）                │
                              ▼
                        lifecycle.restart()
                              │
                              ▼
                        JVMプロセス再起動
                              │
                              ▼
                        [再起動完了]
                              │
                              ▼
                        ダッシュボード
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| _restart.jelly | `core/src/main/resources/jenkins/model/Jenkins/_restart.jelly` | テンプレート | 再起動確認画面のJellyテンプレート |
| Jenkins.java | `core/src/main/java/jenkins/model/Jenkins.java` | ソース | `doRestart()`メソッドの実装 |
| Lifecycle.java | `core/src/main/java/hudson/lifecycle/Lifecycle.java` | ソース | 再起動機能の抽象クラス |
| HudsonIsRestarting.java | `core/src/main/java/hudson/util/HudsonIsRestarting.java` | ソース | 再起動中表示クラス |
| sidepanel.jelly | `core/src/main/resources/jenkins/model/Jenkins/sidepanel.jelly` | テンプレート | サイドパネル |
| _restart.properties | `core/src/main/resources/jenkins/model/Jenkins/_restart.properties` | 設定 | 国際化メッセージ定義 |
