# 画面設計書 35-安全な再起動

## 概要

本ドキュメントは、Jenkinsの「安全な再起動」画面の設計について記述したものです。この画面は実行中のジョブが完了するのを待ってからJenkinsを再起動するための設定・確認画面を提供します。

### 本画面の処理概要

この画面では、Jenkins管理者が実行中のビルドを中断することなく、安全にJenkinsを再起動できます。

**業務上の目的・背景**：Jenkinsの設定変更やプラグイン更新後に再起動が必要な場合、即時再起動は実行中のビルドを中断してしまいます。本画面により、管理者は「クワイエットダウン」モードを有効にし、新規ビルドの開始を抑止しつつ、実行中のビルドが完了するのを待ってから再起動を実行できます。これにより、業務への影響を最小限に抑えた計画的な再起動が可能になります。

**画面へのアクセス方法**：Jenkins管理画面から「安全な再起動」を選択、または直接 `/safeRestart` URLにアクセスします。MANAGE権限を持つユーザーのみがアクセス可能です。

**主要な操作・処理内容**：
1. 再起動バナーメッセージの入力（オプション）
2. 「Restart」ボタンによる安全な再起動の開始
3. クワイエットダウン中の場合、「Cancel」ボタンでキャンセル
4. 再起動不可時のエラーメッセージ表示

**画面遷移**：
- 遷移元：Jenkins管理画面（/manage）、システム設定画面
- 遷移先：ダッシュボード（クワイエットダウン状態）→再起動中画面→ダッシュボード

**権限による表示制御**：
- MANAGE権限を持つユーザーのみアクセス可能
- 再起動機能がサポートされていない環境では、代替メッセージが表示される
- クワイエットダウン中の場合のみ「Cancel」ボタンが表示される

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 1 | Jenkins本体 | 主機能 | ジョブ完了待機後の再起動処理 |
| 7 | キュー管理 | 補助機能 | 実行中ジョブの完了待機 |

## 画面種別

入力・確認画面（アクション実行設定・確認）

## URL/ルーティング

| URL | HTTPメソッド | 説明 |
|-----|-------------|------|
| `/safeRestart` | GET | 安全な再起動画面の表示 |
| `/safeRestart` | POST | 安全な再起動処理の開始/キャンセル |

## 入出力項目

### 入力項目

| 項目名 | 項目種別 | 必須 | 説明 |
|--------|---------|------|------|
| message | テキストボックス | いいえ | Jenkinsが再起動中であることをユーザーに通知するバナーメッセージ |
| cancel | 隠しフィールド | いいえ | キャンセル時に送信されるフラグ |

### 出力項目

| 項目名 | 説明 |
|--------|------|
| 警告メッセージ | 再起動に関する注意事項 |
| Restartボタン | 再起動実行ボタン（destructive color） |
| Cancelボタン | クワイエットダウンキャンセルボタン（クワイエットダウン中のみ表示） |
| エラーメッセージ | 再起動不可時のメッセージ |

## 表示項目

### 再起動可能時

| 項目名 | 説明 |
|--------|------|
| restartWarning | 再起動に関する警告メッセージ |
| メッセージ入力欄 | バナーメッセージのテキストボックス（既存のquietDownReasonがあれば初期値として設定） |
| Restartボタン | 再起動実行ボタン（赤色/destructive） |
| Cancelボタン | クワイエットダウンキャンセルボタン（クワイエットダウン中のみ） |

### 再起動不可時

| 項目名 | 説明 |
|--------|------|
| cannotRestart | "Jenkins cannot restart itself as currently configured." |

## イベント仕様

### 1-Restartボタンクリック

「Restart」ボタンをクリックすると、安全な再起動処理が開始されます。

**処理フロー**:
1. ユーザーが「Restart」ボタンをクリック
2. POSTリクエストが`/safeRestart`に送信される（messageパラメータ含む）
3. `doSafeRestart()`メソッドが呼び出される
4. `safeRestart(message)`が実行される
5. クワイエットダウンモードが有効化（新規ビルド開始抑止）
6. バックグラウンドスレッドが実行中ジョブの完了を監視
7. 全ジョブ完了後、`Lifecycle.restart()`が実行される
8. 再起動完了後、ダッシュボードにリダイレクト

### 2-Cancelボタンクリック

「Cancel」ボタンをクリックすると、クワイエットダウン状態がキャンセルされます。

**処理フロー**:
1. ユーザーが「Cancel」ボタンをクリック
2. POSTリクエストが`/safeRestart`に送信される（cancel=trueパラメータ含む）
3. `doCancelQuietDown()`が呼び出される
4. クワイエットダウン状態が解除され、新規ビルドが再開可能になる
5. ダッシュボードにリダイレクト

### 3-メッセージ入力

バナーメッセージを入力すると、クワイエットダウン中にすべてのユーザーに対して表示されます。

## データベース更新仕様

本画面自体はデータベースを更新しませんが、クワイエットダウン状態がメモリ上で管理されます。

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| Restart押下 | - | - | QuietDownInfoがメモリ上に設定される |
| Cancel押下 | - | - | QuietDownInfoがクリアされる |

## メッセージ仕様

| メッセージID | メッセージ種別 | メッセージ内容 | 表示条件 |
|-------------|---------------|---------------|---------|
| Safe restart | ラベル | 画面タイトル/アプリバー | 常時 |
| restartWarning | 警告 | 再起動に関する注意事項 | 再起動可能時 |
| Jenkins is restarting banner | ラベル | メッセージ入力欄のラベル | 再起動可能時 |
| description | 説明 | メッセージ入力欄の説明 | 再起動可能時 |
| Restart | ボタン | Restartボタンラベル | 再起動可能時 |
| Cancel | ボタン | Cancelボタンラベル | クワイエットダウン中 |
| cannotRestart | エラー | 再起動不可メッセージ | 再起動不可時 |

## 例外処理

| 例外条件 | 表示内容 | 処理 |
|---------|---------|------|
| 権限不足 | アクセス拒否画面 | MANAGE権限がない場合は画面にアクセスできない |
| 再起動未サポート | エラーメッセージ | Lifecycleが再起動をサポートしていない場合 |
| RestartNotSupportedException | エラー画面 | 再起動処理中にエラーが発生した場合 |

## 備考

- 「安全な再起動」は、実行中のビルドを待機してから再起動するため、時間がかかる可能性があります
- クワイエットダウン中は、新規ビルドはキューに入りますが開始されません
- バナーメッセージはすべてのJenkinsユーザーに表示され、再起動の理由や予定を伝えるのに使用できます
- 既にクワイエットダウン中の場合、入力欄には現在のquietDownReasonが初期値として設定されます
- Restartボタンは`jenkins-!-destructive-color`クラスで赤色表示され、破壊的操作であることを視覚的に示しています

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

安全な再起動に関わるデータ構造を理解します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | Jenkins.java（QuietDownInfo） | `core/src/main/java/jenkins/model/Jenkins.java` | 内部クラス`QuietDownInfo`（行5984-6012）。message、safeRestartフラグを保持 |
| 1-2 | Lifecycle.java | `core/src/main/java/hudson/lifecycle/Lifecycle.java` | 再起動機能の抽象化 |

**読解のコツ**: `QuietDownInfo`は`message`（バナーメッセージ）と`safeRestart`（安全な再起動フラグ）を持ちます。`isSafeRestart()`で判定できます。

#### Step 2: エントリーポイントを理解する

処理の起点となるファイルを確認します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | _safeRestart.jelly | `core/src/main/resources/jenkins/model/Jenkins/_safeRestart.jelly` | 確認・入力画面テンプレート。メッセージ入力とボタン表示 |
| 2-2 | Jenkins.java | `core/src/main/java/jenkins/model/Jenkins.java` | `doSafeRestart()`メソッド（行4600付近）、`safeRestart()`メソッド（行4683付近） |

**主要処理フロー（_safeRestart.jelly）**:
1. **28行目**: `l:layout`でレイアウト設定（タイトル: "Safe restart"）
2. **32行目**: `l:app-bar`でタイトル表示
3. **33-34行目**: `app.lifecycle.canRestart()`で再起動可否を確認
4. **35行目**: `${%restartWarning}`で警告メッセージ表示
5. **37-41行目**: メッセージ入力欄（既存のquietDownReasonを初期値に）
6. **42-46行目**: ボタンバー（Restart + クワイエットダウン中はCancel）

**主要処理フロー（Jenkins.doSafeRestart()）**:
1. **4601行目**: `checkPermission(MANAGE)`で権限確認
2. **4602-4603行目**: GETリクエストの場合は画面にフォワード
3. **4606-4608行目**: cancelパラメータがある場合は`doCancelQuietDown()`
4. **4610-4612行目**: `safeRestart(message)`を呼び出し

#### Step 3: バックグラウンド処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | Jenkins.java（safeRestart） | `core/src/main/java/jenkins/model/Jenkins.java` | `safeRestart()`メソッド（行4683-4695）。新スレッドでジョブ完了を待機 |

### プログラム呼び出し階層図

```
[HTTPリクエスト: GET /safeRestart]
    │
    ├─ Jenkins.doSafeRestart() (行4600)
    │      │
    │      ├─ checkPermission(MANAGE)
    │      │
    │      └─ HttpResponses.forwardToView("_safeRestart.jelly")
    │             │
    │             └─ _safeRestart.jelly
    │                    │
    │                    ├─ app.lifecycle.canRestart()
    │                    │
    │                    ├─ メッセージ入力欄
    │                    │      └─ value="${app.quietDownReason ?: null}"
    │                    │
    │                    └─ ボタン表示
    │                           ├─ Restart（常時）
    │                           └─ Cancel（isQuietingDown()時のみ）

[HTTPリクエスト: POST /safeRestart (Restart)]
    │
    ├─ Jenkins.doSafeRestart() (行4600)
    │      │
    │      ├─ checkPermission(MANAGE)
    │      │
    │      └─ safeRestart(message) (行4683)
    │             │
    │             ├─ restartableLifecycle()
    │             │
    │             ├─ quietDownInfo = new QuietDownInfo(message, true)
    │             │
    │             └─ 新スレッド "safe-restart thread"
    │                    │
    │                    ├─ ジョブ完了待機ループ
    │                    │      └─ isQuietingDown() && !isBusyBuilding()
    │                    │
    │                    └─ lifecycle.restart()

[HTTPリクエスト: POST /safeRestart (Cancel)]
    │
    ├─ Jenkins.doSafeRestart() (行4600)
    │      │
    │      └─ doCancelQuietDown()
    │             │
    │             └─ quietDownInfo = null
```

### データフロー図

```
[入力]                      [処理]                              [出力]

GETリクエスト ─────────▶ doSafeRestart() ──────────────────▶ _safeRestart.jelly表示
                              │
                              ▼
                        canRestart()確認
                              │
                    ┌─────────┴─────────┐
                    ▼                   ▼
               再起動可能           再起動不可
                    │                   │
                    ▼                   ▼
            入力フォーム表示     エラーメッセージ

POSTリクエスト ────────▶ doSafeRestart() ──────────────────▶ リダイレクト
（Restart）                   │
    │                        ▼
    │               safeRestart(message)
    │                        │
message ─────────────▶ QuietDownInfo設定
                              │
                              ▼
                    safe-restart thread開始
                              │
                              ▼
                    ジョブ完了待機
                              │
                              ▼
                    lifecycle.restart()
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| _safeRestart.jelly | `core/src/main/resources/jenkins/model/Jenkins/_safeRestart.jelly` | テンプレート | 安全な再起動画面のJellyテンプレート |
| Jenkins.java | `core/src/main/java/jenkins/model/Jenkins.java` | ソース | `doSafeRestart()`、`safeRestart()`メソッドの実装 |
| Lifecycle.java | `core/src/main/java/hudson/lifecycle/Lifecycle.java` | ソース | 再起動機能の抽象クラス |
| HudsonIsRestarting.java | `core/src/main/java/hudson/util/HudsonIsRestarting.java` | ソース | 再起動中表示クラス |
| sidepanel.jelly | `core/src/main/resources/jenkins/model/Jenkins/sidepanel.jelly` | テンプレート | サイドパネル |
| _safeRestart.properties | `core/src/main/resources/jenkins/model/Jenkins/_safeRestart.properties` | 設定 | 国際化メッセージ定義 |
