# 画面設計書 36-Jenkinsについて

## 概要

本ドキュメントは、Jenkinsの「Jenkinsについて」画面の設計について記述したものです。この画面はJenkinsのバージョン情報、ライセンス情報、依存ライブラリの情報を表示します。

### 本画面の処理概要

この画面では、Jenkinsのバージョン、利用しているオープンソースライブラリのライセンス情報などを確認できます。

**業務上の目的・背景**：ソフトウェアのライセンス管理やコンプライアンス対応において、使用しているライブラリとそのライセンスを把握することは重要です。本画面により、管理者や法務担当者はJenkinsが使用している全てのサードパーティライブラリとそのライセンス情報を一覧で確認でき、ライセンス監査やオープンソースコンプライアンスに対応できます。また、現在のJenkinsバージョンの確認にも使用されます。

**画面へのアクセス方法**：Jenkins管理画面（/manage）から「Jenkinsについて」リンクをクリック、または直接 `/about` URLにアクセスします。READ権限を持つ全てのユーザーがアクセス可能です。

**主要な操作・処理内容**：
1. Jenkinsバージョン情報の表示
2. Mavenで管理される依存ライブラリとそのライセンスの表示
3. 静的に組み込まれたライブラリ（CSS、アイコンフォント等）の表示
4. インストール済みプラグインのライセンス情報へのリンク表示
5. コミュニティ参加への案内（Get involvedボタン）

**画面遷移**：
- 遷移元：Jenkins管理画面（/manage）
- 遷移先：プラグイン別サードパーティライセンス画面、外部サイト（jenkins.io/participate）

**権限による表示制御**：
- READ権限を持つ全ユーザーがアクセス可能
- 表示内容に権限による差異はない

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 1 | Jenkins本体 | 主機能 | バージョン・ライセンス情報の表示 |

## 画面種別

情報表示画面（タブ形式の詳細表示）

## URL/ルーティング

| URL | HTTPメソッド | 説明 |
|-----|-------------|------|
| `/about` | GET | Jenkinsについて画面の表示 |

## 入出力項目

この画面は参照専用のため、入力項目はありません。

## 表示項目

### ヘッダー部

| 項目名 | 説明 |
|--------|------|
| Jenkinsロゴ | Jenkinsのロゴ画像（オーロラ背景付き） |
| Version | 現在のJenkinsバージョン（app.VERSION） |
| Get involvedボタン | Jenkinsコミュニティ参加ページへのリンク |

### 説明文（blurb）

| 項目名 | 説明 |
|--------|------|
| blurb | Jenkinsについての説明文 |

### Maven依存ライブラリタブ

| 項目名 | 説明 |
|--------|------|
| ライブラリ一覧 | Maven/Gradleで管理されるJava依存ライブラリとそのライセンス情報 |

### 静的依存ライブラリタブ

| 項目名 | 説明 |
|--------|------|
| Name | ライブラリ名（外部リンク付き） |
| Author | 作成者（外部リンク付き） |
| Licence | ライセンス種別（ライセンス文書への外部リンク付き） |

### プラグイン依存ライブラリタブ

| 項目名 | 説明 |
|--------|------|
| Name | プラグイン名（サードパーティライセンスページへのリンク付き） |

## イベント仕様

### 1-タブ切り替え

タブ（Maven dependencies / Static dependencies / Plugin dependencies）をクリックすると、対応する情報パネルが表示されます。

### 2-Get involvedボタンクリック

「Get involved」ボタンをクリックすると、Jenkinsコミュニティ参加ページ（https://www.jenkins.io/participate/）が新しいタブで開きます。

### 3-ライブラリリンククリック

各ライブラリ名やライセンスのリンクをクリックすると、外部サイトが新しいタブで開きます。

### 4-プラグインリンククリック

プラグイン名をクリックすると、そのプラグインのサードパーティライセンスページ（`/plugin/{shortName}/wrapper/thirdPartyLicenses`）に遷移します。

## データベース更新仕様

本画面は参照専用のため、データベースの更新は発生しません。

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 画面表示 | - | SELECT | バージョン情報、ライセンスXML、プラグイン一覧の取得（ファイルシステム/メモリから） |

## メッセージ仕様

| メッセージID | メッセージ種別 | メッセージ内容 | 表示条件 |
|-------------|---------------|---------------|---------|
| Version | ラベル | Version | バージョン表示ラベル |
| Get involved | ボタン | Get involved | 常時 |
| logo | alt属性 | Jenkins logo | ロゴ画像のalt |
| blurb | 説明 | Jenkinsについての説明文 | 常時 |
| maven.dependencies | 見出し | Maven Dependencies | タブ見出し |
| static.dependencies | 見出し | Static Dependencies | タブ見出し |
| plugin.dependencies | 見出し | Plugin Dependencies | タブ見出し |
| No information recorded | 情報 | No information recorded | ライセンス情報がない場合 |

## 例外処理

| 例外条件 | 表示内容 | 処理 |
|---------|---------|------|
| 権限不足 | アクセス拒否画面 | READ権限がない場合（通常は発生しない） |
| ライセンスXML取得失敗 | "No information recorded" | licenses.xmlが存在しない場合 |
| プラグインが非アクティブ | 取り消し線表示 | `<strike>`タグで表示 |

## 備考

- Maven依存ライブラリのライセンス情報は`/META-INF/licenses.xml`から読み込まれます
- 静的依存ライブラリはハードコードされており、現在は「Jenkins Contrib Themes」と「Ionicons」が含まれています
- プラグイン一覧は`app.pluginManager.plugins`から取得され、非アクティブなプラグインは取り消し線で表示されます
- 「Get involved」ボタンにはハートアイコン（symbol-heart）が表示されます
- ページにはオーロラ背景効果（`app-about-branding__aurora`）が適用されています

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

画面で表示されるデータの出所を理解します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | AboutJenkins.java | `core/src/main/java/hudson/AboutJenkins.java` | ManagementLinkの実装。URLName、必要権限、`getLicensesURL()`の定義 |
| 1-2 | Jenkins.java | `core/src/main/java/jenkins/model/Jenkins.java` | `VERSION`定数、`pluginManager`プロパティ |

**読解のコツ**: `AboutJenkins`クラスは軽量で、主にURLとライセンスXMLのパスを提供します。画面の複雑さはJellyテンプレートにあります。

#### Step 2: エントリーポイントを理解する

処理の起点となるファイルを確認します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | index.jelly | `core/src/main/resources/hudson/AboutJenkins/index.jelly` | メイン画面テンプレート。ヘッダー、タブ構成、各ライブラリセクション |

**主要処理フロー**:
1. **28-45行目**: ヘッダー部の定義（ロゴ、バージョン、Get involvedボタン）
2. **47-49行目**: `l:settings-subpage`で権限チェック（MANAGE_AND_SYSTEM_READ）
3. **52-55行目**: オーロラ背景とロゴの表示
4. **57行目**: blurb（説明文）の表示
5. **59-72行目**: Maven依存ライブラリタブ（licenses.xmlから）
6. **74-113行目**: 静的依存ライブラリタブ（ハードコード）
7. **115-142行目**: プラグイン依存ライブラリタブ

#### Step 3: ライセンス情報取得を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | thirdPartyLicenses.jelly | `core/src/main/resources/lib/hudson/thirdPartyLicenses.jelly` | ライセンス一覧表示用タグライブラリ |

### プログラム呼び出し階層図

```
[HTTPリクエスト: /about]
    │
    ├─ Jenkins.java
    │      └─ Stapler routing → AboutJenkins
    │             └─ index.jelly
    │
    └─ index.jelly
           │
           ├─ ヘッダー部
           │      ├─ app.VERSION
           │      └─ Get involvedボタン（外部リンク）
           │
           ├─ l:settings-subpage (権限チェック)
           │      └─ MANAGE_AND_SYSTEM_READ
           │
           ├─ Maven依存タブ
           │      │
           │      ├─ it.licensesURL
           │      │      └─ AboutJenkins.getLicensesURL()
           │      │             └─ /META-INF/licenses.xml
           │      │
           │      └─ t:thirdPartyLicenses
           │             └─ j:include uri="${uri}"
           │
           ├─ 静的依存タブ
           │      └─ ハードコードされたテーブル
           │
           └─ プラグイン依存タブ
                  │
                  └─ app.pluginManager.plugins
                         │
                         └─ 各プラグインのthirdPartyLicensesリンク
```

### データフロー図

```
[入力]                        [処理]                              [出力]

Jenkins.VERSION ──────────▶ バージョン表示 ─────────────────▶ ヘッダー部

/META-INF/licenses.xml ───▶ AboutJenkins.getLicensesURL() ─▶ Maven依存タブ
                                   │
                                   ▼
                           t:thirdPartyLicenses
                           （XML解析・テーブル表示）

ハードコード ─────────────▶ 静的テーブル ──────────────────▶ 静的依存タブ
（Ionicons, Contrib Themes）

PluginManager.plugins ────▶ ループ処理 ────────────────────▶ プラグイン依存タブ
                                   │
                                   ▼
                           p.active判定
                           （非アクティブは取り消し線）
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| index.jelly | `core/src/main/resources/hudson/AboutJenkins/index.jelly` | テンプレート | メイン画面のJellyテンプレート |
| AboutJenkins.java | `core/src/main/java/hudson/AboutJenkins.java` | ソース | ManagementLinkの実装クラス |
| thirdPartyLicenses.jelly | `core/src/main/resources/lib/hudson/thirdPartyLicenses.jelly` | テンプレート | ライセンス表示用タグ |
| licenses.xml | `/META-INF/licenses.xml` | データ | Maven依存ライブラリのライセンス情報 |
| PluginManager.java | `core/src/main/java/hudson/PluginManager.java` | ソース | プラグイン管理クラス |
| index.properties | `core/src/main/resources/hudson/AboutJenkins/index.properties` | 設定 | 国際化メッセージ定義 |
| section-to-tabs.js | `war/src/main/js/section-to-tabs.js` | JavaScript | タブUI生成スクリプト |
