# 画面設計書 37-プラグイン管理トップ

## 概要

本ドキュメントは、Jenkinsの「プラグイン管理トップ」画面の設計について記述したものです。この画面はプラグイン管理機能へのエントリーポイントとなり、更新可能なプラグインがある場合は更新画面にリダイレクトします。

### 本画面の処理概要

この画面は、プラグイン管理の各機能へのナビゲーションを提供する画面です。

**業務上の目的・背景**：Jenkinsのプラグインシステムは、機能拡張の中核を担っています。本画面は、プラグインのインストール、更新、管理といった各操作へのアクセスポイントを提供します。特に、更新可能なプラグインがある場合は自動的に更新画面に誘導し、セキュリティ更新などの重要なアップデートを促進します。

**画面へのアクセス方法**：Jenkins管理画面（/manage）から「プラグインの管理」リンクをクリック、または直接 `/manage/pluginManager/` URLにアクセスします。SYSTEM_READ権限を持つユーザーがアクセス可能です。

**主要な操作・処理内容**：
1. 更新可能なプラグインがある場合、更新画面（/updates）へのリダイレクト
2. 更新センターにジョブがある場合、進捗状況へのリンク表示
3. サイドパネルからの各画面へのナビゲーション

**画面遷移**：
- 遷移元：Jenkins管理画面（/manage）
- 遷移先：更新可能なプラグイン（/updates）、利用可能なプラグイン（/available）、インストール済みプラグイン（/installed）、詳細設定（/advanced）、ダウンロード進捗（/updates/）

**権限による表示制御**：
- SYSTEM_READ権限を持つユーザーがアクセス可能
- 管理者権限（ADMINISTER）がない場合、一部の操作が制限される可能性がある

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 2 | プラグインマネージャー | 主機能 | プラグイン管理のナビゲーション |
| 3 | アップデートセンター | 補助機能 | 更新情報の表示 |

## 画面種別

ナビゲーション画面（リダイレクト/メニュー画面）

## URL/ルーティング

| URL | HTTPメソッド | 説明 |
|-----|-------------|------|
| `/manage/pluginManager/` | GET | プラグイン管理トップ（更新画面へのリダイレクト機能付き） |

## 入出力項目

この画面は主にナビゲーション用のため、入力項目はありません。

## 表示項目

### メインエリア

| 項目名 | 説明 |
|--------|------|
| 更新センターリンク | 更新センターへのリンク（ジョブがある場合のみ表示） |

### サイドパネル（sidepanel.jelly）

| 項目名 | アイコン | 説明 |
|--------|---------|------|
| Updates | symbol-download | 更新可能なプラグイン画面へのリンク（バッジ付き） |
| Available plugins | symbol-shopping-bag | 利用可能なプラグイン画面へのリンク |
| Installed plugins | symbol-plugins | インストール済みプラグイン画面へのリンク |
| Advanced settings | symbol-settings | 詳細設定画面へのリンク |
| Download progress | symbol-list | ダウンロード進捗画面へのリンク（ジョブがある場合のみ） |

## イベント仕様

### 1-画面アクセス

プラグイン管理トップ（/manage/pluginManager/）にアクセスすると、更新センターにジョブがある場合のみ更新センターへのリンクが表示されます。

**処理フロー**:
1. ユーザーが`/manage/pluginManager/`にアクセス
2. `local:updates`タグがインクルードされる
3. `app.updateCenter.jobs`が空でない場合、更新センターへのリンクを表示

### 2-サイドパネルナビゲーション

サイドパネルの各リンクをクリックすると、対応する画面に遷移します。

| リンク | 遷移先URL |
|--------|----------|
| Updates | `/manage/pluginManager/` |
| Available plugins | `/manage/pluginManager/available` |
| Installed plugins | `/manage/pluginManager/installed` |
| Advanced settings | `/manage/pluginManager/advanced` |
| Download progress | `/manage/pluginManager/updates/` |

## データベース更新仕様

本画面は参照専用のため、データベースの更新は発生しません。

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 画面表示 | - | SELECT | UpdateCenterのジョブ状況を確認 |

## メッセージ仕様

| メッセージID | メッセージ種別 | メッセージ内容 | 表示条件 |
|-------------|---------------|---------------|---------|
| Plugins | ラベル | サイドパネルタイトル | 常時 |
| Updates | ラベル | Updates | サイドパネルリンク |
| Available plugins | ラベル | Available plugins | サイドパネルリンク |
| Installed plugins | ラベル | Installed plugins | サイドパネルリンク |
| Advanced settings | ラベル | Advanced settings | サイドパネルリンク |
| Download progress | ラベル | Download progress | ジョブがある場合 |
| UpdatePageLegend | 情報 | 更新センターへのリンク | ジョブがある場合 |

## 例外処理

| 例外条件 | 表示内容 | 処理 |
|---------|---------|------|
| 権限不足 | アクセス拒否画面 | SYSTEM_READ権限がない場合は画面にアクセスできない |

## 備考

- この画面（index.jelly）は非常にシンプルで、主な機能はサイドパネルで提供されます
- サイドパネルの「Updates」リンクには`app.updateCenter.badge`でバッジが表示され、更新可能なプラグイン数を示します
- 「Download progress」リンクは`app.updateCenter.jobs`が空でない場合のみ表示されます
- `local:updates`タグは、プラグイン管理画面共通のコンポーネントです

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

プラグイン管理に関わる主要なクラスを理解します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | PluginManager.java | `core/src/main/java/hudson/PluginManager.java` | プラグイン管理の中核クラス。plugins、failedPlugins、UpdateCenterとの連携 |
| 1-2 | UpdateCenter.java | `core/src/main/java/hudson/model/UpdateCenter.java` | 更新センター。jobs（実行中/完了ジョブ）、updates（更新可能プラグイン）の管理 |

**読解のコツ**: `PluginManager`はJenkinsインスタンスから`app.pluginManager`でアクセスでき、`UpdateCenter`は`app.updateCenter`でアクセスできます。

#### Step 2: エントリーポイントを理解する

処理の起点となるファイルを確認します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | index.jelly | `core/src/main/resources/hudson/PluginManager/index.jelly` | メイン画面テンプレート。local:updatesタグのインクルード |
| 2-2 | sidepanel.jelly | `core/src/main/resources/hudson/PluginManager/sidepanel.jelly` | サイドパネルのナビゲーション定義 |

**主要処理フロー（index.jelly）**:
1. **26行目**: `local:updates`タグをインクルード（名前空間定義）
2. **27-32行目**: `local:updates`タグを使用し、ジョブがある場合はリンクを表示

**主要処理フロー（sidepanel.jelly）**:
1. **30行目**: `l:side-panel sticky="true"`でスティッキーサイドパネル
2. **31行目**: `l:app-bar`でタイトル表示
3. **32-39行目**: `l:tasks`で各画面へのリンクを定義
4. **33行目**: Updatesリンクにバッジ（`badge="${app.updateCenter.badge}"`）
5. **37-39行目**: ジョブがある場合のみDownload progressリンクを表示

### プログラム呼び出し階層図

```
[HTTPリクエスト: /manage/pluginManager/]
    │
    ├─ Jenkins.java
    │      └─ Stapler routing → PluginManager
    │             └─ index.jelly
    │
    └─ index.jelly
           │
           ├─ local:updates
           │      │
           │      └─ app.updateCenter.jobs
           │             └─ 空でない場合、リンク表示
           │
           └─ sidepanel.jelly（インクルード）
                  │
                  ├─ l:side-panel
                  │
                  ├─ l:app-bar title="Plugins"
                  │
                  └─ l:tasks
                         │
                         ├─ Updates（badge付き）
                         │      └─ app.updateCenter.badge
                         │
                         ├─ Available plugins
                         │
                         ├─ Installed plugins
                         │
                         ├─ Advanced settings
                         │
                         └─ Download progress（条件付き）
                                └─ app.updateCenter.jobs.isEmpty()
```

### データフロー図

```
[入力]                      [処理]                              [出力]

GETリクエスト ─────────▶ PluginManager ──────────────────▶ index.jelly
                              │
                              ▼
                    UpdateCenter.getJobs()
                              │
                    ┌─────────┴─────────┐
                    ▼                   ▼
              ジョブあり            ジョブなし
                    │                   │
                    ▼                   ▼
            リンク表示              表示なし

                    サイドパネル
                         │
                         ├─ Updates + badge ──▶ /manage/pluginManager/
                         ├─ Available ─────────▶ /manage/pluginManager/available
                         ├─ Installed ─────────▶ /manage/pluginManager/installed
                         ├─ Advanced ──────────▶ /manage/pluginManager/advanced
                         └─ Progress（条件） ──▶ /manage/pluginManager/updates/
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| index.jelly | `core/src/main/resources/hudson/PluginManager/index.jelly` | テンプレート | メイン画面のJellyテンプレート |
| sidepanel.jelly | `core/src/main/resources/hudson/PluginManager/sidepanel.jelly` | テンプレート | サイドパネルナビゲーション |
| PluginManager.java | `core/src/main/java/hudson/PluginManager.java` | ソース | プラグイン管理クラス |
| UpdateCenter.java | `core/src/main/java/hudson/model/UpdateCenter.java` | ソース | 更新センタークラス |
| updates.jelly | `core/src/main/resources/hudson/PluginManager/updates.jelly` | テンプレート | 更新可能プラグイン画面 |
| index.properties | `core/src/main/resources/hudson/PluginManager/index.properties` | 設定 | 国際化メッセージ定義 |
| sidepanel.properties | `core/src/main/resources/hudson/PluginManager/sidepanel.properties` | 設定 | サイドパネルメッセージ定義 |
