# 画面設計書 38-インストール済みプラグイン

## 概要

本ドキュメントは、Jenkinsの「インストール済みプラグイン」画面の設計について記述したものです。この画面はインストール済みのプラグイン一覧を表示し、有効化/無効化、アンインストールなどの管理操作を提供します。

### 本画面の処理概要

この画面では、Jenkins管理者がインストール済みのプラグインを確認・管理できます。

**業務上の目的・背景**：Jenkinsの機能はプラグインによって拡張されます。本画面により、管理者は現在インストールされているプラグインの状態（有効/無効、バージョン、健全性スコア）を一覧で確認し、不要なプラグインの無効化やアンインストール、セキュリティ警告の確認、ダウングレードなどの管理操作を行えます。プラグイン間の依存関係も可視化され、安全な管理が可能です。

**画面へのアクセス方法**：プラグイン管理サイドパネルから「Installed plugins」をクリック、または直接 `/manage/pluginManager/installed` URLにアクセスします。SYSTEM_READ権限を持つユーザーがアクセス可能です。

**主要な操作・処理内容**：
1. インストール済みプラグイン一覧の表示（名前、バージョン、健全性スコア、有効状態）
2. プラグインの有効化/無効化（トグルスイッチ）
3. プラグインのアンインストール
4. プラグインのダウングレード（バックアップバージョンがある場合）
5. プラグインの検索/フィルタリング
6. 失敗したプラグインのエラー表示

**画面遷移**：
- 遷移元：プラグイン管理トップ、Jenkins管理画面
- 遷移先：プラグイン詳細ページ（外部）、イシュートラッカー（外部）、安全な再起動画面

**権限による表示制御**：
- SYSTEM_READ権限：一覧表示のみ
- ADMINISTER権限：有効/無効切り替え、アンインストール、ダウングレード操作が可能

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 2 | プラグインマネージャー | 主機能 | インストール済みプラグインの一覧表示・管理 |
| 51 | 拡張機構 | 補助機能 | プラグイン拡張情報の表示 |

## 画面種別

一覧画面（管理機能付き）

## URL/ルーティング

| URL | HTTPメソッド | 説明 |
|-----|-------------|------|
| `/manage/pluginManager/installed` | GET | インストール済みプラグイン一覧の表示 |
| `/manage/pluginManager/plugin/{shortName}` | POST | プラグインの有効/無効切り替え |
| `/manage/pluginManager/plugin/{shortName}/doUninstall` | POST | プラグインのアンインストール |
| `/manage/pluginManager/updateCenter/plugin/{shortName}/downgrade` | POST | プラグインのダウングレード |

## 入出力項目

### 入力項目

| 項目名 | 項目種別 | 必須 | 説明 |
|--------|---------|------|------|
| filter-box | テキストボックス | いいえ | プラグイン検索/フィルタリング用 |

### 出力項目（テーブル列）

| 項目名 | 説明 |
|--------|------|
| Name | プラグイン名（バージョン付き、外部リンク） |
| Health | 健全性スコア（健全性スコアが利用可能な場合のみ） |
| Enabled | 有効/無効トグルスイッチ |
| ダウングレードボタン | バックアップバージョンがある場合のみ（管理者のみ） |
| アンインストールボタン | 管理者のみ |

## 表示項目

### アプリバー

| 項目名 | 説明 |
|--------|------|
| 検索ボックス | プラグイン名でフィルタリング |

### プラグインテーブル

| 項目名 | 説明 |
|--------|------|
| プラグイン名 | 表示名とバージョン（リンク付き） |
| 説明 | プラグインの概要説明 |
| 依存関係 | 依存しているプラグイン一覧 |
| 健全性スコア | プラグインの健全性を示すスコア（0-100） |
| 有効スイッチ | 有効/無効を切り替えるトグル |
| イシュー報告リンク | イシュートラッカーへのリンク |
| セキュリティ警告 | アクティブなセキュリティ警告 |
| 非推奨警告 | プラグインが非推奨の場合 |
| 引き継ぎ募集 | メンテナ募集中のプラグイン |

### 失敗したプラグイン

| 項目名 | 説明 |
|--------|------|
| プラグイン名 | ロードに失敗したプラグインの名前 |
| エラーメッセージ | 失敗の原因 |

## イベント仕様

### 1-検索/フィルタリング

検索ボックスにテキストを入力すると、プラグイン一覧がリアルタイムでフィルタリングされます。

### 2-有効/無効トグル切り替え

トグルスイッチを切り替えると、プラグインの有効/無効状態が変更されます。

**処理フロー**:
1. ユーザーがトグルスイッチをクリック
2. JavaScriptがPOSTリクエストを送信（`plugin/{shortName}`）
3. サーバーでプラグインの状態を変更
4. 再起動が必要なメッセージを表示

### 3-アンインストールボタンクリック

アンインストールボタンをクリックすると、確認後にプラグインがアンインストール予約されます。

**処理フロー**:
1. ユーザーがアンインストールボタンをクリック
2. 確認ダイアログが表示される
3. 確認後、POSTリクエストが送信（`plugin/{shortName}/doUninstall`）
4. プラグインに「Uninstallation pending」と表示
5. 再起動後にプラグインが削除される

### 4-ダウングレードボタンクリック

ダウングレードボタンをクリックすると、プラグインが以前のバージョンに戻されます。

**処理フロー**:
1. ユーザーがダウングレードボタンをクリック
2. POSTリクエストが送信（`updateCenter/plugin/{shortName}/downgrade`）
3. バックアップバージョンが復元される

### 5-再起動ボタンクリック

変更後に表示される「Restart Once No Jobs Are Running」ボタンをクリックすると、安全な再起動が実行されます。

## データベース更新仕様

本画面では、プラグインの状態変更がファイルシステム上で行われます。

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 画面表示 | - | SELECT | PluginManager.pluginsからプラグイン一覧取得 |
| 有効/無効切替 | - | UPDATE | プラグインの.disabled/.enabledファイル操作 |
| アンインストール | - | DELETE | プラグインの.jpiファイル削除予約 |
| ダウングレード | - | UPDATE | バックアップ.jpiファイルの復元 |

## メッセージ仕様

| メッセージID | メッセージ種別 | メッセージ内容 | 表示条件 |
|-------------|---------------|---------------|---------|
| Installed plugins | ラベル | 画面タイトル | 常時 |
| Warning | 警告 | 警告ラベル | 再起動が必要な場合 |
| requires.restart | 警告 | 再起動が必要 | 再起動が必要な場合 |
| No plugins installed | 情報 | プラグインなし | プラグインが0件の場合 |
| securityWarning | 警告 | セキュリティ警告 | セキュリティ問題がある場合 |
| deprecationWarning | 警告 | 非推奨警告 | 非推奨プラグインの場合 |
| adoptThisPlugin | 警告 | 引き継ぎ募集 | メンテナ募集中の場合 |
| Uninstallation pending | 情報 | アンインストール予約済み | アンインストール予約時 |
| uninstall-title | 確認 | アンインストール確認メッセージ | アンインストール時 |

## 例外処理

| 例外条件 | 表示内容 | 処理 |
|---------|---------|------|
| 権限不足 | アクセス拒否画面 | SYSTEM_READ権限がない場合 |
| プラグイン無効化不可 | ツールチップでメッセージ | 依存関係により無効化できない場合 |
| プラグインアンインストール不可 | ツールチップでメッセージ | 依存関係によりアンインストールできない場合 |
| プラグインロード失敗 | エラーメッセージ表示 | failedPluginsセクションに表示 |

## 備考

- プラグインの有効/無効切り替えやアンインストールは即座には反映されず、Jenkins再起動後に適用されます
- 依存関係のあるプラグインは無効化やアンインストールが制限されます（`hasMandatoryDependents`、`hasImpliedDependents`）
- 健全性スコア（Health Score）はUpdateCenterから取得され、プラグインの品質指標を示します
- `_table.js`と`_installed.js`がクライアントサイドの動作を制御します
- テーブルはソート可能（`sortable`クラス）です

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

プラグイン情報のデータ構造を理解します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | PluginWrapper.java | `core/src/main/java/hudson/PluginWrapper.java` | プラグインのラッパークラス。enabled、version、dependencies、activeWarningsなど |
| 1-2 | PluginManager.java | `core/src/main/java/hudson/PluginManager.java` | `plugins`、`failedPlugins`、`pluginsSortedByTitle`の管理 |

**読解のコツ**: `PluginWrapper`はプラグインの全情報を保持し、`hasMandatoryDependents()`や`hasImpliedDependents()`で依存関係を確認できます。

#### Step 2: エントリーポイントを理解する

処理の起点となるファイルを確認します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | installed.jelly | `core/src/main/resources/hudson/PluginManager/installed.jelly` | メイン画面テンプレート。プラグインテーブルの構築、権限チェック |

**主要処理フロー**:
1. **30行目**: `l:layout`でレイアウト設定（権限: SYSTEM_READ）
2. **31行目**: `readOnlyMode`の判定（ADMINISTER権限がない場合）
3. **40-49行目**: アプリバーと検索ボックス
4. **56-58行目**: 再起動が必要な場合の警告表示
5. **77-299行目**: プラグインテーブルの描画
6. **266-296行目**: 失敗したプラグインの表示
7. **303-309行目**: 再起動ボタン

#### Step 3: クライアントサイド動作を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | _table.js | `core/src/main/resources/hudson/PluginManager/_table/` | テーブル操作のJavaScript |
| 3-2 | _installed.js | `core/src/main/resources/hudson/PluginManager/_installed/` | インストール済み画面固有のJavaScript |

### プログラム呼び出し階層図

```
[HTTPリクエスト: /manage/pluginManager/installed]
    │
    ├─ PluginManager
    │      └─ installed.jelly
    │
    └─ installed.jelly
           │
           ├─ l:layout (権限: SYSTEM_READ)
           │      └─ readOnlyMode判定
           │
           ├─ sidepanel.jelly（インクルード）
           │
           ├─ アプリバー
           │      └─ 検索ボックス
           │
           ├─ 再起動警告（条件付き）
           │      └─ updateCenter.isRestartRequiredForCompletion()
           │
           ├─ プラグインテーブル
           │      │
           │      ├─ pluginsSortedByTitle（ループ）
           │      │      │
           │      │      ├─ プラグイン名・バージョン
           │      │      │      └─ p.displayName, p.version
           │      │      │
           │      │      ├─ 依存関係表示
           │      │      │      └─ p.mandatoryDependencies
           │      │      │
           │      │      ├─ 健全性スコア
           │      │      │      └─ p.healthScore
           │      │      │
           │      │      ├─ 有効/無効トグル
           │      │      │      └─ plugin-manager-toggle-switch
           │      │      │
           │      │      ├─ ダウングレードボタン（条件付き）
           │      │      │      └─ p.downgradable
           │      │      │
           │      │      └─ アンインストールボタン
           │      │
           │      └─ failedPlugins（ループ）
           │             └─ エラーメッセージ表示
           │
           └─ 再起動ボタン（条件付き）
```

### データフロー図

```
[入力]                        [処理]                              [出力]

GETリクエスト ─────────────▶ PluginManager ──────────────────▶ installed.jelly
                                   │
                                   ▼
                    PluginManager.pluginsSortedByTitle
                                   │
                                   ▼
                    各プラグインの情報取得
                    ├─ displayName, version
                    ├─ enabled, active
                    ├─ healthScore
                    ├─ activeWarnings
                    ├─ mandatoryDependents
                    └─ impliedDependents

トグル切替 ───────────────────▶ POSTリクエスト ────────────────▶ 状態更新
（JavaScript）                plugin/{shortName}                  │
                                                                  ▼
                                                         再起動必要フラグ

アンインストール ─────────────▶ POSTリクエスト ────────────────▶ 削除予約
（JavaScript）              plugin/{shortName}/doUninstall        │
                                                                  ▼
                                                         isDeleted()=true
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| installed.jelly | `core/src/main/resources/hudson/PluginManager/installed.jelly` | テンプレート | メイン画面のJellyテンプレート |
| PluginManager.java | `core/src/main/java/hudson/PluginManager.java` | ソース | プラグイン管理クラス |
| PluginWrapper.java | `core/src/main/java/hudson/PluginWrapper.java` | ソース | プラグインラッパークラス |
| sidepanel.jelly | `core/src/main/resources/hudson/PluginManager/sidepanel.jelly` | テンプレート | サイドパネル |
| _table.js | `core/src/main/resources/hudson/PluginManager/_table/` | JavaScript | テーブル操作スクリプト |
| _installed.js | `core/src/main/resources/hudson/PluginManager/_installed/` | JavaScript | 画面固有スクリプト |
| installed.properties | `core/src/main/resources/hudson/PluginManager/installed.properties` | 設定 | 国際化メッセージ定義 |
