# 画面設計書 39-利用可能なプラグイン

## 概要

本ドキュメントは、Jenkinsの「利用可能なプラグイン」画面の設計について記述したものです。この画面はインストール可能なプラグインの検索・一覧表示とインストール機能を提供します。

### 本画面の処理概要

この画面では、Jenkins管理者がUpdate Centerから利用可能なプラグインを検索し、インストールできます。

**業務上の目的・背景**：Jenkinsの機能拡張にはプラグインのインストールが必要です。本画面により、管理者は何千ものプラグインから必要なものを検索し、依存関係を自動解決しながらインストールできます。健全性スコアやリリース日などの情報を参考に、適切なプラグインを選択できます。

**画面へのアクセス方法**：プラグイン管理サイドパネルから「Available plugins」をクリック、または直接 `/manage/pluginManager/available` URLにアクセスします。SYSTEM_READ権限を持つユーザーがアクセス可能です。

**主要な操作・処理内容**：
1. 利用可能なプラグイン一覧の表示（名前、リリース日、健全性スコア）
2. プラグインの検索/フィルタリング
3. プラグインの選択とインストール（即時または再起動後）
4. 更新サイトの確認（Check now）

**画面遷移**：
- 遷移元：プラグイン管理トップ、Jenkins管理画面
- 遷移先：更新センター（インストール進捗）、プラグイン詳細ページ（外部）

**権限による表示制御**：
- SYSTEM_READ権限：一覧表示のみ
- ADMINISTER権限：インストール操作が可能

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 2 | プラグインマネージャー | 主機能 | インストール可能プラグインの検索・一覧表示 |
| 3 | アップデートセンター | 補助機能 | プラグイン情報の取得 |

## 画面種別

一覧画面（検索・選択・インストール機能付き）

## URL/ルーティング

| URL | HTTPメソッド | 説明 |
|-----|-------------|------|
| `/manage/pluginManager/available` | GET | 利用可能なプラグイン一覧の表示 |
| `/manage/pluginManager/install` | POST | プラグインのインストール実行 |

## 入出力項目

### 入力項目

| 項目名 | 項目種別 | 必須 | 説明 |
|--------|---------|------|------|
| filter-box | テキストボックス | いいえ | プラグイン検索/フィルタリング用 |
| plugin.{name}.{sourceId} | チェックボックス | いいえ | インストールするプラグインの選択 |

### 出力項目（テーブル列）

| 項目名 | 説明 |
|--------|------|
| Install | インストール選択チェックボックス（管理者のみ） |
| Name | プラグイン名（バージョン付き、外部リンク） |
| Released | リリース日（相対時間表示） |
| Health | 健全性スコア（健全性スコアが利用可能な場合のみ） |

## 表示項目

### アプリバー

| 項目名 | 説明 |
|--------|------|
| 検索ボックス | プラグイン名でフィルタリング |
| Installボタン | 選択したプラグインを即時インストール（管理者のみ） |
| Install after restartボタン | 選択したプラグインを再起動後にインストール（管理者のみ） |
| Check nowボタン | 更新サイトを確認 |

### プラグインテーブル

| 項目名 | 説明 |
|--------|------|
| チェックボックス | インストール選択用（管理者のみ） |
| プラグイン名 | 表示名とバージョン（外部リンク付き） |
| リリース日 | 相対時間表示（例："3 days ago"） |
| 健全性スコア | プラグインの健全性を示すスコア（0-100） |

## イベント仕様

### 1-検索/フィルタリング

検索ボックスにテキストを入力すると、プラグイン一覧がリアルタイムでフィルタリングされます。`plugin-manager-ui.js`によりクライアントサイドで処理されます。

### 2-チェックボックス選択

プラグインのチェックボックスを選択/解除すると、インストール対象として追加/削除されます。

### 3-Installボタンクリック

「Install」ボタンをクリックすると、選択したプラグインが即時インストールされます。

**処理フロー**:
1. ユーザーが「Install」ボタンをクリック
2. フォームがPOST送信（`action="install"`、`name="dynamicLoad"`）
3. サーバーでプラグインのダウンロード・インストールを開始
4. 更新センターにリダイレクトされ、進捗が表示される

### 4-Install after restartボタンクリック

「Install after restart」ボタンをクリックすると、選択したプラグインが再起動後にインストールされます。

**処理フロー**:
1. ユーザーが「Install after restart」ボタンをクリック
2. フォームがPOST送信（`action="install"`、dynamicLoadパラメータなし）
3. プラグインがダウンロードされ、再起動後にインストールされる

### 5-Check nowボタンクリック

更新サイトの情報を最新化します（`check.jelly`で実装）。

## データベース更新仕様

プラグインのインストールはファイルシステム上で行われます。

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 画面表示 | - | SELECT | UpdateCenterから利用可能プラグイン一覧取得 |
| Install | - | INSERT | プラグインの.jpiファイルダウンロード・配置 |

## メッセージ仕様

| メッセージID | メッセージ種別 | メッセージ内容 | 表示条件 |
|-------------|---------------|---------------|---------|
| Available plugins | ラベル | 画面タイトル | 常時 |
| Plugins | ラベル | サブタイトル | 常時 |
| Search available plugins | プレースホルダ | 検索ボックスのプレースホルダ | 常時 |
| Install | ボタン | インストールボタン | 管理者のみ |
| Install after restart | ボタン | 再起動後インストールボタン | 管理者のみ |
| healthTooltip | ツールチップ | 健全性スコアの説明 | 健全性スコア列ヘッダー |

## 例外処理

| 例外条件 | 表示内容 | 処理 |
|---------|---------|------|
| 権限不足 | アクセス拒否画面 | SYSTEM_READ権限がない場合 |
| 更新サイト接続失敗 | エラーメッセージ | ネットワークエラー時 |

## 備考

- プラグイン一覧はJavaScriptで動的にロードされます（`plugin-manager-ui.js`）
- テーブル本体（tbody）は空で、JavaScriptがUpdateCenter APIからデータを取得して描画します
- 「Install」と「Install after restart」の違いは、`dynamicLoad`パラメータの有無です
- スプリットボタンUIで「Install」がメイン、「Install after restart」がドロップダウンメニューになっています
- 健全性スコアはプラグインの品質指標で、ツールチップで詳細説明が表示されます

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

利用可能なプラグインのデータ構造を理解します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | UpdateSite.java | `core/src/main/java/hudson/model/UpdateSite.java` | `Plugin`内部クラス。name、version、wiki、excerpt、releaseTimestamp、healthScoreなど |
| 1-2 | UpdateCenter.java | `core/src/main/java/hudson/model/UpdateCenter.java` | `getAvailables()`メソッド、プラグインリストの取得 |

**読解のコツ**: `UpdateSite.Plugin`はUpdate Centerから取得した未インストールプラグインの情報を保持します。

#### Step 2: エントリーポイントを理解する

処理の起点となるファイルを確認します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | available.jelly | `core/src/main/resources/hudson/PluginManager/available.jelly` | メイン画面テンプレート。検索、インストールボタン、テーブル構造 |

**主要処理フロー**:
1. **30行目**: `l:layout`でレイアウト設定（権限: SYSTEM_READ）
2. **35-69行目**: アプリバー（検索、インストールボタン、Check now）
3. **71行目**: `plugin-manager-ui.js`の読み込み
4. **73-97行目**: フォームとテーブル構造（tbodyは空、JSで描画）

#### Step 3: クライアントサイド動作を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | plugin-manager-ui.js | `war/src/main/js/` | 利用可能プラグインのフェッチとテーブル描画 |
| 3-2 | check.jelly | `core/src/main/resources/hudson/PluginManager/check.jelly` | Check nowボタンの実装 |

### プログラム呼び出し階層図

```
[HTTPリクエスト: /manage/pluginManager/available]
    │
    ├─ PluginManager
    │      └─ available.jelly
    │
    └─ available.jelly
           │
           ├─ l:layout (権限: SYSTEM_READ)
           │
           ├─ sidepanel.jelly（インクルード）
           │
           ├─ アプリバー
           │      │
           │      ├─ 検索ボックス
           │      │
           │      ├─ Installボタン（スプリットボタン）
           │      │      ├─ Install（dynamicLoad付き）
           │      │      └─ Install after restart
           │      │
           │      └─ check.jelly（Check nowボタン）
           │
           ├─ plugin-manager-ui.js
           │      │
           │      └─ UpdateCenter API呼び出し
           │             │
           │             └─ 利用可能プラグイン取得
           │                    └─ テーブル描画
           │
           └─ フォーム
                  │
                  └─ テーブル（tbody空、JS描画）
                         │
                         ├─ Install列（管理者のみ）
                         ├─ Name列
                         ├─ Released列
                         └─ Health列（条件付き）
```

### データフロー図

```
[入力]                        [処理]                              [出力]

GETリクエスト ─────────────▶ available.jelly ─────────────────▶ HTML骨格

                    plugin-manager-ui.js
                              │
                              ▼
                    UpdateCenter API呼び出し
                              │
                              ▼
                    利用可能プラグインリスト
                              │
                              ▼
                    [テーブル動的描画]

チェックボックス選択 ───────▶ フォーム状態更新

Installクリック ──────────▶ POSTリクエスト ────────────────▶ UpdateCenter
                         /manage/pluginManager/install         │
                                   │                           ▼
                                   │                    インストールジョブ作成
                                   │                           │
                                   └───────────────────▶ 更新センターへリダイレクト
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| available.jelly | `core/src/main/resources/hudson/PluginManager/available.jelly` | テンプレート | メイン画面のJellyテンプレート |
| PluginManager.java | `core/src/main/java/hudson/PluginManager.java` | ソース | プラグイン管理クラス、doInstallメソッド |
| UpdateCenter.java | `core/src/main/java/hudson/model/UpdateCenter.java` | ソース | 更新センタークラス |
| UpdateSite.java | `core/src/main/java/hudson/model/UpdateSite.java` | ソース | 更新サイト、Plugin内部クラス |
| sidepanel.jelly | `core/src/main/resources/hudson/PluginManager/sidepanel.jelly` | テンプレート | サイドパネル |
| check.jelly | `core/src/main/resources/hudson/PluginManager/check.jelly` | テンプレート | Check nowボタン |
| plugin-manager-ui.js | `war/src/main/js/` | JavaScript | 動的プラグインリスト描画 |
| available.properties | `core/src/main/resources/hudson/PluginManager/available.properties` | 設定 | 国際化メッセージ定義 |
