# 画面設計書 4-ログイン

## 概要

本ドキュメントは、Jenkinsのログイン画面の設計仕様を定義するものです。

### 本画面の処理概要

ログイン画面は、Jenkins環境へのユーザー認証を行う画面です。ユーザー名とパスワードを入力して認証を行い、認証成功後に元々アクセスしようとしていたページまたはダッシュボードにリダイレクトされます。

**業務上の目的・背景**：Jenkinsはビルド・デプロイパイプラインを管理する重要なシステムであり、不正アクセスを防止するために認証機能が必要です。この画面は、設定されたSecurityRealm（認証方式）に基づいてユーザーを認証し、適切な権限でシステムにアクセスさせるためのインターフェースを提供します。

**画面へのアクセス方法**：セキュリティが有効な状態で未認証のまま保護されたリソースにアクセスしようとした場合、自動的にこの画面にリダイレクトされます。また、URLで直接 `/login` にアクセスすることもできます。

**主要な操作・処理内容**：
1. ユーザー名（Username）の入力
2. パスワード（Password）の入力
3. 「Keep me signed in」チェックによるセッション維持（Remember Me機能）
4. サインインボタン押下による認証実行
5. セルフサインアップが有効な場合の登録画面への遷移リンク

**画面遷移**：認証成功後はダッシュボードまたは元々アクセスしようとしていたページに遷移します。認証失敗時はログインエラー画面（同画面にエラー表示）に遷移します。セルフサインアップが有効な場合はユーザー登録画面へ遷移できます。

**権限による表示制御**：認証前の画面のため、権限による表示制御はありません。ただし、セットアップウィザードでセキュリティトークン認証が必要な場合は、別の認証画面が表示されます。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 28 | 認証（SecurityRealm） | 主機能 | ユーザー認証処理（ユーザー名/パスワード検証） |
| 33 | CSRF保護 | 補助機能 | クロスサイトリクエストフォージェリ対策 |

## 画面種別

認証

## URL/ルーティング

- `/login` - ログイン画面
- `/j_spring_security_check` - 認証処理エンドポイント（フォーム送信先）

## 入出力項目

| 項目名 | 入力/出力 | データ型 | 必須 | 説明 |
|--------|----------|----------|------|------|
| j_username | 入力 | String | ○ | ユーザー名 |
| j_password | 入力 | String | ○ | パスワード |
| remember_me | 入力 | Boolean | - | セッション維持フラグ |
| from | 入力（hidden） | String | - | 認証後のリダイレクト先URL |

## 表示項目

| 項目名 | データ型 | 説明 |
|--------|----------|------|
| タイトル | Text | "Sign in to Jenkins" |
| ユーザー名入力フィールド | TextInput | ユーザー名入力欄 |
| パスワード入力フィールド | PasswordInput | パスワード入力欄（マスク表示） |
| Keep me signed in | Checkbox | Remember Me機能のチェックボックス |
| Sign inボタン | Button | 認証実行ボタン |
| or registerリンク | Link | ユーザー登録画面へのリンク（セルフサインアップ有効時のみ） |
| エラーメッセージ | Message | 認証失敗時のエラーメッセージ |

## イベント仕様

### 1-Sign inボタン押下

フォームデータをSecurityRealmの認証ゲートウェイURL（`authenticationGatewayUrl`）にPOSTします。認証処理はSpring Securityフレームワークを通じて行われます。

### 2-or registerリンク押下

セルフサインアップが有効な場合、ユーザー登録画面（`/signup`）に遷移します。

### 3-Federated Login

フェデレーテッドログインサービス（OAuth等）が設定されている場合、各サービスのログインフラグメントが表示されます。

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 認証成功 | セッションストア | INSERT | セッション情報の作成 |
| Remember Me有効 | Remember Meトークン | INSERT | 永続化トークンの保存 |

### テーブル別更新項目詳細

本画面での直接的なファイルシステム更新はありません。認証情報はSecurityRealmの実装により管理されます。

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|-------------|------|---------------|---------|
| Invalid username or password | エラー | "Invalid username or password" | 認証失敗時 |
| signIn | ラベル | "Sign in" | ボタンラベル |
| or register | リンク | "or register" | セルフサインアップ有効時 |

## 例外処理

| 例外状態 | 処理内容 |
|---------|---------|
| 認証失敗 | エラーメッセージを表示し、入力フィールドをエラー状態にする |
| セッション無効 | 新しいセッションを生成 |
| セットアップウィザード中 | セキュリティトークン認証画面を表示 |

## 備考

- キャッシュ制御ヘッダーが設定されており、ブラウザキャッシュが無効化されています（`Cache-Control: no-cache,no-store,must-revalidate`）
- CSRF対策として、フォームにCrumbトークンが含まれています
- Remember Me機能はSpring Securityで無効化されていない場合のみ表示されます
- ロボット検索エンジンのインデックス防止のためNOFOLLOWメタタグが設定されています

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

認証に関わるデータ構造と設定を理解します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | SecurityRealm.java | `core/src/main/java/hudson/security/SecurityRealm.java` | 認証の基底クラス、getAuthenticationGatewayUrl() |
| 1-2 | HudsonPrivateSecurityRealm.java | `core/src/main/java/hudson/security/HudsonPrivateSecurityRealm.java` | Jenkins独自の認証実装 |

**読解のコツ**: SecurityRealmはJenkinsの認証方式を抽象化したクラスです。LDAP、Active Directory、Jenkins独自認証など、実装によって認証方法が異なります。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | login.jelly | `core/src/main/resources/jenkins/model/Jenkins/login.jelly` | 画面のメインテンプレート |

**主要処理フロー**:
1. **29-36行目**: キャッシュ制御ヘッダーの設定
2. **42行目**: セッションの取得/生成
3. **47行目**: リダイレクト先（from）の取得
4. **66-67行目**: セットアップウィザード中かどうかの判定
5. **77-130行目**: ログインフォームの生成
6. **79-83行目**: エラー時のメッセージ表示
7. **108-117行目**: Remember Me機能の表示条件
8. **125-129行目**: セルフサインアップリンクの表示条件
9. **132-136行目**: フェデレーテッドログインの表示

#### Step 3: 認証処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | DefaultSecurityRealmFilter.java | `core/src/main/java/jenkins/security/DefaultSecurityRealmFilter.java` | 認証フィルター |

**主要処理フロー**:
- Spring Securityとの連携
- 認証成功/失敗時のハンドリング

#### Step 4: Remember Me機能を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | RememberMeServicesImpl.java | `core/src/main/java/jenkins/security/RememberMeServicesImpl.java` | Remember Me実装 |

### プログラム呼び出し階層図

```
login.jelly (エントリーポイント)
    │
    ├─ simple-head.jelly (スタイル)
    │
    ├─ simple-branding.jelly (ブランディング)
    │
    ├─ simple-header.jelly (ヘッダー)
    │
    └─ form (認証フォーム)
           │
           └─ POST to authenticationGatewayUrl
                  │
                  ├─ Spring Security Filter Chain
                  │      └─ UsernamePasswordAuthenticationFilter
                  │
                  └─ SecurityRealm.authenticate()
                         ├─ 成功 → リダイレクト（from URL）
                         └─ 失敗 → loginError.jelly
```

### データフロー図

```
[入力]               [処理]                    [出力]

j_username ─────▶ Spring Security ───▶ Authentication成功
j_password              │                      │
                        │                      ▼
                        ▼              SecurityContext設定
              SecurityRealm.authenticate()     │
                        │                      ▼
                        ▼              リダイレクト（from URL or /）
                   認証失敗 ───────▶ login.jelly（error=true）
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| login.jelly | `core/src/main/resources/jenkins/model/Jenkins/login.jelly` | テンプレート | メイン画面テンプレート |
| loginError.jelly | `core/src/main/resources/jenkins/model/Jenkins/loginError.jelly` | テンプレート | エラー時テンプレート |
| SecurityRealm.java | `core/src/main/java/hudson/security/SecurityRealm.java` | ソース | 認証基底クラス |
| HudsonPrivateSecurityRealm.java | `core/src/main/java/hudson/security/HudsonPrivateSecurityRealm.java` | ソース | Jenkins独自認証 |
| simple-head.jelly | 各PageDecoratorにより提供 | テンプレート | ページヘッド |
| simple-branding.jelly | 各PageDecoratorにより提供 | テンプレート | ブランディング |
| authenticate-security-token.jelly | `core/src/main/resources/jenkins/install/SetupWizard/` | テンプレート | セットアップ時の認証 |
