# 画面設計書 40-更新可能なプラグイン

## 概要

本ドキュメントは、Jenkinsの「更新可能なプラグイン」画面の設計について記述したものです。この画面は更新可能なプラグインの一覧表示と更新機能を提供します。

### 本画面の処理概要

この画面では、Jenkins管理者がインストール済みプラグインのうち、新しいバージョンが利用可能なものを確認し、更新することができます。

**業務上の目的・背景**：Jenkinsの安定運用とセキュリティ維持のため、プラグインを最新の状態に保つことが重要です。本画面により、管理者は互換性警告やセキュリティ警告を確認しながら、安全にプラグインを更新できます。特にセキュリティ脆弱性を修正する更新は優先的に適用すべきです。

**画面へのアクセス方法**：プラグイン管理サイドパネルから「Updates」をクリック、または直接 `/manage/pluginManager/` URLにアクセスします。SYSTEM_READ権限を持つユーザーがアクセス可能です。

**主要な操作・処理内容**：
1. 更新可能なプラグイン一覧の表示（名前、リリース日、インストール済みバージョン、健全性スコア）
2. プラグインの検索/フィルタリング
3. 互換性のある更新のみを選択
4. プラグインの選択と更新

**画面遷移**：
- 遷移元：プラグイン管理トップ、Jenkins管理画面
- 遷移先：更新センター（インストール進捗）、プラグイン詳細ページ（外部）

**権限による表示制御**：
- SYSTEM_READ権限：一覧表示のみ
- ADMINISTER権限：更新操作が可能

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 2 | プラグインマネージャー | 主機能 | 更新可能プラグインの検索・一覧表示 |
| 3 | アップデートセンター | 補助機能 | プラグイン更新情報の取得・更新実行 |

## 画面種別

一覧画面（検索・選択・更新機能付き）

## URL/ルーティング

| URL | HTTPメソッド | 説明 |
|-----|-------------|------|
| `/manage/pluginManager/` | GET | 更新可能なプラグイン一覧の表示 |
| `/manage/pluginManager/install` | POST | プラグインの更新実行 |

## 入出力項目

### 入力項目

| 項目名 | 項目種別 | 必須 | 説明 |
|--------|---------|------|------|
| filter-box | テキストボックス | いいえ | プラグイン検索/フィルタリング用 |
| plugin.{name}.{sourceId} | チェックボックス | いいえ | 更新するプラグインの選択 |

### 出力項目（テーブル列）

| 項目名 | 説明 |
|--------|------|
| チェックボックス | 更新選択（管理者のみ） |
| Name | プラグイン名（新バージョン、外部リンク） |
| Released | 新バージョンのリリース日（相対時間表示） |
| Installed | インストール済みバージョン（非アクティブは括弧付き） |
| Health | 健全性スコア（健全性スコアが利用可能な場合のみ） |

## 表示項目

### アプリバー

| 項目名 | 説明 |
|--------|------|
| 検索ボックス | プラグイン名でフィルタリング |
| Updateボタン | 選択したプラグインを更新（管理者のみ、選択時のみ有効） |
| Check nowボタン | 更新サイトを確認 |

### 行選択コントローラー（ヘッダー）

| 項目名 | 説明 |
|--------|------|
| 全選択チェックボックス | すべてのプラグインを選択/解除 |
| Compatibleボタン | 互換性のある更新のみを選択（非互換更新がある場合のみ表示） |

### プラグインテーブル

| 項目名 | 説明 |
|--------|------|
| チェックボックス | 更新選択用（管理者のみ）、更新済みは無効化 |
| プラグイン名 | 表示名と新バージョン（外部リンク付き） |
| カテゴリバッジ | プラグインのカテゴリ（クリックでフィルタリング） |
| 概要 | プラグインの説明文 |
| 警告セクション | 互換性警告、セキュリティ警告、非推奨警告など |
| リリース日 | 相対時間表示（例："3 days ago"） |
| インストール済みバージョン | 現在のバージョン（非アクティブは括弧付き） |
| 健全性スコア | プラグインの健全性を示すスコア（0-100） |

### 警告メッセージ

| 警告種別 | 表示条件 | スタイル |
|---------|---------|---------|
| 互換性警告（compatWarning） | `!p.isCompatibleWithInstalledVersion()` | jenkins-alert-danger |
| 親プラグイン互換性警告 | `p.hasIncompatibleParentPlugins()` | jenkins-alert-danger |
| コア互換性警告（coreWarning） | `p.isForNewerHudson()` | jenkins-alert-danger |
| セキュリティ脆弱性修正 | `p.fixesSecurityVulnerabilities()` | jenkins-alert-warning |
| 依存関係互換性警告 | `!p.isNeededDependenciesCompatibleWithInstalledVersion(cache)` | jenkins-alert-danger |
| 依存関係コア警告 | `p.isNeededDependenciesForNewerJenkins(cache)` | jenkins-alert-danger |
| セキュリティ警告（warnings） | `p.hasWarnings()` | jenkins-alert-danger |
| 非推奨警告（deprecationWarning） | `p.isDeprecated()` | jenkins-alert-warning |
| 引き継ぎ募集（adoptThisPlugin） | `it.hasAdoptThisPluginLabel(p)` | jenkins-alert-warning |

## イベント仕様

### 1-検索/フィルタリング

検索ボックスにテキストを入力すると、プラグイン一覧がリアルタイムでフィルタリングされます。`_table`アジャンクトによりクライアントサイドで処理されます。

### 2-チェックボックス選択

プラグインのチェックボックスを選択/解除すると、更新対象として追加/削除されます。Updateボタンは選択がある場合のみ有効になります。

### 3-Compatibleボタンクリック

「Compatible」ボタンをクリックすると、互換性のある更新のみが選択されます。`data-compat-warning`属性がないプラグインが対象となります。

### 4-Updateボタンクリック

「Update」ボタンをクリックすると、選択したプラグインが更新されます。

**処理フロー**:
1. ユーザーが「Update」ボタンをクリック
2. フォームがPOST送信（`action="install"`）
3. サーバーでプラグインのダウンロード・更新を開始
4. 更新センターにリダイレクトされ、進捗が表示される

### 5-Check nowボタンクリック

更新サイトの情報を最新化します（`check.jelly`で実装）。

### 6-カテゴリバッジクリック

カテゴリバッジをクリックすると、そのカテゴリでフィルタリングされます（`?filter={category}`）。

## データベース更新仕様

プラグインの更新はファイルシステム上で行われます。

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 画面表示 | - | SELECT | UpdateCenterから更新可能プラグイン一覧取得 |
| Update | - | UPDATE | プラグインの.jpiファイルダウンロード・上書き |

## メッセージ仕様

| メッセージID | メッセージ種別 | メッセージ内容 | 表示条件 |
|-------------|---------------|---------------|---------|
| Updates | ラベル | 画面タイトル | 常時 |
| Plugins | ラベル | サブタイトル | 常時 |
| Search plugin updates | プレースホルダ | 検索ボックスのプレースホルダ | 常時 |
| Update | ボタン | 更新ボタン | 管理者かつ更新あり |
| Compatible | ボタン | 互換性のある更新を選択 | 非互換更新がある場合 |
| CompatibleTooltip | ツールチップ | Compatibleボタンの説明 | Compatibleボタン |
| No updates available | 通知 | 更新がない場合のメッセージ | 更新がない場合 |
| compatWarning | 警告 | 互換性警告メッセージ | 非互換更新 |
| coreWarning | 警告 | コアバージョン警告 | 新しいコアが必要 |
| securityWarning | 警告 | セキュリティ警告 | 脆弱性がある場合 |
| deprecationWarning | 警告 | 非推奨警告 | 非推奨プラグイン |
| adoptThisPlugin | 警告 | 引き継ぎ募集メッセージ | 引き継ぎ募集中 |
| healthTooltip | ツールチップ | 健全性スコアの説明 | 健全性スコア列ヘッダー |
| Inactive | タイトル | 非アクティブプラグインの説明 | プラグインが非アクティブ |
| No health score available | ツールチップ | 健全性スコアなしの説明 | 健全性スコアがない場合 |

## 例外処理

| 例外条件 | 表示内容 | 処理 |
|---------|---------|------|
| 権限不足 | アクセス拒否画面 | SYSTEM_READ権限がない場合 |
| 更新サイト接続失敗 | エラーメッセージ | ネットワークエラー時 |

## 備考

- 更新済みのプラグインは`already-upgraded`クラスが付与され、チェックボックスがチェック済み・無効化されます
- `data-compat-warning`属性は互換性のない更新に付与され、Compatibleボタンでの選択から除外されます
- 「Update」ボタンは初期状態で`disabled="true"`、チェックボックス選択で有効化されます
- 非アクティブなプラグインのバージョンは括弧付きで表示されます（例："(1.0.0)"）
- セキュリティ脆弱性を修正する更新には黄色い警告バナーが表示されます
- テーブルはName列でデフォルト降順ソートされます（`initialSortDir="down"`）
- `row-selection-controller.js`が行選択のロジックを制御します

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

更新可能なプラグインのデータ構造を理解します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | UpdateSite.java | `core/src/main/java/hudson/model/UpdateSite.java` | `Plugin`内部クラス。isCompatibleWithInstalledVersion()、fixesSecurityVulnerabilities()、hasWarnings()、isDeprecated()など |
| 1-2 | UpdateCenter.java | `core/src/main/java/hudson/model/UpdateCenter.java` | `getUpdates()`メソッド（28行目）、`hasIncompatibleUpdates(cache)`メソッド |

**読解のコツ**: `UpdateSite.Plugin`は更新情報を保持し、互換性チェックやセキュリティ情報へのアクセスを提供します。

#### Step 2: エントリーポイントを理解する

処理の起点となるファイルを確認します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | updates.jelly | `core/src/main/resources/hudson/PluginManager/updates.jelly` | メイン画面テンプレート。検索、更新ボタン、テーブル構造、警告表示 |

**主要処理フロー**:
1. **27行目**: `l:layout`でレイアウト設定（権限: SYSTEM_READ）
2. **28行目**: `app.updateCenter.updates`で更新可能プラグイン一覧取得
3. **38-58行目**: アプリバー（検索、Updateボタン、Check now）
4. **60行目**: `_table`アジャンクトの読み込み
5. **62-259行目**: フォームとテーブル構造
6. **67-252行目**: プラグインテーブル（Name降順ソート）
7. **70-83行目**: 行選択コントローラー（Compatible選択）
8. **97-251行目**: プラグインループ（警告表示含む）

#### Step 3: 行選択コントローラーを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | row-selection-controller.js | `war/src/main/js/components/row-selection-controller.js` | 行選択ロジック、Compatible選択の実装 |
| 3-2 | _table | `core/src/main/resources/hudson/PluginManager/_table/` | テーブルフィルタリング、ソート機能 |

### プログラム呼び出し階層図

```
[HTTPリクエスト: /manage/pluginManager/]
    │
    ├─ PluginManager
    │      └─ updates.jelly
    │
    └─ updates.jelly
           │
           ├─ l:layout (権限: SYSTEM_READ)
           │
           ├─ sidepanel.jelly（インクルード）
           │
           ├─ row-selection-controller.js
           │
           ├─ アプリバー
           │      │
           │      ├─ 検索ボックス
           │      │
           │      ├─ Updateボタン（初期disabled）
           │      │
           │      └─ check.jelly（Check nowボタン）
           │
           ├─ _tableアジャンクト
           │      └─ フィルタリング・ソート機能
           │
           └─ フォーム（action="install"）
                  │
                  ├─ UpdateCenter.getUpdates()
                  │      └─ 更新可能プラグインリスト
                  │
                  └─ テーブル
                         │
                         ├─ ヘッダー
                         │      │
                         │      ├─ rowSelectionController
                         │      │      └─ Compatibleボタン（条件付き）
                         │      │
                         │      ├─ Name列（降順ソート）
                         │      ├─ Released列
                         │      ├─ Installed列
                         │      └─ Health列（条件付き）
                         │
                         └─ プラグイン行ループ
                                │
                                ├─ チェックボックス
                                │      └─ data-compat-warning属性
                                │
                                ├─ プラグイン詳細
                                │      │
                                │      ├─ 名前・バージョン（外部リンク）
                                │      ├─ カテゴリバッジ
                                │      ├─ 概要
                                │      └─ 警告セクション
                                │             │
                                │             ├─ compatWarning
                                │             ├─ parentCompatWarning
                                │             ├─ coreWarning
                                │             ├─ セキュリティ脆弱性修正
                                │             ├─ depCompatWarning
                                │             ├─ depCoreWarning
                                │             ├─ securityWarning
                                │             ├─ deprecationWarning
                                │             └─ adoptThisPlugin
                                │
                                ├─ リリース日
                                ├─ インストール済みバージョン
                                └─ 健全性スコア
```

### データフロー図

```
[入力]                        [処理]                              [出力]

GETリクエスト ─────────────▶ updates.jelly ─────────────────────▶ HTML画面

                    UpdateCenter.getUpdates()
                              │
                              ▼
                    更新可能プラグインリスト
                              │
                              ▼
                    PluginManager.createCache()
                              │
                              ▼
                    互換性チェック
                              │
                              ▼
                    [テーブル描画（警告付き）]

チェックボックス選択 ───────▶ row-selection-controller.js
                              │
                              ▼
                    Updateボタン有効化

Compatibleクリック ──────────▶ data-compat-warning判定
                              │
                              ▼
                    互換更新のみ選択

Updateクリック ──────────────▶ POSTリクエスト ────────────────▶ UpdateCenter
                         /manage/pluginManager/install         │
                                   │                           ▼
                                   │                    更新ジョブ作成
                                   │                           │
                                   └───────────────────▶ 更新センターへリダイレクト
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| updates.jelly | `core/src/main/resources/hudson/PluginManager/updates.jelly` | テンプレート | メイン画面のJellyテンプレート |
| PluginManager.java | `core/src/main/java/hudson/PluginManager.java` | ソース | プラグイン管理クラス、createCache()メソッド |
| UpdateCenter.java | `core/src/main/java/hudson/model/UpdateCenter.java` | ソース | getUpdates()、hasIncompatibleUpdates()メソッド |
| UpdateSite.java | `core/src/main/java/hudson/model/UpdateSite.java` | ソース | Plugin内部クラス、互換性・警告チェックメソッド |
| sidepanel.jelly | `core/src/main/resources/hudson/PluginManager/sidepanel.jelly` | テンプレート | サイドパネル |
| check.jelly | `core/src/main/resources/hudson/PluginManager/check.jelly` | テンプレート | Check nowボタン |
| row-selection-controller.js | `war/src/main/js/components/row-selection-controller.js` | JavaScript | 行選択コントローラー |
| _table | `core/src/main/resources/hudson/PluginManager/_table/` | アジャンクト | テーブルフィルタリング・ソート |
| updates.properties | `core/src/main/resources/hudson/PluginManager/updates.properties` | 設定 | 国際化メッセージ定義 |
