# 画面設計書 41-プラグイン詳細設定

## 概要

本ドキュメントは、Jenkinsのプラグイン詳細設定画面（Advanced Settings）の画面設計書です。プラグインの手動アップロード機能およびアップデートサイトの設定を行う画面について記述します。

### 本画面の処理概要

この画面では、プラグイン管理における高度な設定操作を行うことができます。通常のプラグインマネージャーでは利用できない、プラグインファイルの直接アップロードやアップデートサイトのURL変更などの機能を提供します。

**業務上の目的・背景**：標準のアップデートサイト以外からプラグインを取得する必要がある場合（社内プラグイン、開発中のプラグイン、特定バージョンのプラグインなど）や、プロキシ環境でのアップデートサイト接続設定を行う場合に使用します。企業環境では、セキュリティポリシーにより外部サイトへの直接アクセスが制限されている場合があり、その際にカスタムアップデートサイトの設定やプラグインの手動インストールが必要となります。

**画面へのアクセス方法**：Jenkins管理画面（/manage）からプラグイン管理（/pluginManager）に遷移し、左側のサイドメニューまたはタブから「Advanced settings」を選択します。URL直接アクセスは `/pluginManager/advanced` で可能です。

**主要な操作・処理内容**：
1. プラグインファイル（.hpi/.jpi形式）をローカルファイルシステムから選択してアップロード
2. プラグインファイルをURL指定でダウンロード・インストール
3. アップデートサイトのURLを変更してカスタムアップデートサイトを利用
4. アップデートサイトURLをデフォルトにリセット
5. 追加設定されたその他のアップデートサイトの確認

**画面遷移**：
- 遷移元：プラグイン管理トップ（/pluginManager）、インストール済みプラグイン、利用可能なプラグイン、更新可能なプラグイン
- 遷移先：更新センター（/updateCenter）（プラグインアップロード後）、プラグイン管理の各画面

**権限による表示制御**：SYSTEM_READ権限を持つユーザーは画面の閲覧が可能です。ADMINISTER権限を持つユーザーのみ、プラグインのアップロードやアップデートサイトURLの変更操作が有効になります。読み取り専用モードの場合、入力フィールドは表示されますが、送信ボタンは非表示となります。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 2 | プラグインマネージャー | 主機能 | プラグインの詳細設定（アップデートサイト等） |
| 49 | プロキシ設定 | 補助機能 | プロキシ経由でのダウンロード設定 |

## 画面種別

設定

## URL/ルーティング

- **URL**: `/pluginManager/advanced`
- **Jellyテンプレート**: `core/src/main/resources/hudson/PluginManager/advanced.jelly`
- **権限**: `app.SYSTEM_READ`（閲覧）、`app.ADMINISTER`（編集）

## 入出力項目

### プラグインデプロイセクション（Deploy Plugin）

| 項目名 | 項目ID | 種別 | 必須 | データ型 | 説明 |
|--------|--------|------|------|----------|------|
| ファイル | name | 入力 | - | File | アップロードするプラグインファイル（.hpi/.jpi形式） |
| URL | pluginUrl | 入力 | - | String | プラグインファイルのダウンロードURL |

### アップデートサイトセクション（Update Site）

| 項目名 | 項目ID | 種別 | 必須 | データ型 | 説明 |
|--------|--------|------|------|----------|------|
| URL | site | 入力 | 必須 | String | アップデートサイトのURL |

## 表示項目

### プラグインデプロイセクション

| 項目名 | 説明 |
|--------|------|
| 説明文 | プラグインのアップロード方法に関する説明テキスト |
| ファイル選択 | ローカルファイルを選択するための入力フィールド |
| URL入力 | プラグインURLを入力するテキストフィールド |
| Deployボタン | プラグインをデプロイするボタン |

### アップデートサイトセクション

| 項目名 | 説明 |
|--------|------|
| URL入力 | アップデートサイトURLを入力するテキストフィールド |
| Reset to defaultリンク | デフォルトURLにリセットするリンク |
| Submitボタン | 設定を保存するボタン |

### その他のサイトセクション（Other Sites）

| 項目名 | 説明 |
|--------|------|
| サイトURLリスト | デフォルト以外のアップデートサイトURLの一覧 |

## イベント仕様

### 1-プラグインファイルアップロード（Deploy）

1. ユーザーがファイルを選択するか、URLを入力
2. 「Deploy」ボタンをクリック
3. POSTリクエストが`uploadPlugin`アクションに送信される
4. サーバー側でプラグインファイルが検証される
5. プラグインが`$JENKINS_HOME/plugins`ディレクトリにコピーされる
6. 更新センター画面（/updateCenter）にリダイレクトされ、インストール状況が表示される

### 2-アップデートサイトURL変更（Submit）

1. ユーザーがアップデートサイトURLを入力
2. 「Submit」ボタンをクリック
3. POSTリクエストが`siteConfigure`アクションに送信される
4. 入力されたURLの妥当性が検証される
5. 設定が保存され、画面がリロードされる

### 3-デフォルトURLへのリセット（Reset to default）

1. 「Reset to default」リンクをクリック
2. JavaScriptによりURLフィールドにデフォルトURL（https://updates.jenkins.io/update-center.json）が設定される
3. ユーザーが「Submit」ボタンをクリックして変更を保存

## データベース更新仕様

### 操作別データベース影響一覧

本画面はJenkinsのファイルベースの設定システムを使用しており、RDBMSのデータベースは使用しません。

| 操作（イベント） | 対象ファイル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| プラグインアップロード | plugins/*.jpi | CREATE | プラグインファイルの配置 |
| アップデートサイト設定 | hudson.model.UpdateCenter.xml | UPDATE | アップデートサイト設定の更新 |

### ファイル別更新項目詳細

#### plugins/*.jpi

| 操作 | 内容 | 備考 |
|-----|------|------|
| CREATE | アップロードされたプラグインファイル | Jenkins再起動または動的ロードにより有効化 |

#### hudson.model.UpdateCenter.xml

| 操作 | 要素 | 更新値・取得条件 | 備考 |
|-----|------|-----------------|------|
| UPDATE | sites/site/url | 入力されたアップデートサイトURL | 即座に反映 |

## メッセージ仕様

| 種別 | メッセージ | 発生条件 |
|------|----------|----------|
| 情報 | The Proxy configuration form has been moved to Configure System page | 画面表示時（常時） |
| エラー | Invalid plugin file | 不正なファイル形式をアップロードした場合 |
| エラー | Failed to download plugin from URL | URLからのダウンロードに失敗した場合 |
| エラー | Invalid update site URL | アップデートサイトURLの検証に失敗した場合 |

## 例外処理

| 状態 | 処理 |
|------|------|
| 権限不足 | 編集要素が非表示になり、読み取り専用モードで表示 |
| ファイルアップロード失敗 | エラーメッセージを表示し、画面を再表示 |
| URLアクセス不可 | 接続エラーメッセージを表示 |
| プラグイン形式不正 | プラグインファイルの形式エラーを表示 |

## 備考

- プロキシ設定は本画面から移動し、システム設定画面（/manage/configure）で行うようになっています
- プラグインのアップロードにはADMINISTER権限が必要です
- アップデートサイトURLの検証は`checkUpdateSiteUrl`アクションで非同期に実行されます
- プラグインURLの検証は`checkPluginUrl`アクションで非同期に実行されます

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

プラグイン管理に関わるデータ構造を把握します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | UpdateSite.java | `core/src/main/java/hudson/model/UpdateSite.java` | アップデートサイトのデータ構造、URL・IDの管理方法 |
| 1-2 | UpdateCenter.java | `core/src/main/java/hudson/model/UpdateCenter.java` | 更新センターの全体構造、sitesリストの管理 |

**読解のコツ**: `UpdateSite`はアップデートサイトの1エントリを表し、`UpdateCenter`は複数の`UpdateSite`を管理するコンテナです。

#### Step 2: エントリーポイントを理解する

画面表示とフォーム処理のエントリーポイントを特定します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | advanced.jelly | `core/src/main/resources/hudson/PluginManager/advanced.jelly` | 画面レイアウト、フォームアクション定義 |
| 2-2 | PluginManager.java | `core/src/main/java/hudson/PluginManager.java` | uploadPlugin、siteConfigureアクションの実装 |

**主要処理フロー**:
1. **29-110行目**: Jellyテンプレートで画面構造を定義
2. **31-32行目**: 権限チェック（`permission="${app.SYSTEM_READ}"`と`readOnlyMode`判定）
3. **46-64行目**: Deploy Pluginセクション（ADMINISTER権限ユーザーのみ）
4. **66-93行目**: Update Siteセクション（URL設定フォーム）

#### Step 3: フォーム送信処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | PluginManager.java | `core/src/main/java/hudson/PluginManager.java` | doUploadPlugin、doSiteConfigureメソッド |

**主要処理フロー**:
- **uploadPlugin処理**: ファイルのマルチパートアップロードまたはURLからのダウンロードを処理
- **siteConfigure処理**: アップデートサイトURLの更新と永続化

### プログラム呼び出し階層図

```
ブラウザ (advanced.jelly)
    |
    +-- [POST] uploadPlugin
    |      |
    |      +-- PluginManager.doUploadPlugin()
    |             |
    |             +-- プラグインファイル検証
    |             +-- plugins/ディレクトリへの配置
    |             +-- UpdateCenter画面へリダイレクト
    |
    +-- [POST] siteConfigure
           |
           +-- PluginManager.doSiteConfigure()
                  |
                  +-- UpdateCenter.getSite(ID_DEFAULT)
                  +-- UpdateSite.setUrl()
                  +-- UpdateCenter.save()
```

### データフロー図

```
[入力]                    [処理]                         [出力]

プラグインファイル ───> PluginManager.doUploadPlugin() ───> plugins/*.jpi
                              |
                              +───────────────────────────> UpdateCenter画面

アップデートサイトURL ───> PluginManager.doSiteConfigure() ───> UpdateCenter.xml
                              |
                              +───────────────────────────> 画面リフレッシュ
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| advanced.jelly | `core/src/main/resources/hudson/PluginManager/advanced.jelly` | テンプレート | 画面表示定義 |
| advanced.properties | `core/src/main/resources/hudson/PluginManager/advanced.properties` | 設定 | メッセージ定義 |
| PluginManager.java | `core/src/main/java/hudson/PluginManager.java` | ソース | プラグイン管理ロジック |
| UpdateCenter.java | `core/src/main/java/hudson/model/UpdateCenter.java` | ソース | 更新センター管理 |
| UpdateSite.java | `core/src/main/java/hudson/model/UpdateSite.java` | ソース | アップデートサイト定義 |
| sidepanel.jelly | `core/src/main/resources/hudson/PluginManager/sidepanel.jelly` | テンプレート | サイドパネルナビゲーション |
| _updateSite.jelly | `core/src/main/resources/hudson/PluginManager/_updateSite.jelly` | テンプレート | アップデートサイト関連JavaScript |
