# 画面設計書 42-更新センター

## 概要

本ドキュメントは、Jenkinsの更新センター画面（Update Center / Download Progress）の画面設計書です。プラグインのダウンロード・インストール進捗状況を表示する画面について記述します。

### 本画面の処理概要

この画面では、プラグインのインストールや更新処理のリアルタイム進捗状況を表示します。複数のプラグインが同時にダウンロード・インストールされる際、各ジョブの状態（待機中、ダウンロード中、インストール完了、エラーなど）を一覧で確認できます。

**業務上の目的・背景**：プラグインのインストールは時間がかかる場合があり、ネットワーク環境によってはダウンロードに失敗することもあります。この画面により、管理者はインストール処理の進捗を監視し、問題が発生した場合に適切な対応を取ることができます。また、インストール完了後に再起動が必要かどうかの判断材料を提供します。

**画面へのアクセス方法**：利用可能なプラグイン画面や更新可能なプラグイン画面からプラグインをインストール・更新する際、自動的にこの画面にリダイレクトされます。また、プラグイン詳細設定画面からプラグインをアップロードした際にも遷移します。URL直接アクセスは `/updateCenter` で可能です。

**主要な操作・処理内容**：
1. プラグインのダウンロード進捗の確認
2. プラグインのインストール状況の確認
3. インストール完了後のダッシュボードへの遷移
4. 再起動スケジュールの設定（オプション）

**画面遷移**：
- 遷移元：利用可能なプラグイン（/pluginManager/available）、更新可能なプラグイン（/pluginManager/updates）、プラグイン詳細設定（/pluginManager/advanced）
- 遷移先：ダッシュボード（/）、インストール済みプラグイン（/pluginManager/installed）

**権限による表示制御**：SYSTEM_READ権限を持つユーザーは画面の閲覧が可能です。ADMINISTER権限を持つユーザーのみ、再起動スケジュールの設定が可能です。Jenkinsのライフサイクルが再起動をサポートしている場合にのみ、再起動オプションが表示されます。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 3 | アップデートセンター | 主機能 | プラグインダウンロード・インストール状況の表示 |
| 2 | プラグインマネージャー | 補助機能 | インストール処理の実行 |

## 画面種別

一覧 / 状態表示

## URL/ルーティング

- **URL**: `/updateCenter`
- **Jellyテンプレート**: `core/src/main/resources/hudson/model/UpdateCenter/index.jelly`
- **ボディ部分**: `core/src/main/resources/hudson/model/UpdateCenter/body.jelly`
- **権限**: `app.SYSTEM_READ`

## 入出力項目

### 再起動スケジュールセクション

| 項目名 | 項目ID | 種別 | 必須 | データ型 | 説明 |
|--------|--------|------|------|----------|------|
| 再起動スケジュール | scheduleRestart | 入力 | - | Boolean | インストール完了後に再起動をスケジュールするかどうか |

## 表示項目

### ダウンロード進捗テーブル

| 項目名 | 説明 |
|--------|------|
| プラグイン名 | インストール対象のプラグイン名 |
| 状態 | 現在の処理状態（Pending、Installing、Success、Failure等） |
| 進捗 | ダウンロード進捗表示 |

### 操作リンク

| 項目名 | 説明 |
|--------|------|
| Go back to the top page | ダッシュボードへ戻るリンク |
| 再起動チェックボックス | インストール完了後に再起動をスケジュール |

## イベント仕様

### 1-自動更新（AJAX）

1. ページロード時にJavaScriptが初期化される
2. 定期的にbody.jellyをAJAXで取得
3. ジョブ一覧テーブルが最新の状態に更新される
4. すべてのジョブが完了するまで更新が継続

### 2-再起動スケジュール設定

1. 「Restart Jenkins when installation is complete and no jobs are running」チェックボックスをオン
2. Jenkinsがquietingdownモードに入る
3. 実行中のジョブがなくなり次第、自動的に再起動

### 3-トップページへ戻る

1. 「Go back to the top page」リンクをクリック
2. ダッシュボード（/）にリダイレクト
3. インストールしたプラグインは即座に利用可能（再起動不要の場合）

## データベース更新仕様

### 操作別データベース影響一覧

本画面は主に表示機能であり、直接的なデータ更新は行いません。ただし、再起動スケジュール設定時にJenkinsの状態が変更されます。

| 操作（イベント） | 対象 | 操作種別 | 概要 |
|----------------|------|---------|------|
| 再起動スケジュール | Jenkins状態 | UPDATE | quietingdownフラグの設定 |

## メッセージ仕様

| 種別 | メッセージ | 発生条件 |
|------|----------|----------|
| 情報 | Download progress | 画面タイトル |
| 情報 | Go back to the top page | ナビゲーションリンク |
| 情報 | you can start using the installed plugins right away | ダッシュボードへ戻るリンクの補足説明 |
| 警告 | Restart Jenkins when installation is complete and no jobs are running | 再起動オプションの説明 |

## 例外処理

| 状態 | 処理 |
|------|------|
| ダウンロード失敗 | ジョブ行にエラー状態を表示、失敗アイコンを表示 |
| ネットワークエラー | 接続失敗メッセージを表示 |
| 依存関係エラー | 依存プラグインの問題を表示 |

## 備考

- プラグインのインストールは再起動なしで有効になる場合があります（動的ロード対応プラグイン）
- 一部のプラグインは再起動が必要な場合があり、その旨がジョブ状態に表示されます
- 再起動オプションは`app.lifecycle.canRestart()`がtrueの場合にのみ表示されます
- AJAX更新により画面が自動的にリフレッシュされるため、手動でのリロードは不要です

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

更新センターのジョブ管理構造を把握します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | UpdateCenter.java | `core/src/main/java/hudson/model/UpdateCenter.java` | UpdateCenterJobクラス、ジョブリストの管理 |
| 1-2 | UpdateCenterJob (内部クラス) | 同上 | ジョブの状態管理、InstallationJob/DownloadJob |

**読解のコツ**: `UpdateCenterJob`は抽象クラスで、`InstallationJob`や`DownloadJob`がその具象実装です。`jobs`ベクターでジョブが管理されます。

#### Step 2: エントリーポイントを理解する

画面表示の構造を把握します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | index.jelly | `core/src/main/resources/hudson/model/UpdateCenter/index.jelly` | 全体レイアウト、adjunctインクルード |
| 2-2 | body.jelly | `core/src/main/resources/hudson/model/UpdateCenter/body.jelly` | ジョブ一覧表示、AJAX更新領域 |

**主要処理フロー**:
1. **31行目**: 権限チェック（`permission="${app.SYSTEM_READ}"`）
2. **32-33行目**: JavaScript adjunctの読み込み
3. **37行目**: body.jellyのインクルードでジョブ一覧表示

#### Step 3: AJAX更新処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | update-center.js | `core/src/main/resources/hudson/model/UpdateCenter/update-center.js` | 定期更新処理のJavaScript |
| 3-2 | row.jelly | `core/src/main/resources/hudson/model/UpdateCenter/*/row.jelly` | 各ジョブタイプの行表示 |

### プログラム呼び出し階層図

```
ブラウザ (index.jelly)
    |
    +-- JavaScript (update-center.js)
    |      |
    |      +-- [AJAX GET] body.jelly
    |             |
    |             +-- forEach: it.jobs
    |                    |
    |                    +-- row.jelly (各ジョブの状態表示)
    |
    +-- [POST] scheduleRestart (再起動スケジュール)
           |
           +-- Jenkins.doQuietDown()
```

### データフロー図

```
[入力]                    [処理]                         [出力]

プラグインインストール要求 ───> UpdateCenter.addJob() ───> jobsリストに追加
                                     |
AJAX更新リクエスト ───────────> body.jelly描画 ─────────> ジョブ状態HTML
                                     |
再起動チェックボックス ──────> Jenkins.doQuietDown() ───> 再起動スケジュール
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| index.jelly | `core/src/main/resources/hudson/model/UpdateCenter/index.jelly` | テンプレート | メイン画面レイアウト |
| body.jelly | `core/src/main/resources/hudson/model/UpdateCenter/body.jelly` | テンプレート | AJAX更新領域 |
| UpdateCenter.java | `core/src/main/java/hudson/model/UpdateCenter.java` | ソース | 更新センターロジック |
| update-center.js | `core/src/main/resources/hudson/model/UpdateCenter/update-center.js` | JavaScript | AJAX更新処理 |
| _download-failure.jelly | `core/src/main/resources/hudson/model/UpdateCenter/_download-failure.jelly` | テンプレート | ダウンロード失敗表示 |
| sidepanel.jelly | `core/src/main/resources/hudson/PluginManager/sidepanel.jelly` | テンプレート | サイドパネル（プラグインマネージャーから継承） |
