# 画面設計書 43-ユーザー一覧

## 概要

本ドキュメントは、Jenkinsのユーザー一覧画面の画面設計書です。Jenkins独自のセキュリティレルム（HudsonPrivateSecurityRealm）を使用している場合に、登録されているユーザーの一覧を表示し、ユーザーの追加・削除を行う画面について記述します。

### 本画面の処理概要

この画面では、Jenkinsにログイン可能なユーザーアカウントの一覧を表示します。各ユーザーのID、表示名、アバターを確認でき、ユーザーの詳細画面への遷移や削除操作が可能です。

**業務上の目的・背景**：Jenkinsの独自認証機能（HudsonPrivateSecurityRealm）を使用する場合、管理者はユーザーアカウントを直接管理する必要があります。この画面により、現在登録されているユーザーの確認、新規ユーザーの作成、不要になったユーザーの削除を一元的に行うことができます。外部認証（LDAP、Active Directory等）を使用する場合、この画面は表示されません。

**画面へのアクセス方法**：Jenkins管理画面（/manage）から「Manage Users」を選択、または「Users」リンクをクリックします。URL直接アクセスは `/securityRealm` で可能です。この画面はHudsonPrivateSecurityRealmが有効な場合にのみアクセス可能です。

**主要な操作・処理内容**：
1. 登録されているユーザー一覧の表示
2. ユーザーアバター、ID、表示名の確認
3. ユーザー詳細画面への遷移
4. ユーザーの削除（確認付き）
5. 新規ユーザーの作成（Create Userボタン）

**画面遷移**：
- 遷移元：Jenkins管理画面（/manage）
- 遷移先：ユーザー詳細画面（/user/{userId}/）、ユーザー追加画面（/securityRealm/addUser）

**権限による表示制御**：ADMINISTER権限を持つユーザーのみがこの画面にアクセスできます。「Create User」ボタンおよびユーザー削除アイコンはADMINISTER権限を持つユーザーにのみ表示されます。現在ログイン中の自分自身は削除できません。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 30 | ユーザー管理 | 主機能 | 登録ユーザーの一覧表示 |
| 29 | 認可（AuthorizationStrategy） | 補助機能 | ユーザー権限情報の表示 |

## 画面種別

一覧

## URL/ルーティング

- **URL**: `/securityRealm`（HudsonPrivateSecurityRealm使用時）
- **Jellyテンプレート**: `core/src/main/resources/hudson/security/HudsonPrivateSecurityRealm/index.jelly`
- **権限**: `app.ADMINISTER`

## 入出力項目

本画面は主に表示機能であり、入力項目はありません。

## 表示項目

### ヘッダー部分

| 項目名 | 説明 |
|--------|------|
| タイトル | 「Users」とユーザー数を表示 |
| Create Userボタン | 新規ユーザー作成画面へのリンク |
| 説明文 | ログイン可能なユーザーの説明 |

### ユーザー一覧テーブル

| 項目名 | 説明 |
|--------|------|
| アバター | ユーザーのプロフィール画像（64x64） |
| User ID | ユーザーのログインID（ユーザー詳細へのリンク） |
| Name | ユーザーの表示名（フルネーム） |
| 設定アイコン | ユーザー設定画面へのリンク |
| 削除アイコン | ユーザー削除ボタン（削除可能な場合のみ表示） |

## イベント仕様

### 1-ユーザー一覧表示

1. 画面アクセス時に`getAllUsers()`メソッドが呼び出される
2. HudsonPrivateSecurityRealm.Detailsプロパティを持つユーザーのみが抽出される
3. ユーザーIDでソートされた一覧がテーブルに表示される

### 2-Create Userボタンクリック

1. 「Create User」ボタンをクリック
2. /securityRealm/addUserに遷移
3. ユーザー追加フォームが表示される

### 3-ユーザーID/設定アイコンクリック

1. ユーザーIDまたは設定アイコンをクリック
2. /user/{userId}/に遷移
3. 該当ユーザーの詳細画面が表示される

### 4-ユーザー削除

1. 削除アイコン（ゴミ箱）をクリック
2. 確認ダイアログが表示される（「Delete Jenkins user '{displayName}'?」）
3. 確認後、POSTリクエストが{userId}/doDeleteに送信される
4. ユーザーデータが削除され、一覧が更新される

## データベース更新仕様

### 操作別データベース影響一覧

Jenkinsはファイルベースの設定システムを使用しています。

| 操作（イベント） | 対象ファイル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| ユーザー削除 | users/{userId}/config.xml | DELETE | ユーザー設定ファイルの削除 |
| ユーザー削除 | users/{userId}/ | DELETE | ユーザーディレクトリの削除 |

### ファイル別更新項目詳細

#### users/{userId}/config.xml

| 操作 | 内容 | 備考 |
|-----|------|------|
| DELETE | ユーザー設定ファイル全体 | ユーザーの全プロパティが削除される |

## メッセージ仕様

| 種別 | メッセージ | 発生条件 |
|------|----------|----------|
| 情報 | Users ({count}) | 画面タイトルにユーザー数を表示 |
| 情報 | These users can log into Jenkins... | 画面説明文（blurb） |
| 確認 | Delete Jenkins user '{displayName}'? | ユーザー削除確認時 |

## 例外処理

| 状態 | 処理 |
|------|------|
| 権限不足 | 403 Forbidden、画面アクセス拒否 |
| 自分自身の削除 | 削除アイコンが非表示になる（canDelete()がfalseを返す） |
| HudsonPrivateSecurityRealm以外使用時 | 管理画面にリンクが表示されない |

## 備考

- この画面はHudsonPrivateSecurityRealmが有効な場合にのみ表示されます
- asynchPeople画面（/asynchPeople）にはSCMコミットによって自動作成されたユーザーも含まれますが、この画面にはログイン可能なユーザーのみが表示されます
- テーブルはソート可能で、User IDカラムがデフォルトのソートキーです
- ユーザー削除はUser.canDelete()メソッドで可否が判定されます

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

ユーザー管理に関わるデータ構造を把握します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | User.java | `core/src/main/java/hudson/model/User.java` | Userクラスの構造、プロパティ管理 |
| 1-2 | HudsonPrivateSecurityRealm.java | `core/src/main/java/hudson/security/HudsonPrivateSecurityRealm.java` | Details内部クラス、getAllUsers()メソッド |

**読解のコツ**: `User`はJenkinsの全ユーザーを表し、`HudsonPrivateSecurityRealm.Details`プロパティを持つユーザーのみがログイン可能なユーザーとして扱われます。

#### Step 2: エントリーポイントを理解する

画面表示の構造を把握します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | index.jelly | `core/src/main/resources/hudson/security/HudsonPrivateSecurityRealm/index.jelly` | 画面レイアウト、テーブル構造 |
| 2-2 | index.properties | `core/src/main/resources/hudson/security/HudsonPrivateSecurityRealm/index.properties` | メッセージ定義 |

**主要処理フロー**:
1. **42行目**: 権限チェック（`permission="${app.ADMINISTER}"`）
2. **29行目**: app-barでタイトルとユーザー数表示
3. **31-35行目**: Create Userボタン（isAdmin条件付き）
4. **43-86行目**: ユーザー一覧テーブルの描画

#### Step 3: ユーザー取得・削除ロジックを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | HudsonPrivateSecurityRealm.java | `core/src/main/java/hudson/security/HudsonPrivateSecurityRealm.java` | getAllUsers()メソッド（行591-602） |
| 3-2 | User.java | `core/src/main/java/hudson/model/User.java` | canDelete()メソッド（行971-975）、doDoDelete()メソッド（行922-933） |

**主要処理フロー**:
- **getAllUsers()**: Detailsプロパティを持つユーザーをフィルタリングしてソート
- **canDelete()**: ADMINISTER権限、自分自身でないこと、永続化されたフォルダが存在することをチェック
- **doDoDelete()**: ユーザーデータの削除とリダイレクト

### プログラム呼び出し階層図

```
ブラウザ (index.jelly)
    |
    +-- HudsonPrivateSecurityRealm.getAllUsers()
    |      |
    |      +-- User.getAll()
    |      +-- user.getProperty(Details.class) でフィルタリング
    |      +-- Collections.sort() でソート
    |
    +-- [GET] /user/{userId}/
    |      |
    |      +-- User詳細画面へ遷移
    |
    +-- [POST] /user/{userId}/doDelete
           |
           +-- User.doDoDelete()
                  |
                  +-- User.delete()
                         +-- ユーザーファイルの削除
```

### データフロー図

```
[入力]                    [処理]                         [出力]

画面アクセス ────────> getAllUsers() ──────────────> ユーザー一覧テーブル
                              |
                              +-- フィルタリング（Detailsあり）
                              +-- ソート（ID順）

削除クリック ──────────> User.doDoDelete() ────────> ユーザー削除
                              |                          |
                              +-- 権限チェック            +-- 一覧リフレッシュ
                              +-- User.delete()
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| index.jelly | `core/src/main/resources/hudson/security/HudsonPrivateSecurityRealm/index.jelly` | テンプレート | 画面表示定義 |
| index.properties | `core/src/main/resources/hudson/security/HudsonPrivateSecurityRealm/index.properties` | 設定 | メッセージ定義 |
| HudsonPrivateSecurityRealm.java | `core/src/main/java/hudson/security/HudsonPrivateSecurityRealm.java` | ソース | セキュリティレルム実装 |
| User.java | `core/src/main/java/hudson/model/User.java` | ソース | ユーザーモデル |
| addUser.jelly | `core/src/main/resources/hudson/security/HudsonPrivateSecurityRealm/addUser.jelly` | テンプレート | ユーザー追加画面 |
| sidepanel.jelly | `core/src/main/resources/hudson/security/HudsonPrivateSecurityRealm/sidepanel.jelly` | テンプレート | サイドパネル |
