# 画面設計書 44-ユーザー詳細

## 概要

本ドキュメントは、Jenkinsのユーザー詳細画面の画面設計書です。特定のユーザーの詳細情報（ユーザーID、表示名、説明、所属グループ等）を表示する画面について記述します。

### 本画面の処理概要

この画面では、個別のユーザーアカウントの詳細情報を表示します。ユーザーのID、表示名、説明、所属グループ（権限グループ）を確認でき、ADMINISTER権限を持つユーザーは説明の編集が可能です。

**業務上の目的・背景**：ユーザーの情報を確認するための中心的な画面です。ユーザーがどのグループ（権限グループ）に所属しているか、どのような説明が設定されているかを確認できます。また、ユーザー設定ページ群へのエントリポイントとしても機能し、サイドパネルから各種設定画面に遷移できます。

**画面へのアクセス方法**：ユーザー一覧画面からユーザーIDをクリック、ビルド履歴やコミット履歴からユーザー名をクリック、または `/user/{userId}` にURL直接アクセスします。

**主要な操作・処理内容**：
1. ユーザーID（Jenkins User ID）の表示
2. ユーザー説明の表示と編集
3. 所属グループ（認証グループ）の一覧表示
4. UserPropertyからのサマリー情報表示
5. 各種ユーザー設定画面へのサイドパネルナビゲーション

**画面遷移**：
- 遷移元：ユーザー一覧（/securityRealm）、ビルド詳細、変更ログ、People画面
- 遷移先：ユーザービルド一覧（/user/{userId}/builds）、各種ユーザー設定画面

**権限による表示制御**：すべてのユーザーが自分自身および他のユーザーの詳細を閲覧できます。ADMINISTER権限を持つユーザーは、説明の編集ボタンが表示されます。所属グループ情報はADMINISTER権限を持つユーザーにのみ表示されます。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 30 | ユーザー管理 | 主機能 | ユーザーの詳細情報表示 |
| 6 | ビルド（Build） | 補助機能 | ユーザーに関連するビルド履歴の表示 |

## 画面種別

詳細

## URL/ルーティング

- **URL**: `/user/{userId}`
- **Jellyテンプレート**: `core/src/main/resources/hudson/model/User/index.jelly`
- **権限**: なし（認証ユーザーであればアクセス可能）

## 入出力項目

### 説明編集セクション（ADMINISTER権限時）

| 項目名 | 項目ID | 種別 | 必須 | データ型 | 説明 |
|--------|--------|------|------|----------|------|
| 説明 | description | 入力 | - | String | ユーザーの説明テキスト |

## 表示項目

### ヘッダー部分

| 項目名 | 説明 |
|--------|------|
| ユーザー表示名 | ページタイトルとして表示されるユーザーの表示名 |
| 説明編集ボタン | 説明を編集するためのボタン（ADMINISTER権限時） |

### ユーザー情報セクション

| 項目名 | 説明 |
|--------|------|
| 説明 | ユーザーに設定された説明文（編集可能） |
| Jenkins User ID | ユーザーのログインID |
| Groups | ユーザーが所属するグループの一覧（ADMINISTER権限時のみ） |

### UserPropertyサマリー

| 項目名 | 説明 |
|--------|------|
| 各プロパティのサマリー | UserPropertyが提供するsummary.jellyの内容 |

## イベント仕様

### 1-ユーザー詳細表示

1. 画面アクセス時にUser.getById()でユーザーを取得
2. sidepanel.jellyでサイドナビゲーションを表示
3. ユーザーのプロパティを順次処理してサマリーを表示
4. ADMINISTER権限があれば所属グループを表示

### 2-説明編集

1. 説明編集ボタンをクリック
2. インライン編集フォームが表示される
3. 説明を入力して保存
4. POSTリクエストがsubmitDescriptionアクションに送信される
5. User.doSubmitDescription()で説明が更新・保存される

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象ファイル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 説明編集 | users/{userId}/config.xml | UPDATE | ユーザー説明の更新 |

### ファイル別更新項目詳細

#### users/{userId}/config.xml

| 操作 | 要素 | 更新値・取得条件 | 備考 |
|-----|------|-----------------|------|
| UPDATE | description | 入力された説明テキスト | HTMLタグ使用可（MarkupFormatter依存） |

## メッセージ仕様

| 種別 | メッセージ | 発生条件 |
|------|----------|----------|
| ラベル | Jenkins User ID | ユーザーID表示のラベル |
| ラベル | Groups | 所属グループ表示のラベル |

## 例外処理

| 状態 | 処理 |
|------|------|
| 存在しないユーザーID | 404エラーまたは新規ユーザー作成（設定による） |
| 権限不足（説明編集） | 編集ボタンが非表示 |

## 備考

- ユーザーの所属グループはSecurityRealmから動的に取得されます
- AUTHENTICATED_AUTHORITY2およびユーザー自身のIDはグループ一覧から除外されます
- UserPropertyのsummary.jellyはオプションで、存在する場合のみ表示されます
- User.ALLOW_USER_CREATION_VIA_URLがtrueの場合、存在しないユーザーIDにアクセスするとユーザーが作成されます

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

ユーザーモデルの構造を把握します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | User.java | `core/src/main/java/hudson/model/User.java` | Userクラスの基本構造、プロパティ管理 |
| 1-2 | UserProperty.java | `core/src/main/java/hudson/model/UserProperty.java` | UserPropertyの基底クラス |

**読解のコツ**: `User`クラスはユーザーの基本情報（id, fullName, description）とプロパティ（properties）を保持します。

#### Step 2: エントリーポイントを理解する

画面表示の構造を把握します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | index.jelly | `core/src/main/resources/hudson/model/User/index.jelly` | 画面レイアウト、各セクションの構造 |

**主要処理フロー**:
1. **26行目**: タイトルにユーザー表示名を設定
2. **27行目**: sidepanel.jellyでサイドナビゲーション
3. **33行目**: 説明編集ボタン（ADMINISTER権限条件）
4. **37行目**: editableDescriptionで説明表示/編集
5. **38-40行目**: Jenkins User IDの表示
6. **42-44行目**: UserPropertyのサマリー表示ループ
7. **45-53行目**: 所属グループの表示

#### Step 3: 権限と認証グループの取得を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | User.java | `core/src/main/java/hudson/model/User.java` | getAuthorities()メソッド（行984-1008） |

**主要処理フロー**:
- **getAuthorities()**: impersonate2()でユーザーの認証情報を取得し、AUTHENTICATED_AUTHORITY2と自分自身のIDを除外してグループ一覧を返す

### プログラム呼び出し階層図

```
ブラウザ (index.jelly)
    |
    +-- it.displayName (ページタイトル)
    |
    +-- editableDescription (説明表示/編集)
    |      |
    |      +-- [POST] doSubmitDescription()
    |
    +-- it.id (Jenkins User ID)
    |
    +-- forEach: it.allProperties
    |      |
    |      +-- summary.jelly (オプション)
    |
    +-- it.authorities (ADMINISTER権限時)
           |
           +-- User.getAuthorities()
                  |
                  +-- User.impersonate2()
                         |
                         +-- Authentication.getAuthorities()
```

### データフロー図

```
[入力]                    [処理]                         [出力]

URL /user/{userId} ────> User.getById() ───────────────> User詳細表示
                              |
                              +-- it.displayName
                              +-- it.description
                              +-- it.id
                              +-- it.allProperties
                              +-- it.authorities

説明編集 ───────────────> User.doSubmitDescription() ───> config.xml更新
                              |
                              +-- User.save()
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| index.jelly | `core/src/main/resources/hudson/model/User/index.jelly` | テンプレート | メイン画面表示 |
| User.java | `core/src/main/java/hudson/model/User.java` | ソース | ユーザーモデル |
| sidepanel.jelly | `core/src/main/resources/hudson/model/User/sidepanel.jelly` | テンプレート | サイドナビゲーション |
| UserProperty.java | `core/src/main/java/hudson/model/UserProperty.java` | ソース | ユーザープロパティ基底クラス |
| builds.jelly | `core/src/main/resources/hudson/model/User/builds.jelly` | テンプレート | ユーザービルド一覧 |
