# 画面設計書 45-ユーザービルド一覧

## 概要

本ドキュメントは、Jenkinsのユーザービルド一覧画面の画面設計書です。特定のユーザーが関係したビルド（トリガーした、またはコミットを含む）の一覧を表示する画面について記述します。

### 本画面の処理概要

この画面では、特定のユーザーに関連するビルドの履歴を一覧表示します。ユーザーが「関係した」とは、そのユーザーが手動でビルドをトリガーした場合（UserIdCause）、またはそのユーザーのコミットがビルドに含まれている場合（SCM変更ログ）を指します。

**業務上の目的・背景**：開発者やCI管理者が、特定のユーザーがどのようなビルドに関与したかを追跡するために使用します。コードレビューや問題調査の際に、特定の開発者が行った変更に関連するビルド結果を確認する場合に有用です。また、ビルドの責任者を特定する際にも活用できます。

**画面へのアクセス方法**：ユーザー詳細画面のサイドパネルから「Builds」リンクをクリック、または `/user/{userId}/builds` にURL直接アクセスします。

**主要な操作・処理内容**：
1. ユーザーに関連するビルドの一覧表示
2. ビルド結果（成功/失敗/不安定等）の確認
3. 各ビルド詳細画面への遷移
4. RSSフィードへのアクセス（全ビルド/失敗ビルド/最新ビルド）

**画面遷移**：
- 遷移元：ユーザー詳細画面（/user/{userId}/）、サイドパネル
- 遷移先：各ジョブのビルド詳細画面（/job/{jobName}/{buildNumber}/）

**権限による表示制御**：ビルド一覧の表示には、各ジョブのREAD権限が必要です。ユーザーがアクセス権を持たないジョブのビルドは表示されません。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 6 | ビルド（Build） | 主機能 | 特定ユーザーのビルド履歴表示 |
| 30 | ユーザー管理 | 補助機能 | ユーザー情報に基づく関連ビルドの抽出 |

## 画面種別

一覧

## URL/ルーティング

- **URL**: `/user/{userId}/builds`
- **Jellyテンプレート**: `core/src/main/resources/hudson/model/User/builds.jelly`
- **権限**: なし（各ジョブのREAD権限に依存）

## 入出力項目

本画面は表示専用であり、入力項目はありません。

## 表示項目

### ヘッダー部分

| 項目名 | 説明 |
|--------|------|
| タイトル | 「Builds for {ユーザー表示名}」 |
| RSSリンク | 全ビルド、失敗ビルド、最新ビルドのRSSフィード |

### ビルド一覧

| 項目名 | 説明 |
|--------|------|
| ステータスアイコン | ビルド結果を示すアイコン（成功=青/緑、失敗=赤、不安定=黄） |
| ビルド番号 | ビルドの番号（ジョブへのリンク） |
| ビルド日時 | ビルドの実行日時 |
| ジョブ名 | ビルドが実行されたジョブの名前 |

## イベント仕様

### 1-ビルド一覧表示

1. 画面アクセス時にUser.getBuilds()が呼び出される
2. 全ジョブからユーザーに関連するビルドを抽出
3. RunListとして結果をソートしてプロジェクトビューで表示

### 2-ビルド詳細遷移

1. ビルド番号またはジョブ名リンクをクリック
2. 該当するビルドの詳細画面に遷移

### 3-RSSフィード取得

1. RSSアイコンをクリック
2. 対応するRSSフィードが返される（rssAll, rssFailed, rssLatest）

## データベース更新仕様

本画面は表示専用であり、データの更新は行いません。

## メッセージ仕様

| 種別 | メッセージ | 発生条件 |
|------|----------|----------|
| タイトル | Builds for {displayName} | 画面タイトル |

## 例外処理

| 状態 | 処理 |
|------|------|
| 関連ビルドなし | 空のビルド一覧を表示 |
| アクセス権限なし（特定ジョブ） | 該当ビルドが一覧から除外される |

## 備考

- ビルドの関連判定は`User.relatedTo(Run)`メソッドで行われます
- 関連判定の条件：
  - `RunWithSCM.hasParticipant(user)`がtrue（SCM変更ログにユーザーが含まれる）
  - `Cause.UserIdCause.getUserId()`がユーザーIDと一致（ユーザーがトリガーした）
- RunListは遅延評価されるため、大量のビルドがあっても効率的に処理されます
- 表示件数はRunListのデフォルト制限に従います

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

ビルド履歴とユーザーの関連を把握します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | RunList.java | `core/src/main/java/hudson/util/RunList.java` | ビルド一覧の遅延評価リスト |
| 1-2 | Run.java | `core/src/main/java/hudson/model/Run.java` | ビルドの基本データ構造 |

**読解のコツ**: `RunList`は複数のジョブからビルドを集約し、遅延評価でフィルタリング・ソートを行います。

#### Step 2: エントリーポイントを理解する

画面表示の構造を把握します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | builds.jelly | `core/src/main/resources/hudson/model/User/builds.jelly` | 画面レイアウト |

**主要処理フロー**:
1. **26行目**: タイトルに「Builds for {displayName}」を設定
2. **27行目**: sidepanel.jellyでサイドナビゲーション
3. **30行目**: t:projectViewでビルド一覧を表示
4. **31行目**: t:rssBar-withAllでRSSリンクを表示

#### Step 3: ビルド取得ロジックを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | User.java | `core/src/main/java/hudson/model/User.java` | getBuilds()メソッド（行784-787）、relatedTo()メソッド（行764-777） |

**主要処理フロー**:
- **getBuilds()**: Jenkins.get().allItems(Job.class)からすべてのジョブを取得し、relatedTo()フィルタを適用
- **relatedTo()**:
  - RunWithSCM.hasParticipant()でSCM変更ログをチェック
  - Cause.UserIdCauseでトリガーユーザーをチェック

### プログラム呼び出し階層図

```
ブラウザ (builds.jelly)
    |
    +-- t:projectView(builds="${it.builds}")
           |
           +-- User.getBuilds()
                  |
                  +-- RunList.fromJobs(Jenkins.allItems(Job.class))
                  |      |
                  |      +-- 全ジョブからビルドを収集
                  |
                  +-- .filter(this::relatedTo)
                         |
                         +-- User.relatedTo(Run)
                                |
                                +-- RunWithSCM.hasParticipant(this)
                                +-- Cause.UserIdCause.getUserId()
```

### データフロー図

```
[入力]                    [処理]                         [出力]

全ジョブ ───────────> RunList.fromJobs() ──────────> ビルドストリーム
                              |
                              +-- relatedTo()フィルタ
                                     |
                                     +-- SCM参加チェック
                                     +-- トリガーユーザーチェック
                                     |
                                     +────────────────────> フィルタ済みRunList
                                                                  |
                                                                  +──> t:projectView表示
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| builds.jelly | `core/src/main/resources/hudson/model/User/builds.jelly` | テンプレート | メイン画面表示 |
| User.java | `core/src/main/java/hudson/model/User.java` | ソース | ユーザーモデル、getBuilds()実装 |
| RunList.java | `core/src/main/java/hudson/util/RunList.java` | ソース | ビルドリスト管理 |
| Run.java | `core/src/main/java/hudson/model/Run.java` | ソース | ビルドモデル |
| sidepanel.jelly | `core/src/main/resources/hudson/model/User/sidepanel.jelly` | テンプレート | サイドナビゲーション |
| projectView.jelly | `core/src/main/resources/lib/hudson/projectView.jelly` | テンプレート | ビルド一覧表示コンポーネント |
