# 画面設計書 5-ログインエラー

## 概要

本ドキュメントは、Jenkinsのログインエラー画面の設計仕様を定義するものです。

### 本画面の処理概要

ログインエラー画面は、ユーザー認証が失敗した場合に表示される画面です。技術的には独立した画面ではなく、ログイン画面にエラー状態を付与して再表示する仕組みになっています。

**業務上の目的・背景**：認証失敗時にユーザーに適切なフィードバックを提供し、正しい認証情報での再試行を促すことが目的です。不正アクセスの試行を記録し、セキュリティ監査に活用することも重要な役割です。

**画面へのアクセス方法**：ログイン画面で無効なユーザー名またはパスワードを入力してサインインを試行した場合、自動的にこの画面（状態）にリダイレクトされます。URLは `/loginError` ですが、実際には login.jelly にエラーフラグを付与して表示します。

**主要な操作・処理内容**：
1. 認証失敗時のエラーメッセージ表示
2. 認証情報の再入力機会の提供
3. 正しい認証情報でのサインイン再試行

**画面遷移**：ログイン画面で認証失敗した場合にこの画面に遷移します。正しい認証情報を入力すると、ダッシュボードまたは元々アクセスしようとしていたページに遷移します。

**権限による表示制御**：認証前の画面のため、権限による表示制御はありません。セットアップウィザードでセキュリティトークン認証中の場合は、セキュリティトークン認証画面がエラー状態で表示されます。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 28 | 認証（SecurityRealm） | 主機能 | 認証失敗時のエラー表示 |

## 画面種別

エラー（認証）

## URL/ルーティング

- `/loginError` - ログインエラー画面

## 入出力項目

| 項目名 | 入力/出力 | データ型 | 必須 | 説明 |
|--------|----------|----------|------|------|
| j_username | 入力 | String | ○ | ユーザー名（再入力） |
| j_password | 入力 | String | ○ | パスワード（再入力） |
| error | 内部 | Boolean | - | エラー状態フラグ |

## 表示項目

| 項目名 | データ型 | 説明 |
|--------|----------|------|
| エラーメッセージ | Message | "Invalid username or password" |
| ユーザー名入力フィールド | TextInput | エラー状態のスタイルが適用された入力欄 |
| パスワード入力フィールド | PasswordInput | エラー状態のスタイルが適用された入力欄 |
| Sign inボタン | Button | 認証再試行ボタン |

## イベント仕様

### 1-Sign inボタン押下

ログイン画面と同様に、フォームデータをSecurityRealmの認証ゲートウェイURLにPOSTします。認証成功の場合は元のリダイレクト先へ遷移し、再度失敗の場合はこの画面が再表示されます。

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 画面表示 | - | - | データベース更新なし |

### テーブル別更新項目詳細

本画面での直接的なファイルシステム更新はありません。

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|-------------|------|---------------|---------|
| Invalid username or password | エラー | "Invalid username or password" | 常時表示 |

## 例外処理

| 例外状態 | 処理内容 |
|---------|---------|
| セキュリティ設定無効 | ダッシュボードへリダイレクト |
| 既に認証済み | ダッシュボードへリダイレクト |
| セットアップウィザード中 | セキュリティトークン認証画面をエラー表示 |

## 備考

- HTTPステータスコード401（Unauthorized）が返されます
- この画面は login.jelly を `error=true` の状態で再利用しています
- 認証済みユーザーがこのURLにアクセスすると、ダッシュボードにリダイレクトされます
- セッションの `from` 属性からリダイレクト先を取得します

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

エラー状態の管理方法を理解します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | Functions.java | `core/src/main/java/hudson/Functions.java` | isAnonymous()メソッド |

**読解のコツ**: loginError.jellyは状態判定ロジックのみを含み、実際の表示はlogin.jellyに委譲します。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | loginError.jelly | `core/src/main/resources/jenkins/model/Jenkins/loginError.jelly` | 状態判定とルーティング |

**主要処理フロー**:
1. **29行目**: hudson.Functionsのインスタンス作成
2. **30-33行目**: セットアップウィザード中の場合、セキュリティトークン認証画面を表示
3. **34-38行目**: セキュリティ有効かつ匿名ユーザーの場合、401ステータスとlogin.jellyを表示
4. **39-41行目**: それ以外（認証済み）の場合、ダッシュボードへリダイレクト

#### Step 3: エラー表示の仕組みを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | login.jelly | `core/src/main/resources/jenkins/model/Jenkins/login.jelly` | error変数によるエラー表示切り替え |

**主要処理フロー**:
- **47行目**: error時はセッションから、通常時はリクエストパラメータからfromを取得
- **49行目**: error時にinputClassを`jenkins-input--error`に設定
- **79-83行目**: error時にエラーメッセージを表示

### プログラム呼び出し階層図

```
loginError.jelly (エントリーポイント)
    │
    ├─ [セットアップウィザード中]
    │      └─ authenticate-security-token.jelly
    │
    ├─ [セキュリティ有効 & 匿名]
    │      ├─ st:statusCode(401)
    │      └─ login.jelly (error=true)
    │             └─ エラーメッセージ表示
    │
    └─ [認証済み]
           └─ st:redirect(".")
```

### データフロー図

```
[入力]               [処理]                    [出力]

/loginError ───▶ loginError.jelly ───▶ 状態判定
                        │
                        ├─ セットアップ中 ───▶ token認証画面
                        │
                        ├─ 未認証 ───▶ login.jelly (error=true)
                        │                     │
                        │                     └─▶ 401 + エラーメッセージ
                        │
                        └─ 認証済み ───▶ リダイレクト（/）
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| loginError.jelly | `core/src/main/resources/jenkins/model/Jenkins/loginError.jelly` | テンプレート | 状態判定とルーティング |
| login.jelly | `core/src/main/resources/jenkins/model/Jenkins/login.jelly` | テンプレート | 実際のエラー表示 |
| Functions.java | `core/src/main/java/hudson/Functions.java` | ソース | ユーティリティ関数 |
| authenticate-security-token.jelly | `core/src/main/resources/jenkins/install/SetupWizard/` | テンプレート | セットアップ時の認証 |
