# 画面設計書 51-セットアップウィザード

## 概要

本ドキュメントは、Jenkins初回起動時に表示されるセットアップウィザード画面の設計仕様を定義するものである。

### 本画面の処理概要

セットアップウィザード画面は、Jenkinsを初めてインストールした際に表示される初期設定画面であり、管理者が必要な初期設定を段階的に行うためのガイド付きインターフェースを提供する。

**業務上の目的・背景**：Jenkinsを新規にインストールした管理者が、複雑なシステム設定を理解していなくても、セキュアかつ機能的なJenkins環境を迅速に構築できるようにするために必要である。初期設定を誤ると、セキュリティリスクや運用上の問題が発生する可能性があるため、ウィザード形式で段階的にガイドすることで、設定漏れや誤設定を防止する。

**画面へのアクセス方法**：Jenkins初回起動時に自動的にリダイレクトされる。セットアップが完了していない状態でJenkinsのルートURL（`/`）にアクセスすると、強制的にこの画面に遷移する。`FORCE_SETUP_WIZARD_FILTER`フィルターにより、セットアップ完了前は他の画面へのアクセスが制限される。

**主要な操作・処理内容**：
1. 初期管理パスワードの入力による認証（セキュリティトークン認証画面）
2. 推奨プラグインまたはカスタムプラグインの選択とインストール
3. 初回管理者ユーザーの作成
4. JenkinsインスタンスURLの設定
5. プロキシ設定（必要に応じて）

**画面遷移**：
- 遷移元：Jenkins初回起動、またはセットアップ未完了状態でのルートアクセス
- 遷移先：ダッシュボード（セットアップ完了後）
- 内部遷移：セキュリティトークン認証 → プラグイン選択 → ユーザー作成 → インスタンス設定 → 完了

**権限による表示制御**：セットアップウィザードは初回起動時のみ表示され、`Jenkins.ADMINISTER`権限が必要。セットアップ完了後は通常のダッシュボードにリダイレクトされる。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 70 | 初期化フレームワーク | 主機能 | Jenkins初期セットアップの実行 |
| 2 | プラグインマネージャー | 補助機能 | 推奨プラグインのインストール |
| 30 | ユーザー管理 | 遷移先機能 | 管理者ユーザー作成への遷移 |

## 画面種別

ウィザード（マルチステップ）

## URL/ルーティング

- URL: `/setupWizard/`
- コントローラー: `jenkins.install.SetupWizard`

## 入出力項目

| 項目名 | 項目ID | 入力/出力 | 型 | 必須 | 説明 |
|--------|--------|----------|-----|------|------|
| 該当なし | - | - | - | - | この画面自体は入力項目を持たず、子画面（プラグイン選択等）で入力を受け付ける |

## 表示項目

| 項目名 | 表示条件 | 説明 |
|--------|----------|------|
| ウィザードコンテナ | 常時 | プラグインセットアップウィザードのUIを表示するコンテナ（`plugin-setup-wizard-container`） |
| ウィザードUI | 常時 | JavaScriptベースのウィザードUIコンポーネント |

## イベント仕様

### 1-ページ読み込み

ページ読み込み時に以下の処理が実行される：

1. `SetupWizard`クラスの初期化確認
2. 現在のインストール状態（`InstallState`）の確認
3. セットアップフィルターの有効化確認
4. ウィザードUIの読み込みとレンダリング

### 2-プラグインリスト取得

`doPlatformPluginList()`メソッドが呼び出され、以下の処理が行われる：

1. 更新サイトから推奨プラグインリストを取得
2. バージョンに応じたプラグインフィルタリング
3. JSON形式でプラグインカテゴリとリストを返却

### 3-セットアップ完了

`doCompleteInstall()`メソッドが呼び出され、以下の処理が行われる：

1. 管理者権限の確認
2. 最終実行バージョンの保存
3. 現在のバージョンレベルの設定
4. インストール状態を`INITIAL_SETUP_COMPLETED`に遷移
5. セットアップウィザードフィルターの解除

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| セットアップ初期化 | ファイルシステム | INSERT | 初期管理パスワードファイルの作成 |
| セットアップ完了 | ファイルシステム | UPDATE | インストール状態ファイルの更新 |

### テーブル別更新項目詳細

#### ファイルシステム（$JENKINS_HOME/）

| 操作 | 項目（ファイル名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT | secrets/initialAdminPassword | ランダム生成されたUUID（ハイフン除去、小文字） | 初回起動時のみ、パーミッション0640 |
| UPDATE | jenkins.install.UpgradeWizard.state | 現在のJenkinsバージョン | セットアップ完了時 |
| UPDATE | config.xml | セキュリティ設定、認可戦略等 | 初回セットアップ時 |

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|-------------|------|--------------|----------|
| SetupWizard.DisplayName | 情報 | Setup Wizard | 画面タイトルとして表示 |
| ConfigureInstance.ValidationErrors | エラー | 検証エラーがあります | インスタンス設定で無効な値が入力された場合 |
| ConfigureInstance.RootUrl.Empty | エラー | URLを入力してください | ルートURLが未入力の場合 |
| ConfigureInstance.RootUrl.Invalid | エラー | 有効なURLを入力してください | ルートURLの形式が不正な場合 |

## 例外処理

| 例外種別 | 発生条件 | 処理内容 |
|----------|----------|----------|
| セットアップ未完了時のアクセス制限 | セットアップ完了前に他の画面にアクセス | `FORCE_SETUP_WIZARD_FILTER`により`/setupWizard/`にリダイレクト |
| 認証失敗 | 初期パスワードが不正 | エラーメッセージを表示し、再入力を促す |
| プラグインリスト取得失敗 | ネットワークエラー等 | ローカルの`platform-plugins.json`にフォールバック |

## 備考

- セットアップウィザードは`PageDecorator`を拡張しており、Jenkins全体のページ装飾に影響を与える
- `ADMIN_INITIAL_API_TOKEN`システムプロパティにより、初期APIトークンの自動生成が可能
- セットアップ中は`FullControlOnceLoggedInAuthorizationStrategy`が設定される
- JNLP（エージェント接続ポート）はデフォルトで無効化される（`-1`）
- CRUMBイシュアーがデフォルトで有効化され、CSRF保護が適用される

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、セットアップウィザードの状態管理と設定データ構造を理解することが重要。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | InstallState.java | `core/src/main/java/jenkins/install/InstallState.java` | インストール状態の列挙型と状態遷移ロジック |
| 1-2 | SetupWizard.java | `core/src/main/java/jenkins/install/SetupWizard.java` | ウィザード全体の制御クラス、フィールド定義（89-99行目） |

**読解のコツ**: `InstallState`の各状態（`NEW`, `INITIAL_SETUP_COMPLETED`等）がどのような条件で遷移するかを把握する。

#### Step 2: エントリーポイントを理解する

処理の起点となるファイル・関数を特定。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | index.jelly | `core/src/main/resources/jenkins/install/SetupWizard/index.jelly` | 画面のメインレイアウト、`wizard-ui`のインクルード |
| 2-2 | SetupWizard.java | `core/src/main/java/jenkins/install/SetupWizard.java` | `init()`メソッド（142-212行目）で初期化処理 |

**主要処理フロー**:
1. **142-145行目**: 新規インストール判定と初期化開始
2. **148-182行目**: セキュリティレルム設定、初期管理者作成、パスワードファイル生成
3. **185-203行目**: 初期パスワードのログ出力
4. **206-211行目**: 更新サイトの初期化

#### Step 3: 画面制御を理解する

ウィザード画面の表示制御とフィルター機構。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | SetupWizard.java | `core/src/main/java/jenkins/install/SetupWizard.java` | `FORCE_SETUP_WIZARD_FILTER`（758-791行目）による強制リダイレクト |
| 3-2 | SetupWizard.java | `core/src/main/java/jenkins/install/SetupWizard.java` | `setUpFilter()`/`tearDownFilter()`（269-287行目）でフィルター管理 |

**主要処理フロー**:
- **765-782行目**: リクエストURIの判定とリダイレクト処理
- **796-800行目**: `checkFilter()`でインストール状態に応じたフィルター設定

#### Step 4: APIエンドポイントを理解する

ウィザードが使用するREST APIエンドポイント。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | SetupWizard.java | `core/src/main/java/jenkins/install/SetupWizard.java` | `doCreateAdminUser()`（332-414行目）ユーザー作成API |
| 4-2 | SetupWizard.java | `core/src/main/java/jenkins/install/SetupWizard.java` | `doConfigureInstance()`（416-444行目）インスタンス設定API |
| 4-3 | SetupWizard.java | `core/src/main/java/jenkins/install/SetupWizard.java` | `doPlatformPluginList()`（502-519行目）プラグインリスト取得API |

### プログラム呼び出し階層図

```
Jenkins起動
    │
    ├─ SetupWizard.init(newInstall)
    │      ├─ HudsonPrivateSecurityRealm作成
    │      ├─ 初期管理者ユーザー作成
    │      ├─ initialAdminPasswordファイル生成
    │      └─ UpdateCenter.updateDefaultSite()
    │
    ├─ FORCE_SETUP_WIZARD_FILTER.doFilter()
    │      └─ /setupWizard/へリダイレクト
    │
    └─ SetupWizard画面表示
           ├─ doPlatformPluginList() → プラグイン選択
           ├─ doCreateAdminUser() → ユーザー作成
           ├─ doConfigureInstance() → URL設定
           └─ doCompleteInstall() → 完了処理
```

### データフロー図

```
[入力]                      [処理]                           [出力]

初回起動検知 ─────────────▶ SetupWizard.init() ─────────────▶ initialAdminPassword生成
                                   │
                                   ▼
セキュリティトークン入力 ──▶ 認証処理 ────────────────────▶ セッション確立
                                   │
                                   ▼
プラグイン選択 ────────────▶ UpdateCenter.install() ─────▶ プラグインインストール
                                   │
                                   ▼
ユーザー情報入力 ──────────▶ doCreateAdminUser() ─────────▶ Userオブジェクト生成
                                   │
                                   ▼
Jenkins URL入力 ───────────▶ doConfigureInstance() ──────▶ JenkinsLocationConfiguration更新
                                   │
                                   ▼
完了ボタン押下 ────────────▶ doCompleteInstall() ─────────▶ InstallState.INITIAL_SETUP_COMPLETED
                                                                    │
                                                                    ▼
                                                              ダッシュボード表示
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| SetupWizard.java | `core/src/main/java/jenkins/install/SetupWizard.java` | ソース | メインコントローラー |
| InstallState.java | `core/src/main/java/jenkins/install/InstallState.java` | ソース | インストール状態管理 |
| InstallUtil.java | `core/src/main/java/jenkins/install/InstallUtil.java` | ソース | インストールユーティリティ |
| index.jelly | `core/src/main/resources/jenkins/install/SetupWizard/index.jelly` | テンプレート | メイン画面テンプレート |
| wizard-ui.jelly | `core/src/main/resources/jenkins/install/SetupWizard/wizard-ui.jelly` | テンプレート | ウィザードUIコンポーネント |
| platform-plugins.json | `core/src/main/resources/jenkins/install/platform-plugins.json` | 設定 | 推奨プラグインリスト |
| HudsonPrivateSecurityRealm.java | `core/src/main/java/hudson/security/HudsonPrivateSecurityRealm.java` | ソース | ユーザー認証レルム |
