# 画面設計書 53-インスタンス設定

## 概要

本ドキュメントは、セットアップウィザード内でJenkinsインスタンスの基本設定を行う画面の設計仕様を定義するものである。

### 本画面の処理概要

インスタンス設定画面は、Jenkinsセットアップウィザードの最終ステップの一つとして、JenkinsサーバーのベースURLを設定するためのフォームを提供する。

**業務上の目的・背景**：JenkinsのルートURLは、ビルド通知メールに含まれるリンク、Webhook設定、プラグインのコールバックURL等、様々な機能で使用される重要な設定である。初期セットアップ時に正しいURLを設定しておくことで、これらの機能が正常に動作し、ユーザーがJenkinsの各種リソースに正しくアクセスできるようになる。また、リバースプロキシ環境やDocker環境では、自動検出されるURLが実際のアクセスURLと異なる場合があるため、明示的な設定が必要となる。

**画面へのアクセス方法**：セットアップウィザードの初回ユーザー作成ステップ完了後、自動的に遷移する。直接アクセスする場合は`/setupWizard/setupWizardConfigureInstance`にアクセスする。

**主要な操作・処理内容**：
1. JenkinsのルートURL（Jenkins URL）の入力
2. URLの形式検証
3. インスタンス設定の保存

**画面遷移**：
- 遷移元：初回ユーザー作成画面（setupWizardFirstUser）
- 遷移先：ダッシュボード（セットアップ完了後）

**権限による表示制御**：セットアップウィザードコンテキスト内でのみ表示される。`Jenkins.ADMINISTER`権限が必要。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 45 | システム設定 | 主機能 | JenkinsインスタンスURL等の設定 |
| 1 | Jenkins本体 | 補助機能 | コア設定の初期化 |

## 画面種別

設定（フォーム入力）

## URL/ルーティング

- URL: `/setupWizard/setupWizardConfigureInstance`
- テンプレート: `core/src/main/resources/jenkins/install/SetupWizard/setupWizardConfigureInstance.jelly`
- POSTアクション: `/setupWizard/configureInstance`

## 入出力項目

| 項目名 | 項目ID | 入力/出力 | 型 | 必須 | 説明 |
|--------|--------|----------|-----|------|------|
| Jenkins URL | rootUrl | 入力 | String | 必須 | JenkinsサーバーのベースURL（例: http://localhost:8080/） |

## 表示項目

| 項目名 | 表示条件 | 説明 |
|--------|----------|------|
| タイトル | 常時 | "Instance Configuration" |
| Jenkins URL入力フィールド | 常時 | URL入力用のテキストボックス |
| ヘルプテキスト | 常時 | Jenkins URLの説明テキスト |
| エラーパネル | エラー時 | 入力検証エラーの表示領域 |

## イベント仕様

### 1-ページ読み込み

ページ読み込み時にJavaScriptによって初期値が設定される。

処理フロー：
1. `setInitialRootUrlFieldValue`アジャンクトが読み込まれる
2. リクエストから現在のJenkins URLを取得
3. `root-url`入力フィールドに初期値を設定

### 2-フォーム送信（インスタンス設定）

フォーム送信時に`SetupWizard.doConfigureInstance()`メソッドが呼び出される。

処理フロー：
1. `Jenkins.ADMINISTER`権限の確認
2. URLの検証処理（`checkRootUrl()`）
   - 空チェック
   - 有効なURL形式かどうかの検証（`UrlHelper.isValidRootUrl()`）
3. エラーがあればエラーレスポンスを返却
4. URLの適用処理（`useRootUrl()`）
   - `JenkinsLocationConfiguration.setUrl()`で設定を保存
5. インストール状態を`CONFIGURE_INSTANCE`から次の状態へ遷移
6. JSON形式でCRUMB情報を含むレスポンスを返却

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| インスタンス設定保存 | ファイルシステム | UPDATE | JenkinsLocationConfiguration.xmlの更新 |

### テーブル別更新項目詳細

#### ファイルシステム（$JENKINS_HOME/）

| 操作 | 項目（ファイル名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| UPDATE | jenkins.model.JenkinsLocationConfiguration.xml | rootUrl: 入力されたURL | グローバル設定ファイル |

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|-------------|------|--------------|----------|
| Instance Configuration | 情報 | インスタンス設定 | 画面タイトル |
| Jenkins URL | 情報 | Jenkins URL: | ラベル |
| jenkinsURL_help | 情報 | JenkinsのルートURLを入力してください | ヘルプテキスト |
| ConfigureInstance.ValidationErrors | エラー | 検証エラーがあります | 検証失敗時 |
| ConfigureInstance.RootUrl.Empty | エラー | URLを入力してください | URL未入力時 |
| ConfigureInstance.RootUrl.Invalid | エラー | 有効なURLを入力してください | URL形式不正時 |

## 例外処理

| 例外種別 | 発生条件 | 処理内容 |
|----------|----------|----------|
| URL未入力 | rootUrlがnullまたは空 | エラーメッセージを含むJSONレスポンスを返却 |
| URL形式不正 | 有効なURL形式でない | エラーメッセージを含むJSONレスポンスを返却 |
| 権限不足 | ADMINISTER権限がない | アクセス拒否エラー |

## 備考

- このフォームは`norefresh="true"`が設定されており、自動リフレッシュが無効化されている
- 初期値は`setInitialRootUrlFieldValue`アジャンクトによってJavaScriptで設定される
- URL検証には`jenkins.util.UrlHelper.isValidRootUrl()`メソッドが使用される
- 設定は`JenkinsLocationConfiguration`に保存され、`jenkins.model.JenkinsLocationConfiguration.xml`ファイルに永続化される

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、Jenkins設定の保存先と構造を理解することが重要。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | JenkinsLocationConfiguration.java | `core/src/main/java/jenkins/model/JenkinsLocationConfiguration.java` | URL設定の保存先と取得方法 |
| 1-2 | UrlHelper.java | `core/src/main/java/jenkins/util/UrlHelper.java` | URL検証ロジック |

**読解のコツ**: `JenkinsLocationConfiguration`がシングルトンとして動作し、XMLファイルに設定を永続化する仕組みを把握する。

#### Step 2: エントリーポイントを理解する

処理の起点となるファイル・関数を特定。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | setupWizardConfigureInstance.jelly | `core/src/main/resources/jenkins/install/SetupWizard/setupWizardConfigureInstance.jelly` | フォームのHTMLテンプレート |

**主要処理フロー**:
1. **27行目**: `norefresh="true"`でレイアウト設定
2. **30行目**: フォームアクションが`/setupWizard/configureInstance`に設定
3. **37行目**: URL入力フィールド
4. **48行目**: `setInitialRootUrlFieldValue`アジャンクトの読み込み

#### Step 3: バックエンド処理を理解する

インスタンス設定のサーバーサイド処理。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | SetupWizard.java | `core/src/main/java/jenkins/install/SetupWizard.java` | `doConfigureInstance()`メソッド（416-444行目） |
| 3-2 | SetupWizard.java | `core/src/main/java/jenkins/install/SetupWizard.java` | `checkRootUrl()`メソッド（446-454行目） |
| 3-3 | SetupWizard.java | `core/src/main/java/jenkins/install/SetupWizard.java` | `useRootUrl()`メソッド（456-459行目） |

**主要処理フロー**:
- **419行目**: 権限チェック `Jenkins.get().checkPermission(Jenkins.ADMINISTER)`
- **421-423行目**: エラーマップの初期化とURL検証
- **425-427行目**: 検証エラー時のエラーレスポンス返却
- **430-433行目**: URL適用とエラーチェック
- **436行目**: 状態遷移処理

### プログラム呼び出し階層図

```
setupWizardConfigureInstance.jelly
    │
    ├─ setInitialRootUrlFieldValue (JavaScript)
    │      └─ 初期URL値の設定
    │
    └─ フォームPOST → /setupWizard/configureInstance
           │
           └─ SetupWizard.doConfigureInstance()
                  │
                  ├─ Jenkins.checkPermission(ADMINISTER)
                  │
                  ├─ checkRootUrl()
                  │      └─ UrlHelper.isValidRootUrl()
                  │
                  ├─ useRootUrl()
                  │      └─ JenkinsLocationConfiguration.setUrl()
                  │
                  └─ InstallUtil.proceedToNextStateFrom()
```

### データフロー図

```
[入力]                      [処理]                           [出力]

Jenkins URL入力 ────────▶ ┌─────────────────────────┐
                          │ doConfigureInstance()   │
                          │                         │
                          │ 1. 権限チェック         │
                          │ 2. URL検証              │──▶ エラーレスポンス（検証失敗時）
                          │ 3. URL保存              │
                          └─────────────────────────┘
                                   │
                                   ▼
                          JenkinsLocationConfiguration.xml 更新
                                   │
                                   ▼
                          InstallState遷移
                                   │
                                   ▼
                          ダッシュボードへ
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| setupWizardConfigureInstance.jelly | `core/src/main/resources/jenkins/install/SetupWizard/setupWizardConfigureInstance.jelly` | テンプレート | メイン画面テンプレート |
| SetupWizard.java | `core/src/main/java/jenkins/install/SetupWizard.java` | ソース | コントローラー |
| JenkinsLocationConfiguration.java | `core/src/main/java/jenkins/model/JenkinsLocationConfiguration.java` | ソース | URL設定管理 |
| UrlHelper.java | `core/src/main/java/jenkins/util/UrlHelper.java` | ソース | URL検証ユーティリティ |
| setInitialRootUrlFieldValue.js | `core/src/main/resources/jenkins/install/SetupWizard/setInitialRootUrlFieldValue.js` | JavaScript | 初期値設定スクリプト |
