# 画面設計書 54-セキュリティトークン認証

## 概要

本ドキュメントは、Jenkins初回起動時のセットアップウィザードで初期管理パスワードを入力する認証画面の設計仕様を定義するものである。

### 本画面の処理概要

セキュリティトークン認証画面は、Jenkins初回起動時に自動生成された初期管理パスワード（セキュリティトークン）を入力して認証を行う画面である。この認証を通過しないとセットアップウィザードに進むことができない。

**業務上の目的・背景**：Jenkins初回インストール時、サーバーにファイルシステムアクセス権限を持つ正当な管理者のみがセットアップを実行できるようにするためのセキュリティ対策である。初期管理パスワードは`$JENKINS_HOME/secrets/initialAdminPassword`ファイルに保存されており、このファイルにアクセスできる人物のみがパスワードを知ることができる。これにより、ネットワーク経由の不正アクセスや未認証ユーザーによるセットアップ乗っ取りを防止する。

**画面へのアクセス方法**：Jenkins初回起動後、セットアップウィザードフィルターが有効な状態でJenkinsにアクセスすると、この画面が表示される。`/setupWizard/authenticate-security-token`に直接アクセスすることも可能。

**主要な操作・処理内容**：
1. 初期管理パスワード（セキュリティトークン）の入力
2. Continueボタンの押下
3. パスワード検証と認証処理

**画面遷移**：
- 遷移元：Jenkins初回起動
- 遷移先：セットアップウィザード（認証成功時）
- 遷移先：同画面（認証失敗時、エラーメッセージ表示）

**権限による表示制御**：この画面は認証前に表示されるため、特別な権限チェックは行われない。ただし、認証成功後に`Jenkins.ADMINISTER`権限が付与される。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 28 | 認証（SecurityRealm） | 主機能 | 初期管理パスワードによる認証 |
| 34 | 機密情報管理 | 補助機能 | セキュリティトークンの検証 |

## 画面種別

認証（ログイン）

## URL/ルーティング

- URL: `/setupWizard/authenticate-security-token`
- テンプレート: `core/src/main/resources/jenkins/install/SetupWizard/authenticate-security-token.jelly`
- POSTアクション: `${app.instance.securityRealm.authenticationGatewayUrl}`

## 入出力項目

| 項目名 | 項目ID | 入力/出力 | 型 | 必須 | 説明 |
|--------|--------|----------|-----|------|------|
| ユーザー名 | j_username | 入力（hidden） | String | 必須 | 固定値"admin"（初期管理者ユーザー名） |
| パスワード | j_password | 入力 | String | 必須 | 初期管理パスワード（セキュリティトークン） |
| 遷移元 | from | 入力（hidden） | String | 任意 | 認証成功後のリダイレクト先 |
| CRUMBトークン | (crumb field) | 入力（hidden） | String | 必須 | CSRF保護トークン |

## 表示項目

| 項目名 | 表示条件 | 説明 |
|--------|----------|------|
| モーダルヘッダー | 常時 | "Getting Started" |
| タイトル | 常時 | "Unlock Jenkins" |
| パスワードファイルパス説明 | 常時 | initialAdminPasswordファイルの場所を説明 |
| パスワードコピー指示 | 常時 | パスワードをコピーして貼り付けるよう指示 |
| エラーアラート | 認証失敗時 | "The password entered is incorrect" |
| パスワード入力フィールド | 常時 | セキュリティトークン入力用テキストボックス |
| Continueボタン | 常時 | 認証実行ボタン |

## イベント仕様

### 1-フォーム送信（認証）

フォーム送信時にセキュリティレルムの認証ゲートウェイに認証リクエストが送信される。

処理フロー：
1. フォームがセキュリティレルムの`authenticationGatewayUrl`にPOSTされる
2. ユーザー名（固定値: admin）とパスワードで認証を試行
3. `HudsonPrivateSecurityRealm`がパスワードを検証
4. 検証成功時：セッション確立後、セットアップウィザードにリダイレクト
5. 検証失敗時：エラーパラメータ付きで同画面に戻る

### 2-認証失敗時のエラー表示

`error`パラメータがtrueの場合：
1. エラーアラートボックスを表示
2. パスワード入力フィールドにエラースタイル（danger）を適用
3. 再入力を促す

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 認証成功 | メモリ/セッション | UPDATE | セッション情報の確立 |

### テーブル別更新項目詳細

この画面ではファイルシステムへの永続的な更新は行われない。認証成功時にHTTPセッションが確立される。

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|-------------|------|--------------|----------|
| authenticate-security-token.getting.started | 情報 | Getting Started | モーダルヘッダー |
| authenticate-security-token.unlock.jenkins | 情報 | Unlock Jenkins | メインタイトル |
| jenkins.install.findSecurityTokenMessage | 情報 | To ensure Jenkins is securely set up by the administrator, a password has been written to the log (not sure where to find it?) and this file on the server: {0} | パスワードファイル説明 |
| authenticate-security-token.copy.password | 情報 | Please copy the password from either location and paste it below. | 操作指示 |
| authenticate-security-token.error | エラー | Error | エラーラベル |
| authenticate-security-token.password.incorrect | エラー | The password entered is incorrect | 認証失敗時 |
| authenticate-security-token.password.administrator | 情報 | Administrator password | 入力フィールドラベル |
| authenticate-security-token.continue | 情報 | Continue | ボタンラベル |

## 例外処理

| 例外種別 | 発生条件 | 処理内容 |
|----------|----------|----------|
| 認証失敗 | パスワードが不正 | error=trueパラメータ付きで同画面にリダイレクト |
| セキュリティレルム未設定 | SecurityRealmが設定されていない | 例外発生（通常起こらない） |

## 備考

- 初期管理者ユーザー名は`SetupWizard.initialSetupAdminUserName`で定義されており、デフォルト値は"admin"
- 初期管理パスワードファイルは`$JENKINS_HOME/secrets/initialAdminPassword`に保存される
- パスワードファイルのパーミッションは0640（所有者読み書き、グループ読み取り）
- レイアウトは`full-screen`タイプでモーダル風のデザイン
- Bootstrap 3のスタイルが適用されている（`bootstrap-3`クラス）
- CSRF保護のためCRUMBトークンが含まれる

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、初期管理パスワードの生成と保存の仕組みを理解することが重要。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | SetupWizard.java | `core/src/main/java/jenkins/install/SetupWizard.java` | `getInitialAdminPasswordFile()`メソッド（688-689行目） |
| 1-2 | SetupWizard.java | `core/src/main/java/jenkins/install/SetupWizard.java` | `init()`メソッド内のパスワード生成（152-166行目） |

**読解のコツ**: `UUID.randomUUID()`で生成されたパスワードがどのようにファイルに保存されるかを把握する。

#### Step 2: エントリーポイントを理解する

処理の起点となるファイル・関数を特定。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | authenticate-security-token.jelly | `core/src/main/resources/jenkins/install/SetupWizard/authenticate-security-token.jelly` | フォームのHTMLテンプレート |

**主要処理フロー**:
1. **7行目**: フォームアクションが`authenticationGatewayUrl`に設定
2. **8-9行目**: hidden項目（from, crumb）
3. **29行目**: j_usernameがhiddenで"admin"に固定
4. **30行目**: j_passwordのパスワード入力フィールド
5. **35行目**: Continueボタン

#### Step 3: 認証処理を理解する

パスワード検証のサーバーサイド処理。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | SetupWizard.java | `core/src/main/java/jenkins/install/SetupWizard.java` | `isUsingSecurityDefaults()`メソッド（308-327行目） |
| 3-2 | HudsonPrivateSecurityRealm.java | `core/src/main/java/hudson/security/HudsonPrivateSecurityRealm.java` | パスワード検証ロジック |

**主要処理フロー**:
- **313行目**: ユーザー数が1であることを確認
- **314行目**: adminユーザーの詳細を読み込み
- **316-318行目**: パスワードファイルの内容と入力パスワードを比較

### プログラム呼び出し階層図

```
authenticate-security-token.jelly
    │
    └─ フォームPOST → SecurityRealm.authenticationGatewayUrl
           │
           ├─ 認証成功
           │      │
           │      └─ セットアップウィザードにリダイレクト
           │             └─ /setupWizard/
           │
           └─ 認証失敗
                  │
                  └─ 同画面にリダイレクト（error=true）
                         └─ エラーメッセージ表示
```

### データフロー図

```
[入力]                      [処理]                           [出力]

j_username (hidden) ───▶ ┌─────────────────────────┐
"admin"                  │                         │
                         │ SecurityRealm           │
j_password ────────────▶ │ 認証処理                │
(セキュリティトークン)    │                         │
                         │ パスワード検証          │
                         └─────────────────────────┘
                                   │
                    ┌──────────────┴──────────────┐
                    │                            │
                    ▼                            ▼
              認証成功                        認証失敗
                    │                            │
                    ▼                            ▼
           /setupWizard/へ               同画面（error=true）
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| authenticate-security-token.jelly | `core/src/main/resources/jenkins/install/SetupWizard/authenticate-security-token.jelly` | テンプレート | メイン画面テンプレート |
| client-scripts.jelly | `core/src/main/resources/jenkins/install/SetupWizard/client-scripts.jelly` | テンプレート | クライアントスクリプト |
| SetupWizard.java | `core/src/main/java/jenkins/install/SetupWizard.java` | ソース | ウィザードコントローラー |
| HudsonPrivateSecurityRealm.java | `core/src/main/java/hudson/security/HudsonPrivateSecurityRealm.java` | ソース | 認証レルム |
| authenticate-security-token.properties | `core/src/main/resources/jenkins/install/SetupWizard/authenticate-security-token.properties` | 設定 | メッセージリソース |
