# 画面設計書 55-プロキシ設定

## 概要

本ドキュメントは、セットアップウィザード内でHTTPプロキシサーバーの設定を行う画面の設計仕様を定義するものである。

### 本画面の処理概要

プロキシ設定画面は、Jenkinsセットアップウィザードのオプションステップとして、外部ネットワーク接続に使用するHTTPプロキシサーバーの設定を行うためのフォームを提供する。

**業務上の目的・背景**：企業ネットワーク等でインターネット接続にプロキシサーバーを経由する必要がある環境では、Jenkinsがプラグインのダウンロードや更新サイトへのアクセスを行うためにプロキシ設定が必須となる。セットアップウィザード中にプロキシを設定することで、推奨プラグインのインストールが円滑に行える。また、後からシステム設定画面でも変更可能だが、初期セットアップ時に設定しておくことで、プラグインインストールの失敗を防止できる。

**画面へのアクセス方法**：セットアップウィザードのプラグイン選択前に、ネットワーク接続に問題がある場合に表示される。直接アクセスする場合は`/setupWizard/proxy-configuration`にアクセスする。

**主要な操作・処理内容**：
1. プロキシサーバーのホスト名/IPアドレスの入力
2. プロキシサーバーのポート番号の入力
3. プロキシ認証用のユーザー名（オプション）
4. プロキシ認証用のパスワード（オプション）
5. プロキシを使用しないホストの指定（オプション）
6. プロキシ設定の保存

**画面遷移**：
- 遷移元：セットアップウィザード（接続問題検出時）
- 遷移先：セットアップウィザード（プラグイン選択）

**権限による表示制御**：セットアップウィザードコンテキスト内でのみ表示される。通常は`Jenkins.ADMINISTER`権限が必要。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 49 | プロキシ設定 | 主機能 | セットアップ時のプロキシ設定 |

## 画面種別

設定（フォーム入力）

## URL/ルーティング

- URL: `/setupWizard/proxy-configuration`
- テンプレート: `core/src/main/resources/jenkins/install/SetupWizard/proxy-configuration.jelly`
- POSTアクション: `/pluginManager/proxyConfigure`

## 入出力項目

| 項目名 | 項目ID | 入力/出力 | 型 | 必須 | 説明 |
|--------|--------|----------|-----|------|------|
| サーバー | server | 入力 | String | 必須 | プロキシサーバーのホスト名またはIPアドレス |
| ポート | port | 入力 | Integer | 必須 | プロキシサーバーのポート番号 |
| ユーザー名 | userName | 入力 | String | 任意 | プロキシ認証用ユーザー名 |
| パスワード | password | 入力 | String | 任意 | プロキシ認証用パスワード |
| 除外ホスト | noProxyHost | 入力 | String | 任意 | プロキシを経由しないホスト（改行区切り） |

## 表示項目

| 項目名 | 表示条件 | 説明 |
|--------|----------|------|
| タイトル | 常時 | "HTTP Proxy Configuration" |
| プロキシ設定フォーム | 常時 | ProxyConfiguration.configPageで生成されるフォーム |

## イベント仕様

### 1-フォーム送信（プロキシ設定保存）

フォーム送信時に`PluginManager`の`proxyConfigure`アクションが呼び出される。

処理フロー：
1. フォームが`/pluginManager/proxyConfigure`にPOSTされる
2. `ProxyConfiguration`オブジェクトの設定ページから入力値を取得
3. プロキシ設定を検証
4. 設定を`ProxyConfiguration`に保存
5. `$JENKINS_HOME/proxy.xml`ファイルに永続化

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| プロキシ設定保存 | ファイルシステム | INSERT/UPDATE | proxy.xmlの作成/更新 |

### テーブル別更新項目詳細

#### ファイルシステム（$JENKINS_HOME/）

| 操作 | 項目（ファイル名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT/UPDATE | proxy.xml | プロキシ設定情報 | ProxyConfigurationのシリアライズ |

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|-------------|------|--------------|----------|
| HTTP Proxy Configuration | 情報 | HTTPプロキシ設定 | 画面タイトル |

## 例外処理

| 例外種別 | 発生条件 | 処理内容 |
|----------|----------|----------|
| 設定保存失敗 | ファイル書き込みエラー | エラーメッセージを表示 |
| 接続テスト失敗 | プロキシ経由の接続が失敗 | 警告メッセージを表示 |

## 備考

- プロキシ設定は`hudson.ProxyConfiguration`クラスで管理される
- 設定フォームは`ProxyConfiguration`のDescriptorの`configPage`を使用して動的に生成される
- この画面のレイアウトは`full-screen`タイプ
- プロキシ設定は`$JENKINS_HOME/proxy.xml`に保存される
- プロキシ認証のパスワードはSecretとして暗号化保存される

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、プロキシ設定のデータ構造を理解することが重要。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | ProxyConfiguration.java | `core/src/main/java/hudson/ProxyConfiguration.java` | プロキシ設定のフィールドと永続化 |

**読解のコツ**: `ProxyConfiguration`がどのようなフィールドを持ち、どのように`proxy.xml`に保存されるかを把握する。

#### Step 2: エントリーポイントを理解する

処理の起点となるファイル・関数を特定。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | proxy-configuration.jelly | `core/src/main/resources/jenkins/install/SetupWizard/proxy-configuration.jelly` | フォームのHTMLテンプレート |

**主要処理フロー**:
1. **16行目**: フォームアクションが`/pluginManager/proxyConfigure`に設定
2. **18行目**: `app.proxy`で現在のプロキシ設定を取得
3. **19行目**: `app.pluginManager.proxyDescriptor`でフォーム定義を取得
4. **20行目**: `st:include`でDescriptorのconfigPageを読み込み

#### Step 3: バックエンド処理を理解する

プロキシ設定のサーバーサイド処理。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | PluginManager.java | `core/src/main/java/hudson/PluginManager.java` | `proxyConfigure`アクション |
| 3-2 | ProxyConfiguration.java | `core/src/main/java/hudson/ProxyConfiguration.java` | 設定の保存処理 |

### プログラム呼び出し階層図

```
proxy-configuration.jelly
    │
    ├─ app.proxy → ProxyConfiguration（現在の設定）
    │
    ├─ app.pluginManager.proxyDescriptor
    │      └─ ProxyConfiguration.DescriptorImpl
    │
    └─ フォームPOST → /pluginManager/proxyConfigure
           │
           └─ PluginManager.doProxyConfigure()
                  │
                  └─ ProxyConfiguration.save()
                         └─ proxy.xml 書き込み
```

### データフロー図

```
[入力]                      [処理]                           [出力]

サーバー ──────────────▶ ┌─────────────────────────┐
ポート ────────────────▶ │                         │
ユーザー名 ────────────▶ │ PluginManager           │
パスワード ────────────▶ │ .doProxyConfigure()     │──▶ proxy.xml
除外ホスト ────────────▶ │                         │
                         │ ProxyConfiguration      │
                         │ .save()                 │
                         └─────────────────────────┘
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| proxy-configuration.jelly | `core/src/main/resources/jenkins/install/SetupWizard/proxy-configuration.jelly` | テンプレート | メイン画面テンプレート |
| ProxyConfiguration.java | `core/src/main/java/hudson/ProxyConfiguration.java` | ソース | プロキシ設定管理 |
| PluginManager.java | `core/src/main/java/hudson/PluginManager.java` | ソース | プラグイン管理（プロキシ設定含む） |
| config.jelly | `core/src/main/resources/hudson/ProxyConfiguration/config.jelly` | テンプレート | プロキシ設定フォーム定義 |
