# 画面設計書 56-ログレコーダー一覧

## 概要

本ドキュメントは、Jenkinsのログレコーダー一覧画面の設計仕様を定義するものである。

### 本画面の処理概要

ログレコーダー一覧画面は、Jenkinsで設定されているカスタムログレコーダーの一覧を表示し、ログレコーダーの管理を行うための画面である。

**業務上の目的・背景**：Jenkins運用時に問題が発生した場合、特定のコンポーネントやプラグインのログを詳細に記録して分析する必要がある。標準のJenkinsログでは情報量が不十分な場合があり、ログレコーダーを使用することで特定のJavaパッケージやクラスのログレベルを変更し、より詳細なデバッグ情報を取得できる。本画面はこれらのログレコーダーを一元管理し、効率的なトラブルシューティングを支援する。

**画面へのアクセス方法**：Jenkins管理画面（`/manage`）から「System Log」リンクをクリック、または直接`/log/`にアクセスする。

**主要な操作・処理内容**：
1. 既存のログレコーダー一覧の表示
2. 新規ログレコーダーの作成
3. ログレコーダーの設定画面への遷移
4. ログレベル設定画面への遷移
5. 全Jenkinsログの表示

**画面遷移**：
- 遷移元：Jenkins管理画面（ManageJenkinsAction）
- 遷移先：ログレコーダー詳細（個別のログレコーダー）
- 遷移先：全Jenkinsログ（`/log/all`）
- 遷移先：ログレベル設定（`/log/levels`）
- 遷移先：ログレコーダー設定（`/log/{name}/configure`）

**権限による表示制御**：`Jenkins.SYSTEM_READ`権限で閲覧可能。「Add recorder」ボタンは`Jenkins.ADMINISTER`権限を持つユーザーのみ表示される。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 50 | ログ管理 | 主機能 | ログレコーダーの一覧表示 |

## 画面種別

一覧

## URL/ルーティング

- URL: `/log/`
- コントローラー: `hudson.logging.LogRecorderManager`
- テンプレート: `core/src/main/resources/hudson/logging/LogRecorderManager/index.jelly`

## 入出力項目

| 項目名 | 項目ID | 入力/出力 | 型 | 必須 | 説明 |
|--------|--------|----------|-----|------|------|
| レコーダー名 | name | 入力（新規作成時） | String | 必須 | 新規ログレコーダーの名前 |

## 表示項目

| 項目名 | 表示条件 | 説明 |
|--------|----------|------|
| タイトル | 常時 | ログレコーダー管理画面のタイトル |
| 説明 | 常時 | ログレコーダー機能の説明 |
| Add recorderボタン | ADMINISTER権限時 | 新規ログレコーダー作成ボタン |
| Log levelsボタン | 常時 | ログレベル設定画面へのリンク |
| ヘルプリンク | 常時 | ログレコーダーの追加情報へのリンク |
| ログレコーダーテーブル | 常時 | 登録済みログレコーダーの一覧 |
| All Jenkins Logs | 常時 | 全Jenkinsログへのリンク |
| 設定ボタン | ADMINISTER権限時 | 各レコーダーの設定画面へのリンク |

## イベント仕様

### 1-ページ読み込み

ページ読み込み時に`LogRecorderManager.getRecorders()`が呼び出され、登録済みのログレコーダー一覧を取得する。

処理フロー：
1. `StaplerProxy.getTarget()`で権限チェック（`Jenkins.SYSTEM_READ`）
2. `getRecorders()`でログレコーダーリストを取得
3. テーブルにレコーダー情報を表示

### 2-新規レコーダー作成

「Add recorder」ボタンクリック時に`/log/new`に遷移し、`doNewLogRecorder()`が呼び出される。

処理フロー：
1. `Jenkins.ADMINISTER`権限の確認
2. `Jenkins.checkGoodName()`で名前の検証
3. 新規`LogRecorder`オブジェクトを作成
4. レコーダーリストに追加
5. 設定画面（`{name}/configure`）にリダイレクト

### 3-ログレコーダー詳細へ遷移

レコーダー名リンククリック時に該当レコーダーの詳細画面に遷移。

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 新規レコーダー作成 | ファイルシステム | INSERT | ログレコーダー設定XMLの作成 |

### テーブル別更新項目詳細

#### ファイルシステム（$JENKINS_HOME/log/）

| 操作 | 項目（ファイル名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT | {レコーダー名}.xml | LogRecorder設定 | 新規作成時 |

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|-------------|------|--------------|----------|
| LogRecorderManager.DisplayName | 情報 | System Log | 画面タイトル |
| Add recorder | 情報 | Add recorder | ボタンラベル |
| Log levels | 情報 | Log levels | ボタンラベル |
| Additional information on log recorders | 情報 | ログレコーダーの追加情報 | ヘルプツールチップ |
| Name | 情報 | Name | テーブルヘッダー |
| All Jenkins Logs | 情報 | All Jenkins Logs | リンクテキスト |

## 例外処理

| 例外種別 | 発生条件 | 処理内容 |
|----------|----------|----------|
| 権限不足 | SYSTEM_READ権限がない | アクセス拒否 |
| 不正な名前 | レコーダー名が無効 | Failureをスロー |

## 備考

- ログレコーダーの設定ファイルは`$JENKINS_HOME/log/`ディレクトリに保存される
- テーブルは`sortable`クラスが付いており、名前でソート可能
- `l:settings-subpage`レイアウトを使用した設定画面スタイル
- 管理リンクは`SystemLogLink`クラスから取得

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、ログレコーダーのデータ構造を理解することが重要。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | LogRecorderManager.java | `core/src/main/java/hudson/logging/LogRecorderManager.java` | マネージャークラスの構造とレコーダーリスト管理 |
| 1-2 | LogRecorder.java | `core/src/main/java/hudson/logging/LogRecorder.java` | 個別のログレコーダーの構造 |

**読解のコツ**: `LogRecorderManager`がどのように複数の`LogRecorder`を管理し、URLルーティングを行うかを把握する。

#### Step 2: エントリーポイントを理解する

処理の起点となるファイル・関数を特定。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | index.jelly | `core/src/main/resources/hudson/logging/LogRecorderManager/index.jelly` | 画面のHTMLテンプレート |

**主要処理フロー**:
1. **30-49行目**: ヘッダー部分（タイトル、ボタン）の定義
2. **51行目**: `l:settings-subpage`レイアウトの使用
3. **63-84行目**: ログレコーダーテーブルの生成
4. **71-81行目**: 各レコーダーの行を`j:forEach`でループ生成

#### Step 3: バックエンド処理を理解する

ログレコーダー管理のサーバーサイド処理。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | LogRecorderManager.java | `core/src/main/java/hudson/logging/LogRecorderManager.java` | `doNewLogRecorder()`メソッド（167-177行目） |
| 3-2 | LogRecorderManager.java | `core/src/main/java/hudson/logging/LogRecorderManager.java` | `getTarget()`メソッド（294-300行目）での権限チェック |

**主要処理フロー**:
- **169行目**: 権限チェック `Jenkins.get().checkPermission(Jenkins.ADMINISTER)`
- **171行目**: 名前の検証 `Jenkins.checkGoodName(name)`
- **173行目**: 新規LogRecorderをリストに追加
- **176行目**: 設定画面にリダイレクト

### プログラム呼び出し階層図

```
/log/ アクセス
    │
    ├─ LogRecorderManager.getTarget()
    │      └─ 権限チェック (SYSTEM_READ)
    │
    └─ index.jelly レンダリング
           │
           ├─ getRecorders() → ログレコーダーリスト取得
           │
           ├─ "Add recorder" クリック → /log/new
           │      └─ doNewLogRecorder()
           │             ├─ 権限チェック (ADMINISTER)
           │             ├─ LogRecorder作成
           │             └─ {name}/configure へリダイレクト
           │
           └─ レコーダー名クリック → /{name}/ へ遷移
```

### データフロー図

```
[入力]                      [処理]                           [出力]

アクセス要求 ──────────▶ ┌─────────────────────────┐
                          │ LogRecorderManager     │
                          │                         │
                          │ getTarget() 権限チェック│
                          │ getRecorders() 取得     │
                          └─────────────────────────┘
                                   │
                                   ▼
                          ログレコーダー一覧表示
                                   │
           ┌───────────────────────┴───────────────────────┐
           │                       │                       │
           ▼                       ▼                       ▼
    "All Jenkins Logs"      レコーダー詳細         "Add recorder"
    → /log/all              → /log/{name}/        → /log/new
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| index.jelly | `core/src/main/resources/hudson/logging/LogRecorderManager/index.jelly` | テンプレート | メイン画面テンプレート |
| LogRecorderManager.java | `core/src/main/java/hudson/logging/LogRecorderManager.java` | ソース | マネージャークラス |
| LogRecorder.java | `core/src/main/java/hudson/logging/LogRecorder.java` | ソース | レコーダークラス |
| SystemLogLink.java | `core/src/main/java/jenkins/management/SystemLogLink.java` | ソース | 管理リンク |
| feeds.jelly | `core/src/main/resources/hudson/logging/LogRecorderManager/feeds.jelly` | テンプレート | RSSフィード |
