# 画面設計書 57-ログレコーダー詳細

## 概要

本ドキュメントは、特定のログレコーダーの詳細画面の設計仕様を定義するものである。

### 本画面の処理概要

ログレコーダー詳細画面は、特定のログレコーダーがキャプチャしたログレコードを表示し、レコーダーの管理操作を行うための画面である。

**業務上の目的・背景**：ログレコーダーで特定のJavaパッケージやクラスのログを収集した後、そのログを確認・分析する必要がある。本画面では、レコーダーが収集したログエントリを時系列で表示し、問題の特定や原因分析を支援する。また、エージェント（スレーブ）ノードのログも統合して表示することで、分散環境でのデバッグを効率化する。

**画面へのアクセス方法**：ログレコーダー一覧画面から特定のレコーダー名をクリック、または直接`/log/{レコーダー名}/`にアクセスする。

**主要な操作・処理内容**：
1. ログレコードの表示
2. ログのクリア
3. レコーダーの設定変更
4. RSSフィードの購読
5. レコーダーの削除

**画面遷移**：
- 遷移元：ログレコーダー一覧（`/log/`）
- 遷移先：レコーダー設定画面（`/log/{name}/configure`）
- 遷移先：ログレコーダー一覧（削除後）

**権限による表示制御**：`Jenkins.SYSTEM_READ`権限で閲覧可能。「Clear This Log」「Configure」「Delete log recorder」は`Jenkins.ADMINISTER`権限を持つユーザーのみ表示される。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 50 | ログ管理 | 主機能 | ログレコーダーの詳細・ログ出力表示 |

## 画面種別

詳細

## URL/ルーティング

- URL: `/log/{レコーダー名}/`
- コントローラー: `hudson.logging.LogRecorder`
- テンプレート: `core/src/main/resources/hudson/logging/LogRecorder/index.jelly`

## 入出力項目

この画面は主に表示専用であり、入力項目は存在しない。

## 表示項目

| 項目名 | 表示条件 | 説明 |
|--------|----------|------|
| タイトル | 常時 | ログレコーダー名 |
| Clear This Logボタン | ADMINISTER権限、ログあり | ログクリアボタン |
| Configureボタン | ADMINISTER権限 | 設定画面へのリンク |
| Atom feedメニュー | 常時 | RSSフィード購読メニュー |
| Delete log recorderリンク | ADMINISTER権限 | レコーダー削除リンク |
| No logs availableメッセージ | ログなし時 | ログがない場合の通知 |
| ログレコードテーブル | ログあり時 | コントローラーのログレコード |
| エージェントログセクション | エージェントログあり時 | 各エージェントのログレコード |

## イベント仕様

### 1-ページ読み込み

ページ読み込み時にログレコーダーの情報とログレコードを取得する。

処理フロー：
1. `LogRecorder.getLogRecords()`でコントローラーのログを取得
2. `LogRecorder.getSlaveLogRecords()`でエージェントのログを取得
3. ログをフォーマットしてテーブルに表示

### 2-ログクリア

「Clear This Log」ボタン押下時に`doClear()`が呼び出される。

処理フロー：
1. `Jenkins.ADMINISTER`権限の確認
2. `handler.clear()`でログバッファをクリア
3. 同じ画面にリダイレクト

### 3-レコーダー削除

「Delete log recorder」リンク確認後に`doDoDelete()`が呼び出される。

処理フロー：
1. `Jenkins.ADMINISTER`権限の確認
2. 設定ファイルの削除
3. 親マネージャーからレコーダーを除去
4. ログターゲットの無効化
5. ログレコーダー一覧にリダイレクト

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| レコーダー削除 | ファイルシステム | DELETE | 設定XMLファイルの削除 |
| ログクリア | メモリ | UPDATE | リングバッファのクリア |

### テーブル別更新項目詳細

#### ファイルシステム（$JENKINS_HOME/log/）

| 操作 | 項目（ファイル名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| DELETE | {レコーダー名}.xml | - | 削除時 |

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|-------------|------|--------------|----------|
| Clear This Log | 情報 | Clear This Log | ボタンラベル |
| Configure | 情報 | Configure | ボタンラベル |
| Atom feed | 情報 | Atom feed | メニューヘッダー |
| Delete log recorder | 情報 | Delete log recorder | リンクラベル |
| delete.logrecorder | 確認 | Are you sure you want to delete {0}? | 削除確認メッセージ |
| No logs available | 情報 | No logs available | ログなし時 |

## 例外処理

| 例外種別 | 発生条件 | 処理内容 |
|----------|----------|----------|
| 権限不足 | SYSTEM_READ権限がない | アクセス拒否 |
| レコーダー未存在 | 指定された名前のレコーダーがない | 404エラー |

## 備考

- ログはリングバッファ（`RingBufferLogHandler`）に保存され、一定数を超えると古いものから削除される
- エージェントのログは`getSlaveLogRecords()`でリモート取得される
- 削除時は確認ダイアログ（`l:confirmationLink`）が表示される
- レイアウトは`one-column`タイプ

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、ログレコードの取得と保存の仕組みを理解することが重要。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | LogRecorder.java | `core/src/main/java/hudson/logging/LogRecorder.java` | ログレコーダーの構造とハンドラー |
| 1-2 | RingBufferLogHandler.java | `core/src/main/java/hudson/util/RingBufferLogHandler.java` | ログバッファの実装 |

**読解のコツ**: `handler`フィールドの`RingBufferLogHandler`がどのようにログをバッファリングするかを把握する。

#### Step 2: エントリーポイントを理解する

処理の起点となるファイル・関数を特定。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | index.jelly | `core/src/main/resources/hudson/logging/LogRecorder/index.jelly` | 画面のHTMLテンプレート |

**主要処理フロー**:
1. **31行目**: `noLogs`変数でログの有無を判定
2. **36-48行目**: アプリバー（ボタン群）の定義
3. **69-71行目**: ログなし時のメッセージ表示
4. **73行目**: `t:logRecords`タグでログを表示
5. **74-77行目**: エージェントログの表示

#### Step 3: バックエンド処理を理解する

ログ管理のサーバーサイド処理。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | LogRecorder.java | `core/src/main/java/hudson/logging/LogRecorder.java` | `doClear()`メソッド（442-448行目） |
| 3-2 | LogRecorder.java | `core/src/main/java/hudson/logging/LogRecorder.java` | `delete()`メソッド（503-514行目） |
| 3-3 | LogRecorder.java | `core/src/main/java/hudson/logging/LogRecorder.java` | `getLogRecords()`メソッド（533-535行目） |
| 3-4 | LogRecorder.java | `core/src/main/java/hudson/logging/LogRecorder.java` | `getSlaveLogRecords()`メソッド（542-573行目） |

**主要処理フロー**:
- **444行目**: 権限チェック
- **446行目**: `handler.clear()`でバッファクリア
- **504行目**: 削除時の権限チェック
- **506-513行目**: ファイル削除、リスト除去、ターゲット無効化

### プログラム呼び出し階層図

```
/log/{name}/ アクセス
    │
    └─ index.jelly レンダリング
           │
           ├─ getLogRecords() → コントローラーログ取得
           │      └─ handler.getView()
           │
           ├─ getSlaveLogRecords() → エージェントログ取得
           │      └─ 各Computer.getLogRecords()
           │
           ├─ "Clear This Log" クリック → /clear
           │      └─ doClear()
           │             ├─ 権限チェック
           │             └─ handler.clear()
           │
           └─ "Delete log recorder" クリック → /doDelete
                  └─ delete()
                         ├─ 権限チェック
                         ├─ getConfigFile().delete()
                         ├─ getParent().getRecorders().remove()
                         └─ loggers.forEach(Target::disable)
```

### データフロー図

```
[入力]                      [処理]                           [出力]

アクセス要求 ──────────▶ ┌─────────────────────────┐
                          │ LogRecorder             │
                          │                         │
                          │ getLogRecords()         │──▶ コントローラーログ表示
                          │ getSlaveLogRecords()    │──▶ エージェントログ表示
                          └─────────────────────────┘
                                   │
           ┌───────────────────────┴───────────────────────┐
           │                                               │
           ▼                                               ▼
    "Clear This Log"                                "Delete"
           │                                               │
           ▼                                               ▼
    handler.clear()                              設定ファイル削除
                                                 リスト除去
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| index.jelly | `core/src/main/resources/hudson/logging/LogRecorder/index.jelly` | テンプレート | メイン画面テンプレート |
| LogRecorder.java | `core/src/main/java/hudson/logging/LogRecorder.java` | ソース | レコーダークラス |
| RingBufferLogHandler.java | `core/src/main/java/hudson/util/RingBufferLogHandler.java` | ソース | ログバッファ |
| logRecords.jelly | `core/src/main/resources/lib/hudson/logRecords.jelly` | テンプレート | ログ表示コンポーネント |
| sidepanel.jelly | `core/src/main/resources/hudson/logging/LogRecorder/sidepanel.jelly` | テンプレート | サイドパネル |
| configure.jelly | `core/src/main/resources/hudson/logging/LogRecorder/configure.jelly` | テンプレート | 設定画面 |
