# 画面設計書 58-ラベル詳細

## 概要

本ドキュメントは、特定のラベルの詳細情報を表示する画面の設計仕様を定義するものである。

### 本画面の処理概要

ラベル詳細画面は、Jenkins内で定義されたラベルに関連するノード（エージェント）とジョブの情報を表示する画面である。

**業務上の目的・背景**：Jenkinsでは、ノードにラベルを付与することで、特定の環境（OS、アーキテクチャ、インストール済みツール等）を持つノードを論理的にグルーピングできる。ジョブはラベル式を使って実行ノードを制約できる。本画面では、特定のラベルを持つノードの一覧と、そのラベルを使用しているジョブの一覧を確認することで、ビルド環境の把握と管理を支援する。

**画面へのアクセス方法**：ノード詳細画面やジョブ設定画面からラベル名リンクをクリック、または直接`/label/{ラベル名}/`にアクセスする。

**主要な操作・処理内容**：
1. ラベルに関連するノード（Computer）の一覧表示
2. ラベルを使用しているプロジェクト（ジョブ）の一覧表示
3. ラベルの説明編集（アトムラベルの場合）

**画面遷移**：
- 遷移元：ノード詳細、ジョブ設定、その他のラベルリンク
- 遷移先：ノード詳細画面（ノード名クリック時）
- 遷移先：ジョブ詳細画面（プロジェクト名クリック時）

**権限による表示制御**：`Jenkins.READ`権限で閲覧可能。説明の編集は`Jenkins.ADMINISTER`権限が必要。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 68 | ラベル管理 | 主機能 | ラベルの詳細情報表示 |
| 12 | コンピューター管理 | 補助機能 | ラベルに関連するノードの表示 |
| 4 | ジョブ（Job） | 補助機能 | ラベルに関連するジョブの表示 |

## 画面種別

詳細

## URL/ルーティング

- URL: `/label/{ラベル名}/`
- コントローラー: `hudson.model.Label`
- テンプレート: `core/src/main/resources/hudson/model/Label/index.jelly`

## 入出力項目

| 項目名 | 項目ID | 入力/出力 | 型 | 必須 | 説明 |
|--------|--------|----------|-----|------|------|
| 説明 | description | 入力（編集時） | String | 任意 | ラベルの説明文（アトムラベルのみ） |

## 表示項目

| 項目名 | 表示条件 | 説明 |
|--------|----------|------|
| ラベル名 | 常時 | ラベルの名前（タイトル） |
| 説明編集ボタン | アトムラベル、ADMINISTER権限 | 説明を編集するボタン |
| 説明 | アトムラベル、説明あり | ラベルの説明文 |
| Nodesセクション | 常時 | 関連ノードの一覧 |
| Projectsセクション | 常時 | 関連プロジェクトの一覧 |
| Noneメッセージ | プロジェクトなし | プロジェクトがない場合のメッセージ |

## イベント仕様

### 1-ページ読み込み

ページ読み込み時にラベルに関連する情報を取得する。

処理フロー：
1. ラベル名からLabelオブジェクトを解決
2. `getComputers()`で関連するComputerリストを取得
3. `getTiedJobs()`で関連するジョブリストを取得
4. アクションのサマリーを収集

### 2-説明編集

説明編集ボタン押下時に編集ダイアログを表示。

処理フロー：
1. `Jenkins.ADMINISTER`権限の確認
2. 説明入力ダイアログを表示
3. 入力内容を保存

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 説明編集 | ファイルシステム | UPDATE | ラベルの説明を保存 |

### テーブル別更新項目詳細

ラベル自体はJenkinsの設定に含まれており、個別のファイルとしては保存されない。アトムラベルの説明は`$JENKINS_HOME/labels/{ラベル名}/config.xml`に保存される場合がある。

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|-------------|------|--------------|----------|
| Nodes | 情報 | Nodes | セクションタイトル |
| Projects | 情報 | Projects | セクションタイトル |
| None | 情報 | None | プロジェクトがない場合 |

## 例外処理

| 例外種別 | 発生条件 | 処理内容 |
|----------|----------|----------|
| ラベル未存在 | 指定されたラベルがない | 404エラー（またはラベル作成） |

## 備考

- ラベルには「アトムラベル」（`LabelAtom`）と「ラベル式」（`LabelExpression`）の2種類がある
- アトムラベルは単一のラベル名、ラベル式は論理演算子を含む式
- 説明編集は`it.atom`がtrueの場合（アトムラベル）のみ表示される
- ノード一覧は`getComputers()`から取得され、名前順でソートされる
- プロジェクト一覧は`getTiedJobs()`から取得され、`AbstractProject`のみが対象
- サイドパネル（`sidepanel.jelly`）が含まれる

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、ラベルのデータ構造を理解することが重要。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | Label.java | `core/src/main/java/hudson/model/Label.java` | ラベルの抽象クラス、ノード・ジョブとの関連 |
| 1-2 | LabelAtom.java | `core/src/main/java/hudson/model/labels/LabelAtom.java` | アトムラベルの実装 |

**読解のコツ**: `Label`が抽象クラスで、`LabelAtom`と`LabelExpression`のサブクラスがあることを把握する。

#### Step 2: エントリーポイントを理解する

処理の起点となるファイル・関数を特定。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | index.jelly | `core/src/main/resources/hudson/model/Label/index.jelly` | 画面のHTMLテンプレート |

**主要処理フロー**:
1. **32-34行目**: アトムラベルの場合のみ説明編集ボタンを表示
2. **36-38行目**: アトムラベルの場合のみ説明を表示
3. **44-54行目**: Nodesセクション - 関連ノードを表示
4. **57-67行目**: Projectsセクション - 関連ジョブを表示

#### Step 3: バックエンド処理を理解する

ラベル関連のサーバーサイド処理。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | Label.java | `core/src/main/java/hudson/model/Label.java` | `getNodes()`メソッド（206-220行目） |
| 3-2 | Label.java | `core/src/main/java/hudson/model/Label.java` | `getComputers()`メソッド（222-226行目） |
| 3-3 | Label.java | `core/src/main/java/hudson/model/Label.java` | `getTiedJobs()`メソッド（392-398行目） |

**主要処理フロー**:
- **207-219行目**: 全ノードを走査し、ラベルにマッチするノードを収集
- **225行目**: ノードからComputerを取得し、ソートして返却
- **394-397行目**: 全ジョブを走査し、ラベルに紐づくジョブを収集

### プログラム呼び出し階層図

```
/label/{name}/ アクセス
    │
    ├─ Jenkins.getLabel(name)
    │      └─ Labelオブジェクト解決
    │
    └─ index.jelly レンダリング
           │
           ├─ it.atom判定
           │      └─ true: 説明編集ボタン、説明表示
           │
           ├─ getComputers()
           │      └─ getNodes() → Node.toComputer()
           │             └─ ソートして返却
           │
           └─ getTiedJobs()
                  └─ Jenkins.allItems(AbstractProject)
                         └─ フィルタリング
```

### データフロー図

```
[入力]                      [処理]                           [出力]

/label/{name}/ ─────────▶ ┌─────────────────────────┐
                          │ Label解決               │
                          │                         │
                          │ getNodes()              │──▶ ノード一覧
                          │   └─ 全ノード走査       │
                          │   └─ matches()判定      │
                          │                         │
                          │ getTiedJobs()           │──▶ ジョブ一覧
                          │   └─ 全ジョブ走査       │
                          │   └─ ラベル式評価       │
                          └─────────────────────────┘
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| index.jelly | `core/src/main/resources/hudson/model/Label/index.jelly` | テンプレート | メイン画面テンプレート |
| Label.java | `core/src/main/java/hudson/model/Label.java` | ソース | ラベル抽象クラス |
| LabelAtom.java | `core/src/main/java/hudson/model/labels/LabelAtom.java` | ソース | アトムラベル |
| LabelExpression.java | `core/src/main/java/hudson/model/labels/LabelExpression.java` | ソース | ラベル式 |
| sidepanel.jelly | `core/src/main/resources/hudson/model/Label/sidepanel.jelly` | テンプレート | サイドパネル |
| projectView.jelly | `core/src/main/resources/lib/hudson/projectView.jelly` | テンプレート | プロジェクト一覧表示 |
