# 画面設計書 59-CLI操作

## 概要

本ドキュメントは、Jenkins CLIの使用方法と利用可能なコマンド一覧を表示する画面の設計仕様を定義するものである。

### 本画面の処理概要

CLI操作画面は、Jenkins Command Line Interface（CLI）の使い方を説明し、利用可能なCLIコマンドの一覧を表示する画面である。

**業務上の目的・背景**：Jenkins CLIを使用すると、スクリプトや自動化ツールからJenkinsの操作を行うことができる。ジョブの実行、設定の取得・更新、プラグインの管理など、多くの操作がCLI経由で可能である。本画面は、CLIツールのダウンロードリンクと使用方法のガイド、そして利用可能なコマンドの一覧を提供することで、管理者や開発者がCLIを効果的に活用できるよう支援する。

**画面へのアクセス方法**：Jenkins管理画面から「Jenkins CLI」リンクをクリック、または直接`/cli/`にアクセスする。

**主要な操作・処理内容**：
1. Jenkins CLIクライアント（jenkins-cli.jar）のダウンロード
2. CLIの使用方法の確認
3. 利用可能なコマンド一覧の閲覧
4. 個別コマンドの詳細ヘルプの確認

**画面遷移**：
- 遷移元：Jenkins管理画面（ManageJenkinsAction）
- 遷移先：コマンド詳細画面（`/cli/command/{コマンド名}`）

**権限による表示制御**：`Jenkins.READ`権限で閲覧可能。実際のCLIコマンド実行時は各コマンドで定義された権限が必要。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 39 | CLIコマンド基盤 | 主機能 | CLI使用方法とコマンド一覧の表示 |
| 40 | ビルドコマンド | 補助機能 | ビルドコマンドの説明 |
| 41 | ジョブ管理コマンド | 補助機能 | ジョブ管理コマンドの説明 |
| 42 | ノード管理コマンド | 補助機能 | ノード管理コマンドの説明 |
| 43 | プラグイン管理コマンド | 補助機能 | プラグイン管理コマンドの説明 |

## 画面種別

一覧/ガイド

## URL/ルーティング

- URL: `/cli/`
- コントローラー: `hudson.cli.CLIAction`
- テンプレート: `core/src/main/resources/hudson/cli/CLIAction/index.jelly`

## 入出力項目

この画面は表示専用であり、入力項目は存在しない。

## 表示項目

| 項目名 | 表示条件 | 説明 |
|--------|----------|------|
| タイトル | 常時 | "Jenkins CLI" |
| 説明文 | 常時 | CLIの概要説明 |
| ヘルプリンク | 常時 | 外部ドキュメントへのリンク |
| Getting startedセクション | 常時 | CLIの導入手順 |
| jenkins-cli.jarダウンロードボタン | 常時 | CLIクライアントのダウンロードリンク |
| 使用例 | 常時 | CLIコマンドの実行例 |
| Available Commandsセクション | 常時 | コマンド一覧テーブル |
| コマンド名 | 常時 | 各コマンドの名前（リンク） |
| コマンド説明 | 常時 | 各コマンドの簡単な説明 |

## イベント仕様

### 1-ページ読み込み

ページ読み込み時にCLIコマンド一覧を取得する。

処理フロー：
1. `Functions.getCLICommands()`で利用可能なCLIコマンドを取得
2. コマンドをテーブルに表示

### 2-CLIクライアントダウンロード

「jenkins-cli.jar」ボタンクリック時にCLIクライアントがダウンロードされる。

処理フロー：
1. `/jnlpJars/jenkins-cli.jar`にリダイレクト
2. JARファイルがダウンロードされる

### 3-コマンド詳細表示

コマンド名クリック時に詳細ページに遷移。

処理フロー：
1. `doCommand()`メソッドが呼び出される
2. コマンド名から`CLICommand`オブジェクトを取得
3. `command.jelly`テンプレートでヘルプを表示

## データベース更新仕様

この画面ではデータの更新は行われない（読み取り専用）。

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|-------------|------|--------------|----------|
| description | 情報 | CLIの説明文 | ページ説明 |
| Getting started | 情報 | Getting started | セクションタイトル |
| instruction1 | 情報 | Download jenkins-cli.jar | 手順1の説明 |
| instruction2 | 情報 | Run the CLI | 手順2の説明 |
| Available Commands | 情報 | Available Commands | セクションタイトル |
| Name | 情報 | Name | テーブルヘッダー |
| Description | 情報 | Description | テーブルヘッダー |

## 例外処理

| 例外種別 | 発生条件 | 処理内容 |
|----------|----------|----------|
| コマンド未存在 | 指定されたコマンドがない | 404エラー |

## 備考

- CLIクライアント（jenkins-cli.jar）は`/jnlpJars/`ディレクトリから提供される
- コマンド一覧は`CLICommand`のサブクラスをExtensionポイントから収集
- 認証には、APIトークンまたはSSH鍵を使用
- WebSocket接続がサポートされている場合は`isWebSocketSupported()`でチェック可能
- テーブルは`sortable`クラスでソート可能
- `l:settings-subpage`レイアウトを使用

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、CLIコマンドの構造を理解することが重要。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | CLICommand.java | `core/src/main/java/hudson/cli/CLICommand.java` | CLIコマンドの基底クラス |
| 1-2 | CLIAction.java | `core/src/main/java/hudson/cli/CLIAction.java` | CLI画面のコントローラー |

**読解のコツ**: `CLICommand`がExtensionPointであり、各コマンドがサブクラスとして実装されていることを把握する。

#### Step 2: エントリーポイントを理解する

処理の起点となるファイル・関数を特定。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | index.jelly | `core/src/main/resources/hudson/cli/CLIAction/index.jelly` | 画面のHTMLテンプレート |

**主要処理フロー**:
1. **27-37行目**: ヘッダー部分（タイトル、説明、ヘルプリンク）
2. **41-59行目**: Getting startedセクション（ダウンロードリンク、使用例）
3. **61-81行目**: Available Commandsセクション（コマンドテーブル）
4. **71行目**: `h.getCLICommands()`でコマンド一覧を取得

#### Step 3: バックエンド処理を理解する

CLI関連のサーバーサイド処理。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | CLIAction.java | `core/src/main/java/hudson/cli/CLIAction.java` | `doCommand()`メソッド（100-114行目） |
| 3-2 | CLIAction.java | `core/src/main/java/hudson/cli/CLIAction.java` | `getTarget()`メソッド（232-245行目） |

**主要処理フロー**:
- **102行目**: 権限チェック `jenkins.checkPermission(Jenkins.READ)`
- **105-106行目**: コマンド名から`CLICommand`オブジェクトを取得
- **107-109行目**: コマンドが存在しない場合は404エラー

### プログラム呼び出し階層図

```
/cli/ アクセス
    │
    ├─ CLIAction.getTarget()
    │      └─ 権限チェック等
    │
    └─ index.jelly レンダリング
           │
           ├─ h.getCLICommands()
           │      └─ 全CLICommandを取得
           │
           ├─ jenkins-cli.jarダウンロード
           │      └─ /jnlpJars/jenkins-cli.jar
           │
           └─ コマンド名クリック → /cli/command/{name}
                  └─ doCommand()
                         ├─ 権限チェック
                         ├─ CLICommand.clone(commandName)
                         └─ command.jelly レンダリング
```

### データフロー図

```
[入力]                      [処理]                           [出力]

/cli/ アクセス ─────────▶ ┌─────────────────────────┐
                          │ CLIAction               │
                          │                         │
                          │ Functions.getCLICommands()│──▶ コマンド一覧表示
                          │                         │
                          └─────────────────────────┘

jenkins-cli.jar ────────▶ /jnlpJars/jenkins-cli.jar ──▶ JARダウンロード

/cli/command/{name} ────▶ doCommand()
                               │
                               └─ CLICommand.clone() ──▶ コマンド詳細表示
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| index.jelly | `core/src/main/resources/hudson/cli/CLIAction/index.jelly` | テンプレート | メイン画面テンプレート |
| CLIAction.java | `core/src/main/java/hudson/cli/CLIAction.java` | ソース | コントローラー |
| CLICommand.java | `core/src/main/java/hudson/cli/CLICommand.java` | ソース | コマンド基底クラス |
| command.jelly | `core/src/main/resources/hudson/cli/CLIAction/command.jelly` | テンプレート | コマンド詳細テンプレート |
| example.jelly | `core/src/main/resources/hudson/cli/CLIAction/example.jelly` | テンプレート | 使用例テンプレート |
| Functions.java | `core/src/main/java/hudson/Functions.java` | ソース | getCLICommands()メソッド |
