# 画面設計書 6-アクセス拒否

## 概要

本ドキュメントは、Jenkinsのアクセス拒否画面の設計仕様を定義するものです。

### 本画面の処理概要

アクセス拒否画面は、認証済みユーザーが権限のないリソースにアクセスしようとした場合に表示される画面です。HTTP 403 Forbiddenに相当するエラーページです。

**業務上の目的・背景**：Jenkinsはロールベースのアクセス制御（RBAC）により、ユーザーごとに異なる権限を付与できます。権限のないリソースへのアクセスを明確に拒否し、ユーザーにその旨を通知することで、セキュリティを維持しつつ適切なフィードバックを提供します。

**画面へのアクセス方法**：認証済みユーザーが権限のないリソース（ジョブ設定画面、管理画面等）にアクセスしようとした場合、自動的にこの画面にリダイレクトされます。直接URLでアクセスすることは通常ありません。

**主要な操作・処理内容**：
1. アクセス拒否メッセージの表示
2. 例外メッセージ（アクセス拒否の理由）の表示

**画面遷移**：権限のないリソースへのアクセス試行時にこの画面に遷移します。この画面からの遷移先は特に定義されていませんが、ブラウザの戻るボタンで前の画面に戻るか、ダッシュボードへ戻ることができます。

**権限による表示制御**：この画面自体は特別な権限なしで表示されます。サイドパネルは情報漏洩防止のため表示されません。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 29 | 認可（AuthorizationStrategy） | 主機能 | 権限不足時のアクセス拒否表示 |
| 31 | 権限管理 | 補助機能 | 必要な権限の確認処理 |

## 画面種別

エラー

## URL/ルーティング

- `/accessDenied` - アクセス拒否画面

## 入出力項目

| 項目名 | 入力/出力 | データ型 | 必須 | 説明 |
|--------|----------|----------|------|------|
| exception.message | 出力 | String | - | アクセス拒否の理由メッセージ |

## 表示項目

| 項目名 | データ型 | 説明 |
|--------|----------|------|
| タイトル | Text | "Access Denied" |
| エラーメッセージ | Text | 例外メッセージ（アクセス拒否の理由） |

## イベント仕様

### （イベントなし）

本画面は情報表示のみであり、ユーザー操作に応じたイベントはありません。

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 画面表示 | - | - | データベース更新なし |

### テーブル別更新項目詳細

本画面での直接的なファイルシステム更新はありません。

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|-------------|------|---------------|---------|
| Access Denied | エラー | "Access Denied" | 常時表示（タイトル） |
| (exception.message) | エラー | 動的メッセージ | 例外メッセージがある場合 |

## 例外処理

| 例外状態 | 処理内容 |
|---------|---------|
| 例外メッセージなし | タイトルのみ表示 |

## 備考

- サイドパネル（sidepanel.jelly）は意図的に非表示にされています（情報漏洩防止のため）
- 例外メッセージは`st:out`タグでエスケープされて表示されます
- HTTPステータスコード403が返されます
- ヘッダータイトルは"Jenkins Login"と表示されます

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

認可（Authorization）の仕組みを理解します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | AuthorizationStrategy.java | `core/src/main/java/hudson/security/AuthorizationStrategy.java` | 認可戦略の基底クラス |
| 1-2 | Permission.java | `core/src/main/java/hudson/security/Permission.java` | 権限の定義 |

**読解のコツ**: AccessDeniedExceptionがスローされると、この画面にルーティングされます。例外メッセージには、どの権限が不足しているかの情報が含まれます。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | accessDenied.jelly | `core/src/main/resources/jenkins/model/Jenkins/accessDenied.jelly` | 画面のメインテンプレート |

**主要処理フロー**:
1. **27行目**: `l:layout`でレイアウト開始
2. **29行目**: ヘッダータイトルを"Jenkins Login"に設定
3. **30行目**: サイドパネルを空で表示（情報を含まない）
4. **31-35行目**: メインパネルにエラー情報を表示
5. **32行目**: "Access Denied"タイトル
6. **34行目**: 例外メッセージを`st:out`でエスケープ表示

#### Step 3: 認可チェックの仕組みを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | ACL.java | `core/src/main/java/hudson/security/ACL.java` | アクセス制御リスト |

**主要処理フロー**:
- `hasPermission()`メソッドで権限チェック
- 権限なしの場合にAccessDeniedExceptionをスロー

### プログラム呼び出し階層図

```
[権限が必要なリソースへのアクセス]
    │
    └─ ACL.checkPermission()
           │
           └─ [権限なし]
                  │
                  └─ AccessDeniedException
                         │
                         └─ accessDenied.jelly
                                │
                                ├─ l:header (タイトル設定)
                                ├─ l:side-panel (空)
                                └─ l:main-panel
                                       ├─ h1 "Access Denied"
                                       └─ p.error (exception.message)
```

### データフロー図

```
[入力]               [処理]                    [出力]

権限なしアクセス ───▶ ACL.checkPermission() ───▶ 例外スロー
                           │
                           ▼
                  AccessDeniedException ───▶ accessDenied.jelly
                           │                      │
                           │                      ▼
                           └─ exception.message ───▶ エラーメッセージ表示
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| accessDenied.jelly | `core/src/main/resources/jenkins/model/Jenkins/accessDenied.jelly` | テンプレート | メイン画面テンプレート |
| ACL.java | `core/src/main/java/hudson/security/ACL.java` | ソース | アクセス制御 |
| AuthorizationStrategy.java | `core/src/main/java/hudson/security/AuthorizationStrategy.java` | ソース | 認可戦略 |
| Permission.java | `core/src/main/java/hudson/security/Permission.java` | ソース | 権限定義 |
