# 画面設計書 61-メモリ使用状況

## 概要

本ドキュメントは、Jenkins CI/CDサーバーの「メモリ使用状況」画面の設計書です。

### 本画面の処理概要

JVMのメモリ使用状況をリアルタイムでグラフ表示する診断画面です。ヒープ領域および非ヒープ領域のメモリ使用量と最大メモリ量の推移を時系列グラフで可視化します。

**業務上の目的・背景**：Jenkinsサーバーの安定運用において、メモリ不足はビルド失敗やサーバー障害の原因となります。この画面は、管理者がJVMのメモリ使用状況をリアルタイムで監視し、メモリリークの早期発見やパフォーマンス問題の診断を行うために必要です。特にガベージコレクション後のメモリ使用量の推移を確認することで、実際のライブオブジェクトのフットプリントを正確に把握できます。

**画面へのアクセス方法**：Jenkins管理画面 > システム情報 > メモリ使用状況、またはURLパス `/manage/systemInfo/memoryUsage` から直接アクセスします。

**主要な操作・処理内容**：
1. 時間範囲の切り替え（短期/中期/長期）によるグラフ表示期間の変更
2. ヒープメモリの使用量と最大量の時系列グラフ表示
3. 非ヒープメモリの使用量と最大量の時系列グラフ表示
4. 10秒間隔での自動データ更新

**画面遷移**：Jenkins管理画面 > システム情報から遷移可能です。

**権限による表示制御**：SYSTEM_READまたはMANAGE権限を持つユーザーがグラフを閲覧できます。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 47 | 管理モニター | 主機能 | JVMメモリ使用状況の表示 |
| 1 | Jenkins本体 | 補助機能 | JVMメモリ情報の取得 |

## 画面種別

詳細 / 監視

## URL/ルーティング

- URL: `/manage/systemInfo/memoryUsage` または `/administrativeMonitor/memoryUsage/`
- ルーティング: `MemoryUsageMonitor` クラスが Stapler によりURLにバインドされます

## 入出力項目

| 項目名 | 入出力 | 型 | 必須 | 説明 |
|--------|--------|-----|------|------|
| type | 入力 | String | - | 時間範囲タイプ（sec10/min/hour）。デフォルトは "min" |

## 表示項目

| 項目名 | 型 | 説明 |
|--------|-----|------|
| JVM Memory Usage | 見出し | 画面タイトル |
| Timespan | リンク群 | 時間範囲選択（Short/Medium/Long） |
| Memory Graph | 画像 | メモリ使用量の時系列グラフ（500x300ピクセル） |

### グラフ詳細

| グラフ要素 | 色 | 説明 |
|-----------|-----|------|
| Used (使用量) | 赤 | GC後のメモリ使用量（KB単位） |
| Total (最大量) | 青 | メモリプールの最大サイズ（KB単位） |

### 時間範囲オプション

| オプション | パラメータ値 | 説明 |
|-----------|-------------|------|
| Short | sec10 | 10秒間隔の短期データ |
| Medium | min | 1分間隔の中期データ（デフォルト） |
| Long | hour | 1時間間隔の長期データ |

## イベント仕様

### 1-時間範囲リンククリック

ユーザーがTimespan（Short/Medium/Long）のリンクをクリックすると、選択した時間範囲でグラフが再描画されます。

**処理フロー**：
1. リンククリックにより `?type={sec10|min|hour}` パラメータ付きでページ遷移
2. サーバー側で指定された時間範囲のデータを取得
3. `MultiStageTimeSeries.createTrendChart()` によりグラフ画像を生成
4. グラフ画像を含むページを返却

### 2-グラフ画像取得

**URL**: `graph?type={type}&width=500&height=300`

**処理フロー**：
1. `MemoryGroup.doGraph()` メソッドが呼び出される
2. SYSTEM_READまたはMANAGE権限のチェック
3. `MultiStageTimeSeries.createTrendChart()` でトレンドチャートを生成
4. PNG形式の画像をレスポンスとして返却

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 画面表示 | なし | SELECT | データベースアクセスなし（JVM MBeanから直接取得） |

### メモリデータ収集仕様

データはファイルシステムやデータベースではなく、JVMの `MemoryPoolMXBean` から直接取得されます。

| データソース | 取得間隔 | 説明 |
|-------------|---------|------|
| MemoryPoolMXBean | 10秒 | `PeriodicWork` による定期実行で収集 |

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|-------------|------|--------------|---------|
| - | 見出し | JVM Memory Usage | 常時表示 |
| - | ラベル | Timespan | 常時表示 |
| - | リンク | Short | type != sec10 の場合 |
| - | リンク | Medium | type != min の場合 |
| - | リンク | Long | type != hour の場合 |

## 例外処理

| 例外条件 | 対応 | 表示内容 |
|---------|------|---------|
| 権限不足 | 403エラー | アクセス拒否画面へリダイレクト |
| JVM MBean取得失敗 | グラフ表示エラー | グラフが表示されない |

## 備考

- メモリ使用量はガベージコレクション後の値（`getCollectionUsage()`）を使用しており、ライブオブジェクトの正確なフットプリントを反映します
- 表示単位はKB（キロバイト）です
- ヒープ領域（heap）と非ヒープ領域（nonHeap）の両方のメモリプールを監視しています
- データ収集は `@Extension` アノテーションにより Jenkins起動時に自動的に開始されます

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、メモリ使用量データがどのように管理されているかを理解することが重要です。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | MultiStageTimeSeries.java | `core/src/main/java/hudson/model/MultiStageTimeSeries.java` | 時系列データの管理構造、TimeScale（時間範囲）の概念を理解 |
| 1-2 | MemoryUsageMonitor.java | `core/src/main/java/hudson/diagnosis/MemoryUsageMonitor.java` | MemoryGroup内部クラスの構造、used/maxフィールドの役割を理解 |

**読解のコツ**: `MultiStageTimeSeries` は複数の時間スケール（秒/分/時間）でデータを保持する仕組みです。`ColorPalette` でグラフの色が定義されています。

#### Step 2: エントリーポイントを理解する

処理の起点となるファイル・関数を特定します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | index.jelly | `core/src/main/resources/hudson/diagnosis/MemoryUsageMonitor/index.jelly` | 画面構造、typeパラメータの取得、グラフURLの生成を理解 |

**主要処理フロー**:
1. **行34**: `request2.getParameter('type')` でtypeパラメータを取得（デフォルト: 'min'）
2. **行37-62**: 時間範囲リンクの動的生成（現在選択中の項目はリンクなし）
3. **行64**: `graph?type=${type}` URLでグラフ画像を表示

#### Step 3: データ収集処理を理解する

定期的なメモリデータ収集の仕組みを理解します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | MemoryUsageMonitor.java | `core/src/main/java/hudson/diagnosis/MemoryUsageMonitor.java` | PeriodicWorkの継承、doRun()メソッドの実装を理解 |

**主要処理フロー**:
- **行51**: `@Extension` アノテーションによりJenkins起動時に自動登録
- **行105-109**: コンストラクタでMemoryPoolMXBeanからヒープ/非ヒープのプールを分類
- **行112-114**: `getRecurrencePeriod()` で10秒間隔を設定
- **行117-120**: `doRun()` でheap/nonHeapの両方を更新

#### Step 4: グラフ生成処理を理解する

グラフ画像の生成処理を理解します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | MemoryUsageMonitor.java (MemoryGroup) | `core/src/main/java/hudson/diagnosis/MemoryUsageMonitor.java` | doGraph()メソッド（行96-99）を理解 |

**主要処理フロー**:
- **行96-99**: `doGraph()` メソッドで権限チェック後、TrendChartを生成
- **行75-91**: `update()` メソッドでMemoryPoolMXBeanからデータを収集しKB単位に変換

### プログラム呼び出し階層図

```
index.jelly (画面表示)
    │
    ├─ request2.getParameter('type') ─── パラメータ取得
    │
    └─ graph?type=${type} (画像URL)
           │
           └─ MemoryUsageMonitor.MemoryGroup.doGraph()
                  │
                  ├─ Jenkins.get().checkAnyPermission() ─── 権限チェック
                  │
                  └─ MultiStageTimeSeries.createTrendChart()
                         │
                         └─ TrendChart (PNG画像生成)

[バックグラウンド処理]
MemoryUsageMonitor.doRun() (10秒間隔)
    │
    ├─ heap.update()
    │      └─ MemoryPoolMXBean.getCollectionUsage()
    │
    └─ nonHeap.update()
           └─ MemoryPoolMXBean.getCollectionUsage()
```

### データフロー図

```
[入力]                    [処理]                         [出力]

typeパラメータ ───────▶ index.jelly ─────────────▶ HTML画面
(sec10/min/hour)              │
                              │
                              ▼
                        graph?type=xxx ───────────▶ PNG画像
                              │
                              ▼
                   MemoryGroup.doGraph()
                              │
                              ▼
              MultiStageTimeSeries.createTrendChart()


[バックグラウンド]

MemoryPoolMXBean ───────▶ MemoryGroup.update() ───▶ MultiStageTimeSeries
(JVM内部)                    (10秒間隔)              (メモリ内キャッシュ)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| MemoryUsageMonitor.java | `core/src/main/java/hudson/diagnosis/MemoryUsageMonitor.java` | ソース | メモリ監視の主クラス |
| index.jelly | `core/src/main/resources/hudson/diagnosis/MemoryUsageMonitor/index.jelly` | テンプレート | 画面表示用Jellyテンプレート |
| MultiStageTimeSeries.java | `core/src/main/java/hudson/model/MultiStageTimeSeries.java` | ソース | 時系列データ管理 |
| PeriodicWork.java | `core/src/main/java/hudson/model/PeriodicWork.java` | ソース | 定期実行の基底クラス |
| ColorPalette.java | `core/src/main/java/hudson/util/ColorPalette.java` | ソース | グラフ色定義 |
