# 画面設計書 62-ディスク使用状況

## 概要

本ドキュメントは、Jenkins CI/CDサーバーの「ディスク使用状況」画面（JENKINS_HOMEディスク使用量警告画面）の設計書です。

### 本画面の処理概要

JENKINS_HOMEディレクトリが存在するパーティションのディスク容量がほぼ満杯になった際に表示される警告画面です。問題の説明と推奨される解決策を提示します。

**業務上の目的・背景**：Jenkinsサーバーの安定運用において、ディスク容量不足は深刻な問題を引き起こします。ビルドログ、成果物、設定ファイルなどの保存に失敗すると、ジョブ実行エラーやデータ損失につながります。この画面は、ディスク容量が枯渇する前に管理者に警告を発し、予防的な対応を促すことを目的としています。

**画面へのアクセス方法**：この画面は通常のナビゲーションからはアクセスできません。HudsonHomeDiskUsageChecker（バックグラウンドタスク）がディスク容量不足を検出した際に、管理モニターとして自動的に表示されます。Jenkins管理画面のトップに警告バナーとして表示され、クリックすると詳細画面に遷移します。

**主要な操作・処理内容**：
1. ディスク使用状況の警告メッセージ表示
2. JENKINS_HOMEディレクトリのパス表示
3. 推奨解決策の一覧表示
4. プラグイン拡張による追加解決策の表示
5. 警告を無視して管理画面に戻る操作

**画面遷移**：警告バナークリックから遷移、「No」ボタン押下で /manage へリダイレクト

**権限による表示制御**：管理者権限（ADMINISTER）を持つユーザーのみが表示・操作可能です。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 47 | 管理モニター | 主機能 | ディスク使用状況の表示 |
| 1 | Jenkins本体 | 補助機能 | JENKINS_HOMEディレクトリ情報の取得 |

## 画面種別

警告 / 診断

## URL/ルーティング

- URL: `/manage/administrativeMonitor/hudsonHomeIsFull/`
- ルーティング: `HudsonHomeDiskUsageMonitor` クラスが AdministrativeMonitor として登録され、Staplerにより URLにバインドされます

## 入出力項目

| 項目名 | 入出力 | 型 | 必須 | 説明 |
|--------|--------|-----|------|------|
| no | 入力 | String | - | 「今後この警告を表示しない」選択時にセット |

## 表示項目

| 項目名 | 型 | 説明 |
|--------|-----|------|
| 警告アイコン | アイコン | icon-warning icon-xlg クラスの警告アイコン |
| 警告見出し | テキスト | "JENKINS_HOME is almost full" |
| JENKINS_HOMEパス | テキスト | app.rootDir の値を表示 |
| 説明文1 | テキスト | ディスク容量不足の影響についての説明 |
| 説明文2 | テキスト | 対応の必要性についての説明 |
| 解決策リスト | リスト | 推奨される対応策の一覧 |

### 解決策一覧

| 順序 | 解決策 | 説明 |
|------|-------|------|
| 1 | パーティションのクリーンアップ | 不要なファイルを削除して空き容量を確保 |
| 2 | JENKINS_HOMEの移行 | より大きなパーティションへJENKINS_HOMEを移動 |
| 3+ | プラグイン提供の解決策 | Solution拡張ポイントにより追加される解決策 |

## イベント仕様

### 1-警告を無視（Noボタン）

ユーザーが警告を無視して管理画面に戻る場合の処理です。

**処理フロー**：
1. POSTリクエストで `doAct` アクションを呼び出し（no パラメータ付き）
2. `disable(true)` を呼び出し、この警告を永続的に無効化
3. `/manage` へリダイレクト

### 2-解決策リンククリック

各解決策（プラグイン提供）のリンクをクリックした場合の処理です。

**処理フロー**：
1. `getSolution(id)` で該当の Solution オブジェクトを取得
2. Solution の詳細ページまたはアクションに遷移

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 警告無効化 | なし | ファイル更新 | JENKINS_HOME/org.jenkinsci.Symbol.Disabled に記録 |

### ファイル更新詳細

警告を無効化した場合、AdministrativeMonitor の設定がファイルシステムに保存されます。

| 対象ファイル | 操作 | 説明 |
|-------------|------|------|
| config.xml (Jenkins設定) | UPDATE | disabledAdministrativeMonitors リストに "hudsonHomeIsFull" を追加 |

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|-------------|------|--------------|---------|
| blurb | 見出し | JENKINS_HOME is almost full | 常時表示 |
| description.1 | 説明 | Your JENKINS_HOME ({0}) is almost full... | 常時表示（{0}にJENKINS_HOMEパス） |
| description.2 | 説明 | To prevent that problem, you should act now. | 常時表示 |
| solution.1 | 解決策 | Clean up some files from this partition... | 常時表示 |
| solution.2 | 解決策 | Move JENKINS_HOME to a bigger partition... | 常時表示 |

## 例外処理

| 例外条件 | 対応 | 表示内容 |
|---------|------|---------|
| 権限不足 | 403エラー | アクセス拒否画面へリダイレクト |

## 備考

- この画面は `AdministrativeMonitor` の拡張として実装されており、Jenkins管理画面に警告バナーとして表示されます
- `activated` フラグは `HudsonHomeDiskUsageChecker` によって定期的に更新されます
- 解決策は `Solution` 拡張ポイントを通じてプラグインから追加可能です
- モニターIDは "hudsonHomeIsFull" です

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、管理モニターの基本構造と、ディスク使用状況監視の仕組みを理解します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | AdministrativeMonitor.java | `core/src/main/java/hudson/model/AdministrativeMonitor.java` | 管理モニターの基底クラス、activated/disableの概念を理解 |
| 1-2 | HudsonHomeDiskUsageMonitor.java | `core/src/main/java/hudson/diagnosis/HudsonHomeDiskUsageMonitor.java` | ディスク監視モニターの実装、Solutionインターフェースを理解 |

**読解のコツ**: `AdministrativeMonitor` は Jenkins の警告システムの基盤です。`isActivated()` が true を返すと警告バナーが表示されます。

#### Step 2: エントリーポイントを理解する

画面表示の起点となるファイルを特定します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | index.jelly | `core/src/main/resources/hudson/diagnosis/HudsonHomeDiskUsageMonitor/index.jelly` | 画面構造、メッセージの参照方法、Solution一覧の表示を理解 |

**主要処理フロー**:
1. **行27**: レイアウトとタイトルの設定
2. **行29-32**: 警告アイコンとメッセージの表示
3. **行34-38**: JENKINS_HOMEパスを含む説明文
4. **行40-52**: 解決策リスト（固定2件 + プラグイン提供分）

#### Step 3: バックエンド処理を理解する

ディスク容量チェックとアクション処理を理解します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | HudsonHomeDiskUsageMonitor.java | `core/src/main/java/hudson/diagnosis/HudsonHomeDiskUsageMonitor.java` | doAct()メソッド、getSolutions()、Solutionクラスを理解 |

**主要処理フロー**:
- **行46**: `@Extension @Symbol("diskUsageCheck")` でJenkins起動時に自動登録
- **行50**: `activated` フラグで警告表示を制御
- **行52-54**: コンストラクタでモニターID "hudsonHomeIsFull" を設定
- **行69-77**: `doAct()` でNoボタン押下時の処理（警告無効化 + リダイレクト）
- **行79-81**: `getSolutions()` でプラグイン提供の解決策を取得
- **行111-141**: `Solution` 抽象クラスの定義

#### Step 4: プロパティファイルを理解する

メッセージ定義を確認します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | index.properties | `core/src/main/resources/hudson/diagnosis/HudsonHomeDiskUsageMonitor/index.properties` | 各メッセージの定義内容を確認 |

### プログラム呼び出し階層図

```
index.jelly (画面表示)
    │
    ├─ ${%blurb} ─────────────────── index.properties
    ├─ ${%description.1(app.rootDir)} ─ JENKINS_HOMEパス挿入
    ├─ ${%description.2}
    ├─ ${%solution.1}
    ├─ ${%solution.2}
    │
    └─ j:forEach items="${it.solutions}"
           │
           └─ HudsonHomeDiskUsageMonitor.getSolutions()
                  │
                  └─ Solution.all() (拡張ポイント)

doAct (POSTアクション)
    │
    ├─ パラメータ "no" あり?
    │      │
    │      ├─ Yes: disable(true) → /manage へリダイレクト
    │      │
    │      └─ No: ドットへリダイレクト（現在のURL）

[バックグラウンド]
HudsonHomeDiskUsageChecker (定期実行)
    │
    └─ HudsonHomeDiskUsageMonitor.activated = true/false
```

### データフロー図

```
[入力]                    [処理]                         [出力]

ディスク容量チェック ──▶ HudsonHomeDiskUsageChecker ──▶ activated=true
(定期実行)                                                  │
                                                           ▼
                                              管理画面に警告バナー表示
                                                           │
                                                           ▼
バナークリック ──────────▶ index.jelly ──────────────▶ 警告詳細画面
                              │
                              ▼
                    getSolutions() ──────────────▶ 解決策一覧
                              │
                              ▼
Noボタン押下 ──────────▶ doAct(?no=true) ─────────▶ /manage リダイレクト
                              │
                              ▼
                         disable(true) ───────────▶ config.xml更新
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| HudsonHomeDiskUsageMonitor.java | `core/src/main/java/hudson/diagnosis/HudsonHomeDiskUsageMonitor.java` | ソース | ディスク使用量モニターの主クラス |
| index.jelly | `core/src/main/resources/hudson/diagnosis/HudsonHomeDiskUsageMonitor/index.jelly` | テンプレート | 画面表示用Jellyテンプレート |
| index.properties | `core/src/main/resources/hudson/diagnosis/HudsonHomeDiskUsageMonitor/index.properties` | 設定 | メッセージ定義 |
| AdministrativeMonitor.java | `core/src/main/java/hudson/model/AdministrativeMonitor.java` | ソース | 管理モニターの基底クラス |
| HudsonHomeDiskUsageChecker.java | `core/src/main/java/hudson/diagnosis/HudsonHomeDiskUsageChecker.java` | ソース | ディスク容量チェックのバックグラウンドタスク |
