# 画面設計書 65-API情報

## 概要

本ドキュメントは、Jenkins CI/CDサーバーの「API情報」画面の設計書です。

### 本画面の処理概要

Jenkins REST APIの使用方法を説明するドキュメント画面です。XML、JSON、Python形式でのデータアクセス方法とクエリパラメータの使い方を提供します。

**業務上の目的・背景**：Jenkinsは外部ツールやスクリプトからの自動化アクセスをサポートするため、REST APIを提供しています。この画面は、開発者やCI/CDパイプラインエンジニアがAPIを効果的に活用するための技術ドキュメントを提供することを目的としています。`tree` パラメータや `depth` パラメータの使い方を理解することで、効率的なデータ取得が可能になります。

**画面へのアクセス方法**：各リソースのURLに `/api/` を追加することでアクセスできます。例：`/api/`、`/job/{ジョブ名}/api/`、`/build/{ビルド番号}/api/`

**主要な操作・処理内容**：
1. REST APIの概要説明の閲覧
2. XML API / JSON API / Python APIのサンプルリンク
3. XMLスキーマの参照
4. `tree` パラメータによるデータフィルタリングの説明
5. `depth` パラメータによるデータ深度制御の説明
6. XPath / excludeパラメータの説明

**画面遷移**：任意のリソース画面から `/api/` をURLに追加して遷移、各API形式のリンクからXML/JSON/Pythonデータを取得

**権限による表示制御**：APIアクセスはリソースごとの権限に従います。API情報画面自体は特別な権限なしで閲覧可能です。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 65 | REST API | 主機能 | REST API使用方法の説明表示 |
| 66 | RSSフィード | 補助機能 | RSSフィード情報の説明 |

## 画面種別

ドキュメント / ヘルプ

## URL/ルーティング

- URL: `{リソースURL}/api/`
- ルーティング: `Api` クラスが各リソースの `getApi()` メソッドにより提供され、Staplerにより URLにバインドされます

## 入出力項目

| 項目名 | 入出力 | 型 | 必須 | 説明 |
|--------|--------|-----|------|------|
| xpath | 入力 | String | - | XMLフィルタリング用XPath式 |
| wrapper | 入力 | String | - | 複数ノード結果をラップする要素名 |
| tree | 入力 | String | - | 取得するプロパティの指定 |
| depth | 入力 | int | - | データ取得の深度（デフォルト:0） |
| exclude | 入力 | String | - | 除外するノードのXPath（複数可） |
| pretty | 入力 | boolean | - | JSON出力の整形（true/false） |

## 表示項目

| 項目名 | 型 | 説明 |
|--------|-----|------|
| REST API | 見出し | 画面タイトル |
| 概要説明 | テキスト | APIの基本的な使い方 |
| XML API | リンク+説明 | XML形式でのアクセス方法 |
| JSON API | リンク+説明 | JSON形式でのアクセス方法 |
| Python API | リンク+説明 | Python形式でのアクセス方法 |
| tree説明 | テキスト | treeパラメータの詳細説明 |
| depth説明 | テキスト | depthパラメータの詳細説明 |

### APIエンドポイント一覧

| エンドポイント | 形式 | 説明 |
|--------------|------|------|
| /api/xml | XML | XML形式でデータ取得 |
| /api/json | JSON | JSON形式でデータ取得 |
| /api/python | Python | Python literal形式でデータ取得 |
| /api/schema | XSD | XMLスキーマ取得 |

## イベント仕様

### 1-XML API リンククリック

XML形式でデータを取得します。

**URL**: `xml` または `xml?{パラメータ}`

**処理フロー**：
1. `Api.doXml()` メソッドが呼び出される
2. `xpath`、`wrapper`、`tree`、`depth`、`exclude` パラメータを処理
3. 対象オブジェクトをXML形式でシリアライズ
4. XPath/excludeがある場合はDOMを構築してフィルタリング
5. レスポンスヘッダー（X-Jenkins, X-Jenkins-Session等）を設定
6. XMLをレスポンスとして返却

### 2-JSON API リンククリック

JSON形式でデータを取得します。

**URL**: `json` または `json?pretty=true`

**処理フロー**：
1. `Api.doJson()` メソッドが呼び出される
2. `tree`、`depth` パラメータを処理
3. 対象オブジェクトをJSON形式でシリアライズ
4. `jsonp` パラメータがある場合はJSONP形式で返却
5. レスポンスヘッダーを設定
6. JSONをレスポンスとして返却

### 3-Python API リンククリック

Python literal形式でデータを取得します。

**URL**: `python` または `python?pretty=true`

**処理フロー**：
1. `Api.doPython()` メソッドが呼び出される
2. 対象オブジェクトをPython literal形式でシリアライズ
3. レスポンスとして返却

### 4-Schema リンククリック

XMLスキーマを取得します。

**URL**: `schema`

**処理フロー**：
1. `Api.doSchema()` メソッドが呼び出される
2. 対象オブジェクトのクラスからXMLスキーマを生成
3. XSD形式でレスポンスとして返却

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| API情報表示 | なし | なし | データベースアクセスなし（参照のみ） |
| XMLデータ取得 | なし | SELECT相当 | Javaオブジェクトからのシリアライズ |
| JSONデータ取得 | なし | SELECT相当 | Javaオブジェクトからのシリアライズ |

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|-------------|------|--------------|---------|
| REST API | 見出し | REST API | 常時表示 |
| XML API | リンク | XML API | 常時表示 |
| JSON API | リンク | JSON API | 常時表示 |
| Python API | リンク | Python API | 常時表示 |
| Api_NoXPathMatch | エラー | No matching XPath... | XPathに一致するノードがない場合 |
| Api_MultipleMatch | エラー | Multiple matches... | XPathが複数ノードに一致した場合 |
| Api_WrapperParamInvalid | エラー | Invalid wrapper name | wrapperパラメータが不正な場合 |

## 例外処理

| 例外条件 | 対応 | 表示内容 |
|---------|------|---------|
| XPath一致なし | 404エラー | Api_NoXPathMatch メッセージ |
| 複数ノード一致（wrapperなし） | 500エラー | Api_MultipleMatch メッセージ |
| 不正なwrapper名 | 400エラー | Api_WrapperParamInvalid メッセージ |
| JSONP禁止 | 403エラー | SecureRequester未実装のエラー |

## 備考

- `@Exported` アノテーションが付いたフィールド/メソッドのみがAPIで公開されます
- treeパラメータはXPathより効率的です（サーバー側でのDOM構築が不要）
- depthパラメータは探索用で、本番利用にはtreeパラメータを推奨
- JSONPはSecureRequesterの実装が必要です
- レスポンスヘッダーには `X-Jenkins`（バージョン）と `X-Jenkins-Session`（セッションハッシュ）が含まれます
- セキュリティ対策として `X-Content-Type-Options: nosniff` と `X-Frame-Options: deny` が設定されます

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、API機能の全体構造を理解します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | Api.java | `core/src/main/java/hudson/model/Api.java` | Apiクラスの構造、beanフィールド、各doXxxメソッドを理解 |
| 1-2 | Exported.java | `stapler/src/main/java/org/kohsuke/stapler/export/Exported.java` | APIで公開されるフィールドの定義方法を理解 |

**読解のコツ**: `Api` クラスはラッパーであり、実際のデータは `bean` フィールドに保持されます。`@Exported` アノテーションがAPI公開の鍵です。

#### Step 2: エントリーポイントを理解する

画面表示の起点となるファイルを特定します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | index.jelly | `core/src/main/resources/hudson/model/Api/index.jelly` | 画面構造、各API形式へのリンク、パラメータ説明を理解 |

**主要処理フロー**:
1. **行27**: one-columnレイアウトの設定
2. **行29**: REST APIタイトル
3. **行38-65**: XML API説明（xpath, wrapper, exclude, tree）
4. **行67-70**: JSON API説明
5. **行72-79**: Python API説明
6. **行87-131**: tree/depthパラメータの詳細説明
7. **行133**: オブジェクト固有の追加ドキュメント（_api.jelly）

#### Step 3: XMLシリアライズ処理を理解する

XML出力の実装を理解します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | Api.java (doXml) | `core/src/main/java/hudson/model/Api.java` | doXml()メソッド（行104-211）を理解 |

**主要処理フロー**:
- **行104-108**: メソッドシグネチャとパラメータ
- **行109**: setHeaders()でセキュリティヘッダー設定
- **行113-116**: xpath/excludeがない場合は直接シリアライズ
- **行119-124**: StringWriterに一旦書き出し
- **行127-143**: exclude XPathの処理
- **行145-184**: xpath処理とwrapper処理
- **行192-196**: simpleOutputの判定と処理
- **行207-210**: XMLWriterで出力

#### Step 4: JSON/Pythonシリアライズ処理を理解する

JSON/Python出力の実装を理解します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | Api.java (doJson/doPython) | `core/src/main/java/hudson/model/Api.java` | doJson(), doPython()を理解 |

**主要処理フロー**:
- **行231-263**: doJson() - JSONP対応、Flavor.JSON/JSONP
- **行268-296**: doPython() - Flavor.PYTHON

### プログラム呼び出し階層図

```
index.jelly (ドキュメント表示)
    │
    ├─ <a href="xml">XML API</a>
    │      │
    │      └─ Api.doXml()
    │             │
    │             ├─ setHeaders(rsp) ─── セキュリティヘッダー設定
    │             │
    │             ├─ xpath/exclude なし?
    │             │      │
    │             │      └─ rsp.serveExposedBean(bean, XML)
    │             │
    │             └─ xpath/exclude あり
    │                    │
    │                    ├─ MODEL_BUILDER.get(bean.getClass())
    │                    │      └─ TreePruner でフィルタリング
    │                    │
    │                    ├─ SAXReader().read() ─── DOM構築
    │                    │
    │                    ├─ XPath.selectNodes() ─── フィルタリング
    │                    │
    │                    └─ XMLWriter.write() ─── 出力
    │
    ├─ <a href="json">JSON API</a>
    │      │
    │      └─ Api.doJson()
    │             │
    │             ├─ setHeaders(rsp)
    │             │
    │             └─ rsp.serveExposedBean(bean, JSON/JSONP)
    │
    ├─ <a href="python">Python API</a>
    │      │
    │      └─ Api.doPython()
    │             │
    │             └─ rsp.serveExposedBean(bean, PYTHON)
    │
    └─ <a href="schema">Schema</a>
           │
           └─ Api.doSchema()
                  │
                  └─ SchemaGenerator.generateSchema()
```

### データフロー図

```
[入力]                    [処理]                         [出力]

URLアクセス ──────────▶ index.jelly ─────────────▶ HTML説明画面
/{resource}/api/


/api/xml?tree=... ────▶ Api.doXml() ─────────────▶ XML
                              │
                              ├─ @Exportedフィールド抽出
                              │
                              ├─ TreePruner(tree) フィルタ
                              │
                              └─ XML シリアライズ


/api/json?pretty ─────▶ Api.doJson() ────────────▶ JSON
                              │
                              └─ Flavor.JSON シリアライズ


/api/python ──────────▶ Api.doPython() ──────────▶ Python literal
                              │
                              └─ Flavor.PYTHON シリアライズ
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| Api.java | `core/src/main/java/hudson/model/Api.java` | ソース | API機能の主クラス |
| index.jelly | `core/src/main/resources/hudson/model/Api/index.jelly` | テンプレート | 画面表示用Jellyテンプレート |
| Exported.java | `stapler export` | ソース | APIエクスポート用アノテーション |
| ModelBuilder.java | `stapler export` | ソース | モデル構築 |
| TreePruner.java | `stapler export` | ソース | treeパラメータ処理 |
| Flavor.java | `stapler export` | ソース | 出力形式（XML/JSON/PYTHON/JSONP） |
| SecureRequester.java | `core/src/main/java/jenkins/security/SecureRequester.java` | ソース | JSONP許可判定 |
