# 画面設計書 66-フィンガープリント検索

## 概要

本ドキュメントは、Jenkins CI/CDサーバーの「フィンガープリント検索」画面の設計書です。

### 本画面の処理概要

ファイルのMD5フィンガープリントを検索し、そのファイルがどのビルドで使用されたかを追跡するための画面です。

**業務上の目的・背景**：複数のプロジェクト間でファイル（ライブラリ、成果物など）がどのように伝播しているかを追跡することは、デバッグやセキュリティ監査において重要です。フィンガープリント機能により、特定のファイルがどのビルドで生成され、どのビルドで使用されたかを確認できます。この画面は、ファイルをアップロードするか、既知のMD5ハッシュを使って検索を行うためのインターフェースを提供します。

**画面へのアクセス方法**：Jenkins管理画面 > フィンガープリント、またはダッシュボードのサイドパネルから「フィンガープリントをチェック」リンクでアクセスします。URLパス: `/fingerprintCheck`

**主要な操作・処理内容**：
1. ファイルをアップロードしてフィンガープリントを検索
2. MD5ハッシュ値を計算
3. 一致するフィンガープリントがあれば詳細画面へ遷移
4. 一致しない場合はエラーメッセージを表示

**画面遷移**：ダッシュボード/管理画面から遷移、検索成功時はフィンガープリント詳細画面へ

**権限による表示制御**：特別な権限は不要ですが、フィンガープリント詳細の表示はジョブへの権限に依存します。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 19 | フィンガープリント | 主機能 | ファイルMD5フィンガープリントの検索 |
| 6 | ビルド（Build） | 補助機能 | 関連ビルドの表示 |

## 画面種別

検索 / 登録

## URL/ルーティング

- URL: `/fingerprintCheck`
- ルーティング: `Jenkins` クラスの Stapler バインディングにより URLにマッピングされます

## 入出力項目

| 項目名 | 入出力 | 型 | 必須 | 説明 |
|--------|--------|-----|------|------|
| name | 入力 | File | Yes | フィンガープリントを計算するファイル |

## 表示項目

| 項目名 | 型 | 説明 |
|--------|-----|------|
| Check File Fingerprint | 見出し | 画面タイトル |
| description | テキスト | フィンガープリント機能の説明 |
| more details | リンク | フィンガープリント機能の詳細ドキュメントへのリンク |
| File to check | ファイル入力 | チェックするファイルのアップロードフィールド |
| Check | ボタン | フィンガープリント検索を実行するボタン |

## イベント仕様

### 1-Checkボタン押下

ファイルをアップロードしてフィンガープリント検索を実行します。

**URL**: `doFingerprintCheck` (POST, multipart/form-data)

**処理フロー**：
1. アップロードされたファイルを受け取る
2. ファイルのMD5ハッシュ値を計算
3. FingerprintMapからハッシュ値で検索
4. 一致するフィンガープリントが見つかった場合：
   - フィンガープリント詳細画面（`/fingerprint/{md5}`）へリダイレクト
5. 一致しない場合：
   - NoFingerprintMatch画面を表示

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| フィンガープリント検索 | fingerprints | SELECT | MD5ハッシュでフィンガープリント検索 |

### フィンガープリントストレージ

フィンガープリントはファイルシステムに保存されます：

| パス | 説明 |
|------|------|
| `$JENKINS_HOME/fingerprints/{aa}/{bb}/{md5}.xml` | MD5ハッシュの先頭4文字でディレクトリ分割 |

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|-------------|------|--------------|---------|
| Check File Fingerprint | 見出し | Check File Fingerprint | 常時表示 |
| description | 説明 | フィンガープリントの説明 | 常時表示 |
| more details | リンク | more details | 常時表示 |
| File to check | ラベル | File to check | 常時表示 |
| Check | ボタン | Check | 常時表示 |

## 例外処理

| 例外条件 | 対応 | 表示内容 |
|---------|------|---------|
| フィンガープリントが見つからない | NoFingerprintMatch画面 | 該当するフィンガープリントがない旨のメッセージ |
| ファイルアップロードエラー | エラーメッセージ | ファイルの読み込みに失敗した旨 |
| MD5計算エラー | エラーメッセージ | ハッシュ計算に失敗した旨 |

## 備考

- フィンガープリントはビルド時に `FingerprintRecorder` などのビルドステップで自動的に記録されます
- MD5ハッシュは32文字の16進数文字列として表示されます
- フィンガープリント機能はプラグインなしで利用可能なコア機能です
- 大きなファイルの場合、MD5計算に時間がかかる場合があります

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、フィンガープリント機能の全体構造を理解します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | Fingerprint.java | `core/src/main/java/hudson/model/Fingerprint.java` | Fingerprintクラスの構造、BuildPtr、Range、RangeSetを理解 |
| 1-2 | FingerprintMap.java | `core/src/main/java/hudson/model/FingerprintMap.java` | フィンガープリントのキャッシュと永続化を理解 |

**読解のコツ**: `Fingerprint` はMD5ハッシュをキーとしてファイルの使用履歴を追跡します。`BuildPtr` はビルドへの参照、`RangeSet` はビルド番号の範囲を表します。

#### Step 2: エントリーポイントを理解する

画面表示の起点となるファイルを特定します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | fingerprintCheck.jelly | `core/src/main/resources/jenkins/model/Jenkins/fingerprintCheck.jelly` | 画面構造、フォーム設定、アクションURLを理解 |

**主要処理フロー**:
1. **行30**: レイアウトとタイトルの設定
2. **行31**: サイドパネルの表示
3. **行32**: パンくずリストの設定
4. **行34-35**: タイトル表示
5. **行37-49**: フォーム（multipart/form-data）
6. **行43-45**: ファイル入力フィールド
7. **行46-48**: Checkボタン

#### Step 3: 検索処理を理解する

フィンガープリント検索の実装を理解します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | Jenkins.java | `core/src/main/java/jenkins/model/Jenkins.java` | doFingerprintCheck()メソッドを検索 |

**処理の流れ**:
1. アップロードファイルからInputStreamを取得
2. MD5ハッシュを計算（Util.getDigestOf()）
3. FingerprintMap.get(md5)で検索
4. 結果に応じてリダイレクトまたはエラー画面表示

### プログラム呼び出し階層図

```
fingerprintCheck.jelly (画面表示)
    │
    └─ <f:form action="doFingerprintCheck" enctype="multipart/form-data">
           │
           └─ Jenkins.doFingerprintCheck()
                  │
                  ├─ FileItem.getInputStream() ─── ファイル読み込み
                  │
                  ├─ Util.getDigestOf() ─── MD5計算
                  │
                  ├─ FingerprintMap.get(md5)
                  │      │
                  │      └─ FileFingerprintStorage.load()
                  │             └─ fingerprints/{aa}/{bb}/{md5}.xml
                  │
                  ├─ 見つかった場合
                  │      └─ redirect("/fingerprint/{md5}")
                  │
                  └─ 見つからない場合
                         └─ NoFingerprintMatch画面表示
```

### データフロー図

```
[入力]                    [処理]                         [出力]

ファイル選択 ─────────▶ <input type="file">


Checkボタン押下 ──────▶ doFingerprintCheck()
                              │
                              ├─ FileItem.getInputStream()
                              │
                              ▼
                        Util.getDigestOf()
                              │
                              ▼
                        MD5ハッシュ(32文字)
                              │
                              ▼
                        FingerprintMap.get()
                              │
                    ┌─────────┴─────────┐
                    ▼                   ▼
              見つかった              見つからない
                    │                   │
                    ▼                   ▼
         /fingerprint/{md5}    NoFingerprintMatch画面
            へリダイレクト
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| fingerprintCheck.jelly | `core/src/main/resources/jenkins/model/Jenkins/fingerprintCheck.jelly` | テンプレート | 画面表示用Jellyテンプレート |
| Jenkins.java | `core/src/main/java/jenkins/model/Jenkins.java` | ソース | doFingerprintCheck()を含む |
| Fingerprint.java | `core/src/main/java/hudson/model/Fingerprint.java` | ソース | フィンガープリントデータモデル |
| FingerprintMap.java | `core/src/main/java/hudson/model/FingerprintMap.java` | ソース | フィンガープリントのキャッシュ管理 |
| NoFingerprintMatch.java | `core/src/main/java/hudson/model/NoFingerprintMatch.java` | ソース | 検索結果なしの画面 |
| FileFingerprintStorage.java | `core/src/main/java/jenkins/fingerprints/FileFingerprintStorage.java` | ソース | ファイルベースのストレージ |
