# 画面設計書 67-フィンガープリント詳細

## 概要

本ドキュメントは、Jenkins CI/CDサーバーの「フィンガープリント詳細」画面の設計書です。

### 本画面の処理概要

特定のファイルフィンガープリントの詳細情報を表示する画面です。ファイルがどのビルドで最初に生成され、どのビルドで使用されたかを確認できます。

**業務上の目的・背景**：ソフトウェア開発において、特定のファイル（JAR、DLL、その他の成果物）がどこから来て、どこで使用されているかを追跡することは、セキュリティ監査、障害分析、依存関係の管理において重要です。この画面は、フィンガープリント（MD5ハッシュ）に基づいて、ファイルの生成元ビルドと使用履歴を一覧表示します。

**画面へのアクセス方法**：フィンガープリント検索結果から遷移、またはビルド詳細画面のフィンガープリントリンクからアクセスします。URLパス: `/fingerprint/{md5}`

**主要な操作・処理内容**：
1. ファイル名とMD5ハッシュの表示
2. ファイルの初回記録情報（生成元ビルド）の表示
3. 使用履歴（ジョブ名とビルド番号範囲）の一覧表示
4. 関連ビルドへのリンク

**画面遷移**：フィンガープリント検索画面、ビルド詳細画面から遷移、ジョブリンク/ビルドリンクで各詳細画面へ

**権限による表示制御**：ジョブへのREAD権限がある場合のみ関連情報が表示されます。権限がないジョブの情報は非表示になります。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 19 | フィンガープリント | 主機能 | フィンガープリントの詳細情報表示 |
| 6 | ビルド（Build） | 補助機能 | 関連ビルドの表示 |

## 画面種別

詳細

## URL/ルーティング

- URL: `/fingerprint/{md5}`
- ルーティング: `Fingerprint` クラスが `FingerprintMap` から取得され、Staplerにより URLにバインドされます

## 入出力項目

| 項目名 | 入出力 | 型 | 必須 | 説明 |
|--------|--------|-----|------|------|
| - | - | - | - | この画面には入力項目はありません（URLパスでMD5を指定） |

## 表示項目

| 項目名 | 型 | 説明 |
|--------|-----|------|
| fileName | 見出し | 追跡されているファイルの名前 |
| MD5 | テキスト | ファイルのMD5ハッシュ値（32文字） |
| introduced | テキスト | ファイルが最初に記録された日時 |
| original build | リンク | ファイルを生成したビルドへのリンク |
| Usage | 見出し | 使用履歴セクション |
| Jobs table | テーブル | 使用されたジョブとビルド範囲の一覧 |

### 使用履歴テーブル詳細

| カラム | 型 | 説明 |
|--------|-----|------|
| Job Name | リンク | ジョブへのリンク |
| Build Range | リンク群 | 使用されたビルド番号の範囲へのリンク |

## イベント仕様

### 1-ジョブリンククリック

使用履歴テーブルのジョブ名リンクをクリックした際の処理です。

**処理フロー**：
1. 該当ジョブの詳細画面（`/job/{jobName}`）へ遷移

### 2-ビルド範囲リンククリック

使用履歴テーブルのビルド範囲リンクをクリックした際の処理です。

**処理フロー**：
1. 該当ビルドの詳細画面（`/job/{jobName}/{buildNumber}`）へ遷移

### 3-オリジナルビルドリンククリック

ファイルを生成したオリジナルビルドへのリンクをクリックした際の処理です。

**処理フロー**：
1. 該当ビルドの詳細画面へ遷移

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 画面表示 | なし | SELECT | フィンガープリントXMLファイルからの読み込み |

### データ取得元

| パス | 説明 |
|------|------|
| `$JENKINS_HOME/fingerprints/{aa}/{bb}/{md5}.xml` | フィンガープリント情報のXMLファイル |

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|-------------|------|--------------|---------|
| introduced | テキスト | This file was first recorded at {0} | オリジナルビルド存在時 |
| outside Jenkins | テキスト | outside Jenkins | Jenkins外で最初に記録された場合 |
| Usage | 見出し | Usage | 常時表示 |
| This file has not been used anywhere else | メッセージ | This file has not been used anywhere else. | 使用履歴がない場合 |
| This file has been used in the following places | メッセージ | This file has been used in the following places: | 使用履歴がある場合 |

## 例外処理

| 例外条件 | 対応 | 表示内容 |
|---------|------|---------|
| フィンガープリントが見つからない | 404エラー | リソースが見つからない旨のエラー |
| ジョブへの権限なし | 非表示 | 該当ジョブの情報は表示されない |

## 備考

- フィンガープリント情報は永続化されており、ジョブやビルドが削除されても残ります
- `original` フィールドがnullの場合、ファイルはJenkins外で最初に記録されたことを示します
- `FingerprintFacet` 拡張ポイントにより、プラグインから追加情報を表示できます
- 権限チェックはジョブ単位で行われ、ADMINISTER権限があれば削除されたジョブの情報も表示されます

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、フィンガープリントのデータモデルを理解します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | Fingerprint.java | `core/src/main/java/hudson/model/Fingerprint.java` | Fingerprintクラス全体、getFileName(), getHashString(), getOriginal(), getJobs(), getUsages()を理解 |

**読解のコツ**:
- `original` (BuildPtr) はファイルを最初に生成したビルド
- `usages` (Hashtable<String, RangeSet>) はジョブ名をキーとして使用されたビルド番号の範囲を保持
- `jobs` は権限フィルタリング後のジョブ名リスト

#### Step 2: エントリーポイントを理解する

画面表示の起点となるファイルを特定します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | index.jelly | `core/src/main/resources/hudson/model/Fingerprint/index.jelly` | 画面構造、各表示項目の取得方法を理解 |

**主要処理フロー**:
1. **行27**: one-columnレイアウト、タイトルはファイル名
2. **行29-30**: ファイル名の見出し表示
3. **行32-34**: MD5ハッシュの表示
4. **行35-45**: オリジナルビルド情報（introduced、buildLink）
5. **行46-76**: 使用履歴セクション（Usage）
6. **行47-53**: 使用履歴がない場合のメッセージ
7. **行54-75**: 使用履歴テーブル
8. **行77-79**: FingerprintFacetの追加表示

#### Step 3: 権限チェックを理解する

ジョブへの権限による表示制御を理解します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | Fingerprint.java (BuildPtr) | `core/src/main/java/hudson/model/Fingerprint.java` | hasPermissionToDiscoverBuild()メソッド（行124-133）を理解 |

**権限チェックの流れ**:
- ADMINISTER権限があれば常にtrue
- ジョブが存在し、READ権限があればtrue
- それ以外はfalse

### プログラム呼び出し階層図

```
index.jelly (画面表示)
    │
    ├─ ${it.fileName} ─────────────── Fingerprint.getFileName()
    │
    ├─ ${it.hashString} ───────────── Fingerprint.getHashString()
    │
    ├─ ${it.timestampString} ──────── Fingerprint.getTimestampString()
    │
    ├─ ${it.original} ─────────────── Fingerprint.getOriginal()
    │      │
    │      └─ t:buildLink ────────── ビルドリンク生成
    │
    ├─ ${it.jobs} ─────────────────── Fingerprint.getJobs()
    │      │
    │      └─ 権限フィルタリング済みリスト
    │
    ├─ ${it.usages} ───────────────── Fingerprint.getUsages()
    │      │
    │      └─ Map<String, RangeSet>
    │
    └─ ${it.sortedFacets} ─────────── Fingerprint.getSortedFacets()
           │
           └─ FingerprintFacet拡張ポイント
```

### データフロー図

```
[入力]                    [処理]                         [出力]

/fingerprint/{md5} ────▶ FingerprintMap.get(md5)
                              │
                              ▼
                        Fingerprint.load()
                              │
                              ├─ fingerprints/{aa}/{bb}/{md5}.xml
                              │
                              ▼
                        Fingerprint オブジェクト
                              │
                    ┌─────────┼─────────┐
                    ▼         ▼         ▼
              fileName   original   usages
                    │         │         │
                    ▼         ▼         ▼
            index.jelly で表示


権限フィルタリング:
it.jobs ─────────▶ BuildPtr.hasPermissionToDiscoverBuild()
                        │
                        ├─ ADMINISTER? → true
                        │
                        ├─ Job.READ? → true
                        │
                        └─ それ以外 → false (非表示)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| index.jelly | `core/src/main/resources/hudson/model/Fingerprint/index.jelly` | テンプレート | 画面表示用Jellyテンプレート |
| Fingerprint.java | `core/src/main/java/hudson/model/Fingerprint.java` | ソース | フィンガープリントデータモデル |
| FingerprintMap.java | `core/src/main/java/hudson/model/FingerprintMap.java` | ソース | フィンガープリントのキャッシュ管理 |
| FingerprintFacet.java | `core/src/main/java/jenkins/model/FingerprintFacet.java` | ソース | 拡張ポイント基底クラス |
| buildLink.jelly | `core/src/main/resources/lib/hudson/buildLink.jelly` | テンプレート | ビルドリンク生成タグ |
| buildRangeLink.jelly | `core/src/main/resources/lib/hudson/buildRangeLink.jelly` | テンプレート | ビルド範囲リンク生成タグ |
