# 画面設計書 69-404エラー

## 概要

本ドキュメントは、Jenkins CI/CDサーバーの「404エラー」画面の設計書です。

### 本画面の処理概要

リクエストされたリソースが見つからない場合に表示されるエラー画面です。HTTPステータスコード404（Not Found）に対応します。

**業務上の目的・背景**：存在しないURLへのアクセスや、削除されたリソースへのアクセス時に、ユーザーフレンドリーなエラーメッセージを表示することを目的としています。また、セキュリティ対策として、認証が必要なリソースへの未認証アクセス時にもこの画面が表示される場合があります（権限がないことを悟らせないため）。

**画面へのアクセス方法**：存在しないURLへのアクセス時に自動的に表示されます。web.xmlで404エラーハンドラとして設定されています。

**主要な操作・処理内容**：
1. エラーメッセージの表示
2. セキュリティモードに応じたメッセージ分岐
3. 未認証ユーザーへのログイン促進
4. リクエストURIをセッションに保存（ログイン後のリダイレクト用）

**画面遷移**：ログインリンクからログイン画面へ遷移可能

**権限による表示制御**：匿名ユーザーか認証済みユーザーかで表示メッセージが変わります。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 1 | Jenkins本体 | 主機能 | リソース未検出エラーの表示 |
| 28 | 認証（SecurityRealm） | 補助機能 | セキュリティ状態に応じた表示分岐 |

## 画面種別

エラー

## URL/ルーティング

- URL: 任意のURLで404エラー発生時
- ルーティング: web.xmlの `<error-page>` 設定により `_404.jelly` が呼び出されます

## 入出力項目

| 項目名 | 入出力 | 型 | 必須 | 説明 |
|--------|--------|-----|------|------|
| - | - | - | - | この画面には入力項目はありません |

## 表示項目

| 項目名 | 型 | 説明 |
|--------|-----|------|
| rage.svg | 画像 | 怒り顔の感情アイコン |
| Oops! | 見出し | エラー見出し |
| title | テキスト | エラータイトル（404 Not Foundなど） |
| メッセージ | テキスト | 状況に応じたエラーメッセージ |

### 表示メッセージの分岐

| 条件 | メッセージ |
|------|---------|
| ResourceDomainRootAction.error属性あり | メッセージなし |
| セキュリティ有効 | noAccess（権限不足メッセージ） |
| セキュリティ有効 & 匿名ユーザー | noAccess + tryLoggingIn（ログイン促進） |
| セキュリティ無効 | notFound（リソースが見つからない） |

## イベント仕様

### 1-画面表示

404エラー発生時に自動的に呼び出されます。

**処理フロー**：
1. `st:statusCode` でHTTPステータスコードを設定（response2.getStatus()）
2. リクエストURIをセッションの `from` 属性に保存
3. エラータイトルを取得（jakarta.servlet.error.message または "Not Found"）
4. セキュリティ設定と認証状態を確認
5. 条件に応じたメッセージを表示

### 2-ログインリンク

tryLoggingInメッセージに含まれるログインリンクをクリックした場合の処理です。

**処理フロー**：
1. ログイン画面へ遷移
2. ログイン成功後、セッションの `from` 属性に保存されたURLへリダイレクト

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 画面表示 | なし | セッション更新 | fromパラメータをセッションに保存 |

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|-------------|------|--------------|---------|
| Oops! | 見出し | Oops! | 常時表示 |
| title | タイトル | 404 Not Found / エラーメッセージ | 常時表示 |
| noAccess | メッセージ | 権限不足のメッセージ | セキュリティ有効時 |
| tryLoggingIn | メッセージ | ログイン促進メッセージ | セキュリティ有効 & 匿名時 |
| notFound | メッセージ | リソースが見つからないメッセージ | セキュリティ無効時 |

## 例外処理

| 例外条件 | 対応 | 表示内容 |
|---------|------|---------|
| - | - | この画面自体がエラー処理画面のため、特別な例外処理はありません |

## 備考

- この画面はweb.xmlで404エラーページとして設定されています
- `oops.jelly`（500エラー画面）と類似した構成を持ちます
- `rage.svg` は怒った顔の絵文字アイコンです
- セキュリティ上の理由から、権限不足の場合も「リソースが見つからない」という体裁で表示されることがあります
- `ResourceDomainRootAction.error` 属性がある場合は特殊なリソースドメインエラーとして処理されます

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、エラー画面の構造と設定を理解します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | web.xml | `core/src/main/resources/WEB-INF/web.xml` | error-page設定を確認 |

**読解のコツ**: Jenkinsのエラーページ設定はweb.xmlで定義されています。404と500のエラーページが別々に設定されています。

#### Step 2: エントリーポイントを理解する

画面表示の起点となるファイルを特定します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | _404.jelly | `core/src/main/resources/jenkins/model/Jenkins/_404.jelly` | 画面構造、条件分岐、メッセージ表示を理解 |

**主要処理フロー**:
1. **行31**: `st:statusCode value="${response2.getStatus()}"` でステータスコード設定
2. **行32**: リクエストURIをセッションのfrom属性に保存
3. **行33**: one-columnレイアウト、タイトル設定
4. **行36-39**: rage.svgアイコンとOops!見出しの表示
5. **行40-57**: エラー説明（条件分岐付き）

#### Step 3: 条件分岐を理解する

セキュリティ状態に応じた表示分岐を理解します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | _404.jelly (条件分岐部分) | 同上 | j:choose, j:when, j:otherwiseの構造を理解 |

**主要処理フロー**:
- **行42**: ResourceDomainRootActionエラーでない場合のみメッセージ表示
- **行44-50**: セキュリティ有効（app.useSecurity）の場合
- **行46**: noAccessメッセージ
- **行47-49**: 匿名ユーザー（h.isAnonymous()）の場合tryLoggingInメッセージ追加
- **行51-53**: セキュリティ無効の場合notFoundメッセージ

### プログラム呼び出し階層図

```
[404エラー発生]
    │
    ▼
web.xml (error-page設定)
    │
    └─ _404.jelly
           │
           ├─ st:statusCode ─────── HTTPステータス設定
           │
           ├─ session.setAttribute('from', ...) ─── リダイレクト用URI保存
           │
           ├─ l:layout ─────────── レイアウト設定
           │
           ├─ rage.svg + "Oops!" ── アイコンと見出し
           │
           └─ j:choose ─────────── 条件分岐
                  │
                  ├─ ResourceDomainRootAction.error?
                  │      └─ メッセージなし
                  │
                  └─ j:choose
                         │
                         ├─ app.useSecurity?
                         │      │
                         │      ├─ noAccess
                         │      │
                         │      └─ h.isAnonymous()?
                         │             └─ tryLoggingIn
                         │
                         └─ !app.useSecurity
                                └─ notFound
```

### データフロー図

```
[入力]                    [処理]                         [出力]

存在しないURL ─────────▶ サーブレットコンテナ
                              │
                              ▼
                        404エラー検出
                              │
                              ▼
                        web.xml error-page
                              │
                              ▼
                        _404.jelly
                              │
                              ├─ response2.getStatus() ────▶ HTTPステータス
                              │
                              ├─ request URI ─────────────▶ session[from]
                              │
                              ├─ app.useSecurity ─────────▶ 分岐条件
                              │
                              ├─ h.isAnonymous() ─────────▶ 分岐条件
                              │
                              └─ メッセージ選択 ───────────▶ HTML出力
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| _404.jelly | `core/src/main/resources/jenkins/model/Jenkins/_404.jelly` | テンプレート | 404エラー画面テンプレート |
| _404.properties | `core/src/main/resources/jenkins/model/Jenkins/_404.properties` | 設定 | メッセージ定義 |
| web.xml | `core/src/main/resources/WEB-INF/web.xml` | 設定 | エラーページ設定 |
| oops.jelly | `core/src/main/resources/jenkins/model/Jenkins/oops.jelly` | テンプレート | 500エラー画面（類似実装） |
| rage.svg | `war/src/main/webapp/images/rage.svg` | 画像 | エラーアイコン |
