# 画面設計書 7-ユーザー登録（サインアップ）

## 概要

本ドキュメントは、Jenkinsのユーザー登録（サインアップ）画面の設計仕様を定義するものです。

### 本画面の処理概要

ユーザー登録（サインアップ）画面は、新規ユーザーが自己登録を行うための画面です。セルフサインアップ機能が有効になっている場合にのみ利用可能で、ユーザー名、パスワード、メールアドレス等を入力してアカウントを作成します。

**業務上の目的・背景**：開発チームのメンバーが管理者を介さずに自分でアカウントを作成できるようにすることで、管理者の負担を軽減し、チームの拡大に柔軟に対応できます。セキュリティポリシーに応じて、この機能を有効/無効に設定できます。

**画面へのアクセス方法**：ログイン画面の「or register」リンクをクリックするか、URLで直接 `/securityRealm/signup` にアクセスします。セルフサインアップ機能が無効の場合はアクセスできません。

**主要な操作・処理内容**：
1. ユーザー名の入力 - 必須項目で、重複チェックあり
2. フルネームの入力
3. メールアドレスの入力（Mailerプラグインがインストールされている場合）
4. パスワードの入力と強度表示
5. CAPTCHA入力（有効な場合）
6. アカウント作成ボタン押下による登録処理

**画面遷移**：ログイン画面からこの画面に遷移します。登録成功後は自動的にログインしてダッシュボードに遷移します。

**権限による表示制御**：認証前の画面のため、権限による表示制御はありません。セルフサインアップ機能が無効の場合は画面自体にアクセスできません。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 30 | ユーザー管理 | 主機能 | 新規ユーザーアカウントの作成 |
| 28 | 認証（SecurityRealm） | 補助機能 | セルフサインアップ機能の提供 |
| 64 | フォームバリデーション | API連携 | 入力値の検証（ユーザー名重複チェック等） |

## 画面種別

登録

## URL/ルーティング

- `/securityRealm/signup` - ユーザー登録画面
- `/securityRealm/createAccount` - アカウント作成処理エンドポイント

## 入出力項目

| 項目名 | 入力/出力 | データ型 | 必須 | 説明 |
|--------|----------|----------|------|------|
| username | 入力 | String | ○ | ユーザー名 |
| fullname | 入力 | String | - | フルネーム |
| email | 入力 | String | - | メールアドレス（Mailerプラグイン時） |
| password1 | 入力 | String | ○ | パスワード |
| password2 | 入力（hidden） | String | ○ | パスワード確認（JavaScriptで同期） |
| captcha | 入力 | String | ※ | CAPTCHA入力値（CAPTCHA有効時のみ必須） |

## 表示項目

| 項目名 | データ型 | 説明 |
|--------|----------|------|
| タイトル | Text | "Register" |
| ユーザー名入力フィールド | TextInput | ユーザー名入力欄 |
| フルネーム入力フィールド | TextInput | フルネーム入力欄 |
| メールアドレス入力フィールド | TextInput | メールアドレス入力欄（条件付き） |
| パスワード入力フィールド | PasswordInput | パスワード入力欄 |
| パスワード表示チェック | Checkbox | パスワードを表示するかのチェックボックス |
| パスワード強度表示 | Text | パスワードの強度（Strong/Moderate/Weak/Poor） |
| CAPTCHA画像 | Image | CAPTCHA画像（CAPTCHA有効時） |
| CAPTCHA入力フィールド | TextInput | CAPTCHA入力欄（CAPTCHA有効時） |
| Create accountボタン | Button | アカウント作成ボタン |
| or sign inリンク | Link | ログイン画面へのリンク |

## イベント仕様

### 1-パスワード入力

パスワード入力フィールドに入力すると、リアルタイムでパスワード強度が評価され、強度表示が更新されます。強度は「Strong」「Moderate」「Weak」「Poor」の4段階で表示されます。

### 2-パスワード表示チェック

「Show」チェックボックスをオンにすると、パスワード入力フィールドのタイプがtextに変わり、入力内容が表示されます。

### 3-Create accountボタン押下

フォームデータを `/securityRealm/createAccount` にPOSTします。バリデーションが行われ、問題がなければアカウントが作成され、自動的にログインしてダッシュボードにリダイレクトされます。

### 4-or sign inリンク押下

ログイン画面（`/login`）に遷移します。

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| Create account押下 | $JENKINS_HOME/users/{userId}/ | INSERT | ユーザーディレクトリとconfig.xmlの作成 |

### テーブル別更新項目詳細

#### Jenkinsファイルシステム（$JENKINS_HOME/users/{userId}/config.xml）

| 操作 | 項目 | 更新値・取得条件 | 備考 |
|-----|------|-----------------|------|
| INSERT | fullName | フォーム入力値 | フルネーム |
| INSERT | properties/hudson.security.HudsonPrivateSecurityRealm_-Details | パスワードハッシュ | BCrypt等でハッシュ化 |
| INSERT | properties/hudson.tasks.Mailer_-UserProperty/emailAddress | フォーム入力値 | メールアドレス（Mailerプラグイン時） |

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|-------------|------|---------------|---------|
| Register | ラベル | "Register" | タイトル |
| Strong | 情報 | "Strong" | パスワード強度が強い場合 |
| Moderate | 情報 | "Moderate" | パスワード強度が中程度の場合 |
| Weak | 警告 | "Weak" | パスワード強度が弱い場合 |
| Poor | 警告 | "Poor" | パスワード強度が非常に弱い場合 |
| (バリデーションエラー) | エラー | 動的メッセージ | 入力検証エラー時 |

## 例外処理

| 例外状態 | 処理内容 |
|---------|---------|
| セルフサインアップ無効 | 401 Unauthorizedエラー |
| ユーザー名重複 | エラーメッセージ表示、登録不可 |
| パスワード不一致 | エラーメッセージ表示、登録不可 |
| CAPTCHA不正 | エラーメッセージ表示、登録不可 |
| 不正なユーザー名 | エラーメッセージ表示（正規表現チェック） |

## 備考

- キャッシュ制御ヘッダーが設定されています
- ロボット検索エンジンのインデックス防止のためNOFOLLOWメタタグが設定されています
- パスワード強度表示のJavaScriptは`register.js`で実装されています
- CSRF対策としてCrumbトークンが含まれています
- パスワードはpassword2フィールドがhiddenで、JavaScriptでpassword1と同期されます

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

ユーザー情報の保存構造を理解します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | User.java | `core/src/main/java/hudson/model/User.java` | ユーザーモデルの基底クラス |
| 1-2 | HudsonPrivateSecurityRealm.java | `core/src/main/java/hudson/security/HudsonPrivateSecurityRealm.java` | Details内部クラス（パスワード保存） |

**読解のコツ**: HudsonPrivateSecurityRealm.DetailsクラスがUserPropertyとしてパスワードハッシュを保存します。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | signup.jelly | `core/src/main/resources/hudson/security/HudsonPrivateSecurityRealm/signup.jelly` | 画面のメインテンプレート |

**主要処理フロー**:
1. **31-32行目**: キャッシュ制御ヘッダー設定
2. **40行目**: エラー時の入力フィールドスタイル設定
3. **52行目**: register.jsの読み込み
4. **62-65行目**: パスワード強度表示の国際化テンプレート
5. **67行目**: フォーム送信先（`/securityRealm/createAccount`）
6. **68-81行目**: ユーザー名入力フィールドとエラー表示
7. **82-96行目**: フルネーム入力フィールド
8. **97-113行目**: メールアドレス入力（Mailerプラグイン時のみ）
9. **114-127行目**: CAPTCHA入力（CAPTCHA有効時のみ）
10. **128-150行目**: パスワード入力と強度表示

#### Step 3: アカウント作成処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | HudsonPrivateSecurityRealm.java | `core/src/main/java/hudson/security/HudsonPrivateSecurityRealm.java` | doCreateAccountメソッド（266行目付近） |

**主要処理フロー**:
- フォームデータの検証
- パスワードのハッシュ化
- Userインスタンスの作成と保存
- 自動ログインとリダイレクト

#### Step 4: パスワード強度表示を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | register.js | `war/src/main/js/pages/register.js` | パスワード強度計算と表示 |

### プログラム呼び出し階層図

```
signup.jelly (エントリーポイント)
    │
    ├─ simple-head.jelly (スタイル)
    │
    ├─ simple-branding.jelly (ブランディング)
    │
    ├─ register.js (パスワード強度)
    │
    └─ form (登録フォーム)
           │
           └─ POST to /securityRealm/createAccount
                  │
                  └─ HudsonPrivateSecurityRealm.doCreateAccount()
                         ├─ バリデーション
                         ├─ User作成
                         ├─ パスワードハッシュ化
                         ├─ config.xml保存
                         └─ 自動ログイン → ダッシュボード
```

### データフロー図

```
[入力]               [処理]                    [出力]

username ────────▶ バリデーション ───▶ User.config.xml
fullname                  │
email        ────────▶ doCreateAccount() ───▶ Details（パスワード）
password1                 │
(captcha)                 ▼
              自動ログイン → ダッシュボードリダイレクト
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| signup.jelly | `core/src/main/resources/hudson/security/HudsonPrivateSecurityRealm/signup.jelly` | テンプレート | メイン画面テンプレート |
| HudsonPrivateSecurityRealm.java | `core/src/main/java/hudson/security/HudsonPrivateSecurityRealm.java` | ソース | 認証処理、アカウント作成 |
| User.java | `core/src/main/java/hudson/model/User.java` | ソース | ユーザーモデル |
| register.js | `war/src/main/js/pages/register.js` | JavaScript | パスワード強度表示 |
| simple-head.jelly | 各PageDecoratorにより提供 | テンプレート | ページヘッド |
