# 画面設計書 71-ローディング中

## 概要

本ドキュメントは、Jenkins起動中に表示されるローディング画面の設計仕様を記述したものです。

### 本画面の処理概要

この画面はJenkinsサーバーが起動処理を行っている最中にユーザーへ表示される一時的な待機画面です。Jenkins本体の初期化処理が完了するまでの間、ユーザーに対してシステムが準備中であることを視覚的に通知し、自動的にリロードして完了後のダッシュボードへ遷移させる役割を担います。

**業務上の目的・背景**：JenkinsはCI/CDパイプラインの中核を担うため、起動処理には各種プラグインの読み込み、設定ファイルの解析、ジョブ定義の復元など多くの処理が必要となります。この間、ユーザーがJenkinsにアクセスしても正常なサービスを受けられないため、専用のローディング画面を表示することで「システムが正常に起動準備中である」ことを明示し、ユーザーの混乱を防止します。また、HTTP 503（Service Unavailable）ステータスコードを返却することで、監視システムや外部ツールに対してもサービス一時停止状態を正しく通知します。

**画面へのアクセス方法**：ユーザーがJenkins起動中に任意のURLにアクセスした場合に自動的にこの画面が表示されます。直接的なナビゲーションリンクは存在せず、Jenkinsの初期化処理中にServletContextに`HudsonIsLoading`オブジェクトが設定されることでアクセス時に表示されます。

**主要な操作・処理内容**：
1. Jenkinsロゴの表示による視覚的なブランディング
2. 「Jenkins is getting ready to work」のメッセージとスピナーアニメーションによる待機状態の明示
3. JavaScriptによる定期的な自動リロード処理の実行
4. ブラウザが準備完了時に自動的にリロードされる旨のメッセージ表示

**画面遷移**：
- 遷移元：なし（起動時の初期状態）
- 遷移先：ダッシュボード（View一覧）画面（Jenkins初期化完了後、自動リロードにより遷移）

**権限による表示制御**：この画面は認証・認可の処理が行われる前に表示されるため、権限による表示制御はありません。すべてのアクセスに対して同一の画面が表示されます。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 70 | 初期化フレームワーク | 主機能 | Jenkins起動中の表示 |

## 画面種別

システム状態表示（一時的な待機画面）

## URL/ルーティング

- URL: `/*`（Jenkins起動中は全URLでこの画面にリダイレクト）
- HTTPステータスコード: 503（Service Unavailable）
- キャッシュ制御: `Cache-Control: no-cache,no-store,must-revalidate`、`Expires: 0`

## 入出力項目

本画面は入力項目を持たない表示専用画面です。

| 項目名 | 入出力 | 説明 |
|--------|--------|------|
| なし | - | 入力項目なし |

## 表示項目

| 項目名 | 表示形式 | 説明 |
|--------|----------|------|
| Jenkinsロゴ | 画像（SVG） | `${imagesURL}/svgs/logo.svg`から取得したJenkinsロゴを表示 |
| ローディングメッセージ | テキスト+スピナー | 「Please wait while Jenkins is getting ready to work」のメッセージとスピナーアニメーション |
| 自動リロード通知 | テキスト | 「Your browser will reload automatically when Jenkins is ready」の通知メッセージ |

## イベント仕様

### 1-自動リロード処理

ページ読み込み時に`loading.js`スクリプトが実行され、定期的にJenkinsの準備状態を確認します。Jenkinsの初期化が完了し、通常のレスポンスが返却されるようになると、ブラウザは自動的にページをリロードし、ダッシュボード画面へ遷移します。

**処理フロー**:
1. ページ読み込み完了時に`loading.js`が実行開始
2. 定期的なポーリングでサーバー状態を確認
3. HTTP 200レスポンスを受信した時点で自動リロード実行
4. ダッシュボード画面を表示

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| なし | - | - | 本画面ではデータベース操作は発生しない |

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|-------------|------|---------------|----------|
| Starting Jenkins | タイトル | Starting Jenkins | ページタイトルとして常時表示 |
| loadingMessage | 情報 | Please wait while Jenkins is getting ready to work | ローディング中に常時表示 |
| autoReloadNotice | 情報 | Your browser will reload automatically when Jenkins is ready | ローディング中に常時表示 |

## 例外処理

| 例外条件 | 処理内容 |
|---------|----------|
| JavaScript無効 | 自動リロードが動作しないため、ユーザーが手動でリロードする必要がある |
| ネットワークエラー | ポーリングが失敗しても継続的にリトライを行う |

## 備考

- この画面はJenkinsコアの初期化処理と密接に連携しています
- `HudsonIsLoading`クラスがServletContextの"app"属性に設定されることで、この画面が表示されます
- HTTP 503ステータスコードにより、ロードバランサーや監視システムがサービス停止状態を正しく認識できます
- モバイルデバイスでも適切に表示されるよう、レスポンシブデザインが適用されています
- SEO対策として`ROBOTS: NOFOLLOW`メタタグが設定されており、検索エンジンによるインデックス化を防止しています

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、ローディング画面の制御に使用されるモデルオブジェクトを理解します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | HudsonIsLoading.java | `core/src/main/java/hudson/util/HudsonIsLoading.java` | ローディング画面のモデルオブジェクト。doDynamicメソッドでリクエスト処理を行う |

**読解のコツ**: `HudsonIsLoading`クラスは非常にシンプルな構造で、`doDynamic`メソッドのみを持ちます。Staplerフレームワークの動的ルーティング機能により、すべてのリクエストがこのメソッドで処理されます。

#### Step 2: エントリーポイントを理解する

リクエスト処理の起点を確認します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | HudsonIsLoading.java | `core/src/main/java/hudson/util/HudsonIsLoading.java` | doDynamicメソッドがエントリーポイント |

**主要処理フロー**:
1. **44-46行目**: doDynamicメソッドでHTTP 503ステータスを設定し、index.jellyをフォワード

#### Step 3: ビューテンプレートを理解する

画面の実際のレンダリング処理を確認します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | index.jelly | `core/src/main/resources/hudson/util/HudsonIsLoading/index.jelly` | Jellyテンプレートによる画面レンダリング |

**主要処理フロー**:
- **27行目**: HTTPステータスコード503の設定
- **28-29行目**: キャッシュ制御ヘッダーの設定
- **37行目**: ページタイトル「Starting Jenkins」の設定
- **44-56行目**: ローディング画面のHTML構造（ロゴ、メッセージ、スピナー）
- **58行目**: 自動リロード用JavaScriptの読み込み

### プログラム呼び出し階層図

```
ServletContext.getAttribute("app")
    │
    └─ HudsonIsLoading
           │
           └─ doDynamic(req, rsp)
                  │
                  ├─ rsp.setStatus(503)
                  │
                  └─ req.getView("index.jelly").forward()
                         │
                         └─ index.jelly
                                │
                                └─ loading.js (クライアントサイド)
```

### データフロー図

```
[入力]               [処理]                    [出力]

HTTPリクエスト ───▶ HudsonIsLoading        ───▶ HTTP 503レスポンス
                   .doDynamic()                  │
                         │                       ├─ index.jelly HTML
                         │                       │
                         └─ Stapler              └─ loading.js
                            フレームワーク            (自動リロード)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| HudsonIsLoading.java | `core/src/main/java/hudson/util/HudsonIsLoading.java` | ソース | ローディング画面のモデルオブジェクト |
| index.jelly | `core/src/main/resources/hudson/util/HudsonIsLoading/index.jelly` | テンプレート | ローディング画面のJellyテンプレート |
| loading.js | `core/src/main/resources/scripts/loading.js` | スクリプト | 自動リロード処理を行うJavaScript |
| simple-page.css | `war/src/main/scss/simple-page.scss` | スタイルシート | ローディング画面のスタイル定義 |
| logo.svg | `war/src/main/webapp/images/svgs/logo.svg` | 画像 | Jenkinsロゴ画像 |
