# 画面設計書 72-再起動中

## 概要

本ドキュメントは、Jenkinsサーバーが再起動処理を実行している最中にユーザーへ表示される画面の設計仕様を記述したものです。

### 本画面の処理概要

この画面はJenkinsサーバーが再起動処理を行っている最中にユーザーへ表示される一時的な待機画面です。管理者がシステム設定画面やJenkins管理画面から再起動を実行した際、Jenkinsの停止・再初期化処理が完了するまでの間、ユーザーに対してシステムが再起動中であることを視覚的に通知します。また、「安全な再起動（Safe Restart）」モードの場合は、その旨を追加表示します。

**業務上の目的・背景**：Jenkinsの設定変更やプラグインの更新後に再起動が必要となることがあります。再起動中にユーザーがアクセスした際、通常のエラー画面ではなく専用の再起動画面を表示することで、ユーザーはシステムが正常に再起動処理中であることを理解でき、無用な問い合わせやサポートリクエストを減少させることができます。特に「安全な再起動」モードでは、エージェント上で実行中のビルドが継続可能である旨を通知し、ユーザーの不安を軽減します。

**画面へのアクセス方法**：ユーザーがJenkins再起動中に任意のURLにアクセスした場合に自動的にこの画面が表示されます。直接的なナビゲーションリンクは存在せず、Jenkinsの再起動処理中にServletContextに`HudsonIsRestarting`オブジェクトが設定されることでアクセス時に表示されます。

**主要な操作・処理内容**：
1. Jenkinsロゴの表示による視覚的なブランディング
2. 「Jenkins is restarting」のメッセージとスピナーアニメーションによる再起動状態の明示
3. 安全な再起動モードの場合、追加メッセージの表示
4. JavaScriptによる定期的な自動リロード処理の実行
5. ブラウザが準備完了時に自動的にリロードされる旨のメッセージ表示

**画面遷移**：
- 遷移元：Jenkins管理画面（再起動実行後）、システム設定画面（再起動実行後）
- 遷移先：ダッシュボード（View一覧）画面またはログイン画面（Jenkins再起動完了後、自動リロードにより遷移）

**権限による表示制御**：この画面は認証・認可の処理が行われる前の状態で表示されるため、権限による表示制御はありません。すべてのアクセスに対して同一の画面が表示されます。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 70 | 初期化フレームワーク | 主機能 | Jenkins再起動中の表示 |

## 画面種別

システム状態表示（一時的な待機画面）

## URL/ルーティング

- URL: `/*`（Jenkins再起動中は全URLでこの画面にリダイレクト）
- HTTPステータスコード: 503（Service Unavailable）
- キャッシュ制御: `Cache-Control: no-cache,no-store,must-revalidate`、`Expires: 0`

## 入出力項目

本画面は入力項目を持たない表示専用画面です。

| 項目名 | 入出力 | 説明 |
|--------|--------|------|
| なし | - | 入力項目なし |

## 表示項目

| 項目名 | 表示形式 | 説明 |
|--------|----------|------|
| Jenkinsロゴ | 画像（SVG） | `${imagesURL}/svgs/logo.svg`から取得したJenkinsロゴを表示 |
| ローディングメッセージ | テキスト+スピナー | 「Please wait while Jenkins is restarting」のメッセージとスピナーアニメーション |
| 自動リロード通知 | テキスト | 「Your browser will reload automatically when Jenkins is ready」の通知メッセージ |
| Safe Restartメッセージ | テキスト（条件付き） | 安全な再起動モードの場合のみ「Safe Restart」と「Builds on agents can usually continue.」を表示 |

## イベント仕様

### 1-自動リロード処理

ページ読み込み時に`loading.js`スクリプトが実行され、定期的にJenkinsの準備状態を確認します。Jenkinsの再起動が完了し、通常のレスポンスが返却されるようになると、ブラウザは自動的にページをリロードし、ログイン画面またはダッシュボード画面へ遷移します。

**処理フロー**:
1. ページ読み込み完了時に`loading.js`が実行開始
2. 定期的なポーリングでサーバー状態を確認
3. HTTP 200レスポンスを受信した時点で自動リロード実行
4. ログイン画面またはダッシュボード画面を表示

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| なし | - | - | 本画面ではデータベース操作は発生しない |

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|-------------|------|---------------|----------|
| Restarting Jenkins | タイトル | Restarting Jenkins | ページタイトルとして常時表示 |
| restartingMessage | 情報 | Please wait while Jenkins is restarting | 再起動中に常時表示 |
| autoReloadNotice | 情報 | Your browser will reload automatically when Jenkins is ready | 再起動中に常時表示 |
| safeRestartTitle | 情報 | Safe Restart | 安全な再起動モードの場合のみ表示 |
| safeRestartDescription | 情報 | Builds on agents can usually continue. | 安全な再起動モードの場合のみ表示 |

## 例外処理

| 例外条件 | 処理内容 |
|---------|----------|
| JavaScript無効 | 自動リロードが動作しないため、ユーザーが手動でリロードする必要がある |
| ネットワークエラー | ポーリングが失敗しても継続的にリトライを行う |
| 再起動失敗 | 起動エラー画面（73-起動エラー）へ遷移 |

## 備考

- この画面はJenkinsコアの再起動処理と密接に連携しています
- `HudsonIsRestarting`クラスがServletContextの"app"属性に設定されることで、この画面が表示されます
- `safeRestart`フラグにより、安全な再起動モードかどうかを判定します
- 安全な再起動モードでは、実行中のジョブ完了を待ってから再起動が実行されます
- HTTP 503ステータスコードにより、ロードバランサーや監視システムがサービス停止状態を正しく認識できます

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、再起動画面の制御に使用されるモデルオブジェクトを理解します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | HudsonIsRestarting.java | `core/src/main/java/hudson/util/HudsonIsRestarting.java` | 再起動画面のモデルオブジェクト。safeRestartフラグの管理を行う |

**読解のコツ**: `HudsonIsRestarting`クラスは`safeRestart`フラグを持ち、コンストラクタで設定されます。このフラグにより、安全な再起動モードかどうかを判定します。

#### Step 2: エントリーポイントを理解する

リクエスト処理の起点を確認します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | HudsonIsRestarting.java | `core/src/main/java/hudson/util/HudsonIsRestarting.java` | doDynamicメソッドがエントリーポイント |

**主要処理フロー**:
1. **43-51行目**: コンストラクタでsafeRestartフラグを設定
2. **58-61行目**: doDynamicメソッドでHTTP 503ステータスを設定し、index.jellyをフォワード
3. **66-68行目**: isSafeRestart()メソッドでフラグを返却

#### Step 3: ビューテンプレートを理解する

画面の実際のレンダリング処理を確認します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | index.jelly | `core/src/main/resources/hudson/util/HudsonIsRestarting/index.jelly` | Jellyテンプレートによる画面レンダリング |

**主要処理フロー**:
- **27行目**: HTTPステータスコード503の設定
- **28-29行目**: キャッシュ制御ヘッダーの設定
- **37行目**: ページタイトル「Restarting Jenkins」の設定
- **44-55行目**: 再起動画面のHTML構造（ロゴ、メッセージ、スピナー）
- **56-65行目**: 安全な再起動モードの条件付き表示
- **68行目**: 自動リロード用JavaScriptの読み込み

### プログラム呼び出し階層図

```
ServletContext.getAttribute("app")
    │
    └─ HudsonIsRestarting
           │
           ├─ isSafeRestart()
           │
           └─ doDynamic(req, rsp)
                  │
                  ├─ rsp.setStatus(503)
                  │
                  └─ req.getView("index.jelly").forward()
                         │
                         └─ index.jelly
                                │
                                ├─ it.safeRestart判定
                                │      │
                                │      └─ Safe Restart追加メッセージ表示
                                │
                                └─ loading.js (クライアントサイド)
```

### データフロー図

```
[入力]               [処理]                    [出力]

HTTPリクエスト ───▶ HudsonIsRestarting     ───▶ HTTP 503レスポンス
                   .doDynamic()                  │
                         │                       ├─ index.jelly HTML
                         │                       │
                         └─ Stapler              └─ loading.js
                            フレームワーク            (自動リロード)

                                          [条件付き出力]
                                                 │
                                                 └─ Safe Restart情報
                                                    (safeRestart=true時)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| HudsonIsRestarting.java | `core/src/main/java/hudson/util/HudsonIsRestarting.java` | ソース | 再起動画面のモデルオブジェクト |
| index.jelly | `core/src/main/resources/hudson/util/HudsonIsRestarting/index.jelly` | テンプレート | 再起動画面のJellyテンプレート |
| loading.js | `core/src/main/resources/scripts/loading.js` | スクリプト | 自動リロード処理を行うJavaScript |
| simple-page.css | `war/src/main/scss/simple-page.scss` | スタイルシート | 再起動画面のスタイル定義 |
| logo.svg | `war/src/main/webapp/images/svgs/logo.svg` | 画像 | Jenkinsロゴ画像 |
